/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.ByteBuffer;

class WebsocketFramePool {
    private int index = 0;
    private final WebsocketFrameAndBuffer[] pool;

    public WebsocketFramePool(int bufferSize, int poolSize, Class<? extends WebSocketFrame> type) {
        this.pool = new WebsocketFrameAndBuffer[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            this.pool[i] = new WebsocketFrameAndBuffer(bufferSize, type);
        }
    }

    private WebsocketFrameAndBuffer getNext() {
        for (int i = this.index; i < this.index + this.pool.length; ++i) {
            int item;
            int n = item = i < this.pool.length ? i : i - this.pool.length;
            if (this.pool[item].buffer.refCnt() != 1) continue;
            this.pool[item].buffer.retain();
            this.index = item + 1;
            return this.pool[item];
        }
        return null;
    }

    public WebSocketFrame createFrame() {
        WebsocketFrameAndBuffer next = this.getNext();
        if (next != null) {
            next.buffer.clear();
            return next.frame;
        }
        return null;
    }

    public WebSocketFrame createFrame(ByteBuffer data) {
        WebsocketFrameAndBuffer next = this.getNext();
        if (next != null) {
            next.buffer.clear();
            next.buffer.writeBytes(data);
            data.flip();
            return next.frame;
        }
        return null;
    }

    public void release() {
        for (int i = 0; i < this.pool.length; ++i) {
            this.pool[i].buffer.release();
        }
    }

    private static class WebsocketFrameAndBuffer {
        private final ByteBuf buffer;
        private final WebSocketFrame frame;

        private WebsocketFrameAndBuffer(int bufferSize, Class<? extends WebSocketFrame> type) {
            this.buffer = Unpooled.directBuffer((int)bufferSize, (int)bufferSize);
            if (type == BinaryWebSocketFrame.class) {
                this.frame = new BinaryWebSocketFrame(this.buffer);
            } else if (type == TextWebSocketFrame.class) {
                this.frame = new TextWebSocketFrame(this.buffer);
            } else {
                throw new RuntimeException("Invalid type");
            }
        }
    }
}

