/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import us.ihmc.log.LogTools;

public class ResourceLoaderTools {
    private static final PathMatcher classMatcher = FileSystems.getDefault().getPathMatcher("glob:**/*.class");

    public static void createZipBundle(OutputStream os, final Predicate<String> filter, String ... topLevelDirectories) throws IOException {
        final ZipOutputStream stream = new ZipOutputStream(os);
        ResourceLoaderTools.recursivelyGetResources(new ResourceHandler(){
            private final HashSet<String> names = new HashSet();

            @Override
            public void handleResource(String resourcePath) throws IOException {
                ZipEntry entry;
                if ((filter == null || filter.test(resourcePath)) && this.names.add((entry = new ZipEntry(resourcePath)).getName())) {
                    InputStream resource = ResourceLoaderTools.class.getClassLoader().getResourceAsStream(resourcePath);
                    stream.putNextEntry(entry);
                    ResourceLoaderTools.copyStream(resource, stream);
                    stream.closeEntry();
                    resource.close();
                }
            }
        }, topLevelDirectories);
        stream.close();
    }

    private static void recursivelyGetResources(final ResourceHandler resourceHandler, String ... topLevelDirectories) throws IOException {
        HashSet<String> classPathSet = new HashSet<String>();
        Enumeration<URL> manifests = ResourceLoaderTools.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            URL next = manifests.nextElement();
            InputStream stream = next.openStream();
            Manifest manifest = new Manifest(stream);
            String jarClassPath = manifest.getMainAttributes().getValue("Class-Path");
            if (jarClassPath != null) {
                classPathSet.addAll(Arrays.asList(jarClassPath.split(" ")));
            }
            stream.close();
        }
        classPathSet.addAll(Arrays.asList(System.getProperty("java.class.path").split(Pattern.quote(File.pathSeparator))));
        for (String nextToken : classPathSet) {
            Path path;
            FileSystem fs;
            Path classPath;
            try {
                classPath = Paths.get(nextToken, new String[0]);
            }
            catch (InvalidPathException e) {
                LogTools.error((String)("Couldn't find: " + nextToken));
                continue;
            }
            if (!Files.exists(classPath, new LinkOption[0])) continue;
            if (!Files.isDirectory(classPath, new LinkOption[0])) {
                try {
                    fs = FileSystems.newFileSystem(classPath, (ClassLoader)null);
                }
                catch (Exception e) {
                    LogTools.error((String)("Problem creating a FileSystem for the following classpath entry, skipping: " + nextToken));
                    StringWriter writer = new StringWriter();
                    e.printStackTrace(new PrintWriter(writer));
                    continue;
                }
                path = fs.getPath("/", new String[0]);
            } else {
                fs = null;
                path = classPath;
            }
            Path[] absoluteDirectories = new Path[topLevelDirectories.length];
            for (int i = 0; i < topLevelDirectories.length; ++i) {
                absoluteDirectories[i] = path.resolve(topLevelDirectories[i]);
            }
            for (Path subdirectories : ResourceLoaderTools.checkDirectoryExists(absoluteDirectories)) {
                Files.walkFileTree(subdirectories, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (!classMatcher.matches(file)) {
                            resourceHandler.handleResource(path.relativize(file).toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            if (fs == null) continue;
            fs.close();
        }
    }

    private static List<Path> checkDirectoryExists(Path ... directories) {
        ArrayList<Path> topLevelDirectories = new ArrayList<Path>();
        for (Path directory : directories) {
            if (Files.notExists(directory, new LinkOption[0])) continue;
            topLevelDirectories.add(directory);
        }
        return topLevelDirectories;
    }

    private static void copyStream(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
    }

    private static interface ResourceHandler {
        public void handleResource(String var1) throws IOException;
    }
}

