/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsHolder;

public class KeyPointsHandler
implements KeyPointsHolder {
    private boolean enableKeyPoints = false;
    private final List<Integer> keyPoints = new ArrayList<Integer>();
    private final List<KeyPointsChangedListener> listeners = new ArrayList<KeyPointsChangedListener>();

    public void clear() {
        this.keyPoints.clear();
        this.listeners.clear();
    }

    @Override
    public void addListener(KeyPointsChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public boolean removeListener(KeyPointsChangedListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void toggleKeyPoints() {
        this.enableKeyPoints = !this.enableKeyPoints;
        KeyPointsChange change = new KeyPointsChange(true, this.enableKeyPoints, null, null);
        this.listeners.forEach(listener -> listener.changed(change));
    }

    public void enableKeyPoints(boolean enable) {
        if (enable != this.enableKeyPoints) {
            this.toggleKeyPoints();
        }
    }

    @Override
    public boolean areKeyPointsEnabled() {
        return this.enableKeyPoints;
    }

    public boolean toggleKeyPoint(int bufferIndex) {
        for (int i = 0; i < this.keyPoints.size(); ++i) {
            if (this.keyPoints.get(i) == bufferIndex) {
                this.keyPoints.remove(i);
                this.notifyRemovedKeyPoint(bufferIndex);
                return false;
            }
            if (this.keyPoints.get(i) <= bufferIndex) continue;
            this.keyPoints.add(i, bufferIndex);
            this.notifyAddedKeyPoint(bufferIndex);
            return true;
        }
        this.keyPoints.add(bufferIndex);
        return true;
    }

    public boolean addKeyPoint(int bufferIndex) {
        for (int i = 0; i < this.keyPoints.size(); ++i) {
            if (this.keyPoints.get(i) == bufferIndex) {
                return false;
            }
            if (this.keyPoints.get(i) <= bufferIndex) continue;
            this.keyPoints.add(i, bufferIndex);
            this.notifyAddedKeyPoint(bufferIndex);
            return true;
        }
        this.keyPoints.add(bufferIndex);
        this.notifyAddedKeyPoint(bufferIndex);
        return true;
    }

    public boolean removeKeyPoint(int bufferIndex) {
        for (int i = 0; i < this.keyPoints.size(); ++i) {
            if (this.keyPoints.get(i) == bufferIndex) {
                this.keyPoints.remove(i);
                this.notifyRemovedKeyPoint(bufferIndex);
                return true;
            }
            if (this.keyPoints.get(i) <= bufferIndex) continue;
            return false;
        }
        return false;
    }

    public int getNextKeyPoint(int bufferIndex) {
        for (int i = 0; i < this.keyPoints.size(); ++i) {
            if (this.keyPoints.get(i) <= bufferIndex) continue;
            return this.keyPoints.get(i);
        }
        if (this.keyPoints.size() > 0) {
            return this.keyPoints.get(0);
        }
        return bufferIndex;
    }

    public int getPreviousKeyPoint(int bufferIndex) {
        for (int i = this.keyPoints.size() - 1; i >= 0; --i) {
            if (this.keyPoints.get(i) >= bufferIndex) continue;
            return this.keyPoints.get(i);
        }
        if (this.keyPoints.size() > 0) {
            return this.keyPoints.get(this.keyPoints.size() - 1);
        }
        return bufferIndex;
    }

    public void trimKeyPoints(int startBufferIndex, int endBufferIndex) {
        ArrayList<Integer> removedKeyPoints = new ArrayList<Integer>();
        for (int i = 0; i < this.keyPoints.size(); ++i) {
            if (startBufferIndex < endBufferIndex) {
                if (this.keyPoints.get(i) >= startBufferIndex && this.keyPoints.get(i) <= endBufferIndex) continue;
                removedKeyPoints.add(this.keyPoints.remove(i));
                --i;
                continue;
            }
            if (this.keyPoints.get(i) >= startBufferIndex || this.keyPoints.get(i) <= endBufferIndex) continue;
            removedKeyPoints.add(this.keyPoints.remove(i));
            --i;
        }
        this.notifyRemovedKeyPoints(removedKeyPoints);
    }

    public List<Integer> getKeyPoints() {
        return this.keyPoints;
    }

    private void notifyAddedKeyPoint(int addedKeyPoint) {
        this.notifyAddedKeyPoints(Collections.singletonList(addedKeyPoint));
    }

    private void notifyAddedKeyPoints(List<Integer> addedKeyPoints) {
        KeyPointsChange change = new KeyPointsChange(false, this.enableKeyPoints, addedKeyPoints, null);
        this.listeners.forEach(listener -> listener.changed(change));
    }

    private void notifyRemovedKeyPoint(int removedKeyPoint) {
        this.notifyRemovedKeyPoints(Collections.singletonList(removedKeyPoint));
    }

    private void notifyRemovedKeyPoints(List<Integer> removedKeyPoints) {
        KeyPointsChange change = new KeyPointsChange(false, this.enableKeyPoints, null, removedKeyPoints);
        this.listeners.forEach(listener -> listener.changed(change));
    }

    private static class KeyPointsChange
    implements KeyPointsChangedListener.Change {
        private final boolean wasToggled;
        private final boolean areKeyPointsEnabled;
        private final List<Integer> addedKeyPoints;
        private final List<Integer> removedKeyPoints;

        public KeyPointsChange(boolean wasToggled, boolean areKeyPointsEnabled, List<Integer> addedKeyPoints, List<Integer> removedKeyPoints) {
            this.wasToggled = wasToggled;
            this.areKeyPointsEnabled = areKeyPointsEnabled;
            this.addedKeyPoints = addedKeyPoints == null ? Collections.emptyList() : addedKeyPoints;
            this.removedKeyPoints = removedKeyPoints == null ? Collections.emptyList() : removedKeyPoints;
        }

        @Override
        public boolean wasToggled() {
            return this.wasToggled;
        }

        @Override
        public boolean areKeyPointsEnabled() {
            return this.areKeyPointsEnabled;
        }

        @Override
        public List<Integer> getAddedKeyPoints() {
            return this.addedKeyPoints;
        }

        @Override
        public List<Integer> getRemovedKeyPoints() {
            return this.removedKeyPoints;
        }
    }
}

