/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.log.LogTools;
import us.ihmc.yoVariables.buffer.KeyPointsHandler;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferIndexChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferReader;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryHolder;
import us.ihmc.yoVariables.buffer.interfaces.YoTimeBufferHolder;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBuffer
implements YoVariableHolder,
YoBufferReader,
YoTimeBufferHolder,
YoBufferVariableEntryHolder {
    private String timeVariableName = "t";
    private int inPoint = 0;
    private int outPoint = 0;
    private int currentIndex = 0;
    private int bufferSize;
    private final ArrayList<YoBufferVariableEntry> entries = new ArrayList();
    private final Map<String, List<YoBufferVariableEntry>> simpleNameToEntriesMap = new HashMap<String, List<YoBufferVariableEntry>>();
    private final KeyPointsHandler keyPointsHandler = new KeyPointsHandler();
    private final List<YoBufferIndexChangedListener> indexChangedListeners = new ArrayList<YoBufferIndexChangedListener>();
    private boolean lockIndex = false;

    public YoBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public YoBuffer(YoBuffer other) {
        this.inPoint = other.inPoint;
        this.outPoint = other.outPoint;
        this.currentIndex = other.currentIndex;
        this.bufferSize = other.bufferSize;
        this.lockIndex = other.lockIndex;
        for (YoBufferVariableEntry otherEntry : other.entries) {
            this.addEntry(new YoBufferVariableEntry(otherEntry));
        }
    }

    public void clear() {
        this.inPoint = 0;
        this.outPoint = 0;
        this.currentIndex = 0;
        this.entries.clear();
        this.simpleNameToEntriesMap.clear();
        this.keyPointsHandler.clear();
        this.indexChangedListeners.clear();
    }

    public void clearBuffers(int bufferSize) {
        this.entries.forEach(entry -> entry.clearBuffer(bufferSize));
        this.bufferSize = bufferSize;
    }

    public void resizeBuffer(int newBufferSize) {
        if (newBufferSize < this.bufferSize) {
            this.cropBuffer(this.inPoint, (this.inPoint + newBufferSize - 1) % this.bufferSize);
        } else if (newBufferSize > this.bufferSize) {
            this.shiftBuffer();
            this.enlargeBufferSize(newBufferSize);
        }
    }

    private void enlargeBufferSize(int newBufferSize) {
        for (int i = 0; i < this.entries.size(); ++i) {
            YoBufferVariableEntry entry = this.entries.get(i);
            entry.enlargeBufferSize(newBufferSize);
        }
        this.bufferSize = newBufferSize;
    }

    public void setLockIndex(boolean lock) {
        this.lockIndex = lock;
    }

    public boolean isIndexLocked() {
        return this.lockIndex;
    }

    public void addEntry(YoBufferVariableEntry entry) {
        if (entry.getBufferSize() != this.bufferSize) {
            throw new IllegalArgumentException("The new entry size (" + entry.getBufferSize() + ") does not match the buffer size (" + this.bufferSize + ").");
        }
        this.entries.add(entry);
        String variableName = entry.getVariable().getName().toLowerCase();
        List<YoBufferVariableEntry> entryList = this.simpleNameToEntriesMap.get(variableName);
        if (entryList == null) {
            entryList = new ArrayList<YoBufferVariableEntry>();
            this.simpleNameToEntriesMap.put(variableName, entryList);
        }
        entryList.add(entry);
    }

    public YoBufferVariableEntry addVariable(YoVariable variable) {
        YoBufferVariableEntry entry = this.getEntry(variable);
        if (entry != null) {
            return entry;
        }
        entry = new YoBufferVariableEntry(variable, this.bufferSize);
        this.addEntry(entry);
        return entry;
    }

    public void addVariables(List<? extends YoVariable> variables) {
        this.entries.ensureCapacity(this.entries.size() + variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            this.addVariable(variables.get(i));
        }
    }

    public YoBufferVariableEntry removeVariable(YoVariable variable) {
        YoBufferVariableEntry entry = this.getEntry(variable);
        if (entry == null) {
            return null;
        }
        this.entries.remove(entry);
        this.simpleNameToEntriesMap.get(variable.getName().toLowerCase()).remove(entry);
        return entry;
    }

    public void setInPoint(int index) {
        this.inPoint = index;
        this.keyPointsHandler.trimKeyPoints(this.inPoint, this.outPoint);
    }

    public void setOutPoint(int index) {
        this.outPoint = index;
        this.keyPointsHandler.trimKeyPoints(this.inPoint, this.outPoint);
    }

    public void setInPoint() {
        this.setInPoint(this.currentIndex);
    }

    public void setOutPoint() {
        this.setOutPoint(this.currentIndex);
    }

    public void setInOutPointFullBuffer() {
        this.inPoint = 0;
        this.outPoint = this.getBufferSize() - 1;
    }

    public void toggleKeyPoint() {
        this.keyPointsHandler.toggleKeyPoint(this.currentIndex);
    }

    public boolean isAtInPoint() {
        return this.currentIndex == this.inPoint;
    }

    public boolean isAtOutPoint() {
        return this.currentIndex == this.outPoint;
    }

    public void readFromBuffer() {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).readFromBufferAt(this.currentIndex);
        }
    }

    public void writeIntoBuffer() {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).writeIntoBufferAt(this.currentIndex);
        }
    }

    public void gotoInPoint() {
        this.setCurrentIndex(this.inPoint);
    }

    public void gotoOutPoint() {
        this.setCurrentIndex(this.outPoint);
    }

    @Override
    public void setCurrentIndex(int index) {
        if (this.lockIndex) {
            return;
        }
        this.currentIndex = index;
        if (this.currentIndex >= this.bufferSize) {
            this.currentIndex = 0;
        } else if (this.currentIndex < 0) {
            this.currentIndex = this.bufferSize - 1;
        }
        this.readFromBuffer();
        this.notifyIndexChangedListeners();
    }

    @Override
    public boolean tickAndReadFromBuffer(int stepSize) {
        boolean rolledOver;
        if (this.lockIndex) {
            return false;
        }
        int newIndex = this.currentIndex + stepSize;
        boolean bl = rolledOver = !this.isIndexBetweenBounds(newIndex);
        if (rolledOver) {
            newIndex = stepSize >= 0 ? this.inPoint : this.outPoint;
        }
        this.setCurrentIndex(newIndex);
        return rolledOver;
    }

    public void tickAndWriteIntoBuffer() {
        ++this.currentIndex;
        if (this.currentIndex >= this.bufferSize || this.currentIndex < 0) {
            this.currentIndex = 0;
        }
        this.outPoint = this.currentIndex;
        if (this.outPoint == this.inPoint) {
            ++this.inPoint;
            if (this.inPoint >= this.bufferSize) {
                this.inPoint = 0;
            }
        }
        this.keyPointsHandler.removeKeyPoint(this.currentIndex);
        this.writeIntoBuffer();
        this.notifyIndexChangedListeners();
    }

    private void notifyIndexChangedListeners() {
        for (int i = 0; i < this.indexChangedListeners.size(); ++i) {
            this.indexChangedListeners.get(i).indexChanged(this.currentIndex);
        }
    }

    public void fillBuffer() {
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).fillBuffer();
        }
    }

    public void shiftBuffer() {
        this.shiftBuffer(this.inPoint);
    }

    public void shiftBuffer(int shiftIndex) {
        if (shiftIndex == 0) {
            return;
        }
        if (shiftIndex <= 0 || shiftIndex >= this.bufferSize) {
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).shiftBuffer(shiftIndex);
        }
        this.currentIndex = (this.currentIndex - shiftIndex + this.bufferSize) % this.bufferSize;
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        }
        this.inPoint = 0;
        this.outPoint = (this.outPoint - shiftIndex + this.bufferSize) % this.bufferSize;
        this.tickAndReadFromBuffer(0);
    }

    public void cropBuffer() {
        if (this.inPoint != this.outPoint) {
            this.cropBuffer(this.inPoint, this.outPoint);
        } else {
            this.cropBuffer(this.inPoint, this.inPoint + 1);
        }
    }

    public void cropBuffer(int start, int end) {
        if (start < 0 || end > this.bufferSize) {
            return;
        }
        this.bufferSize = YoBufferVariableEntry.computeBufferSizeAfterCrop(start, end, this.bufferSize);
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).cropBuffer(start, end);
        }
        this.currentIndex = (this.currentIndex - start + this.bufferSize) % this.bufferSize;
        if (this.currentIndex < 0 || this.currentIndex >= this.bufferSize) {
            this.currentIndex = 0;
        }
        this.inPoint = 0;
        this.outPoint = this.bufferSize - 1;
        this.gotoInPoint();
    }

    public void cutBuffer() {
        if (this.inPoint <= this.outPoint) {
            this.cutBuffer(this.inPoint, this.outPoint);
        }
    }

    public void cutBuffer(int start, int end) {
        if (start < 0 || end > this.bufferSize || start > end) {
            return;
        }
        this.bufferSize = YoBufferVariableEntry.computeBufferSizeAfterCut(start, end, this.bufferSize);
        for (int i = 0; i < this.entries.size(); ++i) {
            YoBufferVariableEntry entry = this.entries.get(i);
            int actualBufferSize = entry.cutBuffer(start, end);
            if (actualBufferSize < 0) continue;
            this.bufferSize = actualBufferSize;
        }
        this.currentIndex = (this.currentIndex - start + this.bufferSize) % this.bufferSize;
        if (this.currentIndex < 0 || this.currentIndex >= this.bufferSize) {
            this.currentIndex = 0;
        }
        this.inPoint = 0;
        this.outPoint = start - 1;
        this.gotoOutPoint();
    }

    public void thinData(int n) {
        this.shiftBuffer();
        this.inPoint = 0;
        this.currentIndex = 0;
        if (this.bufferSize <= 2 * n) {
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            YoBufferVariableEntry entry = this.entries.get(i);
            int newBufferSize = entry.thinData(n);
            if (newBufferSize < 0) continue;
            this.bufferSize = newBufferSize;
        }
        this.outPoint = this.bufferSize - 1;
        this.gotoInPoint();
    }

    public double computeAverage(YoVariable variable) {
        YoBufferVariableEntry entry = this.getEntry(variable);
        if (entry == null) {
            return Double.NaN;
        }
        return entry.computeAverage();
    }

    public void applyProcessor(YoBufferProcessor processor) {
        processor.initialize(this);
        if (processor.goForward()) {
            this.gotoInPoint();
            while (!this.isAtOutPoint()) {
                processor.process(this.inPoint, this.outPoint, this.currentIndex);
                this.writeIntoBuffer();
                this.tickAndReadFromBuffer(1);
            }
            processor.process(this.inPoint, this.outPoint, this.currentIndex);
            this.writeIntoBuffer();
            this.tickAndReadFromBuffer(1);
        } else {
            this.gotoOutPoint();
            while (!this.isAtInPoint()) {
                processor.process(this.outPoint, this.inPoint, this.currentIndex);
                this.writeIntoBuffer();
                this.tickAndReadFromBuffer(-1);
            }
            processor.process(this.outPoint, this.inPoint, this.currentIndex);
            this.writeIntoBuffer();
            this.tickAndReadFromBuffer(-1);
        }
    }

    @Override
    public int getInPoint() {
        return this.inPoint;
    }

    @Override
    public int getOutPoint() {
        return this.outPoint;
    }

    public int getNextKeyPoint() {
        return this.keyPointsHandler.getNextKeyPoint(this.currentIndex);
    }

    public int getPreviousKeyPoint() {
        return this.keyPointsHandler.getPreviousKeyPoint(this.currentIndex);
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public YoBufferVariableEntry getEntry(YoVariable variable) {
        for (YoBufferVariableEntry entry : this.entries) {
            if (entry.getVariable() != variable) continue;
            return entry;
        }
        return null;
    }

    public List<YoBufferVariableEntry> getEntries() {
        return this.entries;
    }

    @Override
    public List<YoVariable> getVariables() {
        return this.entries.stream().map(YoBufferVariableEntry::getVariable).collect(Collectors.toList());
    }

    public void addListener(YoBufferIndexChangedListener listener) {
        this.indexChangedListeners.add(listener);
    }

    public void removeListeners() {
        this.indexChangedListeners.clear();
    }

    public boolean removeListener(YoBufferIndexChangedListener listener) {
        return this.indexChangedListeners.remove(listener);
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean epsilonEquals(YoBuffer other, double epsilon) {
        ArrayList<YoBufferVariableEntry> thisEntries = this.entries;
        ArrayList<YoBufferVariableEntry> otherEntries = other.entries;
        if (thisEntries.size() != otherEntries.size()) {
            return false;
        }
        if (this.getBufferInOutLength() != other.getBufferInOutLength()) {
            return false;
        }
        int length = this.getBufferInOutLength();
        for (YoBufferVariableEntry otherEntry : otherEntries) {
            YoVariable variable = otherEntry.getVariable();
            YoBufferVariableEntry thisEntry = this.findVariableEntry(variable.getFullNameString());
            if (thisEntry == null) {
                return false;
            }
            int count = 0;
            int thisIndex = this.getInPoint();
            int otherIndex = other.getInPoint();
            while (count < length) {
                double otherDataPoint;
                double thisDataPoint = thisEntry.readBufferAt(thisIndex);
                if (Double.compare(thisDataPoint, otherDataPoint = otherEntry.readBufferAt(otherIndex)) != 0 && !EuclidCoreTools.epsilonEquals((double)thisDataPoint, (double)otherDataPoint, (double)epsilon)) {
                    return false;
                }
                ++count;
                ++otherIndex;
                if (++thisIndex >= this.getBufferSize()) {
                    thisIndex = 0;
                }
                if (otherIndex < other.getBufferSize()) continue;
                otherIndex = 0;
            }
        }
        return true;
    }

    public void setTimeVariableName(String timeVariableName) {
        if (this.findVariableEntry(timeVariableName) == null) {
            LogTools.error((String)"The requested timeVariableName does not exist, change not successful");
        } else {
            this.timeVariableName = timeVariableName;
        }
    }

    public String getTimeVariableName() {
        return this.timeVariableName;
    }

    public KeyPointsHandler getKeyPointsHandler() {
        return this.keyPointsHandler;
    }

    @Override
    public double[] getTimeBuffer() {
        return this.findVariableEntry(this.timeVariableName).getBuffer();
    }

    @Override
    public YoVariable findVariable(String namespaceEnding, String name) {
        YoBufferVariableEntry entry = this.findVariableEntry(namespaceEnding, name);
        return entry == null ? null : entry.getVariable();
    }

    public YoBufferVariableEntry findVariableEntry(String name) {
        int separatorIndex = name.lastIndexOf(YoTools.NAMESPACE_SEPERATOR_STRING);
        if (separatorIndex == -1) {
            return this.findVariableEntry(null, name);
        }
        return this.findVariableEntry(name.substring(0, separatorIndex), name.substring(separatorIndex + 1));
    }

    public YoBufferVariableEntry findVariableEntry(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        List<YoBufferVariableEntry> entryList = this.simpleNameToEntriesMap.get(name.toLowerCase());
        if (entryList == null || entryList.isEmpty()) {
            return null;
        }
        if (namespaceEnding == null) {
            return entryList.get(0);
        }
        for (int i = 0; i < entryList.size(); ++i) {
            YoBufferVariableEntry candidate = entryList.get(i);
            if (!candidate.getVariable().getNamespace().endsWith(namespaceEnding, true)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public List<YoVariable> findVariables(String namespaceEnding, String name) {
        return this.findVariableEntries(namespaceEnding, name).stream().map(YoBufferVariableEntry::getVariable).collect(Collectors.toList());
    }

    public List<YoBufferVariableEntry> findVariableEntries(String name) {
        int separatorIndex = name.lastIndexOf(YoTools.NAMESPACE_SEPERATOR_STRING);
        if (separatorIndex == -1) {
            return this.findVariableEntries(null, name);
        }
        return this.findVariableEntries(name.substring(0, separatorIndex), name.substring(separatorIndex + 1));
    }

    public List<YoBufferVariableEntry> findVariableEntries(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        List<YoBufferVariableEntry> entryList = this.simpleNameToEntriesMap.get(name.toLowerCase());
        if (entryList == null || entryList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<YoBufferVariableEntry> result = new ArrayList<YoBufferVariableEntry>();
        if (namespaceEnding == null) {
            result.addAll(entryList);
        } else {
            for (int i = 0; i < entryList.size(); ++i) {
                YoBufferVariableEntry candidate = entryList.get(i);
                if (!candidate.getVariable().getNamespace().endsWith(namespaceEnding, true)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    @Override
    public List<YoVariable> findVariables(YoNamespace namespace) {
        return this.findVariableEntries(namespace).stream().map(YoBufferVariableEntry::getVariable).collect(Collectors.toList());
    }

    public List<YoBufferVariableEntry> findVariableEntries(YoNamespace namespace) {
        ArrayList<YoBufferVariableEntry> result = new ArrayList<YoBufferVariableEntry>();
        for (YoBufferVariableEntry entry : this.entries) {
            if (!entry.getVariable().getNamespace().equals(namespace)) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public List<YoVariable> filterVariables(Predicate<YoVariable> filter) {
        return this.filterVariableEntries(filter).stream().map(YoBufferVariableEntry::getVariable).collect(Collectors.toList());
    }

    public List<YoBufferVariableEntry> filterVariableEntries(Predicate<YoVariable> filter) {
        ArrayList<YoBufferVariableEntry> result = new ArrayList<YoBufferVariableEntry>();
        for (YoBufferVariableEntry entry : this.entries) {
            if (!filter.test(entry.getVariable())) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public boolean hasUniqueVariable(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        return this.countNumberOfEntries(namespaceEnding, name) == 1;
    }

    private int countNumberOfEntries(String parentNamespace, String name) {
        List<YoBufferVariableEntry> entryList = this.simpleNameToEntriesMap.get(name.toLowerCase());
        if (entryList == null || entryList.isEmpty()) {
            return 0;
        }
        if (parentNamespace == null) {
            return entryList.size();
        }
        int count = 0;
        for (int i = 0; i < entryList.size(); ++i) {
            if (!entryList.get(i).getVariable().getNamespace().endsWith(parentNamespace, true)) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return "Number of variables: " + this.entries.size() + ", buffer size: " + this.getBufferSize() + ", in-point: " + this.inPoint + ", out-point: " + this.outPoint;
    }
}

