/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid;

import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryIOTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.euclid.YoPoint3D;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoPose3D
implements Pose3DBasics {
    private final YoPoint3D position;
    private final YoQuaternion orientation;

    public YoPose3D(String namePrefix, YoRegistry registry) {
        this(namePrefix, "", registry);
    }

    public YoPose3D(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.position = new YoPoint3D(namePrefix, nameSuffix, registry);
        this.orientation = new YoQuaternion(namePrefix, nameSuffix, registry);
    }

    public YoPose3D(YoPoint3D position, YoQuaternion orientation) {
        this.position = position;
        this.orientation = orientation;
    }

    public void setX(double x) {
        this.position.setX(x);
    }

    public void setY(double y) {
        this.position.setY(y);
    }

    public void setZ(double z) {
        this.position.setZ(z);
    }

    public YoPoint3D getPosition() {
        return this.position;
    }

    public YoQuaternion getOrientation() {
        return this.orientation;
    }

    public YoDouble getYoX() {
        return this.position.getYoX();
    }

    public YoDouble getYoY() {
        return this.position.getYoY();
    }

    public YoDouble getYoZ() {
        return this.position.getYoZ();
    }

    public YoDouble getYoQs() {
        return this.orientation.getYoQs();
    }

    public YoDouble getYoQx() {
        return this.orientation.getYoQx();
    }

    public YoDouble getYoQy() {
        return this.orientation.getYoQy();
    }

    public YoDouble getYoQz() {
        return this.orientation.getYoQz();
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public double getZ() {
        return this.position.getZ();
    }

    public double getYaw() {
        return this.orientation.getYaw();
    }

    public double getPitch() {
        return this.orientation.getPitch();
    }

    public double getRoll() {
        return this.orientation.getRoll();
    }

    public boolean equals(Object object) {
        if (object instanceof Pose3DReadOnly) {
            return this.equals((EuclidGeometry)((Pose3DReadOnly)object));
        }
        return false;
    }

    public String toString() {
        return EuclidGeometryIOTools.getPose3DString((Pose3DReadOnly)this);
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.position, (Object)this.orientation);
    }
}

