/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid;

import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class YoTuple3D
implements Tuple3DBasics {
    private final String namePrefix;
    private final String nameSuffix;
    private final YoDouble x;
    private final YoDouble y;
    private final YoDouble z;

    public YoTuple3D(YoDouble xVariable, YoDouble yVariable, YoDouble zVariable) {
        this.namePrefix = YoGeometryNameTools.getCommonPrefix(xVariable.getName(), yVariable.getName(), zVariable.getName());
        this.nameSuffix = YoGeometryNameTools.getCommonSuffix(xVariable.getName(), yVariable.getName(), zVariable.getName());
        this.x = xVariable;
        this.y = yVariable;
        this.z = zVariable;
    }

    public YoTuple3D(String namePrefix, YoRegistry registry) {
        this(namePrefix, "", registry);
    }

    public YoTuple3D(String namePrefix, String nameSuffix, YoRegistry registry) {
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.x = new YoDouble(YoGeometryNameTools.createXName(namePrefix, nameSuffix), registry);
        this.y = new YoDouble(YoGeometryNameTools.createYName(namePrefix, nameSuffix), registry);
        this.z = new YoDouble(YoGeometryNameTools.createZName(namePrefix, nameSuffix), registry);
    }

    public void setX(double x) {
        this.x.set(x);
    }

    public void setY(double y) {
        this.y.set(y);
    }

    public void setZ(double z) {
        this.z.set(z);
    }

    public double getX() {
        return this.x.getDoubleValue();
    }

    public double getY() {
        return this.y.getDoubleValue();
    }

    public double getZ() {
        return this.z.getDoubleValue();
    }

    public final YoDouble getYoX() {
        return this.x;
    }

    public final YoDouble getYoY() {
        return this.y;
    }

    public final YoDouble getYoZ() {
        return this.z;
    }

    public void notifyVariableChangedListeners() {
        this.x.notifyListeners();
    }

    public final void attachVariableChangedListener(YoVariableChangedListener variableChangedListener) {
        this.x.addListener(variableChangedListener);
        this.y.addListener(variableChangedListener);
        this.z.addListener(variableChangedListener);
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String toString() {
        return EuclidCoreIOTools.getTuple3DString((Tuple3DReadOnly)this);
    }

    public boolean equals(Object object) {
        if (object instanceof Tuple3DReadOnly) {
            return this.equals((EuclidGeometry)((Tuple3DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ());
    }
}

