/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameBoundingBox2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameBoundingBox2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class YoFrameConvexPolygon2D
implements FixedFrameConvexPolygon2DBasics {
    private final List<YoFramePoint2D> yoVertexBuffer = new ArrayList<YoFramePoint2D>();
    private final List<FixedFramePoint2DBasics> vertexBufferView = Collections.unmodifiableList(this.yoVertexBuffer);
    private final boolean clockwiseOrdered = true;
    private final RigidBodyTransform transformToDesiredFrame = new RigidBodyTransform();
    private final YoInteger numberOfVertices;
    private final ReferenceFrame referenceFrame;
    private final FixedFrameBoundingBox2DBasics boundingBox = EuclidFrameFactories.newFixedFrameBoundingBox2DBasics((ReferenceFrameHolder)this);
    private final FixedFramePoint2DBasics centroid = EuclidFrameFactories.newFixedFramePoint2DBasics((ReferenceFrameHolder)this);
    private double area;
    private boolean isUpToDate = false;
    private boolean boundingBoxDirty = true;
    private boolean areaCentroidDirty = true;
    private final Point3D vertex3D = new Point3D();
    private final List<Point2D> tempVertexBuffer = new ArrayList<Point2D>();

    public YoFrameConvexPolygon2D(String namePrefix, ReferenceFrame referenceFrame, int maxNumberOfVertices, YoRegistry registry) {
        this(namePrefix, "", referenceFrame, maxNumberOfVertices, registry);
    }

    public YoFrameConvexPolygon2D(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, int maxNumberOfVertices, YoRegistry registry) {
        this.numberOfVertices = new YoInteger(namePrefix + "NumVertices" + nameSuffix, registry);
        this.referenceFrame = referenceFrame;
        for (int i = 0; i < maxNumberOfVertices; ++i) {
            YoFramePoint2D point = new YoFramePoint2D(namePrefix + "_" + i + "_", nameSuffix, referenceFrame, registry);
            this.yoVertexBuffer.add(point);
            this.tempVertexBuffer.add(new Point2D());
        }
    }

    public YoFrameConvexPolygon2D(List<YoFramePoint2D> yoVertexBuffer, YoInteger yoNumberOfVertices, ReferenceFrame referenceFrame) {
        this.numberOfVertices = yoNumberOfVertices;
        this.referenceFrame = referenceFrame;
        for (YoFramePoint2D vertex : yoVertexBuffer) {
            this.yoVertexBuffer.add(vertex);
            this.tempVertexBuffer.add(new Point2D());
        }
    }

    public FixedFramePoint2DBasics getVertexUnsafe(int index) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(index);
        return this.yoVertexBuffer.get(index);
    }

    public void notifyVerticesChanged() {
        this.isUpToDate = false;
    }

    public void clear() {
        this.numberOfVertices.set(0);
        this.area = Double.NaN;
        this.centroid.setToNaN();
        this.boundingBox.setToNaN();
        this.isUpToDate = false;
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    public void clearAndUpdate() {
        this.clear();
        this.isUpToDate = true;
        this.boundingBoxDirty = false;
        this.areaCentroidDirty = false;
    }

    public void set(Vertex2DSupplier vertex2DSupplier) {
        if (vertex2DSupplier instanceof ConvexPolygon2DReadOnly) {
            ConvexPolygon2DReadOnly other = (ConvexPolygon2DReadOnly)vertex2DSupplier;
            if (!other.isClockwiseOrdered()) {
                super.set(vertex2DSupplier);
                return;
            }
            this.clear();
            this.numberOfVertices.set(other.getNumberOfVertices());
            for (int i = 0; i < this.numberOfVertices.getValue(); ++i) {
                Point2DReadOnly otherVertex = other.getVertexUnsafe(i);
                if (i >= this.yoVertexBuffer.size()) {
                    throw new RuntimeException("This polygon has reached its maximum number of vertices.");
                }
                this.yoVertexBuffer.get(i).set((Tuple2DReadOnly)otherVertex);
            }
            if (other.isUpToDate()) {
                this.isUpToDate = true;
                this.boundingBoxDirty = true;
                this.areaCentroidDirty = true;
            }
        } else {
            super.set(vertex2DSupplier);
        }
    }

    public void set(YoFrameConvexPolygon2D other) {
        if (!other.clockwiseOrdered) {
            super.set((FrameVertex2DSupplier)other);
            return;
        }
        this.checkReferenceFrameMatch((ReferenceFrameHolder)other);
        this.numberOfVertices.set(other.numberOfVertices.getValue());
        for (int i = 0; i < other.numberOfVertices.getValue(); ++i) {
            FixedFramePoint2DBasics otherVertex = other.yoVertexBuffer.get(i);
            if (i >= this.yoVertexBuffer.size()) {
                throw new RuntimeException("This polygon has reached its maximum number of vertices.");
            }
            this.yoVertexBuffer.get(i).set((FrameTuple2DReadOnly)otherVertex);
        }
        this.boundingBox.set((FrameBoundingBox2DReadOnly)other.boundingBox);
        this.centroid.set((FrameTuple2DReadOnly)other.centroid);
        this.area = other.area;
        this.isUpToDate = other.isUpToDate;
        this.boundingBoxDirty = other.boundingBoxDirty;
        this.areaCentroidDirty = other.areaCentroidDirty;
    }

    public void set(FrameVertex2DSupplier frameVertex2DSupplier) {
        if (frameVertex2DSupplier instanceof YoFrameConvexPolygon2D) {
            this.set((YoFrameConvexPolygon2D)frameVertex2DSupplier);
        } else if (frameVertex2DSupplier instanceof FrameConvexPolygon2DReadOnly) {
            FrameConvexPolygon2DReadOnly other = (FrameConvexPolygon2DReadOnly)frameVertex2DSupplier;
            if (!other.isClockwiseOrdered()) {
                super.set(frameVertex2DSupplier);
                return;
            }
            this.clear();
            this.numberOfVertices.set(other.getNumberOfVertices());
            for (int i = 0; i < this.numberOfVertices.getValue(); ++i) {
                FramePoint2DReadOnly otherVertex = other.getVertexUnsafe(i);
                if (i >= this.yoVertexBuffer.size()) {
                    throw new RuntimeException("This polygon has reached its maximum number of vertices.");
                }
                this.yoVertexBuffer.get(i).set((FrameTuple2DReadOnly)otherVertex);
            }
            if (other.isUpToDate()) {
                this.isUpToDate = true;
                this.boundingBoxDirty = true;
                this.areaCentroidDirty = true;
            }
        } else {
            super.set(frameVertex2DSupplier);
        }
    }

    public void setMatchingFrame(FrameVertex2DSupplier frameVertex2DSupplier, boolean checkIfTransformInXYPlane) {
        this.set((Vertex2DSupplier)frameVertex2DSupplier);
        if (frameVertex2DSupplier.getReferenceFrame() != this.referenceFrame) {
            frameVertex2DSupplier.getReferenceFrame().getTransformToDesiredFrame(this.transformToDesiredFrame, this.referenceFrame);
            this.applyTransform((Transform)this.transformToDesiredFrame, checkIfTransformInXYPlane);
        }
    }

    public void addVertexMatchingFrame(ReferenceFrame referenceFrame, Point2DReadOnly vertex, boolean checkIfTransformInXYPlane) {
        if (this.getReferenceFrame() == referenceFrame) {
            this.addVertex(vertex);
        } else {
            referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, this.getReferenceFrame());
            this.addVertex(vertex);
            this.getVertexUnsafe(this.getNumberOfVertices() - 1).applyTransform((Transform)this.transformToDesiredFrame, checkIfTransformInXYPlane);
        }
    }

    public void addVertexMatchingFrame(ReferenceFrame referenceFrame, Point3DReadOnly vertex) {
        if (this.getReferenceFrame() == referenceFrame) {
            this.addVertex(vertex);
        } else {
            referenceFrame.getTransformToDesiredFrame(this.transformToDesiredFrame, this.getReferenceFrame());
            this.transformToDesiredFrame.transform(vertex, (Point3DBasics)this.vertex3D);
            this.addVertex((Point3DReadOnly)this.vertex3D);
        }
    }

    public void update() {
        int i;
        if (this.isUpToDate) {
            return;
        }
        for (i = 0; i < this.numberOfVertices.getValue(); ++i) {
            this.tempVertexBuffer.get(i).set((Tuple2DReadOnly)this.yoVertexBuffer.get(i));
        }
        this.numberOfVertices.set(EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D(this.tempVertexBuffer, (int)this.numberOfVertices.getValue()));
        for (i = 0; i < this.numberOfVertices.getValue(); ++i) {
            this.yoVertexBuffer.get(i).set((Tuple2DReadOnly)this.tempVertexBuffer.get(i));
        }
        this.isUpToDate = true;
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    private void updateCentroidAndArea() {
        if (this.areaCentroidDirty) {
            this.areaCentroidDirty = false;
            this.area = EuclidGeometryPolygonTools.computeConvexPolygon2DArea(this.yoVertexBuffer, (int)this.numberOfVertices.getValue(), (boolean)true, (Point2DBasics)this.centroid);
        }
    }

    private void updateBoundingBox() {
        if (this.boundingBoxDirty) {
            this.boundingBoxDirty = false;
            this.boundingBox.setToNaN();
            this.boundingBox.updateToIncludePoints((FrameVertex2DSupplier)this);
        }
    }

    public void addVertex(double x, double y) {
        this.isUpToDate = false;
        YoFramePoint2D newVertex = this.yoVertexBuffer.get(this.numberOfVertices.getValue());
        if (newVertex == null) {
            throw new RuntimeException("This polygon has reached its maximum number of vertices.");
        }
        newVertex.set(x, y);
        this.numberOfVertices.increment();
    }

    public void removeVertex(int indexOfVertexToRemove) {
        this.checkNonEmpty();
        this.checkIndexInBoundaries(indexOfVertexToRemove);
        if (indexOfVertexToRemove == this.numberOfVertices.getValue() - 1) {
            this.numberOfVertices.decrement();
            return;
        }
        this.isUpToDate = false;
        YoFrameConvexPolygon2D.swap(this.yoVertexBuffer, indexOfVertexToRemove, this.numberOfVertices.getValue() - 1);
        this.numberOfVertices.decrement();
    }

    public List<? extends FramePoint2DReadOnly> getVertexBufferView() {
        return this.vertexBufferView;
    }

    public boolean isClockwiseOrdered() {
        return true;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    public int getNumberOfVertices() {
        return this.numberOfVertices.getValue();
    }

    public int getMaxNumberOfVertices() {
        return this.yoVertexBuffer.size();
    }

    public YoInteger getYoNumberOfVertices() {
        return this.numberOfVertices;
    }

    public List<YoFramePoint2D> getVertexBuffer() {
        return this.yoVertexBuffer;
    }

    public double getArea() {
        this.checkIfUpToDate();
        this.updateCentroidAndArea();
        return this.area;
    }

    public FramePoint2DReadOnly getCentroid() {
        this.checkIfUpToDate();
        this.updateCentroidAndArea();
        return this.centroid;
    }

    public FrameBoundingBox2DReadOnly getBoundingBox() {
        this.checkIfUpToDate();
        this.updateBoundingBox();
        return this.boundingBox;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void translate(double x, double y) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).add(x, y);
        }
        if (!this.boundingBoxDirty) {
            this.boundingBox.getMinPoint().add(x, y);
            this.boundingBox.getMaxPoint().add(x, y);
        }
        if (!this.areaCentroidDirty) {
            this.centroid.add(x, y);
        }
    }

    public void applyTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyTransform(transform, checkIfTransformInXYPlane);
        }
        this.postTransform(transform);
    }

    public void applyInverseTransform(Transform transform, boolean checkIfTransformInXYPlane) {
        this.checkIfUpToDate();
        for (int i = 0; i < this.getNumberOfVertices(); ++i) {
            this.getVertexUnsafe(i).applyInverseTransform(transform, checkIfTransformInXYPlane);
        }
        this.postTransform(transform);
    }

    private void postTransform(Transform transform) {
        if (this.numberOfVertices.getValue() <= 3) {
            this.notifyVerticesChanged();
            this.update();
            return;
        }
        boolean updateVertices = true;
        if (transform instanceof RigidBodyTransformReadOnly) {
            RigidBodyTransformReadOnly rbTransform = (RigidBodyTransformReadOnly)transform;
            updateVertices = rbTransform.hasRotation();
        } else if (transform instanceof AffineTransformReadOnly) {
            AffineTransformReadOnly aTransform = (AffineTransformReadOnly)transform;
            updateVertices = aTransform.hasLinearTransform();
        }
        if (updateVertices) {
            for (int i = 0; i < this.getNumberOfVertices(); ++i) {
                this.tempVertexBuffer.get(i).set((Tuple2DReadOnly)this.yoVertexBuffer.get(i));
            }
            EuclidGeometryPolygonTools.Convexity convexity = null;
            for (int vertexIndex = 0; vertexIndex < this.getNumberOfVertices(); ++vertexIndex) {
                if (convexity == null) {
                    convexity = EuclidGeometryPolygonTools.polygon2DConvexityAtVertex((int)vertexIndex, this.tempVertexBuffer, (int)vertexIndex, (boolean)true);
                }
                if (convexity != null) break;
            }
            if (convexity == EuclidGeometryPolygonTools.Convexity.CONCAVE) {
                EuclidCoreTools.reverse(this.tempVertexBuffer, (int)0, (int)this.getNumberOfVertices());
            }
            int minXMaxYVertexIndex = EuclidGeometryPolygonTools.findMinXMaxYVertexIndex(this.tempVertexBuffer, (int)this.getNumberOfVertices());
            EuclidCoreTools.rotate(this.tempVertexBuffer, (int)0, (int)this.getNumberOfVertices(), (int)(-minXMaxYVertexIndex));
            for (int i = 0; i < this.getNumberOfVertices(); ++i) {
                this.yoVertexBuffer.get(i).set((Tuple2DReadOnly)this.tempVertexBuffer.get(i));
            }
        }
        this.boundingBoxDirty = true;
        this.areaCentroidDirty = true;
    }

    public YoFrameConvexPolygon2D duplicate(YoRegistry newRegistry) {
        YoInteger yoNumberOfVertices = (YoInteger)newRegistry.findVariable(this.numberOfVertices.getFullNameString());
        ArrayList<YoFramePoint2D> yoVertexBuffer = new ArrayList<YoFramePoint2D>();
        for (int i = 0; i < this.yoVertexBuffer.size(); ++i) {
            yoVertexBuffer.add(this.yoVertexBuffer.get(i).duplicate(newRegistry));
        }
        return new YoFrameConvexPolygon2D(yoVertexBuffer, yoNumberOfVertices, this.referenceFrame);
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameConvexPolygon2DString((FrameConvexPolygon2DReadOnly)this);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameConvexPolygon2DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FrameConvexPolygon2DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)Boolean.hashCode(true), this.vertexBufferView);
        bits = EuclidHashCodeTools.addToHashCode((long)bits, (Object)this.referenceFrame);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    private static void swap(List<YoFramePoint2D> vertexBuffer, int i, int j) {
        if (i == j) {
            return;
        }
        YoFramePoint2D iVertex = vertexBuffer.get(i);
        double x_i = iVertex.getX();
        double y_i = iVertex.getY();
        YoFramePoint2D jVertex = vertexBuffer.get(j);
        double x_j = jVertex.getX();
        double y_j = jVertex.getY();
        iVertex.set(x_j, y_j);
        jVertex.set(x_i, y_i);
    }
}

