/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameLineSegment2D
implements FixedFrameLineSegment2DBasics {
    private final YoFramePoint2D firstEndpoint;
    private final YoFramePoint2D secondEndpoint;

    public YoFrameLineSegment2D(String namePrefix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this(namePrefix, "", referenceFrame, registry);
    }

    public YoFrameLineSegment2D(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this.firstEndpoint = new YoFramePoint2D(namePrefix + "FirstEndpoint", nameSuffix, referenceFrame, registry);
        this.secondEndpoint = new YoFramePoint2D(namePrefix + "SecondEndpoint", nameSuffix, referenceFrame, registry);
    }

    public YoFrameLineSegment2D(YoFramePoint2D firstEndpoint, YoFramePoint2D secondEndpoint) {
        this(firstEndpoint.getYoX(), firstEndpoint.getYoY(), secondEndpoint.getYoX(), secondEndpoint.getYoY(), firstEndpoint.getReferenceFrame());
        firstEndpoint.checkReferenceFrameMatch((ReferenceFrameHolder)secondEndpoint);
    }

    public YoFrameLineSegment2D(YoDouble firstEndpointX, YoDouble firstEndpointY, YoDouble secondEndpointX, YoDouble secondEndpointY, ReferenceFrame referenceFrame) {
        this.firstEndpoint = new YoFramePoint2D(firstEndpointX, firstEndpointY, referenceFrame);
        this.secondEndpoint = new YoFramePoint2D(secondEndpointX, secondEndpointY, referenceFrame);
    }

    public FixedFramePoint2DBasics getFirstEndpoint() {
        return this.firstEndpoint;
    }

    public FixedFramePoint2DBasics getSecondEndpoint() {
        return this.secondEndpoint;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.firstEndpoint.getReferenceFrame();
    }

    public YoDouble getYoFirstEndpointX() {
        return this.firstEndpoint.getYoX();
    }

    public YoDouble getYoFirstEndpointY() {
        return this.firstEndpoint.getYoY();
    }

    public YoDouble getYoSecondEndpointX() {
        return this.secondEndpoint.getYoX();
    }

    public YoDouble getYoSecondEndpointY() {
        return this.secondEndpoint.getYoY();
    }

    public YoFrameLineSegment2D duplicate(YoRegistry newRegistry) {
        return new YoFrameLineSegment2D(this.firstEndpoint.duplicate(newRegistry), this.secondEndpoint.duplicate(newRegistry));
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameLineSegment2DString((FrameLineSegment2DReadOnly)this);
    }

    public boolean equals(Object object) {
        if (object instanceof FrameLineSegment2DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FrameLineSegment2DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getFirstEndpoint(), (Object)this.getSecondEndpoint());
    }
}

