/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.euclid.YoPose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFramePose3D
implements FixedFramePose3DBasics {
    private final YoFramePoint3D position;
    private final YoFrameQuaternion orientation;

    public YoFramePose3D(YoPose3D pose, ReferenceFrame referenceFrame) {
        this(new YoFramePoint3D(pose.getPosition(), referenceFrame), new YoFrameQuaternion(pose.getOrientation(), referenceFrame));
    }

    public YoFramePose3D(YoFramePoint3D position, YoFrameQuaternion orientation) {
        position.checkReferenceFrameMatch((ReferenceFrameHolder)orientation);
        position.getReferenceFrame();
        this.position = position;
        this.orientation = orientation;
    }

    public YoFramePose3D(String namePrefix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this(namePrefix, "", referenceFrame, registry);
    }

    public YoFramePose3D(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this.position = new YoFramePoint3D(namePrefix, nameSuffix, referenceFrame, registry);
        this.orientation = new YoFrameQuaternion(namePrefix, nameSuffix, referenceFrame, registry);
    }

    public void set(YoFramePoseUsingYawPitchRoll yoFramePose) {
        this.set((FrameTuple3DReadOnly)yoFramePose.getPosition(), (FrameOrientation3DReadOnly)yoFramePose.getOrientation());
    }

    public void setMatchingFrame(FramePose3DReadOnly other) {
        this.position.setMatchingFrame((FrameTuple3DReadOnly)other.getPosition());
        this.orientation.setMatchingFrame(other.getOrientation());
    }

    public void setMatchingFrame(FrameTuple3DReadOnly position, FrameOrientation3DReadOnly orientation) {
        this.position.setMatchingFrame(position);
        this.orientation.setMatchingFrame(orientation);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.position.getReferenceFrame();
    }

    public YoFramePoint3D getPosition() {
        return this.position;
    }

    public YoFrameQuaternion getOrientation() {
        return this.orientation;
    }

    public YoDouble getYoX() {
        return this.position.getYoX();
    }

    public YoDouble getYoY() {
        return this.position.getYoY();
    }

    public YoDouble getYoZ() {
        return this.position.getYoZ();
    }

    public YoDouble getYoQs() {
        return this.orientation.getYoQs();
    }

    public YoDouble getYoQx() {
        return this.orientation.getYoQx();
    }

    public YoDouble getYoQy() {
        return this.orientation.getYoQy();
    }

    public YoDouble getYoQz() {
        return this.orientation.getYoQz();
    }

    public void attachVariableChangedListener(YoVariableChangedListener variableChangedListener) {
        this.position.attachVariableChangedListener(variableChangedListener);
        this.orientation.attachVariableChangedListener(variableChangedListener);
    }

    public YoFramePose3D duplicate(YoRegistry newRegistry) {
        return new YoFramePose3D(this.position.duplicate(newRegistry), this.orientation.duplicate(newRegistry));
    }

    public String toString() {
        return EuclidFrameIOTools.getFramePose3DString((FramePose3DReadOnly)this);
    }

    public boolean equals(Object object) {
        if (object instanceof FramePose3DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FramePose3DReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)this.getPosition(), (Object)this.getOrientation());
    }
}

