/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameQuaternion
extends YoQuaternion
implements FixedFrameQuaternionBasics {
    private final ReferenceFrame referenceFrame;

    public YoFrameQuaternion(String namePrefix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this(namePrefix, "", referenceFrame, registry);
    }

    public YoFrameQuaternion(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, YoRegistry registry) {
        super(namePrefix, nameSuffix, registry);
        this.referenceFrame = referenceFrame;
        this.setToZero();
    }

    public YoFrameQuaternion(YoQuaternion yoQuaternion, ReferenceFrame referenceFrame) {
        super(yoQuaternion.getYoQx(), yoQuaternion.getYoQy(), yoQuaternion.getYoQz(), yoQuaternion.getYoQs());
        this.referenceFrame = referenceFrame;
    }

    public YoFrameQuaternion(YoDouble qxVariable, YoDouble qyVariable, YoDouble qzVariable, YoDouble qsVariable, ReferenceFrame referenceFrame) {
        super(qxVariable, qyVariable, qzVariable, qsVariable);
        this.referenceFrame = referenceFrame;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    @Override
    public YoFrameQuaternion duplicate(YoRegistry newRegistry) {
        YoDouble x = (YoDouble)newRegistry.findVariable(this.getYoQx().getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(this.getYoQy().getFullNameString());
        YoDouble z = (YoDouble)newRegistry.findVariable(this.getYoQz().getFullNameString());
        YoDouble s = (YoDouble)newRegistry.findVariable(this.getYoQs().getFullNameString());
        return new YoFrameQuaternion(x, y, z, s, this.getReferenceFrame());
    }

    @Override
    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)super.hashCode(), (Object)this.getReferenceFrame());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FrameTuple4DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FrameTuple4DReadOnly)object));
        }
        return false;
    }

    @Override
    public String toString() {
        return EuclidFrameIOTools.getFrameTuple4DString((FrameTuple4DReadOnly)this);
    }
}

