/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameUnitVector2DBasics;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameTuple2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameUnitVector2D
extends YoFrameTuple2D
implements FixedFrameUnitVector2DBasics {
    private boolean dirty = false;

    public YoFrameUnitVector2D(YoDouble xVariable, YoDouble yVariable, ReferenceFrame referenceFrame) {
        super(xVariable, yVariable, referenceFrame);
        this.dirty = false;
    }

    public YoFrameUnitVector2D(String namePrefix, ReferenceFrame referenceFrame, YoRegistry registry) {
        super(namePrefix, "", referenceFrame, registry);
        this.setToZero();
    }

    public YoFrameUnitVector2D(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, YoRegistry registry) {
        super(namePrefix, nameSuffix, referenceFrame, registry);
        this.setToZero();
    }

    public YoFrameUnitVector2D duplicate(YoRegistry newRegistry) {
        YoDouble x = (YoDouble)newRegistry.findVariable(this.getYoX().getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(this.getYoY().getFullNameString());
        return new YoFrameUnitVector2D(x, y, this.getReferenceFrame());
    }

    public void absolute() {
        this.getYoX().set(Math.abs(this.getRawX()));
        this.getYoY().set(Math.abs(this.getRawY()));
    }

    public void negate() {
        this.getYoX().set(-this.getRawX());
        this.getYoY().set(-this.getRawY());
    }

    public void normalize() {
        if (this.dirty) {
            if (EuclidCoreTools.areAllZero((double)this.getRawX(), (double)this.getRawY(), (double)1.0E-16)) {
                this.setToZero();
            } else {
                double lengthInverse = 1.0 / EuclidCoreTools.fastNorm((double)this.getRawX(), (double)this.getRawY());
                this.getYoX().mul(lengthInverse);
                this.getYoY().mul(lengthInverse);
            }
            this.dirty = false;
        }
    }

    public void markAsDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void set(UnitVector2DReadOnly other) {
        this.getYoX().set(other.getRawX());
        this.getYoY().set(other.getRawY());
        this.dirty = other.isDirty();
    }

    @Override
    public void setX(double x) {
        if (this.getRawX() != x) {
            this.getYoX().set(x);
            this.markAsDirty();
        }
    }

    @Override
    public void setY(double y) {
        if (this.getRawY() != y) {
            this.getYoY().set(y);
            this.markAsDirty();
        }
    }

    public double getRawX() {
        return this.getYoX().getValue();
    }

    public double getRawY() {
        return this.getYoY().getValue();
    }

    @Override
    public double getX() {
        this.normalize();
        return super.getX();
    }

    @Override
    public double getY() {
        this.normalize();
        return super.getY();
    }
}

