/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameYawPitchRollBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameYawPitchRollReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFrameYawPitchRoll
implements FixedFrameYawPitchRollBasics {
    private final YoDouble yaw;
    private final YoDouble pitch;
    private final YoDouble roll;
    private final ReferenceFrame referenceFrame;
    private final FrameQuaternion frameQuaternion = new FrameQuaternion();
    private boolean enableNotifications = true;

    public YoFrameYawPitchRoll(String namePrefix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this(namePrefix, "", referenceFrame, registry);
    }

    public YoFrameYawPitchRoll(String namePrefix, String nameSuffix, ReferenceFrame referenceFrame, YoRegistry registry) {
        this.yaw = new YoDouble(YoGeometryNameTools.assembleName(namePrefix, "yaw", nameSuffix), registry);
        this.pitch = new YoDouble(YoGeometryNameTools.assembleName(namePrefix, "pitch", nameSuffix), registry);
        this.roll = new YoDouble(YoGeometryNameTools.assembleName(namePrefix, "roll", nameSuffix), registry);
        this.referenceFrame = referenceFrame;
    }

    public YoFrameYawPitchRoll(YoDouble yaw, YoDouble pitch, YoDouble roll, ReferenceFrame referenceFrame) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        this.referenceFrame = referenceFrame;
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll) {
        this.setYawPitchRoll(yaw, pitch, roll, true);
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll, boolean notifyListeners) {
        this.yaw.set(yaw, notifyListeners);
        this.pitch.set(pitch, notifyListeners);
        this.roll.set(roll, notifyListeners);
    }

    public void setYaw(double yaw) {
        this.yaw.set(yaw, this.enableNotifications);
    }

    public void setPitch(double pitch) {
        this.pitch.set(pitch, this.enableNotifications);
    }

    public void setRoll(double roll) {
        this.roll.set(roll, this.enableNotifications);
    }

    public void set(FrameOrientation3DReadOnly orientation, boolean notifyListeners) {
        this.enableNotifications = notifyListeners;
        this.set(orientation);
        this.enableNotifications = true;
    }

    public void set(Orientation3DReadOnly orientation, boolean notifyListeners) {
        this.enableNotifications = notifyListeners;
        this.set(orientation);
        this.enableNotifications = true;
    }

    public void setMatchingFrame(FrameOrientation3DReadOnly orientation, boolean notifyListeners) {
        this.enableNotifications = notifyListeners;
        this.setMatchingFrame(orientation);
        this.enableNotifications = true;
    }

    public void setFromReferenceFrame(ReferenceFrame referenceFrame, boolean notifyListeners) {
        this.enableNotifications = notifyListeners;
        this.setFromReferenceFrame(referenceFrame);
        this.enableNotifications = true;
    }

    public void add(YoFrameYawPitchRoll other) {
        this.yaw.add(other.getYaw());
        this.pitch.add(other.getPitch());
        this.roll.add(other.getRoll());
    }

    public void add(double yaw, double pitch, double roll) {
        this.yaw.add(yaw);
        this.pitch.add(pitch);
        this.roll.add(roll);
    }

    public double[] getYawPitchRoll() {
        return new double[]{this.yaw.getDoubleValue(), this.pitch.getDoubleValue(), this.roll.getDoubleValue()};
    }

    public double getYaw() {
        return this.yaw.getValue();
    }

    public double getPitch() {
        return this.pitch.getValue();
    }

    public double getRoll() {
        return this.roll.getValue();
    }

    public YoDouble getYoYaw() {
        return this.yaw;
    }

    public YoDouble getYoPitch() {
        return this.pitch;
    }

    public YoDouble getYoRoll() {
        return this.roll;
    }

    public void interpolate(YoFrameYawPitchRoll orientationOne, YoFrameYawPitchRoll orientationTwo, double alpha) {
        this.frameQuaternion.setIncludingFrame((FrameOrientation3DReadOnly)this);
        orientationOne.frameQuaternion.setIncludingFrame((FrameOrientation3DReadOnly)orientationOne);
        orientationTwo.frameQuaternion.setIncludingFrame((FrameOrientation3DReadOnly)orientationTwo);
        this.frameQuaternion.interpolate((FrameQuaternionReadOnly)orientationOne.frameQuaternion, (FrameQuaternionReadOnly)orientationTwo.frameQuaternion, alpha);
        this.set((FrameOrientation3DReadOnly)this.frameQuaternion);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public void attachVariableChangedListener(YoVariableChangedListener variableChangedListener) {
        this.yaw.addListener(variableChangedListener);
        this.pitch.addListener(variableChangedListener);
        this.roll.addListener(variableChangedListener);
    }

    public YoFrameYawPitchRoll duplicate(YoRegistry newRegistry) {
        YoDouble yaw = (YoDouble)newRegistry.findVariable(this.yaw.getFullNameString());
        YoDouble pitch = (YoDouble)newRegistry.findVariable(this.pitch.getFullNameString());
        YoDouble roll = (YoDouble)newRegistry.findVariable(this.roll.getFullNameString());
        return new YoFrameYawPitchRoll(yaw, pitch, roll, this.getReferenceFrame());
    }

    public boolean equals(Object object) {
        if (object instanceof FrameYawPitchRollReadOnly) {
            return super.equals((EuclidFrameGeometry)((FrameYawPitchRollReadOnly)object));
        }
        return false;
    }

    public int hashCode() {
        long bits = EuclidHashCodeTools.addToHashCode((long)EuclidHashCodeTools.toLongHashCode((double)this.getYaw(), (double)this.getPitch(), (double)this.getRoll()), (Object)this.referenceFrame);
        return EuclidHashCodeTools.toIntHashCode((long)bits);
    }

    public String toString() {
        return EuclidFrameIOTools.getFrameYawPitchRollString((FrameYawPitchRollReadOnly)this);
    }
}

