/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.euclid.referenceFrame;

import org.ejml.data.DMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameIOTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.yoVariables.euclid.YoQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.FrameIndexMap;
import us.ihmc.yoVariables.euclid.referenceFrame.interfaces.YoMutableFrameObject;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class YoMutableFrameQuaternion
extends YoQuaternion
implements FrameQuaternionBasics,
YoMutableFrameObject {
    private final YoLong frameId;
    private final FrameIndexMap frameIndexMap;

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame) {
        this(namePrefix, nameSuffix, registry);
        this.setToZero(referenceFrame);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, double x, double y, double z, double s) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, x, y, z, s);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, double[] tupleArray) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tupleArray);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, DMatrix matrix) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, matrix);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, QuaternionReadOnly quaternionReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, quaternionReadOnly);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, Tuple4DReadOnly tuple4DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, tuple4DReadOnly);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, Orientation3DReadOnly orientation3DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(referenceFrame, orientation3DReadOnly);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, Vector3DReadOnly rotationVector) {
        this(namePrefix, nameSuffix, registry);
        this.setRotationVectorIncludingFrame(referenceFrame, rotationVector);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, ReferenceFrame referenceFrame, double yaw, double pitch, double roll) {
        this(namePrefix, nameSuffix, registry);
        this.setYawPitchRollIncludingFrame(referenceFrame, yaw, pitch, roll);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, FrameTuple4DReadOnly frameTuple4DReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(frameTuple4DReadOnly);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry, FrameQuaternionReadOnly frameQuaternionReadOnly) {
        this(namePrefix, nameSuffix, registry);
        this.setIncludingFrame(frameQuaternionReadOnly);
    }

    public YoMutableFrameQuaternion(String namePrefix, String nameSuffix, YoRegistry registry) {
        super(namePrefix, nameSuffix, registry);
        this.frameId = new YoLong(YoGeometryNameTools.assembleName(namePrefix, "frame", nameSuffix), registry);
        this.frameIndexMap = new FrameIndexMap.FrameIndexHashMap();
        this.setToZero(ReferenceFrame.getWorldFrame());
    }

    public YoMutableFrameQuaternion(YoDouble qx, YoDouble qy, YoDouble qz, YoDouble qs, YoLong frameIndex, FrameIndexMap frameIndexMap) {
        super(qx, qy, qz, qs);
        this.frameId = frameIndex;
        this.frameIndexMap = frameIndexMap;
    }

    @Override
    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        YoMutableFrameObject.super.setReferenceFrame(referenceFrame);
    }

    @Override
    public FrameIndexMap getFrameIndexMap() {
        return this.frameIndexMap;
    }

    @Override
    public YoLong getYoFrameIndex() {
        return this.frameId;
    }

    @Override
    public int hashCode() {
        return EuclidHashCodeTools.toIntHashCode((Object)EuclidHashCodeTools.toIntHashCode((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)this.getS()), (Object)this.getReferenceFrame());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof FrameTuple4DReadOnly) {
            return this.equals((EuclidFrameGeometry)((FrameTuple4DReadOnly)object));
        }
        return false;
    }

    @Override
    public String toString() {
        return EuclidFrameIOTools.getFrameTuple4DString((FrameTuple4DReadOnly)this);
    }
}

