/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.parameters;

import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class BooleanParameter
extends YoParameter
implements BooleanProvider {
    private final YoBoolean value;
    private final boolean initialValue;

    public BooleanParameter(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public BooleanParameter(String name, String description, YoRegistry registry) {
        this(name, description, registry, false);
    }

    public BooleanParameter(String name, YoRegistry registry, boolean initialValue) {
        this(name, "", registry, initialValue);
    }

    public BooleanParameter(String name, String description, YoRegistry registry, boolean initialValue) {
        this.value = new YoBooleanParameter(name, description, registry);
        this.initialValue = initialValue;
        this.setParameterBounds(0.0, 1.0);
    }

    @Override
    public boolean getValue() {
        this.checkLoaded();
        return this.value.getBooleanValue();
    }

    @Override
    YoBoolean getVariable() {
        return this.value;
    }

    @Override
    void setToDefault() {
        this.value.set(this.initialValue);
    }

    private class YoBooleanParameter
    extends YoBoolean {
        public YoBooleanParameter(String name, String description, YoRegistry registry) {
            super(name, description, registry);
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public BooleanParameter getParameter() {
            return BooleanParameter.this;
        }

        @Override
        public YoBoolean duplicate(YoRegistry newRegistry) {
            BooleanParameter newParameter = new BooleanParameter(this.getName(), this.getDescription(), newRegistry, BooleanParameter.this.initialValue);
            newParameter.value.set(BooleanParameter.this.value.getValue());
            newParameter.loadStatus = BooleanParameter.this.getLoadStatus();
            return newParameter.value;
        }
    }
}

