/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.registry;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.yoVariables.exceptions.NameCollisionException;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableList
extends AbstractList<YoVariable>
implements YoVariableHolder {
    private final String name;
    private final List<YoVariable> variableList = new ArrayList<YoVariable>();
    private final Map<String, List<YoVariable>> simpleNameToVariablesMap = new LinkedHashMap<String, List<YoVariable>>();

    public YoVariableList(String name) {
        this.name = name;
    }

    public YoVariableList(String name, List<? extends YoVariable> variables) {
        this.name = name;
        this.addAll(variables);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmpty() {
        return this.variableList.isEmpty();
    }

    @Override
    public int size() {
        return this.variableList.size();
    }

    @Override
    public void clear() {
        this.variableList.clear();
        this.simpleNameToVariablesMap.clear();
    }

    @Override
    public YoVariable get(int index) {
        return this.variableList.get(index);
    }

    @Override
    public List<YoVariable> getVariables() {
        return this;
    }

    @Override
    public boolean add(YoVariable variable) {
        if (!this.registerVariableInMap(variable)) {
            return false;
        }
        this.variableList.add(variable);
        return true;
    }

    @Override
    public void add(int index, YoVariable variable) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        if (!this.registerVariableInMap(variable)) {
            return;
        }
        this.variableList.add(index, variable);
    }

    @Override
    public YoVariable set(int index, YoVariable variable) {
        YoVariable previousVariable = this.variableList.get(index);
        if (variable == previousVariable) {
            return previousVariable;
        }
        if (!this.registerVariableInMap(variable)) {
            return null;
        }
        List<YoVariable> homonyms = this.simpleNameToVariablesMap.get(previousVariable.getName().toLowerCase());
        if (homonyms != null) {
            homonyms.remove(previousVariable);
        }
        this.variableList.set(index, variable);
        return previousVariable;
    }

    @Override
    public YoVariable remove(int index) {
        YoVariable variable = this.variableList.get(index);
        List<YoVariable> homonyms = this.simpleNameToVariablesMap.get(variable.getName().toLowerCase());
        if (homonyms != null) {
            homonyms.remove(variable);
        }
        this.variableList.remove(variable);
        return variable;
    }

    @Override
    public boolean remove(Object variable) {
        if (!(variable instanceof YoVariable)) {
            return false;
        }
        List<YoVariable> homonyms = this.simpleNameToVariablesMap.get(((YoVariable)variable).getName().toLowerCase());
        if (homonyms == null) {
            return false;
        }
        boolean modified = homonyms.remove(variable);
        return modified |= this.variableList.remove(variable);
    }

    private boolean registerVariableInMap(YoVariable variable) {
        List<YoVariable> homonyms = this.simpleNameToVariablesMap.get(variable.getName().toLowerCase());
        if (homonyms == null) {
            homonyms = new ArrayList<YoVariable>();
            this.simpleNameToVariablesMap.put(variable.getName().toLowerCase(), homonyms);
        } else {
            if (homonyms.contains(variable)) {
                return false;
            }
            for (int i = 0; i < homonyms.size(); ++i) {
                if (!homonyms.get(i).getNamespace().equals(variable.getNamespace())) continue;
                throw new NameCollisionException("Name collision with " + variable.getFullNameString());
            }
        }
        homonyms.add(variable);
        return true;
    }

    @Override
    public YoVariable findVariable(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        List<YoVariable> variableList = this.simpleNameToVariablesMap.get(name.toLowerCase());
        if (variableList == null || variableList.isEmpty()) {
            return null;
        }
        if (namespaceEnding == null) {
            return variableList.get(0);
        }
        for (int i = 0; i < variableList.size(); ++i) {
            YoVariable candidate = variableList.get(i);
            if (!candidate.getNamespace().endsWith(namespaceEnding)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean hasUniqueVariable(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        return this.countNumberOfVariables(namespaceEnding, name) == 1;
    }

    private int countNumberOfVariables(String parentNamespace, String name) {
        List<YoVariable> variableList = this.simpleNameToVariablesMap.get(name.toLowerCase());
        if (variableList == null || variableList.isEmpty()) {
            return 0;
        }
        if (parentNamespace == null) {
            return variableList.size();
        }
        int count = 0;
        for (int i = 0; i < variableList.size(); ++i) {
            if (!variableList.get(i).getNamespace().endsWith(parentNamespace)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<YoVariable> findVariables(String namespaceEnding, String name) {
        YoTools.checkNameDoesNotContainSeparator(name);
        List<YoVariable> variableList = this.simpleNameToVariablesMap.get(name.toLowerCase());
        if (variableList == null || variableList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<YoVariable> result = new ArrayList<YoVariable>();
        if (namespaceEnding == null) {
            result.addAll(variableList);
        } else {
            for (int i = 0; i < variableList.size(); ++i) {
                YoVariable candidate = variableList.get(i);
                if (!candidate.getNamespace().endsWith(namespaceEnding)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    @Override
    public List<YoVariable> findVariables(YoNamespace namespace) {
        ArrayList<YoVariable> result = new ArrayList<YoVariable>();
        for (YoVariable variable : this.variableList) {
            if (!variable.getNamespace().equals(namespace)) continue;
            result.add(variable);
        }
        return result;
    }

    @Override
    public String toString() {
        if (this.variableList.size() > 10) {
            return this.name + ", contains: " + this.variableList.size() + " variables.";
        }
        StringBuffer result = new StringBuffer();
        result.append(this.name);
        result.append(", variables:");
        for (int i = 0; i < this.variableList.size(); ++i) {
            result.append("\n");
            result.append(this.variableList.get(i).toString());
        }
        return result.toString();
    }
}

