/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import us.ihmc.yoVariables.parameters.YoParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoSearchTools {
    public static YoParameter findFirstParameter(String namespaceEnding, String name, Predicate<YoParameter> predicate, YoRegistry registry) {
        YoVariable result;
        Predicate<YoVariable> yoVariablePredicate = YoVariable::isParameter;
        if (predicate != null) {
            yoVariablePredicate = yoVariablePredicate.and(variable -> predicate.test(variable.getParameter()));
        }
        if ((result = YoSearchTools.findFirstVariable(namespaceEnding, name, yoVariablePredicate, registry)) == null) {
            return null;
        }
        return result.getParameter();
    }

    public static YoVariable findFirstVariable(String namespaceEnding, String name, Predicate<YoVariable> predicate, YoRegistry registry) {
        YoVariable variable;
        if ((namespaceEnding == null || registry.getNamespace().endsWith(namespaceEnding)) && (variable = registry.getVariable(name)) != null && (predicate == null || predicate.test(variable))) {
            return variable;
        }
        for (YoRegistry child : registry.getChildren()) {
            YoVariable variable2 = YoSearchTools.findFirstVariable(namespaceEnding, name, predicate, child);
            if (variable2 == null) continue;
            return variable2;
        }
        return null;
    }

    public static YoRegistry findFirstRegistry(String namespaceEnding, String name, Predicate<YoRegistry> predicate, YoRegistry root) {
        YoRegistry candidate;
        if ((namespaceEnding == null || root.getNamespace().endsWith(namespaceEnding)) && (candidate = root.getChild(name)) != null && (predicate == null || predicate.test(candidate))) {
            return candidate;
        }
        for (YoRegistry child : root.getChildren()) {
            YoRegistry candidate2 = YoSearchTools.findFirstRegistry(namespaceEnding, name, predicate, child);
            if (candidate2 == null) continue;
            return candidate2;
        }
        return null;
    }

    public static List<YoVariable> findVariables(String namespaceEnding, String name, Predicate<YoVariable> predicate, YoRegistry registry, List<YoVariable> matchedVariablesToPack) {
        YoVariable variable;
        if (matchedVariablesToPack == null) {
            matchedVariablesToPack = new ArrayList<YoVariable>();
        }
        if ((namespaceEnding == null || registry.getNamespace().endsWith(namespaceEnding)) && (variable = registry.getVariable(name)) != null && (predicate == null || predicate.test(variable))) {
            matchedVariablesToPack.add(variable);
        }
        for (YoRegistry child : registry.getChildren()) {
            YoSearchTools.findVariables(namespaceEnding, name, predicate, child, matchedVariablesToPack);
        }
        return matchedVariablesToPack;
    }

    public static YoVariable findVariable(Predicate<YoVariable> filter, YoVariableHolder yoVariableHolder) {
        for (YoVariable yoVariable : yoVariableHolder.getVariables()) {
            if (!filter.test(yoVariable)) continue;
            return yoVariable;
        }
        for (YoVariableHolder yoVariableHolder2 : yoVariableHolder.getChildren()) {
            YoVariable result = YoSearchTools.findVariable(filter, yoVariableHolder2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<YoVariable> filterVariables(Predicate<YoVariable> filter, YoVariableHolder yoVariableHolder) {
        return YoSearchTools.filterVariables(filter, yoVariableHolder, null);
    }

    public static List<YoVariable> filterVariables(Predicate<YoVariable> filter, YoVariableHolder yoVariableHolder, List<YoVariable> filteredVariablesToPack) {
        if (filteredVariablesToPack == null) {
            filteredVariablesToPack = new ArrayList<YoVariable>();
        }
        for (YoVariable yoVariable : yoVariableHolder.getVariables()) {
            if (!filter.test(yoVariable)) continue;
            filteredVariablesToPack.add(yoVariable);
        }
        for (YoVariableHolder yoVariableHolder2 : yoVariableHolder.getChildren()) {
            YoSearchTools.filterVariables(filter, yoVariableHolder2, filteredVariablesToPack);
        }
        return filteredVariablesToPack;
    }

    public static List<YoRegistry> filterRegistries(Predicate<YoRegistry> filter, YoRegistry registry) {
        return YoSearchTools.filterRegistries(filter, registry, null);
    }

    public static List<YoRegistry> filterRegistries(Predicate<YoRegistry> filter, YoRegistry registry, List<YoRegistry> filteredRegistriesToPack) {
        if (filteredRegistriesToPack == null) {
            filteredRegistriesToPack = new ArrayList<YoRegistry>();
        }
        if (filter.test(registry)) {
            filteredRegistriesToPack.add(registry);
        }
        for (YoRegistry child : registry.getChildren()) {
            YoSearchTools.filterRegistries(filter, child, filteredRegistriesToPack);
        }
        return filteredRegistriesToPack;
    }

    public static Predicate<YoVariable> regularExpressionFilter(String ... regularExpressions) {
        Pattern[] patterns = (Pattern[])Stream.of(regularExpressions).map(Pattern::compile).toArray(Pattern[]::new);
        return variable -> {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(variable.getName()).matches()) continue;
                return true;
            }
            return false;
        };
    }
}

