/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoDouble
extends YoVariable
implements DoubleProvider {
    private double value;

    public YoDouble(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public YoDouble(String name, String description, YoRegistry registry) {
        super(YoVariableType.DOUBLE, name, description, registry);
        this.set(0.0);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public void add(YoDouble other) {
        this.set(this.value + other.value);
    }

    public void sub(YoDouble other) {
        this.set(this.value - other.value);
    }

    public void sub(double value) {
        this.set(this.value - value);
    }

    public void add(double value) {
        this.set(this.value + value);
    }

    public void mul(double value) {
        this.set(this.value * value);
    }

    public void mul(YoDouble other) {
        this.set(this.value * other.value);
    }

    public boolean valueEquals(double value) {
        return this.value == value;
    }

    public void setToNaN() {
        this.set(Double.NaN);
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public boolean set(double value) {
        return this.set(value, true);
    }

    public boolean set(double value, boolean notifyListeners) {
        if (Double.doubleToLongBits(this.value) != Double.doubleToLongBits(value)) {
            this.value = value;
            if (notifyListeners) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public double getValueAsDouble() {
        return this.getDoubleValue();
    }

    @Override
    public boolean setValueFromDouble(double value, boolean notifyListeners) {
        return this.set(value, notifyListeners);
    }

    @Override
    public long getValueAsLongBits() {
        return Double.doubleToLongBits(this.value);
    }

    @Override
    public boolean setValueFromLongBits(long value, boolean notifyListeners) {
        return this.set(Double.longBitsToDouble(value), notifyListeners);
    }

    @Override
    public boolean setValue(YoVariable other, boolean notifyListeners) {
        return this.set(((YoDouble)other).getValue(), notifyListeners);
    }

    @Override
    public String getValueAsString(String format) {
        return this.convertDoubleValueToString(format, this.value);
    }

    @Override
    public boolean parseValue(String valueAsString, boolean notifyListeners) {
        return this.set(Double.parseDouble(valueAsString), notifyListeners);
    }

    @Override
    public String convertDoubleValueToString(String format, double value) {
        if (format == null) {
            return Double.toString(value);
        }
        return String.format(format, value);
    }

    @Override
    public boolean isZero() {
        return this.value == 0.0;
    }

    @Override
    public YoDouble duplicate(YoRegistry newRegistry) {
        YoDouble duplicate = new YoDouble(this.getName(), this.getDescription(), newRegistry);
        duplicate.setVariableBounds(this.getLowerBound(), this.getUpperBound());
        duplicate.set(this.value);
        return duplicate;
    }

    @Override
    public String toString() {
        return String.format("%s: %s", this.getName(), this.value);
    }
}

