/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoInteger
extends YoVariable
implements IntegerProvider {
    private int value;

    public YoInteger(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public YoInteger(String name, String description, YoRegistry registry) {
        super(YoVariableType.INTEGER, name, description, registry);
        this.set(0);
    }

    public void increment() {
        this.set(this.value + 1);
    }

    public void decrement() {
        this.set(this.value - 1);
    }

    public void add(int value) {
        this.set(this.value + value);
    }

    public void sub(int value) {
        this.set(this.value - value);
    }

    public boolean valueEquals(int value) {
        return this.value == value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public int getIntegerValue() {
        return this.value;
    }

    public boolean set(int value) {
        return this.set(value, true);
    }

    public boolean set(int value, boolean notifyListeners) {
        if (this.value != value) {
            this.value = value;
            if (notifyListeners) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public double getValueAsDouble() {
        return this.value;
    }

    @Override
    public boolean setValueFromDouble(double value, boolean notifyListeners) {
        return this.set((int)Math.round(value), notifyListeners);
    }

    @Override
    public long getValueAsLongBits() {
        return this.value;
    }

    @Override
    public boolean setValueFromLongBits(long value, boolean notifyListeners) {
        return this.set((int)value, notifyListeners);
    }

    @Override
    public boolean setValue(YoVariable other, boolean notifyListeners) {
        return this.set(((YoInteger)other).getValue(), notifyListeners);
    }

    @Override
    public String getValueAsString(String format) {
        return Integer.toString(this.value);
    }

    @Override
    public boolean parseValue(String valueAsString, boolean notifyListeners) {
        return this.set(Integer.parseInt(valueAsString), notifyListeners);
    }

    @Override
    public String convertDoubleValueToString(String format, double value) {
        return Integer.toString((int)value);
    }

    @Override
    public boolean isZero() {
        return this.value == 0;
    }

    @Override
    public YoInteger duplicate(YoRegistry newRegistry) {
        YoInteger duplicate = new YoInteger(this.getName(), this.getDescription(), newRegistry);
        duplicate.setVariableBounds(this.getLowerBound(), this.getUpperBound());
        duplicate.set(this.value);
        return duplicate;
    }

    @Override
    public String toString() {
        return String.format("%s: %d", this.getName(), this.getIntegerValue());
    }
}

