/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.yoVariables.variable;

import us.ihmc.yoVariables.providers.LongProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;
import us.ihmc.yoVariables.variable.YoVariableType;

public class YoLong
extends YoVariable
implements LongProvider {
    private long value;

    public YoLong(String name, YoRegistry registry) {
        this(name, "", registry);
    }

    public YoLong(String name, String description, YoRegistry registry) {
        super(YoVariableType.LONG, name, description, registry);
        this.set(0L);
    }

    public void increment() {
        this.set(this.value + 1L);
    }

    public void decrement() {
        this.set(this.value - 1L);
    }

    public void add(long value) {
        this.set(this.value + value);
    }

    public void subtract(long value) {
        this.set(this.value - value);
    }

    @Override
    public long getValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    public boolean valueEquals(long value) {
        return this.value == value;
    }

    public boolean set(long value) {
        return this.set(value, true);
    }

    public boolean set(long value, boolean notifyListeners) {
        if (this.value != value) {
            this.value = value;
            if (notifyListeners) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public double getValueAsDouble() {
        return this.value;
    }

    @Override
    public boolean setValueFromDouble(double value, boolean notifyListeners) {
        return this.set(Math.round(value), notifyListeners);
    }

    @Override
    public long getValueAsLongBits() {
        return this.getLongValue();
    }

    @Override
    public boolean setValueFromLongBits(long value, boolean notifyListeners) {
        return this.set(value, notifyListeners);
    }

    @Override
    public boolean setValue(YoVariable other, boolean notifyListeners) {
        return this.set(((YoLong)other).getValue(), notifyListeners);
    }

    @Override
    public String getValueAsString(String format) {
        return Long.toString(this.value);
    }

    @Override
    public boolean parseValue(String valueAsString, boolean notifyListeners) {
        return this.set(Long.parseLong(valueAsString), notifyListeners);
    }

    @Override
    public String convertDoubleValueToString(String format, double value) {
        return Long.toString((long)value);
    }

    @Override
    public boolean isZero() {
        return this.getLongValue() == 0L;
    }

    @Override
    public YoLong duplicate(YoRegistry newRegistry) {
        YoLong duplicate = new YoLong(this.getName(), this.getDescription(), newRegistry);
        duplicate.setVariableBounds(this.getLowerBound(), this.getUpperBound());
        duplicate.set(this.getLongValue());
        return duplicate;
    }

    @Override
    public String toString() {
        return String.format("%s: %d", this.getName(), this.getLongValue());
    }
}

