/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXSlider;
import com.jfoenix.skins.JFXTrimSliderSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.Skin;

public class JFXTrimSlider
extends JFXSlider {
    private static final String DEFAULT_STYLE_CLASS = "crop-slider";
    private BooleanProperty showTrim;
    private DoubleProperty trimGap;
    private DoubleProperty trimStartValue;
    private DoubleProperty trimEndValue;
    private BooleanProperty trimStartValueChanging;
    private BooleanProperty trimEndValueChanging;
    private BooleanProperty bindValueToActiveTrim;

    public JFXTrimSlider() {
        this.initialize();
    }

    public JFXTrimSlider(double min, double max, double value) {
        super(min, max, value);
        this.initialize();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new JFXTrimSliderSkin(this);
    }

    @Override
    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/crop-slider.css").toExternalForm();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public boolean isShowTrim() {
        return this.showTrim == null ? false : this.showTrim.get();
    }

    public void setShowTrim(boolean value) {
        this.showTrimProperty().set(value);
    }

    public BooleanProperty showTrimProperty() {
        if (this.showTrim == null) {
            this.showTrim = new SimpleBooleanProperty((Object)this, "showTrim", false);
        }
        return this.showTrim;
    }

    public double getTrimGap() {
        return this.trimGap == null ? 3.0 : this.trimGap.get();
    }

    public void setTrimGap(double value) {
        this.trimGapProperty().set(value);
    }

    public DoubleProperty trimGapProperty() {
        if (this.trimGap == null) {
            this.trimGap = new SimpleDoubleProperty((Object)this, "trimGap", 3.0);
        }
        return this.trimGap;
    }

    public final void setTrimStartValue(double value) {
        if (!this.trimStartValueProperty().isBound()) {
            this.trimStartValueProperty().set(value);
        }
    }

    public final double getTrimStartValue() {
        return this.trimStartValue == null ? 0.0 : this.trimStartValue.get();
    }

    public final DoubleProperty trimStartValueProperty() {
        if (this.trimStartValue == null) {
            this.trimStartValue = new DoublePropertyBase(0.0){

                protected void invalidated() {
                    if (JFXTrimSlider.this.getTrimStartValue() < JFXTrimSlider.this.getMin()) {
                        JFXTrimSlider.this.setTrimStartValue(JFXTrimSlider.this.getMin());
                    } else if (JFXTrimSlider.this.getTrimStartValue() > JFXTrimSlider.this.getTrimEndValue()) {
                        JFXTrimSlider.this.setTrimStartValue(JFXTrimSlider.this.getTrimEndValue());
                    }
                    JFXTrimSlider.this.notifyAccessibleAttributeChanged(AccessibleAttribute.VALUE);
                }

                public Object getBean() {
                    return JFXTrimSlider.this;
                }

                public String getName() {
                    return "trimStartValue";
                }
            };
        }
        return this.trimStartValue;
    }

    public final void setTrimEndValue(double value) {
        if (!this.trimEndValueProperty().isBound()) {
            this.trimEndValueProperty().set(value);
        }
    }

    public final double getTrimEndValue() {
        return this.trimEndValue == null ? 0.0 : this.trimEndValue.get();
    }

    public final DoubleProperty trimEndValueProperty() {
        if (this.trimEndValue == null) {
            this.trimEndValue = new DoublePropertyBase(this.getMax()){

                protected void invalidated() {
                    if (JFXTrimSlider.this.getTrimEndValue() < JFXTrimSlider.this.getTrimStartValue()) {
                        JFXTrimSlider.this.setTrimEndValue(JFXTrimSlider.this.getTrimStartValue());
                    } else if (JFXTrimSlider.this.getTrimEndValue() > JFXTrimSlider.this.getMax()) {
                        JFXTrimSlider.this.setTrimEndValue(JFXTrimSlider.this.getMax());
                    }
                    JFXTrimSlider.this.notifyAccessibleAttributeChanged(AccessibleAttribute.VALUE);
                }

                public Object getBean() {
                    return JFXTrimSlider.this;
                }

                public String getName() {
                    return "trimEndValue";
                }
            };
        }
        return this.trimEndValue;
    }

    public final void setTrimStartValueChanging(boolean trimStartValue) {
        this.trimStartValueChangingProperty().set(trimStartValue);
    }

    public final boolean isTrimStartValueChanging() {
        return this.trimStartValueChanging == null ? false : this.trimStartValueChanging.get();
    }

    public final BooleanProperty trimStartValueChangingProperty() {
        if (this.trimStartValueChanging == null) {
            this.trimStartValueChanging = new SimpleBooleanProperty((Object)this, "trimStartValueChanging", false);
        }
        return this.trimStartValueChanging;
    }

    public final void setTrimEndValueChanging(boolean trimEndValue) {
        this.trimEndValueChangingProperty().set(trimEndValue);
    }

    public final boolean isTrimEndValueChanging() {
        return this.trimEndValueChanging == null ? false : this.trimEndValueChanging.get();
    }

    public final BooleanProperty trimEndValueChangingProperty() {
        if (this.trimEndValueChanging == null) {
            this.trimEndValueChanging = new SimpleBooleanProperty((Object)this, "trimEndValueChanging", false);
        }
        return this.trimEndValueChanging;
    }

    public final void setBindValueToActiveTrim(boolean bind) {
        this.bindValueToActiveTrimProperty().set(bind);
    }

    public final boolean isValueBoundToActiveTrim() {
        return this.bindValueToActiveTrim == null ? false : this.bindValueToActiveTrim.get();
    }

    public final BooleanProperty bindValueToActiveTrimProperty() {
        if (this.bindValueToActiveTrim == null) {
            this.bindValueToActiveTrim = new SimpleBooleanProperty((Object)this, "bindValueToActiveTrim", false);
        }
        return this.bindValueToActiveTrim;
    }

    public void adjustTrimStartValue(double newValue) {
        this.adjustValue(newValue, this.trimStartValue);
    }

    public void adjustTrimEndValue(double newValue) {
        this.adjustValue(newValue, this.trimEndValue);
    }

    public void adjustValue(double newValue, DoubleProperty valueToAdjust) {
        double _min = this.getMin();
        double _max = this.getMax();
        if (_max <= _min) {
            return;
        }
        newValue = newValue < _min ? _min : newValue;
        newValue = newValue > _max ? _max : newValue;
        valueToAdjust.set(this.snapValueToTicks(newValue));
    }

    private double snapValueToTicks(double val) {
        double v = val;
        if (this.isSnapToTicks()) {
            double tickSpacing = 0.0;
            tickSpacing = this.getMinorTickCount() != 0 ? this.getMajorTickUnit() / (double)(Math.max(this.getMinorTickCount(), 0) + 1) : this.getMajorTickUnit();
            int prevTick = (int)((v - this.getMin()) / tickSpacing);
            double prevTickValue = (double)prevTick * tickSpacing + this.getMin();
            double nextTickValue = (double)(prevTick + 1) * tickSpacing + this.getMin();
            v = JFXTrimSlider.nearest(prevTickValue, v, nextTickValue);
        }
        if (v < this.getMin()) {
            return this.getMin();
        }
        if (v > this.getMax()) {
            return this.getMax();
        }
        return v;
    }

    public static double nearest(double less, double value, double more) {
        double lessDiff = value - less;
        double moreDiff = more - value;
        if (lessDiff < moreDiff) {
            return less;
        }
        return more;
    }
}

