/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.BaseURL;
import com.interactivemesh.jfx.importer.col.CImporterImpl;
import com.interactivemesh.jfx.importer.col.CameraC;
import com.interactivemesh.jfx.importer.col.Controller;
import com.interactivemesh.jfx.importer.col.Effect;
import com.interactivemesh.jfx.importer.col.Geometry;
import com.interactivemesh.jfx.importer.col.ImageC;
import com.interactivemesh.jfx.importer.col.LightC;
import com.interactivemesh.jfx.importer.col.Material;
import com.interactivemesh.jfx.importer.col.NodeC;
import com.interactivemesh.jfx.importer.col.ProfileCOMMON;
import com.interactivemesh.jfx.importer.col.Source;
import com.interactivemesh.jfx.importer.col.ValueArray;
import com.interactivemesh.jfx.importer.col.Vertices;
import com.interactivemesh.jfx.importer.col.VisualScene;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import javafx.scene.image.Image;

final class ElementCache {
    private final IdentityHashMap<Image, FilePath> imagePaths = new IdentityHashMap();
    private final HashMap<String, CameraC> cameraMap = new HashMap(8);
    private final HashMap<String, Controller> contrlMap = new HashMap();
    private final HashMap<String, ImageC> imageCMap = new HashMap();
    private final HashMap<String, Effect> effectMap = new HashMap();
    private final HashMap<String, Geometry> geomMap = new HashMap();
    private final HashMap<String, LightC> lightMap = new HashMap(8);
    private final HashMap<String, Material> materialMap = new HashMap();
    private final HashMap<String, NodeC> nodeMap = new HashMap();
    private final HashMap<String, ProfileCOMMON> profileComMap = new HashMap();
    private final HashMap<String, Source> sourceMap = new HashMap();
    private final HashMap<String, VisualScene> visSceneMap = new HashMap(2);
    private final HashMap<String, ValueArray> valueArrayMap = new HashMap();
    private final HashMap<String, Vertices> verticesMap = new HashMap();
    private final HashMap<String, Integer> nodeRefCounts = new HashMap();
    private final CImporterImpl cImporter;
    private final boolean isZAE;
    private BaseURL baseUrl = null;
    private String zaeEntryBase = null;

    ElementCache(CImporterImpl cImporterImpl, boolean bl) {
        this.cImporter = cImporterImpl;
        this.isZAE = bl;
    }

    void clear() {
        Collection<AbstractIdElement> collection;
        this.imagePaths.clear();
        this.cameraMap.clear();
        this.contrlMap.clear();
        if (!this.imageCMap.isEmpty()) {
            collection = this.imageCMap.values();
            for (AbstractIdElement abstractIdElement : collection) {
                ((ImageC)abstractIdElement).clear();
            }
            this.imageCMap.clear();
        }
        if (!this.effectMap.isEmpty()) {
            collection = this.effectMap.values();
            for (AbstractIdElement abstractIdElement : collection) {
                ((Effect)abstractIdElement).clear();
            }
            this.effectMap.clear();
        }
        if (!this.geomMap.isEmpty()) {
            collection = this.geomMap.values();
            for (AbstractIdElement abstractIdElement : collection) {
                ((Geometry)abstractIdElement).clear();
            }
            this.geomMap.clear();
        }
        this.lightMap.clear();
        this.materialMap.clear();
        this.nodeMap.clear();
        this.profileComMap.clear();
        this.sourceMap.clear();
        this.visSceneMap.clear();
        this.valueArrayMap.clear();
        this.verticesMap.clear();
        this.nodeRefCounts.clear();
    }

    BaseURL getBaseURL() {
        return this.baseUrl;
    }

    void setBaseURL(BaseURL baseURL) {
        this.baseUrl = baseURL;
    }

    String getZaeEntryBase() {
        return this.zaeEntryBase;
    }

    void setZaeEntryBase(String string) {
        this.zaeEntryBase = string;
    }

    private ElementCache getReferencedCache(String string) {
        return this.cImporter.getReferencedCache(this.baseUrl, string, this.zaeEntryBase, this.isZAE);
    }

    void increaseNodeRefCt(String string) {
        HashMap<String, Integer> hashMap = null;
        int n = string.indexOf("#");
        hashMap = n == 0 || n < 0 ? this.nodeRefCounts : this.getReferencedCache((String)string.substring((int)0, (int)n)).nodeRefCounts;
        String string2 = string.substring(n + 1);
        Integer n2 = hashMap.get(string2);
        int n3 = 0;
        n3 = n2 == null ? 1 : n2 + 1;
        this.nodeRefCounts.put(string2, n3);
    }

    int getNodeRefCt(String string) {
        Integer n = null;
        int n2 = string.indexOf("#");
        n = n2 == 0 ? this.nodeRefCounts.get(string.substring(1)) : (n2 < 0 ? this.nodeRefCounts.get(string) : this.getReferencedCache((String)string.substring((int)0, (int)n2)).nodeRefCounts.get(string.substring(n2 + 1)));
        if (n != null) {
            return n;
        }
        return 0;
    }

    void putCamera(String string, CameraC cameraC) {
        this.cameraMap.put(string, cameraC);
    }

    CameraC getCamera(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.cameraMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.cameraMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).cameraMap.get(string.substring(n + 1));
    }

    void putController(String string, Controller controller) {
        this.contrlMap.put(string, controller);
    }

    Controller getController(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.contrlMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.contrlMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).contrlMap.get(string.substring(n + 1));
    }

    void putImage(String string, ImageC imageC) {
        this.imageCMap.put(string, imageC);
    }

    ImageC getImage(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.imageCMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.imageCMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).imageCMap.get(string.substring(n + 1));
    }

    void putImagePath(Image image, FilePath filePath) {
        this.imagePaths.put(image, filePath);
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        return this.imagePaths;
    }

    void putEffect(String string, Effect effect) {
        this.effectMap.put(string, effect);
    }

    Effect getEffect(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.effectMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.effectMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).effectMap.get(string.substring(n + 1));
    }

    void putGeometry(String string, Geometry geometry) {
        this.geomMap.put(string, geometry);
    }

    Geometry getGeometry(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.geomMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.geomMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).geomMap.get(string.substring(n + 1));
    }

    void putLight(String string, LightC lightC) {
        this.lightMap.put(string, lightC);
    }

    LightC getLight(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.lightMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.lightMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).lightMap.get(string.substring(n + 1));
    }

    void putMaterial(String string, Material material) {
        this.materialMap.put(string, material);
    }

    Material getMaterial(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.materialMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.materialMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).materialMap.get(string.substring(n + 1));
    }

    void putProfileCom(String string, ProfileCOMMON profileCOMMON) {
        this.profileComMap.put(string, profileCOMMON);
    }

    ProfileCOMMON getProfileCom(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.profileComMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.profileComMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).profileComMap.get(string.substring(n + 1));
    }

    void putNode(String string, NodeC nodeC) {
        this.nodeMap.put(string, nodeC);
    }

    NodeC getNode(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.nodeMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.nodeMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).nodeMap.get(string.substring(n + 1));
    }

    void putSource(String string, Source source) {
        this.sourceMap.put(string, source);
    }

    Source getSource(String string) {
        Source source = null;
        int n = string.indexOf("#");
        source = n == 0 ? this.sourceMap.get(string.substring(1)) : (n < 0 ? this.sourceMap.get(string) : this.getReferencedCache((String)string.substring((int)0, (int)n)).sourceMap.get(string.substring(n + 1)));
        ++source.numReferences;
        return source;
    }

    void putVertices(String string, Vertices vertices) {
        this.verticesMap.put(string, vertices);
    }

    Vertices getVertices(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.verticesMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.verticesMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).verticesMap.get(string.substring(n + 1));
    }

    void putVisualScene(String string, VisualScene visualScene) {
        this.visSceneMap.put(string, visualScene);
    }

    VisualScene getVisualScene(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.visSceneMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.visSceneMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).visSceneMap.get(string.substring(n + 1));
    }

    void putValueArray(String string, ValueArray valueArray) {
        this.valueArrayMap.put(string, valueArray);
    }

    ValueArray getValueArray(String string) {
        int n = string.indexOf("#");
        if (n == 0) {
            return this.valueArrayMap.get(string.substring(1));
        }
        if (n < 0) {
            return this.valueArrayMap.get(string);
        }
        return this.getReferencedCache((String)string.substring((int)0, (int)n)).valueArrayMap.get(string.substring(n + 1));
    }
}

