/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.Geometry;
import com.interactivemesh.jfx.importer.col.InstanceBindMaterial;
import com.interactivemesh.jfx.importer.col.InstanceMaterial;
import com.interactivemesh.jfx.importer.col.Material;
import com.interactivemesh.jfx.importer.col.Param;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

final class InstanceGeometry
extends InstanceBindMaterial {
    private ArrayList<Param> paramList = null;
    private final HashMap<String, InstanceMaterial> instMaterialMap = new HashMap(2);
    private int numShape3Ds = 0;
    private int shape3dCounter = 0;

    InstanceGeometry(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.name != null && this.name.length() > 0) {
            this.name = elementBase.createUniqueName(this.name);
        }
    }

    @Override
    void addParam(Param param) {
        if (this.paramList == null) {
            this.paramList = new ArrayList(4);
        }
        this.paramList.add(param);
    }

    @Override
    InstanceMaterial createInstMaterial(String string, String string2, String string3, String string4) {
        InstanceMaterial instanceMaterial = new InstanceMaterial(string, string2, string3, string4);
        this.instMaterialMap.put(string4, instanceMaterial);
        return instanceMaterial;
    }

    @Override
    void clear() {
        if (this.paramList != null) {
            this.paramList.clear();
            this.paramList = null;
        }
        this.instMaterialMap.clear();
        super.clear();
    }

    ArrayList<MeshView> getInstanceShape3Ds(String string) {
        HashMap<String, ArrayList<TriangleMesh>> hashMap;
        String string2;
        Object object;
        Object object2;
        Object object3;
        Geometry geometry = null;
        if (this.url == null || (geometry = this.cache.getGeometry(this.url)) == null) {
            return null;
        }
        HashMap<String, PhongMaterial> hashMap2 = new HashMap<String, PhongMaterial>(2);
        HashMap<String, int[]> hashMap3 = new HashMap<String, int[]>(2);
        HashMap<String, Boolean> hashMap4 = new HashMap<String, Boolean>(2);
        if (this.instMaterialMap.size() > 0) {
            object3 = this.instMaterialMap.entrySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                string2 = (String)object.getKey();
                hashMap = (InstanceMaterial)object.getValue();
                if (((InstanceMaterial)((Object)hashMap)).url != null) {
                    String string3 = ((InstanceMaterial)((Object)hashMap)).url;
                    Material material = this.cache.getMaterial(string3);
                    PhongMaterial phongMaterial = null;
                    int[] nArray = null;
                    boolean bl = false;
                    if (material == null) {
                        phongMaterial = new PhongMaterial();
                        this.base.putNamedMaterial("PhongMaterial_" + Material.nextMatNameExt(), phongMaterial);
                    } else {
                        phongMaterial = material.getAppearance();
                        bl = material.isDoubleSided();
                        String[] stringArray = material.getTexCoordSemantics();
                        int n = 0;
                        if (stringArray != null && (n = stringArray.length) > 0) {
                            nArray = new int[n];
                            for (int i = 0; i < n; ++i) {
                                nArray[i] = stringArray[i] != null ? ((InstanceMaterial)((Object)hashMap)).getTexCoordSet(stringArray[i]) : -1;
                            }
                        }
                    }
                    hashMap2.put(string2, phongMaterial);
                    hashMap3.put(string2, nArray);
                    hashMap4.put(string2, bl);
                    continue;
                }
                System.out.println("InstanceGeometry mat binding : instMat.url == null for instMat / geomMatSymbol = " + hashMap + " / " + string2);
            }
        }
        object3 = geometry.getGeomType();
        object2 = this.name;
        if (object2 == null || ((String)object2).length() < 1) {
            object2 = geometry.getGeomInstanceName();
        }
        object = new ArrayList(1);
        if (object3 == Geometry.GeomType.MESH) {
            boolean bl;
            string2 = Integer.toString(this.hashCode());
            hashMap = geometry.getQuadTriaGeometries(string2, hashMap3);
            boolean bl2 = bl = hashMap != null && !hashMap.isEmpty();
            if (bl) {
                this.numShape3Ds += hashMap.size();
            }
            if (bl) {
                this.fillShape3Ds(hashMap2, hashMap4, hashMap, (String)object2, string, string2, (ArrayList<MeshView>)object);
            }
        } else {
            if (object3 == Geometry.GeomType.CONVEXMESH) {
                return null;
            }
            if (object3 == Geometry.GeomType.SPLINE) {
                return null;
            }
            if (object3 == Geometry.GeomType.BREP) {
                return null;
            }
        }
        return object;
    }

    private void fillShape3Ds(HashMap<String, PhongMaterial> hashMap, HashMap<String, Boolean> hashMap2, HashMap<String, ArrayList<TriangleMesh>> hashMap3, String string, String string2, String string3, ArrayList<MeshView> arrayList) {
        Set<String> set = hashMap3.keySet();
        for (String string4 : set) {
            ArrayList<TriangleMesh> arrayList2 = hashMap3.get(string4);
            if (arrayList2.isEmpty()) continue;
            if (string4.equals(string3)) {
                this.fillDefaultAppearance(arrayList2, string, string2, arrayList);
                continue;
            }
            PhongMaterial phongMaterial = hashMap.get(string4);
            if (phongMaterial != null) {
                for (TriangleMesh triangleMesh : arrayList2) {
                    MeshView meshView = new MeshView((Mesh)triangleMesh);
                    meshView.setMaterial((javafx.scene.paint.Material)phongMaterial);
                    if (hashMap2.get(string4).booleanValue()) {
                        meshView.setCullFace(CullFace.NONE);
                    }
                    this.setShape3DName(meshView, string, string2);
                    arrayList.add(meshView);
                }
                continue;
            }
            this.fillDefaultAppearance(arrayList2, string, string2, arrayList);
        }
    }

    private void fillDefaultAppearance(ArrayList<TriangleMesh> arrayList, String string, String string2, ArrayList<MeshView> arrayList2) {
        for (TriangleMesh triangleMesh : arrayList) {
            PhongMaterial phongMaterial = new PhongMaterial();
            this.base.putNamedMaterial("PhongMaterial_" + Material.nextMatNameExt(), phongMaterial);
            MeshView meshView = new MeshView((Mesh)triangleMesh);
            meshView.setMaterial((javafx.scene.paint.Material)phongMaterial);
            this.setShape3DName(meshView, string, string2);
            arrayList2.add(meshView);
        }
    }

    private void setShape3DName(MeshView meshView, String string, String string2) {
        String string3 = null;
        if (this.numShape3Ds == 1) {
            string3 = string2 != null && string2.length() > 0 ? string2 : string;
        } else {
            string3 = string + "-" + Integer.toString(this.shape3dCounter);
            ++this.shape3dCounter;
        }
        meshView.setId(string3);
        this.base.putNamedNode(string3, (Node)meshView);
    }
}

