/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.col.ColladaFileParser;
import com.interactivemesh.jfx.importer.col.NewParam;
import com.interactivemesh.jfx.importer.col.ParamFX;
import com.interactivemesh.jfx.importer.col.Sampler;
import com.interactivemesh.jfx.importer.col.Surface;

final class NewSetParamParser
extends AbstractElementParserChar {
    private AbstractElementParser parentParser = null;
    private ParamFX paramFX = null;

    NewSetParamParser(ColladaFileParser colladaFileParser) {
        super(colladaFileParser);
        this.charArray = new char[200];
        this.isCharacter = true;
    }

    void setup(AbstractElementParser abstractElementParser, ParamFX paramFX) {
        this.parentParser = abstractElementParser;
        this.paramFX = paramFX;
        this.arrPos = 0;
    }

    @Override
    void doClose() {
        this.charArray = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        this.arrPos = 0;
        char c = string.charAt(0);
        if (c == 's') {
            if (string.equals("sampler2D")) {
                Sampler sampler = new Sampler(string);
                if (sampler.getType() == null) throw new ImportException("NewSetParamParser : unknown sampler, name = " + string);
                this.paramFX.setType(ParamFX.NewSetType.SA);
                this.paramFX.setSampler(sampler);
                this.cfp.setSamplerParser(this, sampler);
                return;
            } else if (string.equals("surface")) {
                String string2 = this.cfp.xR.getAttributeValue(null, "type");
                Surface surface = new Surface(string2);
                if (surface.type() == null) throw new ImportException("NewSetParamParser : unknown surface, type = " + string2);
                this.paramFX.setType(ParamFX.NewSetType.SU);
                this.paramFX.setSurface(surface);
                this.cfp.setSurfaceParser(this, surface);
                return;
            } else if (string.equals("sampler_image")) {
                String string3 = this.cfp.xR.getAttributeValue(null, "url");
                if (string3 == null) throw new ImportException("NewSetParamParser : sampler_image's url is null !");
                this.paramFX.setType(ParamFX.NewSetType.SI);
                this.paramFX.setSamplerImageUrl(string3);
                return;
            } else if (string.equals("sampler_states")) {
                this.cfp.setNullParser(this, string);
                return;
            } else {
                if (string.equals("semantic")) return;
                this.cfp.setNullParser(this, string);
            }
            return;
        } else {
            if (c == 'f' || c == 'i' || c == 'b') return;
            if (string.equals("array")) {
                this.cfp.setNullParser(this, string);
                return;
            } else if (string.equals("annotate")) {
                this.cfp.setNullParser(this, string);
                return;
            } else {
                if (!string.equals("usertype")) return;
                this.cfp.setNullParser(this, string);
            }
        }
    }

    @Override
    void endElement(String string) {
        char c = string.charAt(0);
        if (c == 'f') {
            if (string.equals("float4")) {
                this.paramFX.setLength(4);
            } else if (string.equals("float")) {
                this.paramFX.setLength(1);
            } else if (string.equals("float2")) {
                this.paramFX.setLength(2);
            } else if (string.equals("float3")) {
                this.paramFX.setLength(3);
            } else if (string.equals("float3x3")) {
                this.paramFX.setLength(9);
                this.paramFX.setMatrixType(ParamFX.NewSetMatrix.F3x3);
            } else if (string.equals("float4x4")) {
                this.paramFX.setLength(16);
                this.paramFX.setMatrixType(ParamFX.NewSetMatrix.F4x4);
            } else if (string.equals("float3x4")) {
                this.paramFX.setLength(12);
                this.paramFX.setMatrixType(ParamFX.NewSetMatrix.F3x4);
            } else if (string.equals("float4x3")) {
                this.paramFX.setLength(12);
                this.paramFX.setMatrixType(ParamFX.NewSetMatrix.F4x3);
            } else {
                this.paramFX.setType(ParamFX.NewSetType.F);
                this.paramFX.setUnsuppMatrixName(string);
                this.paramFX.setMatrixType(ParamFX.NewSetMatrix.UNSUPPORTED);
            }
            if (this.paramFX.getLength() > 0) {
                this.paramFX.setType(ParamFX.NewSetType.F);
                String string2 = this.cUtils().trimString(this.charArray, this.arrPos);
                float[] fArray = new float[this.paramFX.getLength()];
                this.cUtils().splitFloatInto(string2, fArray);
                this.paramFX.setArray(fArray);
            }
        } else if (c == 's') {
            if (string.equals("setparam")) {
                this.setParentParser();
            } else {
                if (string.startsWith("sampler_image")) {
                    return;
                }
                if (string.equals("semantic")) {
                    ((NewParam)this.paramFX).setSemantic(this.cUtils().trimString(this.charArray, this.arrPos));
                }
            }
        } else if (string.equals("newparam")) {
            this.setParentParser();
        } else if (string.equals("modifier")) {
            ((NewParam)this.paramFX).setModifier(this.cUtils().trimString(this.charArray, this.arrPos));
        } else if (c == 'i') {
            if (string.equals("int")) {
                this.paramFX.setLength(1);
            } else if (string.equals("int2")) {
                this.paramFX.setLength(2);
            } else if (string.equals("int3")) {
                this.paramFX.setLength(3);
            } else if (string.equals("int4")) {
                this.paramFX.setLength(4);
            }
            if (this.paramFX.getLength() > 0) {
                this.paramFX.setType(ParamFX.NewSetType.I);
                int[] nArray = new int[this.paramFX.getLength()];
                this.cUtils().splitIntegerInto(this.charArray, this.arrPos, nArray);
                this.paramFX.setArray(nArray);
            }
        } else if (c == 'b') {
            if (string.equals("bool")) {
                this.paramFX.setLength(1);
            } else if (string.equals("bool2")) {
                this.paramFX.setLength(2);
            } else if (string.equals("bool3")) {
                this.paramFX.setLength(3);
            } else if (string.equals("bool4")) {
                this.paramFX.setLength(4);
            }
            if (this.paramFX.getLength() > 0) {
                this.paramFX.setType(ParamFX.NewSetType.B);
                String[] stringArray = new String[this.paramFX.getLength()];
                this.cUtils().splitStringInto(this.charArray, this.arrPos, stringArray);
                boolean[] blArray = new boolean[this.paramFX.getLength()];
                int n = 0;
                for (String string3 : stringArray) {
                    if (string3.equalsIgnoreCase("true")) {
                        blArray[n++] = true;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("false")) {
                        blArray[n++] = false;
                        continue;
                    }
                    throw new ImportException("NewSetParamParser bool-array : neither true nor false! string = " + string3);
                }
                this.paramFX.setArray(blArray);
            }
        } else if (string.equals("enum")) {
            this.paramFX.setType(ParamFX.NewSetType.E);
            this.paramFX.setEnumString(this.cUtils().trimString(this.charArray, this.arrPos));
        }
    }

    private void setParentParser() {
        this.cfp.setParser(this.parentParser);
        this.parentParser = null;
        this.paramFX = null;
    }
}

