/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElement;
import com.interactivemesh.jfx.importer.col.CMeshSmoother;
import com.interactivemesh.jfx.importer.col.CNormalizer;
import com.interactivemesh.jfx.importer.col.CUtils;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.InputS;
import com.interactivemesh.jfx.importer.col.InputU;
import com.interactivemesh.jfx.importer.col.Source;
import com.interactivemesh.jfx.importer.col.Vertices;
import java.util.ArrayList;
import javafx.scene.shape.TriangleMesh;

abstract class Primitive
extends AbstractElement {
    String name = null;
    String material = null;
    int count = 0;
    final ArrayList<InputS> inputList = new ArrayList();
    int vertexOffset = 0;
    boolean isDoFlipCoords = true;
    boolean isDoFlipTexCoords = true;
    float[] coordinatesS = null;
    float[] colorsS = null;
    float[] normalsS = null;
    float[] texCoordinatesS = null;
    int[] coordIndsP = null;
    int[] colorIndsP = null;
    int[] normalIndsP = null;
    int[] texCoordIndsP = null;
    float[] coords = null;
    float[] colors = null;
    float[] normals = null;
    float[] texCoords = null;
    int[] coordInds = null;
    int[] colorInds = null;
    int[] normalInds = null;
    int[] texCoordInds = null;
    int[] stripCounts = null;
    boolean isColors = false;
    boolean isNormals = false;
    boolean isTexCoords = false;
    int colDim = -1;
    int texDim = -1;
    int indexCount = 0;
    TriangleMesh geomArray = null;
    final ArrayList<String> vertexSemantics = new ArrayList();

    Primitive() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
    }

    @Override
    void clear() {
        this.inputList.clear();
        this.coordinatesS = null;
        this.colorsS = null;
        this.normalsS = null;
        this.texCoordinatesS = null;
        this.coordIndsP = null;
        this.colorIndsP = null;
        this.normalIndsP = null;
        this.texCoordIndsP = null;
        this.coords = null;
        this.colors = null;
        this.normals = null;
        this.texCoords = null;
        this.coordInds = null;
        this.colorInds = null;
        this.normalInds = null;
        this.texCoordInds = null;
        this.stripCounts = null;
        this.geomArray = null;
        this.vertexSemantics.clear();
        super.clear();
    }

    abstract void fillIndices(char[] var1, int var2, CUtils var3);

    abstract void createGeometry();

    final TriangleMesh getGeometry() {
        if (this.geomArray == null) {
            this.createGeometry();
        }
        return this.geomArray;
    }

    final String getMatSymbol() {
        return this.material;
    }

    private void convertCoords() {
        int n = 0;
        int n2 = this.coords.length / 3;
        for (int i = 0; i < n2; ++i) {
            if (this.coords[++n] != 0.0f) {
                this.coords[n] = -this.coords[n];
            }
            if (this.coords[++n] != 0.0f) {
                this.coords[n] = -this.coords[n];
            }
            ++n;
        }
    }

    void createLineQuadTriaGeometry(boolean bl) {
        int n;
        int n2 = 0;
        int[] nArray = new int[this.indexCount / 3];
        ArrayList<CMeshSmoother.SmoothMesh> arrayList = this.base.smoother.create(this.coordInds, this.coords.length / 3, this.normalInds);
        ArrayList<Integer> arrayList2 = null;
        int n3 = 0;
        for (CMeshSmoother.SmoothMesh smoothMesh : arrayList) {
            arrayList2 = smoothMesh.getIndices();
            n3 = smoothMesh.getSmGrId();
            int n4 = arrayList2.size();
            for (n = 0; n < n4; n += 3) {
                nArray[arrayList2.get((int)n).intValue() / 3] = n3;
            }
            smoothMesh.close();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        arrayList.clear();
        if (this.isDoFlipCoords) {
            this.convertCoords();
        }
        if (!this.isTexCoords) {
            this.texCoords = new float[2];
            this.texCoords[0] = 0.0f;
            this.texCoords[1] = 0.0f;
        } else if (this.isDoFlipTexCoords) {
            int n5 = this.texCoords.length;
            for (int i = 1; i < n5; i += 2) {
                this.texCoords[i] = 1.0f - this.texCoords[i];
            }
        }
        this.geomArray = new TriangleMesh();
        this.geomArray.getPoints().addAll(this.coords);
        this.geomArray.getTexCoords().addAll(this.texCoords);
        Object object = new int[this.indexCount * 2];
        int n6 = 0;
        if (this.isTexCoords) {
            for (n = 0; n < this.indexCount; ++n) {
                object[n6++] = this.coordInds[n];
                object[n6++] = this.texCoordInds[n];
            }
        } else {
            for (n = 0; n < this.indexCount; ++n) {
                object[n6++] = this.coordInds[n];
                object[n6++] = false;
            }
        }
        this.geomArray.getFaces().addAll((int[])object);
        this.geomArray.getFaceSmoothingGroups().addAll(nArray);
    }

    void vertexComponentsAndIndices(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Source source;
        String string;
        int n6 = n / this.vertexOffset;
        Vertices vertices = null;
        InputS iterator = null;
        for (InputS iterator2 : this.inputList) {
            if (!iterator2.semantic.equals("VERTEX")) continue;
            vertices = this.cache.getVertices(iterator2.source);
            iterator = iterator2;
            break;
        }
        this.inputList.remove(iterator);
        int n7 = iterator.offset;
        for (InputU inputU : vertices.inputList) {
            string = inputU.semantic;
            source = null;
            if (string.equals("POSITION") && (source = this.cache.getSource(inputU.source)) != null) {
                n5 = 3;
                if (source.isAccessor()) {
                    n5 = source.accessorStride;
                }
                if (n5 == 3) {
                    this.coordinatesS = source.getFloatArray();
                    if (source.numReferences > 1) {
                        this.coordinatesS = (float[])this.coordinatesS.clone();
                        this.isDoFlipCoords = false;
                    }
                } else if (n5 == 2) {
                    float[] fArray = source.getFloatArray();
                    n4 = fArray.length + fArray.length / 2;
                    n3 = 0;
                    this.coordinatesS = new float[n4];
                    for (int i = 0; i < n4; i += 3) {
                        this.coordinatesS[i] = fArray[n3++];
                        this.coordinatesS[i + 1] = fArray[n3++];
                        this.coordinatesS[i + 2] = 0.0f;
                    }
                } else {
                    System.out.println("posDim = " + n5);
                }
                this.coordIndsP = new int[n6];
                n2 = 0;
                for (n4 = n7; n4 < n; n4 += this.vertexOffset) {
                    this.coordIndsP[n2++] = nArray[n4];
                }
                continue;
            }
            if (string.equals("COLOR") && (source = this.cache.getSource(inputU.source)) != null) {
                this.isColors = true;
                this.colDim = 3;
                if (source.isAccessor()) {
                    this.colDim = source.accessorStride;
                }
                this.colorsS = source.getFloatArray();
                if (source.numReferences > 1) {
                    this.colorsS.clone();
                }
                this.colorIndsP = new int[n6];
                n5 = 0;
                for (n2 = n7; n2 < n; n2 += this.vertexOffset) {
                    this.colorIndsP[n5++] = nArray[n2];
                }
                continue;
            }
            if (string.equals("NORMAL") && (source = this.cache.getSource(inputU.source)) != null) {
                this.isNormals = true;
                this.normalsS = source.getFloatArray();
                if (source.numReferences > 1) {
                    this.normalsS = (float[])this.normalsS.clone();
                }
                this.normalIndsP = new int[n6];
                n5 = 0;
                for (n2 = n7; n2 < n; n2 += this.vertexOffset) {
                    this.normalIndsP[n5++] = nArray[n2];
                }
                continue;
            }
            if (!string.equals("TEXCOORD") || (source = this.cache.getSource(inputU.source)) == null) continue;
            this.isTexCoords = true;
            this.texDim = 2;
            if (source.isAccessor()) {
                this.texDim = source.accessorStride;
            }
            this.texCoordinatesS = source.getFloatArray();
            if (source.numReferences > 1) {
                this.texCoordinatesS = (float[])this.texCoordinatesS.clone();
                this.isDoFlipTexCoords = false;
            }
            this.texCoordIndsP = new int[n6];
            n5 = 0;
            for (n2 = n7; n2 < n; n2 += this.vertexOffset) {
                this.texCoordIndsP[n5++] = nArray[n2];
            }
        }
        for (InputS inputS : this.inputList) {
            string = inputS.semantic;
            source = null;
            n5 = 0;
            if (string.equals("COLOR") && (source = this.cache.getSource(inputS.source)) != null) {
                this.isColors = true;
                this.colDim = 3;
                if (source.isAccessor()) {
                    this.colDim = source.accessorStride;
                }
                this.colorsS = source.getFloatArray();
                if (source.numReferences > 1) {
                    this.colorsS = (float[])this.colorsS.clone();
                }
                this.colorIndsP = new int[n6];
                n5 = 0;
                for (n4 = n2 = inputS.offset; n4 < n; n4 += this.vertexOffset) {
                    this.colorIndsP[n5++] = nArray[n4];
                }
            } else if (string.equals("NORMAL") && (source = this.cache.getSource(inputS.source)) != null) {
                this.isNormals = true;
                this.normalsS = source.getFloatArray();
                if (source.numReferences > 1) {
                    this.normalsS = (float[])this.normalsS.clone();
                }
                this.normalIndsP = new int[n6];
                n5 = 0;
                for (n4 = n2 = inputS.offset; n4 < n; n4 += this.vertexOffset) {
                    this.normalIndsP[n5++] = nArray[n4];
                }
            } else if (string.equals("TEXCOORD") && (source = this.cache.getSource(inputS.source)) != null) {
                this.isTexCoords = true;
                n2 = inputS.set;
                this.texDim = 2;
                if (source.isAccessor()) {
                    this.texDim = source.accessorStride;
                }
                this.texCoordinatesS = source.getFloatArray();
                if (source.numReferences > 1) {
                    this.texCoordinatesS = (float[])this.texCoordinatesS.clone();
                    this.isDoFlipTexCoords = false;
                }
                this.texCoordIndsP = new int[n6];
                n5 = 0;
                for (n3 = n4 = inputS.offset; n3 < n; n3 += this.vertexOffset) {
                    this.texCoordIndsP[n5++] = nArray[n3];
                }
            } else {
                System.out.println("PrimitiveProcessor : UNIMPLEMENTED SEMANTIC " + string);
            }
            source = null;
        }
    }

    void prepareLineTriaArrays(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        boolean bl4 = false;
        float[] fArray = null;
        if (bl4 || bl) {
            this.coords = this.base.indexer.createRFTriplesAndInds(this.coordinatesS, this.coordinatesS.length, this.coordInds);
            this.isDoFlipCoords = true;
            if (bl) {
                fArray = this.coords;
            }
        } else {
            this.coords = this.coordinatesS;
        }
        if (bl) {
            this.isNormals = true;
            int[] nArray = null;
            int[] nArray2 = null;
            float[] fArray2 = null;
            int[] nArray3 = new int[fArray.length / 3];
            CNormalizer.Triplef[] triplefArray = null;
            nArray = this.coordInds;
            fArray2 = this.base.normalizer.calcTriangleNormals(fArray, nArray, nArray3);
            int[][] nArray4 = this.base.normalizer.vertexIndices(nArray, nArray3);
            nArray2 = new int[this.indexCount];
            boolean bl5 = true;
            triplefArray = this.base.normalizer.calcIndexedVertexNormals(this.base.creaseAngle, bl5, fArray2, nArray, nArray4, nArray2);
            int n2 = triplefArray.length;
            CNormalizer.Triplef triplef = null;
            n = 0;
            this.normals = new float[n2 * 3];
            for (int i = 0; i < n2; ++i) {
                triplef = triplefArray[i];
                this.normals[n++] = triplef.x;
                this.normals[n++] = triplef.y;
                this.normals[n++] = triplef.z;
            }
            this.normalInds = nArray2;
        } else if (this.isNormals) {
            this.normals = bl4 ? this.base.indexer.createRFTriplesAndInds(this.normalsS, this.normalsS.length, this.normalInds) : this.normalsS;
        }
        if (this.isColors) {
            if (bl4) {
                if (this.colDim == 3) {
                    this.colors = this.base.indexer.createRFTriplesAndInds(this.colorsS, this.colorsS.length, this.colorInds);
                } else if (this.colDim == 4) {
                    this.colors = this.base.indexer.createRFQuadsAndInds(this.colorsS, this.colorsS.length, this.colorInds);
                }
            } else {
                this.colors = this.colorsS;
            }
        }
        if (this.isTexCoords) {
            if (bl4) {
                if (this.texDim == 2) {
                    this.texCoords = this.base.indexer.createRFTuplesAndInds(this.texCoordinatesS, this.texCoordinatesS.length, this.texCoordInds);
                }
                this.isDoFlipTexCoords = true;
            } else {
                this.texCoords = this.texCoordinatesS;
            }
        }
    }

    void reverseFaces(int n) {
        int n2;
        int n3 = this.coordInds.length;
        int n4 = -1;
        int n5 = n - 1;
        for (n2 = 0; n2 < n3; n2 += n) {
            n4 = this.coordInds[n2 + n5];
            this.coordInds[n2 + n5] = this.coordInds[n2 + 1];
            this.coordInds[n2 + 1] = n4;
        }
        if (this.isNormals) {
            for (n2 = 0; n2 < n3; n2 += n) {
                n4 = this.normalInds[n2 + n5];
                this.normalInds[n2 + n5] = this.normalInds[n2 + 1];
                this.normalInds[n2 + 1] = n4;
            }
        }
        if (this.isColors) {
            for (n2 = 0; n2 < n3; n2 += n) {
                n4 = this.colorInds[n2 + n5];
                this.colorInds[n2 + n5] = this.colorInds[n2 + 1];
                this.colorInds[n2 + 1] = n4;
            }
        }
        if (this.isTexCoords) {
            for (n2 = 0; n2 < n3; n2 += n) {
                n4 = this.texCoordInds[n2 + n5];
                this.texCoordInds[n2 + n5] = this.texCoordInds[n2 + 1];
                this.texCoordInds[n2 + 1] = n4;
            }
        }
        if (this.isNormals) {
            int n6 = this.normals.length;
            for (n2 = 0; n2 < n6; ++n2) {
                this.normals[n2] = -this.normals[n2];
            }
        }
    }

    final int triaCtOfFanStrip(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i];
        }
        return n2 -= 2 * n;
    }

    final void dropFlatTriangles() {
        int n;
        int n2 = this.coordInds.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 / 10);
        for (n = 0; n < n2; n += 3) {
            int n3 = this.coordInds[n] * 3;
            int n4 = this.coordInds[n + 1] * 3;
            int n5 = this.coordInds[n + 2] * 3;
            if (this.coordinatesS[n3 + 0] == this.coordinatesS[n4 + 0] && this.coordinatesS[n3 + 1] == this.coordinatesS[n4 + 1] && this.coordinatesS[n3 + 2] == this.coordinatesS[n4 + 2]) {
                arrayList.add(n);
                continue;
            }
            if (this.coordinatesS[n3 + 0] == this.coordinatesS[n5 + 0] && this.coordinatesS[n3 + 1] == this.coordinatesS[n5 + 1] && this.coordinatesS[n3 + 2] == this.coordinatesS[n5 + 2]) {
                arrayList.add(n);
                continue;
            }
            if (this.coordinatesS[n4 + 0] != this.coordinatesS[n5 + 0] || this.coordinatesS[n4 + 1] != this.coordinatesS[n5 + 1] || this.coordinatesS[n4 + 2] != this.coordinatesS[n5 + 2]) continue;
            arrayList.add(n);
        }
        if (arrayList.size() > 0) {
            int n6;
            n = arrayList.size();
            int[] nArray = null;
            int[] nArray2 = null;
            int[] nArray3 = null;
            int n7 = n2 - n * 3;
            int[] nArray4 = new int[n7];
            if (this.isColors) {
                nArray2 = new int[n7];
            }
            if (this.isNormals) {
                nArray = new int[n7];
            }
            if (this.isTexCoords) {
                nArray3 = new int[n7];
            }
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (n6 = 0; n6 < n; ++n6) {
                n9 = (Integer)arrayList.get(n6);
                for (int i = n8; i < n9; ++i) {
                    nArray4[n10] = this.coordInds[i];
                    if (this.isColors) {
                        nArray2[n10] = this.colorInds[i];
                    }
                    if (this.isNormals) {
                        nArray[n10] = this.normalInds[i];
                    }
                    if (this.isTexCoords) {
                        nArray3[n10] = this.texCoordInds[i];
                    }
                    ++n10;
                }
                n8 = n9 + 3;
            }
            for (n6 = n8; n6 < n2; ++n6) {
                nArray4[n10] = this.coordInds[n6];
                if (this.isColors) {
                    nArray2[n10] = this.colorInds[n6];
                }
                if (this.isNormals) {
                    nArray[n10] = this.normalInds[n6];
                }
                if (this.isTexCoords) {
                    nArray3[n10] = this.texCoordInds[n6];
                }
                ++n10;
            }
            this.coordInds = nArray4;
            if (this.isColors) {
                this.colorInds = nArray2;
            }
            if (this.isNormals) {
                this.normalInds = nArray;
            }
            if (this.isTexCoords) {
                this.texCoordInds = nArray3;
            }
            arrayList.clear();
        }
    }
}

