/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import javax.xml.stream.XMLStreamException;

abstract class AbstractElementParserChar
extends AbstractElementParser {
    private static final String BOOLEAN = "Boolean";
    private static final String DOUBLE = "Double";
    private static final String FLOAT = "Float";
    private static final String INTEGER = "Integer";
    private static final String STRING = "String";
    private String primValue = null;
    String primTagName = null;
    boolean isCharacter = false;
    boolean isPrimitive = false;
    int arrPos = 0;
    char[] charArray = null;

    AbstractElementParserChar(FxFileParser fxFileParser) {
        super(fxFileParser);
    }

    final void setupChar() {
        this.arrPos = 0;
        this.isCharacter = false;
        this.isPrimitive = false;
        this.primValue = null;
        this.primTagName = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean processPrimitiveStartElement(String string) {
        if (!(string.equals(DOUBLE) || string.equals(STRING) || string.equals(BOOLEAN) || string.equals(INTEGER) || string.equals(FLOAT))) {
            if (!string.equals("reference")) return false;
            if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("PrimitiveParser : primitive reference element doesn't have prefix 'fx:' !");
            String string2 = this.fxfp.xR.getAttributeValue(null, "source");
            if (string2 == null) throw new ImportException("PrimitiveParser : source attribute in primitive referernce element is null !");
            String string3 = this.fxfp.currCache.getPrimitive(string2);
            if (string3 == null) {
                throw new ImportException("PrimitiveParser : no primitive referernce found for source = >" + string2 + "< !");
            }
            this.primValue = string3;
            this.primTagName = string;
            return true;
        }
        this.getPrimitiveFromAttribute(string);
        this.primTagName = string;
        return true;
    }

    private void getPrimitiveFromAttribute(String string) {
        String string2 = null;
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (!this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
            String string3 = this.fxfp.xR.getAttributeLocalName(i);
            String string4 = this.fxfp.xR.getAttributeValue(i);
            if (string4 != null && string4.length() > 0) {
                if (string3.equals("value")) {
                    this.primValue = string4;
                    continue;
                }
                if (string3.equals("id")) {
                    string2 = string4;
                    continue;
                }
                throw new ImportException(string + " element : neither 'fx:id' nor 'fx:value' attribute. Local name = >" + string3 + "< !");
            }
            throw new ImportException(string + " element : " + string3 + " string is empty !");
        }
        if (string2 != null) {
            this.fxfp.currCache.putPrimitive(string2, this.primValue);
        }
    }

    @Override
    final void characters() throws XMLStreamException {
        if (this.isCharacter) {
            int n = this.fxfp.xR.getTextLength();
            if (this.charArray.length - this.arrPos < n) {
                char[] cArray = this.charArray;
                int n2 = (int)Math.max((float)(this.arrPos + n), (float)cArray.length * 2.0f);
                this.charArray = new char[n2];
                System.arraycopy(cArray, 0, this.charArray, 0, this.arrPos);
            }
            int n3 = this.fxfp.xR.getTextCharacters(0, this.charArray, this.arrPos, n);
            this.arrPos += n3;
        }
    }

    final String getCharOrPrimString() {
        if (this.isCharacter) {
            this.isCharacter = false;
            String string = this.fxfp.base.fxUtils.trimString(this.charArray, this.arrPos);
            if (string != null && string.length() > 0) {
                return string;
            }
            return null;
        }
        if (this.isPrimitive) {
            this.isPrimitive = false;
            String string = this.primValue;
            this.primValue = null;
            return string;
        }
        return null;
    }
}

