/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.NodeParser;
import java.net.URL;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.shape.Box;
import javafx.scene.shape.MeshView;

final class GroupParser
extends NodeParser {
    private ClassLoader classLoader = null;
    private Group currGroup = null;
    private boolean isChildren = false;
    private final boolean isNestedGroupParser;
    int num = -1;

    GroupParser(FxFileParser fxFileParser) {
        this(fxFileParser, false);
    }

    GroupParser(FxFileParser fxFileParser, boolean bl) {
        super(fxFileParser);
        this.isNestedGroupParser = !bl;
    }

    void setup(AbstractElementParser abstractElementParser, Group group) {
        this.parentParser = abstractElementParser;
        this.currGroup = group;
        this.isChildren = false;
        this.setupNode();
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.fxfp.xR.getAttributeValue(i);
            if (string == null || string.length() <= 0) {
                throw new ImportException("GroupParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
            }
            String string2 = this.fxfp.xR.getAttributeLocalName(i);
            this.processNodeAttributes(string2, string, i);
        }
    }

    @Override
    String getIdDefault() {
        return "Group";
    }

    @Override
    void close() {
        super.close();
    }

    @Override
    void startElement(String string) {
        if (this.isChildren) {
            if (!this.processChildElement(string)) {
                this.fxfp.setNullParser(this, string);
            }
        } else if (string.equals("transforms")) {
            this.fxfp.setTransformsParser(this, (Node)this.currGroup);
        } else if (string.equals("children")) {
            this.isChildren = true;
        } else {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (!this.processNodeStartElement(string) && !this.processChildElement(string)) {
                if (this.processPrimitiveStartElement(string)) {
                    this.isPrimitive = true;
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            }
            if (this.isCharacter) {
                this.arrPos = 0;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processChildElement(String string) {
        if (string.equals("Group")) {
            Group group = new Group();
            this.currGroup.getChildren().add((Object)group);
            this.fxfp.setNestedGroupParser(this, group);
            return true;
        } else if (string.equals("MeshView")) {
            MeshView meshView = new MeshView();
            this.currGroup.getChildren().add((Object)meshView);
            this.fxfp.setMeshViewParser(this, meshView);
            return true;
        } else if (string.equals("Box")) {
            Box box = new Box();
            this.currGroup.getChildren().add((Object)box);
            this.fxfp.setBoxParser(this, box);
            return true;
        } else if (string.equals("Cylinder")) {
            this.fxfp.setCylinderParser(this, this.currGroup);
            return true;
        } else if (string.equals("Sphere")) {
            this.fxfp.setSphereParser(this, this.currGroup);
            return true;
        } else if (string.equals("AmbientLight")) {
            if (this.fxfp.base.isIgnoreLights) {
                this.fxfp.setNullParser(this, string);
                return true;
            } else {
                AmbientLight ambientLight = new AmbientLight();
                this.currGroup.getChildren().add((Object)ambientLight);
                this.fxfp.base.addLight((LightBase)ambientLight);
                this.fxfp.setLightParser(this, (LightBase)ambientLight, string);
            }
            return true;
        } else if (string.equals("PointLight")) {
            if (this.fxfp.base.isIgnoreLights) {
                this.fxfp.setNullParser(this, string);
                return true;
            } else {
                PointLight pointLight = new PointLight();
                this.currGroup.getChildren().add((Object)pointLight);
                this.fxfp.base.addLight((LightBase)pointLight);
                this.fxfp.setLightParser(this, (LightBase)pointLight, string);
            }
            return true;
        } else if (string.equals("ParallelCamera")) {
            ParallelCamera parallelCamera = new ParallelCamera();
            if (!this.fxfp.base.isIgnoreCameras) {
                this.currGroup.getChildren().add((Object)parallelCamera);
                this.fxfp.base.addCamera((Camera)parallelCamera);
            }
            this.fxfp.setCameraParser(this, (Camera)parallelCamera, string, this.currGroup);
            return true;
        } else if (string.equals("PerspectiveCamera")) {
            PerspectiveCamera perspectiveCamera = new PerspectiveCamera(true);
            if (!this.fxfp.base.isIgnoreCameras) {
                this.currGroup.getChildren().add((Object)perspectiveCamera);
                this.fxfp.base.addCamera((Camera)perspectiveCamera);
            }
            this.fxfp.setCameraParser(this, (Camera)perspectiveCamera, string, this.currGroup);
            return true;
        } else {
            String string2;
            if (!string.equals("include")) return false;
            if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("GroupParser : include element doesn't have prefix 'fx:' !");
            String string3 = this.fxfp.xR.getAttributeValue(null, "source");
            if (string3 == null || string3.length() <= 0) throw new ImportException("GroupParser : source attribute of include element not found !");
            URL uRL = null;
            if (string3.charAt(0) == '/') {
                if (this.classLoader == null) {
                    this.classLoader = Thread.currentThread().getContextClassLoader();
                    if (this.classLoader == null) {
                        throw new ImportException("GroupParser : ClassLoader not available. Can't include FXML file relative to the classpath for source =\n" + string3);
                    }
                }
                if ((uRL = this.classLoader.getResource(string2 = string3.substring(1))) == null) {
                    throw new ImportException("GroupParser : ClassLoader.getResource(path) for included FXML file returned null-URL: \n  path = " + string3);
                }
            } else {
                uRL = this.fxfp.base.fxUtils.getUrlForRelativePath(this.fxfp.currCache.getBaseURL(), string3);
                if (uRL == null) {
                    throw new ImportException("GroupParser : Can't create URL for included FXML file : \n  base = " + this.fxfp.currCache.getBaseURL().toString() + "\n  path = " + string3);
                }
            }
            if ((string2 = this.fxfp.importerImpl.parseIncludedFxmlFile(uRL, string3, this.currGroup)) == null) return true;
            this.currGroup.getChildren().add((Object)string2);
        }
        return true;
    }

    @Override
    void endElement(String string) {
        if (string.equals("children")) {
            this.isChildren = false;
        } else if (!string.equals(this.primTagName)) {
            if (this.isCharacter || this.isPrimitive) {
                String string2 = this.getCharOrPrimString();
                if (string2 != null) {
                    this.processNodeEndElement(string, string2);
                }
            } else if (string.equals("Group")) {
                this.setNodeProperties((Node)this.currGroup);
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
                this.currGroup = null;
                if (this.isNestedGroupParser) {
                    this.fxfp.cacheNestedGroupParser(this);
                }
            }
        }
    }
}

