/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.fxml.ColorParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import java.io.IOException;
import java.net.URL;
import java.util.BitSet;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Shape3D;

final class PhongMaterialParser
extends AbstractElementParserChar {
    private ColorParser colorParser = null;
    private Color colorRef = null;
    private AbstractElementParser parentParser;
    private PhongMaterial currPhongMat = null;
    private final BitSet imgAttrs = new BitSet(4);
    private String diffColor = null;
    private String specColor = null;
    private String specPower = null;
    private boolean isColor = false;
    private boolean isImage = false;
    private Shape3D ownerShape3D = null;

    PhongMaterialParser(FxFileParser fxFileParser) {
        super(fxFileParser);
        this.charArray = new char[200];
    }

    PhongMaterial getPhongMaterial() {
        PhongMaterial phongMaterial = this.currPhongMat;
        this.currPhongMat = null;
        return phongMaterial;
    }

    void setup(AbstractElementParser abstractElementParser, Shape3D shape3D) {
        this.parentParser = abstractElementParser;
        this.ownerShape3D = shape3D;
        this.currPhongMat = new PhongMaterial();
        this.fxfp.base.putNamedMaterial(this.currPhongMat);
        this.imgAttrs.clear();
        this.diffColor = null;
        this.specColor = null;
        this.specPower = null;
        this.isColor = false;
        this.isImage = false;
        this.setupChar();
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.fxfp.xR.getAttributeValue(i);
            if (string != null && string.length() > 0) {
                String string2 = this.fxfp.xR.getAttributeLocalName(i);
                if (string2.equals("specularPower")) {
                    this.specPower = string;
                    continue;
                }
                if (string2.equals("diffuseColor")) {
                    this.diffColor = string;
                    continue;
                }
                if (string2.equals("specularColor")) {
                    this.specColor = string;
                    continue;
                }
                if (!string2.equals("id") || !this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
                this.fxfp.currCache.putPhongMaterial(string, this.currPhongMat);
                continue;
            }
            throw new ImportException("PhongMaterialParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
        }
    }

    @Override
    void close() {
        this.charArray = null;
    }

    private Image createImage(String string) {
        String string2 = string.replace('\\', '/');
        URL uRL = this.fxfp.base.fxUtils.getUrlForAbsolutPath(string2);
        if (uRL == null) {
            uRL = this.fxfp.base.fxUtils.getUrlForRelativePath(this.fxfp.currCache.getBaseURL(), string2);
        }
        if (uRL == null) {
            throw new ImportException("Can't create URL for image from path = \n" + string2);
        }
        String string3 = uRL.toExternalForm();
        int n = string3.lastIndexOf(46) + 1;
        String string4 = string3.substring(n);
        WritableImage writableImage = null;
        try {
            if (string4.equalsIgnoreCase("tga")) {
                writableImage = this.fxfp.base.imgFactory.readImage(string4, uRL);
            } else if (string4.equalsIgnoreCase("tif") || string4.equalsIgnoreCase("tiff")) {
                writableImage = this.fxfp.base.imgFactory.readImage(string4, uRL);
            } else {
                if (this.fxfp.base.isWritableImage) {
                    writableImage = this.fxfp.base.imgFactory.readImage(string4, uRL);
                }
                if (writableImage == null) {
                    writableImage = new Image(string3);
                }
            }
        }
        catch (IOException iOException) {
            throw new ImportException("Can't create image for URL = \n" + uRL.toString(), iOException);
        }
        this.fxfp.base.putImagePath((Image)writableImage, new FilePath(string2, uRL));
        return writableImage;
    }

    private void setImage(Image image) {
        if (this.imgAttrs.get(0)) {
            this.imgAttrs.clear(0);
            this.currPhongMat.setBumpMap(image);
        } else if (this.imgAttrs.get(1)) {
            this.imgAttrs.clear(1);
            this.currPhongMat.setDiffuseMap(image);
        } else if (this.imgAttrs.get(2)) {
            this.imgAttrs.clear(2);
            this.currPhongMat.setSelfIlluminationMap(image);
        } else if (this.imgAttrs.get(3)) {
            this.imgAttrs.clear(3);
            this.currPhongMat.setSpecularMap(image);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        this.isCharacter = false;
        this.isPrimitive = false;
        if (this.isColor) {
            if (string.equals("Color")) {
                this.colorParser = this.fxfp.setColorParser(this);
                return;
            } else {
                if (string.equals("reference")) {
                    if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("PhongMaterialParser : color reference element doesn't have prefix 'fx:' !");
                    String string2 = this.fxfp.xR.getAttributeValue(null, "source");
                    if (string2 == null) throw new ImportException("PhongMaterialParser : source attribute in color referernce element is null !");
                    this.colorRef = this.fxfp.currCache.getColor(string2);
                    if (this.colorRef != null) return;
                    throw new ImportException("PhongMaterialParser : no color referernce found for source = >" + string2 + "< !");
                }
                this.fxfp.setNullParser(this, string);
            }
            return;
        } else if (this.isImage) {
            this.isImage = false;
            if (string.equals("Image")) {
                Image image;
                String string3 = this.fxfp.xR.getAttributeValue("http://javafx.com/fxml", "id");
                String string4 = this.fxfp.xR.getAttributeValue(null, "url");
                if (string4 == null || string4.length() <= 0) return;
                if (string4.charAt(0) == '@') {
                    string4 = string4.substring(1);
                }
                if ((image = this.createImage(string4)) == null) return;
                if (string3 != null) {
                    this.fxfp.currCache.putImage(string3, image);
                }
                this.setImage(image);
                return;
            } else if (string.equals("reference")) {
                if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("PhongMaterialParser : image reference element doesn't have prefix 'fx:' !");
                String string5 = this.fxfp.xR.getAttributeValue(null, "source");
                if (string5 == null) throw new ImportException("PhongMaterialParser : source attribute in image referernce element is null !");
                Image image = this.fxfp.currCache.getImage(string5);
                if (image == null) throw new ImportException("PhongMaterialParser : no image referernce found for source = >" + string5 + "< !");
                this.setImage(image);
                return;
            } else {
                this.fxfp.setNullParser(this, string);
            }
            return;
        } else {
            if (string.equals("diffuseColor")) {
                this.isCharacter = true;
                this.isColor = true;
            } else if (string.equals("specularColor")) {
                this.isCharacter = true;
                this.isColor = true;
            } else if (string.equals("specularPower")) {
                this.isCharacter = true;
            } else if (string.equals("bumpMap")) {
                this.isImage = true;
                this.imgAttrs.set(0);
            } else if (string.equals("diffuseMap")) {
                this.isImage = true;
                this.imgAttrs.set(1);
            } else if (string.equals("selfIlluminationMap")) {
                this.isImage = true;
                this.imgAttrs.set(2);
            } else if (string.equals("specularMap")) {
                this.isImage = true;
                this.imgAttrs.set(3);
            } else if (this.processPrimitiveStartElement(string)) {
                this.isPrimitive = true;
            } else {
                this.fxfp.setNullParser(this, string);
            }
            if (!this.isCharacter) return;
            this.arrPos = 0;
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (string.equals("diffuseColor")) {
                this.isColor = false;
                if (this.diffColor == null) {
                    if (this.isCharacter) {
                        String string2 = this.fxfp.base.fxUtils.trimString(this.charArray, this.arrPos);
                        if (string2 != null && string2.length() > 0) {
                            this.diffColor = string2;
                        }
                    } else if (this.colorParser != null) {
                        this.currPhongMat.setDiffuseColor(this.colorParser.getColor());
                        this.colorParser = null;
                    } else if (this.colorRef != null) {
                        this.currPhongMat.setDiffuseColor(this.colorRef);
                        this.colorRef = null;
                    }
                }
            } else if (string.equals("specularColor")) {
                this.isColor = false;
                if (this.specColor == null) {
                    if (this.isCharacter) {
                        String string3 = this.fxfp.base.fxUtils.trimString(this.charArray, this.arrPos);
                        if (string3 != null && string3.length() > 0) {
                            this.specColor = string3;
                        }
                    } else if (this.colorParser != null) {
                        this.currPhongMat.setSpecularColor(this.colorParser.getColor());
                        this.colorParser = null;
                    } else if (this.colorRef != null) {
                        this.currPhongMat.setSpecularColor(this.colorRef);
                        this.colorRef = null;
                    }
                }
            } else if (string.equals("specularPower") && this.specPower == null) {
                String string4 = this.getCharOrPrimString();
                if (string4 != null) {
                    this.specPower = string4;
                }
            } else if (string.equals("PhongMaterial")) {
                if (this.diffColor != null) {
                    this.currPhongMat.setDiffuseColor(Color.valueOf((String)this.diffColor));
                }
                if (this.specColor != null) {
                    this.currPhongMat.setSpecularColor(Color.valueOf((String)this.specColor));
                }
                if (this.specPower != null) {
                    this.currPhongMat.setSpecularPower(Double.parseDouble(this.specPower));
                }
                if (this.ownerShape3D != null) {
                    this.ownerShape3D.setMaterial((Material)this.currPhongMat);
                    this.ownerShape3D = null;
                    this.currPhongMat = null;
                }
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
            }
        }
    }
}

