/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.NodeParser;
import com.interactivemesh.jfx.importer.fxml.PhongMaterialParser;
import com.interactivemesh.jfx.importer.fxml.TransformsParser;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Shape3D;

abstract class Shape3DParser
extends NodeParser {
    private static final String CULLFACE = "cullFace";
    private static final String DRAWMODE = "drawMode";
    private final MaterialParser materialParser;
    TransformsParser transformsParser = null;
    private String cullFace = null;
    private String drawMode = null;
    private PhongMaterial phongMaterial = null;
    boolean isMaterial = false;

    Shape3DParser(FxFileParser fxFileParser) {
        super(fxFileParser);
        this.materialParser = new MaterialParser(fxFileParser);
    }

    final void setupShape3D() {
        this.isMaterial = false;
        this.cullFace = null;
        this.drawMode = null;
        this.phongMaterial = null;
        super.setupNode();
    }

    @Override
    void close() {
        this.materialParser.close();
        super.close();
    }

    final void processShape3DAttributes(String string, String string2, int n) {
        if (string.equals(CULLFACE)) {
            this.cullFace = string2;
        } else if (string.equals(DRAWMODE)) {
            this.drawMode = string2;
        } else {
            super.processNodeAttributes(string, string2, n);
        }
    }

    final boolean processShape3DStartElement(String string) {
        if (string.equals(CULLFACE)) {
            this.isCharacter = true;
            return true;
        }
        if (string.equals(DRAWMODE)) {
            this.isCharacter = true;
            return true;
        }
        return super.processNodeStartElement(string);
    }

    final boolean processShape3DEndElement(String string, String string2) {
        if (string.equals(CULLFACE) && this.cullFace == null) {
            this.cullFace = string2;
            return true;
        }
        if (string.equals(DRAWMODE) && this.drawMode == null) {
            this.drawMode = string2;
            return true;
        }
        return super.processNodeEndElement(string, string2);
    }

    final void setShape3DProperties(Shape3D shape3D) {
        super.setNodeProperties((Node)shape3D);
        if (this.cullFace != null) {
            shape3D.setCullFace(CullFace.valueOf((String)this.cullFace.toUpperCase()));
        }
        if (this.drawMode != null) {
            shape3D.setDrawMode(DrawMode.valueOf((String)this.drawMode.toUpperCase()));
        }
        if (this.phongMaterial != null) {
            shape3D.setMaterial((Material)this.phongMaterial);
            this.phongMaterial = null;
        }
    }

    final void setMaterialParser(AbstractElementParser abstractElementParser, Shape3D shape3D) {
        this.materialParser.setup(abstractElementParser, shape3D);
        this.fxfp.setParser(this.materialParser);
    }

    private final class MaterialParser
    extends AbstractElementParser {
        private PhongMaterialParser phongMaterialParser;
        private AbstractElementParser parentParser;
        private Shape3D currShape3D;

        private MaterialParser(FxFileParser fxFileParser) {
            super(fxFileParser);
            this.phongMaterialParser = null;
            this.parentParser = null;
            this.currShape3D = null;
        }

        private void setup(AbstractElementParser abstractElementParser, Shape3D shape3D) {
            this.parentParser = abstractElementParser;
            this.currShape3D = shape3D;
        }

        @Override
        void close() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void startElement(String string) {
            if (string.equals("PhongMaterial")) {
                if (this.currShape3D != null) {
                    this.fxfp.setPhongMaterialParser(this, this.currShape3D);
                    return;
                } else {
                    this.phongMaterialParser = this.fxfp.setPhongMaterialParser(this, null);
                }
                return;
            } else if (string.equals("reference")) {
                if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("Shape3DParser : material reference element doesn't have prefix 'fx:' !");
                String string2 = this.fxfp.xR.getAttributeValue(null, "source");
                if (string2 == null || string2.length() <= 0) throw new ImportException("Shape3DParser : source attribute in material referernce element is null !");
                PhongMaterial phongMaterial = this.fxfp.currCache.getPhongMaterial(string2);
                if (phongMaterial == null) throw new ImportException("Shape3DParser : no material referernce found for source = >" + string2 + "< !");
                if (this.currShape3D != null) {
                    this.currShape3D.setMaterial((Material)phongMaterial);
                    return;
                } else {
                    Shape3DParser.this.phongMaterial = phongMaterial;
                }
                return;
            } else {
                this.fxfp.setNullParser(this, string);
            }
        }

        @Override
        void endElement(String string) {
            if (string.equals("material")) {
                if (this.currShape3D == null && this.phongMaterialParser != null) {
                    Shape3DParser.this.phongMaterial = this.phongMaterialParser.getPhongMaterial();
                    this.phongMaterialParser = null;
                }
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
                this.currShape3D = null;
            }
        }
    }
}

