/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.Point3DParser;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

final class TransformsParser
extends AbstractElementParser {
    private static final String AFFINE = "Affine";
    private static final String ROTATE = "Rotate";
    private static final String SCALE = "Scale";
    private static final String TRANSLATE = "Translate";
    private static final String PIVOTX = "pivotX";
    private static final String PIVOTY = "pivotY";
    private static final String PIVOTZ = "pivotZ";
    private final AffineParser affineParser;
    private final RotateParser rotateParser;
    private final ScaleParser scaleParser;
    private final TranslateParser translateParser;
    private final ArrayList<Transform> transformList = new ArrayList(5);
    private AbstractElementParser parentParser;
    private Node ownerNode = null;

    TransformsParser(FxFileParser fxFileParser) {
        super(fxFileParser);
        this.affineParser = new AffineParser(this);
        this.rotateParser = new RotateParser(this);
        this.scaleParser = new ScaleParser(this);
        this.translateParser = new TranslateParser(this);
    }

    ArrayList<Transform> getTransforms() {
        return this.transformList;
    }

    void clearTransforms() {
        this.transformList.clear();
        this.transformList.ensureCapacity(5);
    }

    void setup(AbstractElementParser abstractElementParser, Node node) {
        this.parentParser = abstractElementParser;
        this.ownerNode = node;
    }

    @Override
    void close() {
        this.affineParser.close();
        this.rotateParser.close();
        this.scaleParser.close();
        this.translateParser.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        if (string.equals(AFFINE)) {
            Affine affine = new Affine();
            this.transformList.add((Transform)affine);
            this.affineParser.setup(affine);
            this.fxfp.setParser(this.affineParser);
            return;
        } else if (string.equals(ROTATE)) {
            Rotate rotate = new Rotate();
            this.transformList.add((Transform)rotate);
            this.rotateParser.setup(rotate);
            this.fxfp.setParser(this.rotateParser);
            return;
        } else if (string.equals(SCALE)) {
            Scale scale = new Scale();
            this.transformList.add((Transform)scale);
            this.scaleParser.setup(scale);
            this.fxfp.setParser(this.scaleParser);
            return;
        } else if (string.equals(TRANSLATE)) {
            Translate translate = new Translate();
            this.transformList.add((Transform)translate);
            this.translateParser.setup(translate);
            this.fxfp.setParser(this.translateParser);
            return;
        } else if (string.equals("reference")) {
            if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("TransformParser : transform reference element doesn't have prefix 'fx:' !");
            String string2 = this.fxfp.xR.getAttributeValue(null, "source");
            if (string2 == null || string2.length() <= 0) throw new ImportException("TransformParser : source attribute of transform reference not found !");
            Transform transform = this.fxfp.currCache.getTransform(string2);
            if (transform == null) throw new ImportException("TransformParser : no transform referernce found for source = >" + string2 + "< !");
            this.transformList.add(transform);
            return;
        } else {
            this.fxfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("transforms")) {
            if (this.ownerNode != null && !this.transformList.isEmpty()) {
                this.ownerNode.getTransforms().addAll(this.transformList);
                this.ownerNode = null;
                this.clearTransforms();
            }
            this.fxfp.setParser(this.parentParser);
            this.parentParser = null;
        }
    }

    private static final class AffineParser
    extends AbstractElementParserChar {
        private final AbstractElementParser parentParser;
        private final String[] mStrgs = new String[12];
        private Affine currAffine = null;

        private AffineParser(AbstractElementParser abstractElementParser) {
            super(abstractElementParser.fxfp);
            this.parentParser = abstractElementParser;
            this.charArray = new char[200];
        }

        private void setup(Affine affine) {
            this.currAffine = affine;
            Arrays.fill(this.mStrgs, null);
            this.setupChar();
            int n = this.fxfp.xR.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = this.fxfp.xR.getAttributeValue(i);
                if (string != null && string.length() > 0) {
                    String string2 = this.fxfp.xR.getAttributeLocalName(i);
                    if (string2.equals("mxx")) {
                        this.mStrgs[0] = string;
                        continue;
                    }
                    if (string2.equals("mxy")) {
                        this.mStrgs[1] = string;
                        continue;
                    }
                    if (string2.equals("mxz")) {
                        this.mStrgs[2] = string;
                        continue;
                    }
                    if (string2.equals("tx")) {
                        this.mStrgs[3] = string;
                        continue;
                    }
                    if (string2.equals("myx")) {
                        this.mStrgs[4] = string;
                        continue;
                    }
                    if (string2.equals("myy")) {
                        this.mStrgs[5] = string;
                        continue;
                    }
                    if (string2.equals("myz")) {
                        this.mStrgs[6] = string;
                        continue;
                    }
                    if (string2.equals("ty")) {
                        this.mStrgs[7] = string;
                        continue;
                    }
                    if (string2.equals("mzx")) {
                        this.mStrgs[8] = string;
                        continue;
                    }
                    if (string2.equals("mzy")) {
                        this.mStrgs[9] = string;
                        continue;
                    }
                    if (string2.equals("mzz")) {
                        this.mStrgs[10] = string;
                        continue;
                    }
                    if (string2.equals("tz")) {
                        this.mStrgs[11] = string;
                        continue;
                    }
                    if (!string2.equals("id") || !this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
                    this.fxfp.currCache.putTransform(string, (Transform)this.currAffine);
                    continue;
                }
                throw new ImportException("AffineParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
            }
        }

        @Override
        void close() {
            this.charArray = null;
        }

        @Override
        void startElement(String string) {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (string.charAt(0) == 'm' || string.charAt(0) == 't') {
                this.isCharacter = true;
                this.arrPos = 0;
            } else if (this.processPrimitiveStartElement(string)) {
                this.isPrimitive = true;
            } else {
                this.fxfp.setNullParser(this, string);
            }
        }

        @Override
        void endElement(String string) {
            if (!string.equals(this.primTagName)) {
                if (this.isCharacter || this.isPrimitive) {
                    String string2 = this.getCharOrPrimString();
                    if (string2 != null) {
                        if (string.equals("mxx") && this.mStrgs[0] == null) {
                            this.mStrgs[0] = string2;
                        } else if (string.equals("mxy") && this.mStrgs[1] == null) {
                            this.mStrgs[1] = string2;
                        } else if (string.equals("mxz") && this.mStrgs[2] == null) {
                            this.mStrgs[2] = string2;
                        } else if (string.equals("tx") && this.mStrgs[3] == null) {
                            this.mStrgs[3] = string2;
                        } else if (string.equals("myx") && this.mStrgs[4] == null) {
                            this.mStrgs[4] = string2;
                        } else if (string.equals("myy") && this.mStrgs[5] == null) {
                            this.mStrgs[5] = string2;
                        } else if (string.equals("myz") && this.mStrgs[6] == null) {
                            this.mStrgs[6] = string2;
                        } else if (string.equals("ty") && this.mStrgs[7] == null) {
                            this.mStrgs[7] = string2;
                        } else if (string.equals("mzx") && this.mStrgs[8] == null) {
                            this.mStrgs[9] = string2;
                        } else if (string.equals("mzy") && this.mStrgs[9] == null) {
                            this.mStrgs[9] = string2;
                        } else if (string.equals("mzz") && this.mStrgs[10] == null) {
                            this.mStrgs[10] = string2;
                        } else if (string.equals("tz") && this.mStrgs[11] == null) {
                            this.mStrgs[11] = string2;
                        }
                    }
                } else if (string.equals(TransformsParser.AFFINE)) {
                    if (this.mStrgs[0] != null) {
                        this.currAffine.setMxx(Double.parseDouble(this.mStrgs[0]));
                    }
                    if (this.mStrgs[1] != null) {
                        this.currAffine.setMxy(Double.parseDouble(this.mStrgs[1]));
                    }
                    if (this.mStrgs[2] != null) {
                        this.currAffine.setMxz(Double.parseDouble(this.mStrgs[2]));
                    }
                    if (this.mStrgs[3] != null) {
                        this.currAffine.setTx(Double.parseDouble(this.mStrgs[3]));
                    }
                    if (this.mStrgs[4] != null) {
                        this.currAffine.setMyx(Double.parseDouble(this.mStrgs[4]));
                    }
                    if (this.mStrgs[5] != null) {
                        this.currAffine.setMyy(Double.parseDouble(this.mStrgs[5]));
                    }
                    if (this.mStrgs[6] != null) {
                        this.currAffine.setMyz(Double.parseDouble(this.mStrgs[6]));
                    }
                    if (this.mStrgs[7] != null) {
                        this.currAffine.setTy(Double.parseDouble(this.mStrgs[7]));
                    }
                    if (this.mStrgs[8] != null) {
                        this.currAffine.setMzx(Double.parseDouble(this.mStrgs[8]));
                    }
                    if (this.mStrgs[9] != null) {
                        this.currAffine.setMzy(Double.parseDouble(this.mStrgs[9]));
                    }
                    if (this.mStrgs[10] != null) {
                        this.currAffine.setMzz(Double.parseDouble(this.mStrgs[10]));
                    }
                    if (this.mStrgs[11] != null) {
                        this.currAffine.setTz(Double.parseDouble(this.mStrgs[11]));
                    }
                    this.fxfp.setParser(this.parentParser);
                    this.currAffine = null;
                }
            }
        }
    }

    private static final class RotateParser
    extends AbstractElementParserChar {
        private static final String ANGLE = "angle";
        private static final String AXIS = "axis";
        private Point3DParser point3DParser = null;
        private Point3D point3DRef = null;
        private final AbstractElementParser parentParser;
        private Rotate currRotate = null;
        private String angle = null;
        private String pivotX = null;
        private String pivotY = null;
        private String pivotZ = null;
        private boolean isAxis = false;

        private RotateParser(AbstractElementParser abstractElementParser) {
            super(abstractElementParser.fxfp);
            this.parentParser = abstractElementParser;
            this.charArray = new char[200];
        }

        private void setup(Rotate rotate) {
            this.currRotate = rotate;
            this.angle = null;
            this.pivotX = null;
            this.pivotY = null;
            this.pivotZ = null;
            this.setupChar();
            int n = this.fxfp.xR.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = this.fxfp.xR.getAttributeValue(i);
                if (string != null && string.length() > 0) {
                    String string2 = this.fxfp.xR.getAttributeLocalName(i);
                    if (string2.equals(ANGLE)) {
                        this.angle = string;
                        continue;
                    }
                    if (string2.equals(TransformsParser.PIVOTX)) {
                        this.pivotX = string;
                        continue;
                    }
                    if (string2.equals(TransformsParser.PIVOTY)) {
                        this.pivotY = string;
                        continue;
                    }
                    if (string2.equals(TransformsParser.PIVOTZ)) {
                        this.pivotZ = string;
                        continue;
                    }
                    if (!string2.equals("id") || !this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
                    this.fxfp.currCache.putTransform(string, (Transform)this.currRotate);
                    continue;
                }
                throw new ImportException("RotateParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
            }
        }

        @Override
        void close() {
            this.charArray = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void startElement(String string) {
            if (this.isAxis) {
                this.isAxis = false;
                if (string.equals("Point3D")) {
                    this.point3DParser = this.fxfp.setPoint3DParser(this);
                } else if (string.equals("reference")) {
                    if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("RotateParser : axis reference element doesn't have prefix 'fx:' !");
                    String string2 = this.fxfp.xR.getAttributeValue(null, "source");
                    if (string2 == null) throw new ImportException("RotateParser : source attribute in Point3D referernce element is null !");
                    this.point3DRef = this.fxfp.currCache.getPoint3D(string2);
                    if (this.point3DRef == null) {
                        throw new ImportException("RotateParser : no Point3D referernce found for source = >" + string2 + "< !");
                    }
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            } else {
                this.isCharacter = false;
                this.isPrimitive = false;
                if (string.equals(AXIS)) {
                    this.isAxis = true;
                } else if (string.equals(ANGLE)) {
                    this.isCharacter = true;
                } else if (string.equals(TransformsParser.PIVOTX)) {
                    this.isCharacter = true;
                } else if (string.equals(TransformsParser.PIVOTY)) {
                    this.isCharacter = true;
                } else if (string.equals(TransformsParser.PIVOTZ)) {
                    this.isCharacter = true;
                } else if (this.processPrimitiveStartElement(string)) {
                    this.isPrimitive = true;
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            }
            if (!this.isCharacter) return;
            this.arrPos = 0;
        }

        @Override
        void endElement(String string) {
            if (string.equals(AXIS)) {
                this.isAxis = false;
                if (this.point3DParser != null) {
                    this.currRotate.setAxis(this.point3DParser.getPoint3D());
                    this.point3DParser = null;
                } else if (this.point3DRef != null) {
                    this.currRotate.setAxis(this.point3DRef);
                    this.point3DRef = null;
                }
            } else if (!string.equals(this.primTagName)) {
                if (this.isCharacter || this.isPrimitive) {
                    String string2 = this.getCharOrPrimString();
                    if (string2 != null) {
                        if (string.equals(ANGLE) && this.angle == null) {
                            this.angle = string2;
                        } else if (string.equals(TransformsParser.PIVOTX) && this.pivotX == null) {
                            this.pivotX = string2;
                        } else if (string.equals(TransformsParser.PIVOTY) && this.pivotY == null) {
                            this.pivotY = string2;
                        } else if (string.equals(TransformsParser.PIVOTZ) && this.pivotZ == null) {
                            this.pivotZ = string2;
                        }
                    }
                } else if (string.equals(TransformsParser.ROTATE)) {
                    if (this.angle != null) {
                        this.currRotate.setAngle(Double.parseDouble(this.angle));
                    }
                    if (this.pivotX != null) {
                        this.currRotate.setPivotX(Double.parseDouble(this.pivotX));
                    }
                    if (this.pivotY != null) {
                        this.currRotate.setPivotY(Double.parseDouble(this.pivotY));
                    }
                    if (this.pivotZ != null) {
                        this.currRotate.setPivotZ(Double.parseDouble(this.pivotZ));
                    }
                    this.fxfp.setParser(this.parentParser);
                    this.currRotate = null;
                }
            }
        }
    }

    private static final class ScaleParser
    extends AbstractElementParserChar {
        private final AbstractElementParser parentParser;
        private Scale currScale = null;
        private String scaleX = null;
        private String scaleY = null;
        private String scaleZ = null;
        private String pivotX = null;
        private String pivotY = null;
        private String pivotZ = null;

        private ScaleParser(AbstractElementParser abstractElementParser) {
            super(abstractElementParser.fxfp);
            this.parentParser = abstractElementParser;
            this.charArray = new char[200];
        }

        private void setup(Scale scale) {
            this.currScale = scale;
            this.scaleX = null;
            this.scaleY = null;
            this.scaleZ = null;
            this.pivotX = null;
            this.pivotY = null;
            this.pivotZ = null;
            this.setupChar();
            int n = this.fxfp.xR.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = this.fxfp.xR.getAttributeValue(i);
                if (string != null && string.length() > 0) {
                    String string2 = this.fxfp.xR.getAttributeLocalName(i);
                    if (string2.equals("x")) {
                        this.scaleX = string;
                        continue;
                    }
                    if (string2.equals("y")) {
                        this.scaleY = string;
                        continue;
                    }
                    if (string2.equals("z")) {
                        this.scaleZ = string;
                        continue;
                    }
                    if (string2.equals(TransformsParser.PIVOTX)) {
                        this.pivotX = string;
                        continue;
                    }
                    if (string2.equals(TransformsParser.PIVOTY)) {
                        this.pivotY = string;
                        continue;
                    }
                    if (string2.equals(TransformsParser.PIVOTZ)) {
                        this.pivotZ = string;
                        continue;
                    }
                    if (!string2.equals("id") || !this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
                    this.fxfp.currCache.putTransform(string, (Transform)this.currScale);
                    continue;
                }
                throw new ImportException("ScaleParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
            }
        }

        @Override
        void close() {
            this.charArray = null;
        }

        @Override
        void startElement(String string) {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (string.equals("x")) {
                this.isCharacter = true;
            } else if (string.equals("y")) {
                this.isCharacter = true;
            } else if (string.equals("z")) {
                this.isCharacter = true;
            } else if (string.equals(TransformsParser.PIVOTX)) {
                this.isCharacter = true;
            } else if (string.equals(TransformsParser.PIVOTY)) {
                this.isCharacter = true;
            } else if (string.equals(TransformsParser.PIVOTZ)) {
                this.isCharacter = true;
            } else if (this.processPrimitiveStartElement(string)) {
                this.isPrimitive = true;
            } else {
                this.fxfp.setNullParser(this, string);
            }
            if (this.isCharacter) {
                this.arrPos = 0;
            }
        }

        @Override
        void endElement(String string) {
            if (!string.equals(this.primTagName)) {
                if (this.isCharacter || this.isPrimitive) {
                    String string2 = this.getCharOrPrimString();
                    if (string2 != null) {
                        if (string.equals("x") && this.scaleX == null) {
                            this.scaleX = string2;
                        } else if (string.equals("y") && this.scaleY == null) {
                            this.scaleY = string2;
                        } else if (string.equals("z") && this.scaleZ == null) {
                            this.scaleZ = string2;
                        } else if (string.equals(TransformsParser.PIVOTX) && this.pivotX == null) {
                            this.pivotX = string2;
                        } else if (string.equals(TransformsParser.PIVOTY) && this.pivotY == null) {
                            this.pivotY = string2;
                        } else if (string.equals(TransformsParser.PIVOTZ) && this.pivotZ == null) {
                            this.pivotZ = string2;
                        }
                    }
                } else if (string.equals(TransformsParser.SCALE)) {
                    if (this.scaleX != null) {
                        this.currScale.setX(Double.parseDouble(this.scaleX));
                    }
                    if (this.scaleY != null) {
                        this.currScale.setY(Double.parseDouble(this.scaleY));
                    }
                    if (this.scaleZ != null) {
                        this.currScale.setZ(Double.parseDouble(this.scaleZ));
                    }
                    if (this.pivotX != null) {
                        this.currScale.setPivotX(Double.parseDouble(this.pivotX));
                    }
                    if (this.pivotY != null) {
                        this.currScale.setPivotY(Double.parseDouble(this.pivotY));
                    }
                    if (this.pivotZ != null) {
                        this.currScale.setPivotZ(Double.parseDouble(this.pivotZ));
                    }
                    this.fxfp.setParser(this.parentParser);
                    this.currScale = null;
                }
            }
        }
    }

    private static final class TranslateParser
    extends AbstractElementParserChar {
        private final AbstractElementParser parentParser;
        private Translate currTranslate = null;
        private String transX = null;
        private String transY = null;
        private String transZ = null;

        private TranslateParser(AbstractElementParser abstractElementParser) {
            super(abstractElementParser.fxfp);
            this.parentParser = abstractElementParser;
            this.charArray = new char[200];
        }

        private void setup(Translate translate) {
            this.currTranslate = translate;
            this.transX = null;
            this.transY = null;
            this.transZ = null;
            this.setupChar();
            int n = this.fxfp.xR.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string = this.fxfp.xR.getAttributeValue(i);
                if (string != null && string.length() > 0) {
                    String string2 = this.fxfp.xR.getAttributeLocalName(i);
                    if (string2.equals("x")) {
                        this.transX = string;
                        continue;
                    }
                    if (string2.equals("y")) {
                        this.transY = string;
                        continue;
                    }
                    if (string2.equals("z")) {
                        this.transZ = string;
                        continue;
                    }
                    if (!string2.equals("id") || !this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
                    this.fxfp.currCache.putTransform(string, (Transform)this.currTranslate);
                    continue;
                }
                throw new ImportException("TranslateParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
            }
        }

        @Override
        void close() {
            this.charArray = null;
        }

        @Override
        void startElement(String string) {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (string.equals("x")) {
                this.isCharacter = true;
            } else if (string.equals("y")) {
                this.isCharacter = true;
            } else if (string.equals("z")) {
                this.isCharacter = true;
            } else if (this.processPrimitiveStartElement(string)) {
                this.isPrimitive = true;
            } else {
                this.fxfp.setNullParser(this, string);
            }
            if (this.isCharacter) {
                this.arrPos = 0;
            }
        }

        @Override
        void endElement(String string) {
            if (!string.equals(this.primTagName)) {
                if (this.isCharacter || this.isPrimitive) {
                    String string2 = this.getCharOrPrimString();
                    if (string2 != null) {
                        if (string.equals("x") && this.transX == null) {
                            this.transX = string2;
                        } else if (string.equals("y") && this.transY == null) {
                            this.transY = string2;
                        } else if (string.equals("z") && this.transZ == null) {
                            this.transZ = string2;
                        }
                    }
                } else if (string.equals(TransformsParser.TRANSLATE)) {
                    if (this.transX != null) {
                        this.currTranslate.setX(Double.parseDouble(this.transX));
                    }
                    if (this.transY != null) {
                        this.currTranslate.setY(Double.parseDouble(this.transY));
                    }
                    if (this.transZ != null) {
                        this.currTranslate.setZ(Double.parseDouble(this.transZ));
                    }
                    this.fxfp.setParser(this.parentParser);
                    this.currTranslate = null;
                }
            }
        }
    }
}

