/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import com.interactivemesh.jfx.importer.x3d.GeometryNode;
import com.interactivemesh.jfx.importer.x3d.XIndexer;
import com.interactivemesh.jfx.importer.x3d.XMeshSmoother;
import java.util.ArrayList;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.TriangleMesh;

final class TriaQuadSetNode
extends GeometryNode {
    boolean isIndexed = false;
    boolean isQuad = false;
    boolean isTria = false;
    boolean isFan = false;
    boolean isStrip = false;
    String index = null;
    String fanStripCount = null;

    TriaQuadSetNode(ElementBase elementBase, ElementCache elementCache) {
        super(elementBase, elementCache);
    }

    @Override
    void clear() {
        this.index = null;
        this.fanStripCount = null;
        super.clear();
    }

    @Override
    Mesh getMesh() {
        int n;
        Object object;
        Object object2;
        int n2;
        if (this.sharedMesh != null && this.use != null) {
            return this.sharedMesh;
        }
        int n3 = 0;
        boolean bl = this.base.isGenerateNormals;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float[] fArray = null;
        float[] fArray2 = null;
        float[] fArray3 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        XIndexer xIndexer = this.base.indexer;
        if (!bl) {
            if (this.useNormal != null) {
                fArray2 = this.cache.getGeomArray(this.useNormal);
                if (fArray2 == null) {
                    System.out.println("TriaQuadSetNode cached normals are null !");
                }
            } else if (this.normal != null) {
                n2 = this.base.xUtils.splitFloats(this.normal);
                fArray2 = new float[n2];
                System.arraycopy(this.base.xUtils.getFloatValues(), 0, fArray2, 0, n2);
                if (this.normalUsed != null) {
                    this.cache.putGeomArray(this.normalUsed, fArray2);
                }
            } else {
                bl2 = true;
            }
        }
        if (this.useCoordinate != null) {
            fArray = this.cache.getGeomArray(this.useCoordinate);
            if (fArray == null) {
                System.out.println("TriaQuadSetNode cached coords are null !");
            }
        } else if (this.coordinate != null) {
            n2 = this.base.xUtils.splitFloatsCoordFlippedYZ(this.coordinate);
            fArray = new float[n2];
            System.arraycopy(this.base.xUtils.getFloatValues(), 0, fArray, 0, n2);
            if (this.coordUsed != null) {
                this.cache.putGeomArray(this.coordUsed, fArray);
            }
        } else if (this.useCoordinateD != null) {
            fArray = this.cache.getGeomArray(this.useCoordinateD);
            if (fArray == null) {
                System.out.println("TriaQuadSetNode cached coordsD are null !");
            }
        } else if (this.coordinateD != null) {
            n2 = this.base.xUtils.splitDoublesCoordFlippedYZ(this.coordinateD);
            fArray = new float[n2];
            System.arraycopy(this.base.xUtils.getFloatValues(), 0, fArray, 0, n2);
            if (this.coordUsed != null) {
                this.cache.putGeomArray(this.coordUsed, fArray);
            }
        } else {
            throw new ImportException("TriaQuadSetNode getMesh : no coordinates!");
        }
        if (this.useTexCoordinate != null) {
            fArray3 = this.cache.getGeomArray(this.useTexCoordinate);
            if (fArray3 == null) {
                System.out.println("TriaQuadSetNode cached texCoords are null !");
            }
        } else if (this.texCoordinate != null) {
            n2 = this.base.xUtils.splitFloatsTexCoord2DFlippedY(this.texCoordinate);
            fArray3 = new float[n2];
            System.arraycopy(this.base.xUtils.getFloatValues(), 0, fArray3, 0, n2);
            if (this.texCoordUsed != null) {
                this.cache.putGeomArray(this.texCoordUsed, fArray3);
            }
        } else {
            bl4 = true;
            fArray3 = new float[]{0.0f, 0.0f};
            if (this.isImageTexture) {
                System.out.println("TriaQuadSetNode : texture image exists but no texture coordinates found! TextureCoordinateGenerator not yet supported");
            }
        }
        if (this.isIndexed) {
            int n4;
            int n5;
            int[] nArray4 = null;
            if (this.isStrip || this.isFan) {
                int[] nArray5 = this.base.xUtils.splitPosIntegersSep(this.index);
                n5 = nArray5[0];
                n4 = nArray5[1];
                object2 = this.base.xUtils.getPolygonLengths();
                int n6 = (n5 - n4 * 2) * 3;
                if (this.isStrip) {
                    object = this.unStrippedTriangleIndices(n6, (int[])object2, n4, this.base.xUtils.getIntValues());
                    ArrayList<Integer> arrayList = this.getFlatTriangles((int[])object, fArray);
                    nArray4 = this.dropFlatTriangles((int[])object, arrayList);
                } else if (this.isFan) {
                    nArray4 = this.unFanedTriangleIndices(n6, (int[])object2, n4, this.base.xUtils.getIntValues());
                }
            } else {
                int n7 = this.base.xUtils.splitPosIntegers(this.index);
                if (this.isTria) {
                    nArray4 = new int[n7];
                    System.arraycopy(this.base.xUtils.getIntValues(), 0, nArray4, 0, n7);
                } else if (this.isQuad) {
                    n5 = n7 / 4;
                    nArray4 = new int[n5 * 2 * 3];
                    n4 = 0;
                    int n8 = 0;
                    int[] nArray6 = this.base.xUtils.getIntValues();
                    for (int i = 0; i < n5; ++i) {
                        int n9 = nArray6[n8++];
                        nArray4[n4++] = n9;
                        nArray4[n4++] = nArray6[n8++];
                        nArray4[n4++] = nArray6[n8];
                        nArray4[n4++] = n9;
                        nArray4[n4++] = nArray6[n8++];
                        nArray4[n4++] = nArray6[n8++];
                    }
                } else {
                    throw new ImportException("TriaQuadSetNode getMesh : neihter triangle nor quad!");
                }
            }
            int n10 = nArray4.length;
            n3 = n10 / 3;
            if (bl2) {
                fArray2 = this.base.normalizer.calculateVertexIndexedTriaNormals(fArray, fArray.length, nArray4);
            }
            nArray = (int[])nArray4.clone();
            fArray = xIndexer.createRFTriplesAndInds(fArray, fArray.length, nArray);
            if (bl) {
                int[] nArray7 = new int[fArray.length / 3];
                float[] fArray4 = this.base.normalizer.calcTriangleNormals(fArray, nArray, nArray7);
                object2 = this.base.normalizer.vertexIndices(nArray, nArray7);
                nArray2 = new int[n10];
                fArray2 = this.base.normalizer.calcIndexedVertexNormals(this.base.creaseAngle, true, fArray4, nArray, (int[][])object2, nArray2);
            } else {
                nArray2 = (int[])nArray4.clone();
                fArray2 = xIndexer.createRFTriplesAndInds(fArray2, fArray2.length, nArray2);
            }
            if (!bl4 && fArray3 != null) {
                nArray3 = (int[])nArray4.clone();
                fArray3 = xIndexer.createRFTuplesAndInds(fArray3, fArray3.length, nArray3);
            }
        } else if (this.isStrip || this.isFan) {
            n2 = this.base.xUtils.splitPosIntegers(this.fanStripCount);
            int[] nArray8 = this.base.xUtils.getIntValues();
            xIndexer.createRFTriplesAndInds(fArray);
            fArray = xIndexer.getRFValues();
            nArray = xIndexer.getRFIndices();
            int n11 = (nArray.length - n2 * 2) * 3;
            ArrayList<Integer> arrayList = null;
            if (this.isStrip) {
                nArray = this.unStrippedTriangleIndices(n11, nArray8, n2, nArray);
                arrayList = this.getFlatTriangles(nArray, fArray);
                nArray = this.dropFlatTriangles(nArray, arrayList);
            } else if (this.isFan) {
                nArray = this.unFanedTriangleIndices(n11, nArray8, n2, nArray);
            }
            if (!bl2 || this.isStrip || this.isFan) {
                // empty if block
            }
            if (bl || bl2) {
                object2 = new int[fArray.length / 3];
                float[] fArray5 = this.base.normalizer.calcTriangleNormals(fArray, nArray, (int[])object2);
                object = this.base.normalizer.vertexIndices(nArray, (int[])object2);
                nArray2 = new int[nArray.length];
                fArray2 = this.base.normalizer.calcIndexedVertexNormals(this.base.creaseAngle, true, fArray5, nArray, (int[][])object, nArray2);
            } else if (fArray2 != null) {
                xIndexer.createRFTriplesAndInds(fArray2);
                fArray2 = xIndexer.getRFValues();
                nArray2 = xIndexer.getRFIndices();
                if (this.isStrip) {
                    nArray2 = this.unStrippedTriangleIndices(n11, nArray8, n2, nArray2);
                    nArray2 = this.dropFlatTriangles(nArray2, arrayList);
                } else if (this.isFan) {
                    nArray2 = this.unFanedTriangleIndices(n11, nArray8, n2, nArray2);
                }
            } else {
                throw new ImportException("TriaQuadSetNode getMesh non-indexed fan/strip : no normals!");
            }
            if (!bl4 && fArray3 != null) {
                xIndexer.createRFTuplesAndInds(fArray3);
                fArray3 = xIndexer.getRFValues();
                nArray3 = xIndexer.getRFIndices();
                if (this.isStrip) {
                    nArray3 = this.unStrippedTriangleIndices(n11, nArray8, n2, nArray3);
                    nArray3 = this.dropFlatTriangles(nArray3, arrayList);
                } else if (this.isFan) {
                    nArray3 = this.unFanedTriangleIndices(n11, nArray8, n2, nArray3);
                }
            }
            xIndexer.clear();
            n3 = nArray.length / 3;
        } else if (this.isTria || this.isQuad) {
            if (this.isQuad) {
                fArray = this.unQuadTriples(fArray);
            }
            xIndexer.createRFTriplesAndInds(fArray);
            fArray = xIndexer.getRFValues();
            nArray = xIndexer.getRFIndices();
            if (bl2) {
                bl3 = true;
            } else if (bl) {
                int[] nArray9 = new int[fArray.length / 3];
                float[] fArray6 = this.base.normalizer.calcTriangleNormals(fArray, nArray, nArray9);
                int[][] nArray10 = this.base.normalizer.vertexIndices(nArray, nArray9);
                nArray2 = new int[nArray.length];
                fArray2 = this.base.normalizer.calcIndexedVertexNormals(this.base.creaseAngle, true, fArray6, nArray, nArray10, nArray2);
            } else if (fArray2 != null) {
                if (this.isQuad) {
                    fArray2 = this.unQuadTriples(fArray2);
                }
                xIndexer.createRFTriplesAndInds(fArray2);
                fArray2 = xIndexer.getRFValues();
                nArray2 = xIndexer.getRFIndices();
            } else {
                throw new ImportException("TriaQuadSetNode getMesh non-indexed : no normals!");
            }
            if (!bl4 && fArray3 != null) {
                if (this.isQuad) {
                    fArray3 = this.unQuadTuples(fArray3);
                }
                xIndexer.createRFTuplesAndInds(fArray3);
                fArray3 = xIndexer.getRFValues();
                nArray3 = xIndexer.getRFIndices();
            }
            xIndexer.clear();
            n3 = nArray.length / 3;
        } else {
            throw new ImportException("TriaQuadSetNode getMesh : neihter triangle nor quad!");
        }
        TriangleMesh triangleMesh = new TriangleMesh();
        triangleMesh.getPoints().setAll(fArray);
        triangleMesh.getTexCoords().setAll(fArray3);
        if (this.base.isReverse) {
            this.reverseIndices(nArray);
            if (!bl4) {
                this.reverseIndices(nArray3);
            }
        }
        int[] nArray11 = new int[n3 * 3 * 2];
        int n12 = 0;
        int n13 = 0;
        if (bl4) {
            for (n = 0; n < n3; ++n) {
                nArray11[n12++] = nArray[n13++];
                nArray11[n12++] = 0;
                nArray11[n12++] = nArray[n13++];
                nArray11[n12++] = 0;
                nArray11[n12++] = nArray[n13++];
                nArray11[n12++] = 0;
            }
        } else {
            for (n = 0; n < n3; ++n) {
                nArray11[n12++] = nArray[n13];
                nArray11[n12++] = nArray3[n13++];
                nArray11[n12++] = nArray[n13];
                nArray11[n12++] = nArray3[n13++];
                nArray11[n12++] = nArray[n13];
                nArray11[n12++] = nArray3[n13++];
            }
        }
        triangleMesh.getFaces().addAll(nArray11);
        int[] nArray12 = new int[n3];
        if (!bl3) {
            ArrayList<XMeshSmoother.SmoothMesh> arrayList = this.base.smoother.create(nArray, fArray.length / 3, nArray2);
            object = null;
            int n14 = 0;
            for (XMeshSmoother.SmoothMesh smoothMesh : arrayList) {
                object = smoothMesh.getIndices();
                n14 = smoothMesh.getSmGrId();
                int n15 = ((ArrayList)object).size();
                for (int i = 0; i < n15; i += 3) {
                    nArray12[((Integer)((ArrayList)object).get((int)i)).intValue() / 3] = n14;
                }
                smoothMesh.close();
            }
            arrayList.clear();
        }
        triangleMesh.getFaceSmoothingGroups().setAll(nArray12);
        if (this.use != null) {
            this.sharedMesh = triangleMesh;
        }
        return triangleMesh;
    }

    private int[] unFanedTriangleIndices(int n, int[] nArray, int n2, int[] nArray2) {
        int[] nArray3 = new int[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            n5 = nArray2[n3++];
            int n6 = nArray[i] - 2;
            for (int j = 0; j < n6; ++j) {
                nArray3[n4++] = n5;
                nArray3[n4++] = nArray2[n3];
                nArray3[n4++] = nArray2[++n3];
            }
            ++n3;
        }
        return nArray3;
    }

    private int[] unStrippedTriangleIndices(int n, int[] nArray, int n2, int[] nArray2) {
        int[] nArray3 = new int[n];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = nArray[i] - 2;
            for (int j = 0; j < n5; ++j) {
                if (j % 2 == 0) {
                    nArray3[n4++] = nArray2[n3];
                    nArray3[n4++] = nArray2[n3 + 1];
                    nArray3[n4++] = nArray2[n3 + 2];
                } else {
                    nArray3[n4++] = nArray2[n3];
                    nArray3[n4++] = nArray2[n3 + 2];
                    nArray3[n4++] = nArray2[n3 + 1];
                }
                ++n3;
            }
            n3 += 2;
        }
        return nArray3;
    }

    private ArrayList<Integer> getFlatTriangles(int[] nArray, float[] fArray) {
        int n = nArray.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n / 10);
        for (int i = 0; i < n; i += 3) {
            int n2 = nArray[i] * 3;
            int n3 = nArray[i + 1] * 3;
            int n4 = nArray[i + 2] * 3;
            if (fArray[n2 + 0] == fArray[n3 + 0] && fArray[n2 + 1] == fArray[n3 + 1] && fArray[n2 + 2] == fArray[n3 + 2]) {
                arrayList.add(i);
                continue;
            }
            if (fArray[n2 + 0] == fArray[n4 + 0] && fArray[n2 + 1] == fArray[n4 + 1] && fArray[n2 + 2] == fArray[n4 + 2]) {
                arrayList.add(i);
                continue;
            }
            if (fArray[n3 + 0] != fArray[n4 + 0] || fArray[n3 + 1] != fArray[n4 + 1] || fArray[n3 + 2] != fArray[n4 + 2]) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private int[] dropFlatTriangles(int[] nArray, ArrayList<Integer> arrayList) {
        int n = nArray.length;
        if (arrayList.size() > 0) {
            int n2;
            int n3 = arrayList.size();
            int n4 = n - n3 * 3;
            int[] nArray2 = new int[n4];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n6 = arrayList.get(n2);
                for (int i = n5; i < n6; ++i) {
                    nArray2[n7] = nArray[i];
                    ++n7;
                }
                n5 = n6 + 3;
            }
            for (n2 = n5; n2 < n; ++n2) {
                nArray2[n7] = nArray[n2];
                ++n7;
            }
            return nArray2;
        }
        return nArray;
    }

    private float[] unQuadTriples(float[] fArray) {
        int n = fArray.length / 12;
        float[] fArray2 = new float[n * 2 * 3 * 3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = n3;
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            n5 = n3;
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n4++];
            fArray2[n2++] = fArray[n4++];
            fArray2[n2++] = fArray[n4];
            fArray2[n2++] = fArray[n5++];
            fArray2[n2++] = fArray[n5++];
            fArray2[n2++] = fArray[n5];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
        }
        return fArray2;
    }

    private float[] unQuadTuples(float[] fArray) {
        int n = fArray.length / 8;
        float[] fArray2 = new float[n * 2 * 3 * 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = n3;
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            n5 = n3;
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n4++];
            fArray2[n2++] = fArray[n4];
            fArray2[n2++] = fArray[n5++];
            fArray2[n2++] = fArray[n5];
            fArray2[n2++] = fArray[n3++];
            fArray2[n2++] = fArray[n3++];
        }
        return fArray2;
    }
}

