/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.AbstractMetaData;
import com.interactivemesh.jfx.importer.x3d.AppearanceNode;
import com.interactivemesh.jfx.importer.x3d.AppearanceParser;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import com.interactivemesh.jfx.importer.x3d.GeometryNode;
import com.interactivemesh.jfx.importer.x3d.GeometryNodeParser;
import com.interactivemesh.jfx.importer.x3d.LightNode;
import com.interactivemesh.jfx.importer.x3d.LightParser;
import com.interactivemesh.jfx.importer.x3d.MetadataParser;
import com.interactivemesh.jfx.importer.x3d.NullParser;
import com.interactivemesh.jfx.importer.x3d.ShapeNode;
import com.interactivemesh.jfx.importer.x3d.ShapeNodeParser;
import com.interactivemesh.jfx.importer.x3d.ViewpointNode;
import com.interactivemesh.jfx.importer.x3d.ViewpointParser;
import com.interactivemesh.jfx.importer.x3d.X3D;
import com.interactivemesh.jfx.importer.x3d.X3DParser;
import com.interactivemesh.jfx.importer.x3d.XImporterImpl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class XFileParser {
    XMLStreamReader xR = null;
    final ElementBase base;
    private AbstractElementParser currElementParser = null;
    private final X3DParser x3dParser;
    private final AppearanceParser appearParser;
    private final GeometryNodeParser geomParser;
    private final LightParser lightParser;
    private final MetadataParser metaParser;
    private final NullParser nullParser;
    private final ShapeNodeParser shapeParser;
    private final ViewpointParser vpParser;
    private final XMLInputFactory xmlif;
    final XImporterImpl importerImpl;

    XFileParser(XImporterImpl xImporterImpl, XMLInputFactory xMLInputFactory, ElementBase elementBase) {
        this.importerImpl = xImporterImpl;
        this.xmlif = xMLInputFactory;
        this.base = elementBase;
        this.x3dParser = new X3DParser(this);
        this.appearParser = new AppearanceParser(this);
        this.geomParser = new GeometryNodeParser(this);
        this.lightParser = new LightParser(this);
        this.metaParser = new MetadataParser(this);
        this.nullParser = new NullParser(this);
        this.shapeParser = new ShapeNodeParser(this);
        this.vpParser = new ViewpointParser(this);
    }

    void clear() {
        this.xR = null;
    }

    void close() {
        this.clear();
        this.x3dParser.close();
        this.appearParser.close();
        this.geomParser.close();
        this.lightParser.close();
        this.metaParser.close();
        this.nullParser.close();
        this.shapeParser.close();
        this.vpParser.close();
    }

    X3D parse(InputStream inputStream, ElementCache elementCache) {
        Object object;
        this.clear();
        boolean bl = false;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        boolean bl2 = false;
        try {
            object = new byte[10];
            inputStream.mark(((byte[])object).length);
            inputStream.read((byte[])object, 0, ((byte[])object).length);
            inputStream.reset();
            if (object[0] == 31 && object[1] == -117 && object[2] == 8) {
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            throw new ImportException("XFileParser : check for GZip failed. " + iOException.getMessage(), iOException);
        }
        if (bl2) {
            try {
                inputStream = new GZIPInputStream(inputStream, 4096);
            }
            catch (ZipException zipException) {
                try {
                    inputStream.reset();
                    System.out.println("XFileParser parse : no gzip, stream reseted.");
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                throw new ImportException("XFileParser GZIPInputStream failed. " + iOException.getMessage(), iOException);
            }
        }
        object = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        try {
            this.xR = this.xmlif.createXMLStreamReader((Reader)object);
            X3D x3D = new X3D(this.base, elementCache);
            this.x3dParser.setup(x3D);
            this.currElementParser = this.x3dParser;
            int n = -1;
            while (this.xR.hasNext()) {
                n = this.xR.next();
                if (n == 1) {
                    this.currElementParser.startElement(this.xR.getLocalName());
                    continue;
                }
                if (n == 2) {
                    this.currElementParser.endElement(this.xR.getLocalName());
                    continue;
                }
                if (n != 8) continue;
                this.xR.close();
            }
            ((InputStreamReader)object).close();
            bl = true;
            X3D x3D2 = x3D;
            return x3D2;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ImportException("Reading X3D file failed.", xMLStreamException);
        }
        catch (ImportException importException) {
            throw importException;
        }
        catch (Exception exception) {
            throw new ImportException("Reading X3D file failed : \n" + exception.getMessage(), exception);
        }
        finally {
            if (!bl) {
                try {
                    this.xR.close();
                    ((InputStreamReader)object).close();
                }
                catch (Exception exception) {
                    throw new ImportException("Can't close X3D reader : \n" + exception.getMessage(), exception);
                }
            }
        }
    }

    void setParser(AbstractElementParser abstractElementParser) {
        this.currElementParser = abstractElementParser;
    }

    void setAppearParser(AppearanceNode appearanceNode, AbstractElementParser abstractElementParser) {
        this.appearParser.setup(appearanceNode, abstractElementParser);
        this.currElementParser = this.appearParser;
    }

    void setGeomParser(GeometryNode geometryNode, AbstractElementParser abstractElementParser, String string) {
        this.geomParser.setup(geometryNode, abstractElementParser, string);
        this.currElementParser = this.geomParser;
    }

    void setLightParser(LightNode lightNode, AbstractElementParser abstractElementParser, String string) {
        this.lightParser.setup(lightNode, abstractElementParser, string);
        this.currElementParser = this.lightParser;
    }

    AbstractMetaData setMetaParser(AbstractElementParser abstractElementParser, String string, String string2, String string3, ElementCache elementCache) {
        AbstractMetaData abstractMetaData = this.metaParser.setupForTopMetadata(abstractElementParser, string, string2, string3, this.base, elementCache);
        this.currElementParser = this.metaParser;
        return abstractMetaData;
    }

    void setNullParser(AbstractElementParser abstractElementParser, String string) {
        this.nullParser.setup(abstractElementParser, string);
        this.currElementParser = this.nullParser;
    }

    void setShapeParser(ShapeNode shapeNode, AbstractElementParser abstractElementParser) {
        this.shapeParser.setup(shapeNode, abstractElementParser);
        this.currElementParser = this.shapeParser;
    }

    void setViewpointParser(ViewpointNode viewpointNode, AbstractElementParser abstractElementParser, String string) {
        this.vpParser.setup(viewpointNode, abstractElementParser, string);
        this.currElementParser = this.vpParser;
    }
}

