/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.x3d.XNormalizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class XIndexer {
    private int[] rfIndices = null;
    private float[] rfValues = null;
    private int[] vertsDone = null;

    XIndexer() {
    }

    void clear() {
        this.rfIndices = null;
        this.rfValues = null;
    }

    void close() {
        this.vertsDone = null;
    }

    int[] getRFIndices() {
        return this.rfIndices;
    }

    float[] getRFValues() {
        return this.rfValues;
    }

    void createRFTuplesAndInds(float[] fArray) {
        XNormalizer.Tuplef tuplef;
        int n = fArray.length / 2;
        this.rfIndices = new int[n];
        int n2 = 0;
        HashMap<XNormalizer.Tuplef, Integer> hashMap = new HashMap<XNormalizer.Tuplef, Integer>(n);
        for (int i = 0; i < n; ++i) {
            tuplef = new XNormalizer.Tuplef(fArray[i * 2], fArray[i * 2 + 1]);
            Integer n3 = (Integer)hashMap.get(tuplef);
            if (n3 == null) {
                this.rfIndices[i] = n2;
                hashMap.put(tuplef, n2);
                ++n2;
                continue;
            }
            this.rfIndices[i] = n3;
        }
        this.rfValues = new float[hashMap.size() * 2];
        Set set = hashMap.entrySet();
        for (Map.Entry entry : set) {
            n2 = (Integer)entry.getValue() * 2;
            tuplef = (XNormalizer.Tuplef)entry.getKey();
            this.rfValues[n2] = tuplef.x;
            this.rfValues[n2 + 1] = tuplef.y;
        }
    }

    void createRFTriplesAndInds(float[] fArray) {
        XNormalizer.Triplef triplef;
        int n = fArray.length / 3;
        this.rfIndices = new int[n];
        int n2 = 0;
        HashMap<XNormalizer.Triplef, Integer> hashMap = new HashMap<XNormalizer.Triplef, Integer>(n);
        for (int i = 0; i < n; ++i) {
            triplef = new XNormalizer.Triplef(fArray[i * 3], fArray[i * 3 + 1], fArray[i * 3 + 2]);
            Integer n3 = (Integer)hashMap.get(triplef);
            if (n3 == null) {
                this.rfIndices[i] = n2;
                hashMap.put(triplef, n2);
                ++n2;
                continue;
            }
            this.rfIndices[i] = n3;
        }
        this.rfValues = new float[hashMap.size() * 3];
        Set set = hashMap.entrySet();
        for (Map.Entry entry : set) {
            n2 = (Integer)entry.getValue() * 3;
            triplef = (XNormalizer.Triplef)entry.getKey();
            this.rfValues[n2] = triplef.x;
            this.rfValues[n2 + 1] = triplef.y;
            this.rfValues[n2 + 2] = triplef.z;
        }
    }

    float[] createRFTriplesAndInds(float[] fArray, int n, int[] nArray) {
        Integer n2;
        XNormalizer.Triplef triplef;
        int n3 = n / 3;
        int n4 = nArray.length;
        HashMap<XNormalizer.Triplef, Integer> hashMap = new HashMap<XNormalizer.Triplef, Integer>(n3 / 2);
        if (this.vertsDone == null || this.vertsDone.length < n3) {
            this.vertsDone = new int[n3];
        }
        Arrays.fill(this.vertsDone, -2);
        int[] nArray2 = nArray;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            n6 = nArray[i];
            if (this.vertsDone[n6] == -2) {
                n7 = n6 * 3;
                triplef = new XNormalizer.Triplef(fArray[n7], fArray[n7 + 1], fArray[n7 + 2]);
                n2 = (Integer)hashMap.get(triplef);
                if (n2 == null) {
                    hashMap.put(triplef, n5);
                    this.vertsDone[n6] = n5;
                    nArray2[i] = n5++;
                    continue;
                }
                this.vertsDone[n6] = n2;
                nArray2[i] = n2;
                continue;
            }
            nArray2[i] = this.vertsDone[n6];
        }
        float[] fArray2 = new float[n5 * 3];
        Set set = hashMap.entrySet();
        for (Map.Entry entry : set) {
            triplef = (XNormalizer.Triplef)entry.getKey();
            n2 = (Integer)entry.getValue() * 3;
            fArray2[n2.intValue()] = triplef.x;
            fArray2[n2.intValue() + 1] = triplef.y;
            fArray2[n2.intValue() + 2] = triplef.z;
        }
        return fArray2;
    }

    float[] createRFTuplesAndInds(float[] fArray, int n, int[] nArray) {
        Integer n2;
        XNormalizer.Tuplef tuplef;
        int n3 = n / 2;
        int n4 = nArray.length;
        HashMap<XNormalizer.Tuplef, Integer> hashMap = new HashMap<XNormalizer.Tuplef, Integer>(n3 / 2);
        if (this.vertsDone == null || this.vertsDone.length < n3) {
            this.vertsDone = new int[n3];
        }
        Arrays.fill(this.vertsDone, -2);
        int[] nArray2 = nArray;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            n6 = nArray[i];
            if (this.vertsDone[n6] == -2) {
                tuplef = new XNormalizer.Tuplef(fArray[n6 * 2], fArray[n6 * 2 + 1]);
                n2 = (Integer)hashMap.get(tuplef);
                if (n2 == null) {
                    hashMap.put(tuplef, n5);
                    this.vertsDone[n6] = n5;
                    nArray2[i] = n5++;
                    continue;
                }
                this.vertsDone[n6] = n2;
                nArray2[i] = n2;
                continue;
            }
            nArray2[i] = this.vertsDone[n6];
        }
        float[] fArray2 = new float[n5 * 2];
        Set set = hashMap.entrySet();
        for (Map.Entry entry : set) {
            tuplef = (XNormalizer.Tuplef)entry.getKey();
            n2 = (Integer)entry.getValue() * 2;
            fArray2[n2.intValue()] = tuplef.x;
            fArray2[n2.intValue() + 1] = tuplef.y;
        }
        return fArray2;
    }
}

