/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.XImporterImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javafx.collections.ObservableList;
import javafx.geometry.Point3D;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

final class XUtils {
    private float[] floatValues = new float[200000];
    private int[] intValues = new int[1200000];
    private int[] polygonLengths = new int[400000];

    XUtils() {
    }

    void close() {
        this.floatValues = null;
        this.intValues = null;
    }

    private void adjustFloatValues(int n, int n2) {
        if (n2 > this.floatValues.length) {
            int n3 = Math.max(n2, (int)((float)this.floatValues.length * 1.5f));
            if (n > 0) {
                float[] fArray = this.floatValues;
                this.floatValues = new float[n3];
                System.arraycopy(fArray, 0, this.floatValues, 0, n);
            } else {
                this.floatValues = new float[n3];
            }
        }
    }

    private void adjustIntValues(int n, int n2) {
        if (n2 > this.intValues.length) {
            int n3 = Math.max(n2, (int)((float)this.intValues.length * 1.5f));
            if (n > 0) {
                int[] nArray = this.intValues;
                this.intValues = new int[n3];
                System.arraycopy(nArray, 0, this.intValues, 0, n);
            } else {
                this.intValues = new int[n3];
            }
        }
    }

    private void adjustPrimLengths(int n, int n2) {
        if (n2 > this.polygonLengths.length) {
            int n3 = Math.max(n2, (int)((float)this.polygonLengths.length * 1.5f));
            if (n > 0) {
                int[] nArray = this.polygonLengths;
                this.polygonLengths = new int[n3];
                System.arraycopy(nArray, 0, this.polygonLengths, 0, n);
            } else {
                this.polygonLengths = new int[n3];
            }
        }
    }

    float[] getFloatValues() {
        return this.floatValues;
    }

    int[] getIntValues() {
        return this.intValues;
    }

    int[] getPolygonLengths() {
        return this.polygonLengths;
    }

    int splitFloats(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        this.adjustFloatValues(0, (int)((float)n / 8.0f));
        try {
            do {
                if ((c = string.charAt(n3)) <= ' ' || c == ',') continue;
                n2 = n3;
                while (++n3 < n && (c = string.charAt(n3)) > ' ' && c != ',') {
                }
                if (n4 >= this.floatValues.length) {
                    this.adjustFloatValues(n4, n4 + 1 + (n - n3) / 7);
                }
                this.floatValues[n4++] = Float.parseFloat(string.substring(n2, n3));
            } while (++n3 < n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split float : " + numberFormatException.getMessage(), numberFormatException);
        }
        return n4;
    }

    int splitFloatsCoordFlippedYZ(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        float f = 0.0f;
        int n5 = 0;
        this.adjustFloatValues(0, (int)((float)n / 8.0f));
        try {
            do {
                if ((c = string.charAt(n3)) <= ' ' || c == ',') continue;
                n2 = n3;
                while (++n3 < n && (c = string.charAt(n3)) > ' ' && c != ',') {
                }
                if (n4 >= this.floatValues.length) {
                    this.adjustFloatValues(n4, n4 + 1 + (n - n3) / 7);
                }
                f = Float.parseFloat(string.substring(n2, n3));
                if (n5 == 0) {
                    n5 = 1;
                } else {
                    if (f != 0.0f) {
                        f = -f;
                    }
                    n5 = n5 == 1 ? 2 : 0;
                }
                this.floatValues[n4++] = f;
            } while (++n3 < n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split float : " + numberFormatException.getMessage(), numberFormatException);
        }
        return n4;
    }

    int splitFloatsTexCoord2DFlippedY(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        boolean bl = false;
        this.adjustFloatValues(0, (int)((float)n / 8.0f));
        try {
            do {
                if ((c = string.charAt(n3)) <= ' ' || c == ',') continue;
                n2 = n3;
                while (++n3 < n && (c = string.charAt(n3)) > ' ' && c != ',') {
                }
                if (n4 >= this.floatValues.length) {
                    this.adjustFloatValues(n4, n4 + 1 + (n - n3) / 7);
                }
                this.floatValues[n4++] = bl ? 1.0f - Float.parseFloat(string.substring(n2, n3)) : Float.parseFloat(string.substring(n2, n3));
                boolean bl2 = bl = !bl;
            } while (++n3 < n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split float : " + numberFormatException.getMessage(), numberFormatException);
        }
        return n4;
    }

    int splitDoublesCoordFlippedYZ(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        float f = 0.0f;
        int n5 = 0;
        this.adjustFloatValues(0, (int)((float)n / 12.0f));
        try {
            do {
                if ((c = string.charAt(n3)) <= ' ' || c == ',') continue;
                n2 = n3;
                while (++n3 < n && (c = string.charAt(n3)) > ' ' && c != ',') {
                }
                if (n4 >= this.floatValues.length) {
                    this.adjustFloatValues(n4, n4 + 1 + (n - n3) / 10);
                }
                f = (float)Double.parseDouble(string.substring(n2, n3));
                if (n5 == 0) {
                    n5 = 1;
                } else {
                    if (f != 0.0f) {
                        f = -f;
                    }
                    n5 = n5 == 1 ? 2 : 0;
                }
                this.floatValues[n4++] = f;
            } while (++n3 < n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split double : " + numberFormatException.getMessage(), numberFormatException);
        }
        return n4;
    }

    int splitPosIntegers(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char c = '\u0000';
        this.adjustIntValues(0, (int)((float)n / 5.0f));
        do {
            if ((c = string.charAt(n4)) <= ' ' || c == ',') continue;
            n3 = 0;
            do {
                n2 = c - 48;
                n3 *= 10;
                n3 += n2;
            } while (++n4 < n && (c = string.charAt(n4)) > ' ' && c != ',');
            if (n5 >= this.intValues.length) {
                this.adjustIntValues(n5, n5 + 1 + (int)((float)(n - n4) / 5.0f));
            }
            this.intValues[n5++] = n3;
        } while (++n4 < n);
        return n5;
    }

    int[] splitPosIntegersSep(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        char c = '\u0000';
        this.adjustIntValues(0, (int)((float)n / 5.0f));
        this.adjustPrimLengths(0, this.intValues.length / 3);
        do {
            if ((c = string.charAt(n4)) <= ' ' || c == ',') continue;
            if (c == '-') {
                ++n4;
                if (n6 >= this.polygonLengths.length) {
                    this.adjustPrimLengths(n6, (int)((float)this.intValues.length * 1.3f));
                }
                this.polygonLengths[n6++] = n7;
                n7 = 0;
                continue;
            }
            n3 = 0;
            do {
                n2 = c - 48;
                n3 *= 10;
                n3 += n2;
            } while (++n4 < n && (c = string.charAt(n4)) > ' ' && c != ',');
            if (n5 >= this.intValues.length) {
                this.adjustIntValues(n5, n5 + 1 + (int)((float)(n - n4) / 5.0f));
            }
            this.intValues[n5++] = n3;
            ++n7;
        } while (++n4 < n);
        if (n7 != 0) {
            this.polygonLengths[n6++] = n7;
        }
        return new int[]{n5, n6};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int[] splitInteger(String string, int[] nArray) {
        int n = 32;
        int n2 = 44;
        int n3 = 0;
        int n4 = Math.max(16, nArray[0]);
        int[] nArray2 = new int[n4];
        int n5 = 0;
        int n6 = -1;
        int n7 = 32;
        int n8 = 0;
        int n9 = string.length();
        try {
            block2: while (true) {
                int[] nArray3;
                if (n8 < n9) {
                    n7 = string.charAt(n8);
                    if (n7 <= n || n7 == n2) {
                        ++n8;
                        continue;
                    }
                } else {
                    if (n5 > n6) {
                        if (n4 == n3) {
                            nArray3 = nArray2;
                            nArray2 = new int[nArray3.length + 1];
                            System.arraycopy(nArray3, 0, nArray2, 0, n3);
                        }
                        nArray2[n3++] = Integer.parseInt(string.substring(n5, n9), 10);
                    }
                    nArray[0] = n3;
                    return nArray2;
                }
                n5 = n8++;
                while (true) {
                    if (n8 >= n9) continue block2;
                    n7 = string.charAt(n8);
                    if (n7 <= n || n7 == n2) {
                        n6 = n8;
                        if (n4 == n3) {
                            nArray3 = nArray2;
                            n4 = (int)((double)n3 * 1.5);
                            nArray2 = new int[n4];
                            System.arraycopy(nArray3, 0, nArray2, 0, n3);
                        }
                        nArray2[n3++] = Integer.parseInt(string.substring(n5, n6), 10);
                        ++n8;
                        continue block2;
                    }
                    ++n8;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split integer: ", numberFormatException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    float[] splitFloat(String string, int[] nArray) {
        int n = 32;
        int n2 = 44;
        int n3 = 0;
        int n4 = Math.max(16, nArray[0]);
        float[] fArray = new float[n4];
        int n5 = 0;
        int n6 = -1;
        int n7 = 32;
        int n8 = 0;
        int n9 = string.length();
        try {
            block2: while (true) {
                float[] fArray2;
                if (n8 < n9) {
                    n7 = string.charAt(n8);
                    if (n7 <= n || n7 == n2) {
                        ++n8;
                        continue;
                    }
                } else {
                    if (n5 > n6) {
                        if (n4 == n3) {
                            fArray2 = fArray;
                            fArray = new float[fArray2.length + 1];
                            System.arraycopy(fArray2, 0, fArray, 0, n3);
                        }
                        fArray[n3++] = Float.parseFloat(string.substring(n5, n9));
                    }
                    nArray[0] = n3;
                    return fArray;
                }
                n5 = n8++;
                while (true) {
                    if (n8 >= n9) continue block2;
                    n7 = string.charAt(n8);
                    if (n7 <= n || n7 == n2) {
                        n6 = n8;
                        if (n4 == n3) {
                            fArray2 = fArray;
                            n4 = (int)((double)n3 * 1.5);
                            fArray = new float[n4];
                            System.arraycopy(fArray2, 0, fArray, 0, n3);
                        }
                        fArray[n3++] = Float.parseFloat(string.substring(n5, n6));
                        ++n8;
                        continue block2;
                    }
                    ++n8;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split float: ", numberFormatException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    double[] splitDouble(String string, int[] nArray) {
        int n = 32;
        int n2 = 44;
        int n3 = 0;
        int n4 = Math.max(16, nArray[0]);
        double[] dArray = new double[n4];
        int n5 = 0;
        int n6 = -1;
        int n7 = 32;
        int n8 = 0;
        int n9 = string.length();
        try {
            block2: while (true) {
                double[] dArray2;
                if (n8 < n9) {
                    n7 = string.charAt(n8);
                    if (n7 <= n || n7 == n2) {
                        ++n8;
                        continue;
                    }
                } else {
                    if (n5 > n6) {
                        if (n4 == n3) {
                            dArray2 = dArray;
                            dArray = new double[dArray2.length + 1];
                            System.arraycopy(dArray2, 0, dArray, 0, n3);
                        }
                        dArray[n3++] = Double.parseDouble(string.substring(n5, n9));
                    }
                    nArray[0] = n3;
                    return dArray;
                }
                n5 = n8++;
                while (true) {
                    if (n8 >= n9) continue block2;
                    n7 = string.charAt(n8);
                    if (n7 <= n || n7 == n2) {
                        n6 = n8;
                        if (n4 == n3) {
                            dArray2 = dArray;
                            n4 = (int)((double)n3 * 1.5);
                            dArray = new double[n4];
                            System.arraycopy(dArray2, 0, dArray, 0, n3);
                        }
                        dArray[n3++] = Double.parseDouble(string.substring(n5, n6));
                        ++n8;
                        continue block2;
                    }
                    ++n8;
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split double: ", numberFormatException);
        }
    }

    ArrayList<String> splitString(String string, int n) {
        int n2 = 32;
        int n3 = 44;
        ArrayList<String> arrayList = new ArrayList<String>(Math.max(4, n));
        int n4 = 0;
        int n5 = -1;
        int n6 = 32;
        int n7 = 0;
        int n8 = string.length();
        block0: while (n7 < n8) {
            n6 = string.charAt(n7);
            if (n6 > n2 && n6 != n3) {
                n4 = n7++;
                while (n7 < n8) {
                    n6 = string.charAt(n7);
                    if (n6 <= n2 || n6 == n3) {
                        n5 = n7++;
                        arrayList.add(string.substring(n4, n5));
                        continue block0;
                    }
                    ++n7;
                }
                continue;
            }
            ++n7;
        }
        if (n4 > n5) {
            arrayList.add(string.substring(n4, n8));
        }
        return arrayList;
    }

    int getInteger(String string) {
        String string2 = string.trim();
        if (string2 == null || string2.length() < 1) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("get integer: ", numberFormatException);
        }
    }

    float getFloat(String string) {
        String string2 = string.trim();
        if (string2 == null || string2.length() < 1) {
            return Float.NaN;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("get float: ", numberFormatException);
        }
    }

    int[] getIntArray(String string) {
        int[] nArray = new int[]{string.length() / 4};
        int[] nArray2 = this.splitInteger(string, nArray);
        int n = nArray[0];
        if (nArray2 == null || n < 1) {
            return null;
        }
        int[] nArray3 = new int[n];
        if (n > 16) {
            System.arraycopy(nArray2, 0, nArray3, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                nArray3[i] = nArray2[i];
            }
        }
        return nArray3;
    }

    float[] getFloatArray(String string) {
        int[] nArray = new int[]{string.length() / 9};
        float[] fArray = this.splitFloat(string, nArray);
        int n = nArray[0];
        if (fArray == null || n < 1) {
            return null;
        }
        float[] fArray2 = new float[n];
        if (n > 16) {
            System.arraycopy(fArray, 0, fArray2, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = fArray[i];
            }
        }
        return fArray2;
    }

    double[] getDoubleArray(String string) {
        int[] nArray = new int[]{string.length() / 14};
        double[] dArray = this.splitDouble(string, nArray);
        int n = nArray[0];
        if (dArray == null || n < 1) {
            return null;
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    String[] getStrings(String string) {
        int n;
        ArrayList<String> arrayList = this.splitString(string, 10);
        if (arrayList == null || (n = arrayList.size()) < 1) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = arrayList.get(i);
        }
        return stringArray;
    }

    ArrayList<String> getMFStrings(String string, boolean bl) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) != '\"') continue;
            arrayList.add(n);
        }
        n = arrayList.size();
        ArrayList<String> arrayList2 = null;
        if (n > 1) {
            arrayList2 = new ArrayList(n / 2);
            String string2 = null;
            for (int i = 0; i < n; i += 2) {
                int n3 = (Integer)arrayList.get(i);
                int n4 = (Integer)arrayList.get(i + 1);
                string2 = string.substring(n3 + 1, n4);
                string2 = this.trimString(string2);
                if (bl) {
                    arrayList2.add(string2);
                    continue;
                }
                if (string2 == null || string2.length() <= 0) continue;
                arrayList2.add(string2);
            }
        } else {
            arrayList2 = new ArrayList<String>(1);
            string = this.trimString(string);
            if (bl) {
                arrayList2.add(string);
            } else if (string != null && string.length() > 0) {
                arrayList2.add(string);
            }
        }
        return arrayList2;
    }

    private String trimString(String string) {
        int n;
        String string2 = "";
        char c = ' ';
        int n2 = -1;
        int n3 = -1;
        int n4 = string.length();
        for (n = 0; n < n4; ++n) {
            if (string.charAt(n) <= c) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            for (n = n4 - 1; n >= 0; --n) {
                if (string.charAt(n) <= c) continue;
                n3 = n;
                break;
            }
            string2 = string.substring(n2, n3 + 1);
        }
        return string2;
    }

    ArrayList<URL> getResourceUrlsFor(ArrayList<String> arrayList, XImporterImpl.BaseURL baseURL, String string, String string2) {
        if (arrayList == null || arrayList.isEmpty()) {
            throw new ImportException(string + ": No readable string for URL !  DEF = " + string2 + " !");
        }
        ArrayList<URL> arrayList2 = new ArrayList<URL>(arrayList.size());
        for (String string3 : arrayList) {
            URL uRL = this.getUrlForAbsolutPath(string3 = string3.replace('\\', '/'));
            if (uRL == null) {
                uRL = this.getUrlForRelativePath(baseURL, string3);
            }
            if (uRL == null) continue;
            arrayList2.add(uRL);
        }
        if (arrayList2.isEmpty()) {
            throw new ImportException(string + ": Can't create any URL for DEF = " + string2 + " !");
        }
        return arrayList2;
    }

    URL getResourceUrlFor(String string, XImporterImpl.BaseURL baseURL, String string2, String string3) {
        URL uRL = this.getUrlForAbsolutPath(string = string.replace('\\', '/'));
        if (uRL == null) {
            uRL = this.getUrlForRelativePath(baseURL, string);
        }
        return uRL;
    }

    URL getUrlForAbsolutPath(String string) {
        URL uRL = null;
        int n = string.indexOf(":");
        try {
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string2.toLowerCase(Locale.ENGLISH);
                if (string3.startsWith("jar") || string3.startsWith("http") || string3.startsWith("file") || string3.startsWith("ftp")) {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                } else if (string.charAt(0) != '/') {
                    uRL = new URL("file", null, "/" + string);
                } else {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                }
            } else if (string.charAt(0) == '/') {
                uRL = new URL("file", null, string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ImportException("Can't create URI !\nPath = " + string + "<!");
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("Can't create URL !\nPath = " + string + "<!");
        }
        return uRL;
    }

    URL getUrlForRelativePath(XImporterImpl.BaseURL baseURL, String string) {
        string = string.replace('\\', '/');
        URL uRL = null;
        try {
            uRL = new URL(baseURL.protocol, baseURL.host, baseURL.port, this.normalizePath(baseURL.path, string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("\nCan't build URL for resource relative to file.\nprotocol = " + baseURL.protocol + ", host = " + baseURL.host + ", port = " + baseURL.port + "\npath = " + baseURL.path + "\nrelativeP path = " + string);
        }
        return uRL;
    }

    String normalizePath(String string, String string2) {
        if (string2.indexOf("./") == 0) {
            return new String(string + string2.substring(2));
        }
        int n = -1;
        int n2 = string2.lastIndexOf("../");
        int n3 = 0;
        if (n2 >= 0) {
            n3 = n2 / 3 + 1;
        }
        if (n3 > 0) {
            int n4 = string.length() - 2;
            n = string.lastIndexOf(47, n4);
            if (n < 0) {
                throw new ImportException("normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
            }
            --n3;
            while (n3 > 0) {
                if ((n = string.lastIndexOf(47, n - 1)) < 0) {
                    throw new ImportException("normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
                }
                --n3;
            }
            return new String(string.substring(0, n + 1) + string2.substring(n2 + 3));
        }
        return new String(string + string2);
    }

    void createAndAddTransforms(ObservableList<Transform> observableList, String string, String string2, String string3, String string4, String string5) {
        float[] fArray;
        Translate translate = null;
        Translate translate2 = null;
        Rotate rotate = null;
        Transform transform = null;
        Rotate rotate2 = null;
        Scale scale = null;
        Translate translate3 = null;
        int n = -1;
        if (string != null) {
            n = this.splitFloats(string);
            if (n == 3) {
                fArray = this.getFloatValues();
                if ((double)fArray[1] != 0.0) {
                    fArray[1] = -fArray[1];
                }
                if ((double)fArray[2] != 0.0) {
                    fArray[2] = -fArray[2];
                }
                translate2 = new Translate((double)fArray[0], (double)fArray[1], (double)fArray[2]);
                translate = translate2.createInverse();
            } else {
                throw new ImportException("TransformNode center : length != 3. Is >" + string + "<");
            }
        }
        if (string2 != null) {
            n = this.splitFloats(string2);
            if (n == 4) {
                fArray = this.getFloatValues();
                if ((double)fArray[1] != 0.0) {
                    fArray[1] = -fArray[1];
                }
                if ((double)fArray[2] != 0.0) {
                    fArray[2] = -fArray[2];
                }
                rotate = new Rotate(Math.toDegrees(fArray[3]), new Point3D((double)fArray[0], (double)fArray[1], (double)fArray[2]));
            } else {
                throw new ImportException("TransformNode rotation : length != 4. Is >" + string2 + "<");
            }
        }
        if (string4 != null) {
            n = this.splitFloats(string4);
            if (n == 4) {
                fArray = this.getFloatValues();
                if ((double)fArray[1] != 0.0) {
                    fArray[1] = -fArray[1];
                }
                if ((double)fArray[2] != 0.0) {
                    fArray[2] = -fArray[2];
                }
                rotate2 = new Rotate(Math.toDegrees(fArray[3]), new Point3D((double)fArray[0], (double)fArray[1], (double)fArray[2]));
                try {
                    transform = rotate2.createInverse();
                }
                catch (NonInvertibleTransformException nonInvertibleTransformException) {
                    throw new ImportException("TransformNode : " + nonInvertibleTransformException.getMessage(), nonInvertibleTransformException);
                }
            } else {
                throw new ImportException("TransformNode scaleOrientation : length != 4. Is >" + string4 + "<");
            }
        }
        if (string3 != null) {
            n = this.splitFloats(string3);
            if (n == 3) {
                fArray = this.getFloatValues();
                scale = new Scale((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            } else {
                throw new ImportException("TransformNode scale : length != 3. Is >" + string3 + "<");
            }
        }
        if (string5 != null) {
            n = this.splitFloats(string5);
            if (n == 3) {
                fArray = this.getFloatValues();
                if ((double)fArray[1] != 0.0) {
                    fArray[1] = -fArray[1];
                }
                if ((double)fArray[2] != 0.0) {
                    fArray[2] = -fArray[2];
                }
                translate3 = new Translate((double)fArray[0], (double)fArray[1], (double)fArray[2]);
            } else {
                throw new ImportException("TransformNode translation : length != 3. Is >" + string5 + "<");
            }
        }
        if (translate3 != null) {
            observableList.add(translate3);
        }
        if (translate2 != null) {
            observableList.add(translate2);
        }
        if (rotate != null) {
            observableList.add(rotate);
        }
        if (rotate2 != null) {
            observableList.add(rotate2);
        }
        if (scale != null) {
            observableList.add(scale);
        }
        if (transform != null) {
            observableList.add(transform);
        }
        if (translate != null) {
            observableList.add(translate);
        }
    }
}

