/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.Application;
import com.jme3.app.VREnvironment;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.VRInputAPI;
import com.jme3.input.vr.VRMouseManager;
import com.jme3.input.vr.VRViewManager;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.PreNormalCaching;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.util.VRGUIPositioningMode;
import com.jme3.util.VRGuiManager;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VRAppState
extends AbstractAppState {
    private static final Logger logger = Logger.getLogger(VRAppState.class.getName());
    public boolean DISABLE_VR = false;
    private float fFar = 1000.0f;
    private float fNear = 0.1f;
    private int xWin = 1920;
    private int yWin = 1080;
    private float resMult = 1.0f;
    private Quaternion tempq = new Quaternion();
    private Application application = null;
    private AppStateManager stateManager = null;
    private AppSettings settings = null;
    private VREnvironment environment = null;

    public VRAppState(VREnvironment environment) {
        this.environment = environment;
        this.setSettings(environment.getSettings());
    }

    public VRAppState(AppSettings settings, VREnvironment environment) {
        this(environment);
        this.settings = settings;
        this.processSettings(settings);
    }

    public void simpleUpdate(float tpf) {
    }

    public void simpleRender(RenderManager renderManager) {
        PreNormalCaching.resetCache(this.environment.isInVR());
    }

    public void setFrustrumNearFar(float near, float far) {
        this.fNear = near;
        this.fFar = far;
    }

    public void setMirrorWindowSize(int width, int height) {
        this.xWin = width;
        this.yWin = height;
    }

    public void setResolutionMultiplier(float val) {
        this.resMult = val;
        if (this.environment.getVRViewManager() != null) {
            this.environment.getVRViewManager().setResolutionMultiplier(this.resMult);
        }
    }

    public void moveScreenProcessingToVR() {
        this.environment.getVRViewManager().moveScreenProcessingToEyes();
    }

    public Quaternion getFinalObserverRotation() {
        if (this.environment.getVRViewManager() == null) {
            if (this.environment.getObserver() == null) {
                return this.environment.getCamera().getRotation();
            }
            return ((Spatial)this.environment.getObserver()).getWorldRotation();
        }
        if (this.environment.getObserver() == null) {
            this.tempq.set(this.environment.getDummyCamera().getRotation());
        } else {
            this.tempq.set(((Spatial)this.environment.getObserver()).getWorldRotation());
        }
        return this.tempq.multLocal(this.environment.getVRHardware().getOrientation());
    }

    public Vector3f getFinalObserverPosition() {
        if (this.environment.getVRViewManager() == null) {
            if (this.environment.getObserver() == null) {
                return this.environment.getCamera().getLocation();
            }
            return ((Spatial)this.environment.getObserver()).getWorldTranslation();
        }
        Vector3f pos = this.environment.getVRHardware().getPosition();
        if (this.environment.getObserver() == null) {
            this.environment.getDummyCamera().getRotation().mult(pos, pos);
            return pos.addLocal(this.environment.getDummyCamera().getLocation());
        }
        ((Spatial)this.environment.getObserver()).getWorldRotation().mult(pos, pos);
        return pos.addLocal(((Spatial)this.environment.getObserver()).getWorldTranslation());
    }

    public ViewPort getLeftViewPort() {
        if (this.environment.getVRViewManager() == null) {
            return this.application.getViewPort();
        }
        return this.environment.getVRViewManager().getLeftViewPort();
    }

    public ViewPort getRightViewPort() {
        if (this.environment.getVRViewManager() == null) {
            return this.application.getViewPort();
        }
        return this.environment.getVRViewManager().getRightViewPort();
    }

    public void setBackgroundColors(ColorRGBA clr) {
        if (this.environment.getVRViewManager() == null) {
            this.application.getViewPort().setBackgroundColor(clr);
        } else if (this.environment.getVRViewManager().getLeftViewPort() != null) {
            this.environment.getVRViewManager().getLeftViewPort().setBackgroundColor(clr);
            if (this.environment.getVRViewManager().getRightViewPort() != null) {
                this.environment.getVRViewManager().getRightViewPort().setBackgroundColor(clr);
            }
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public AppStateManager getStateManager() {
        return this.stateManager;
    }

    public Object getObserver() {
        return this.environment.getObserver();
    }

    public void setObserver(Spatial observer) {
        this.environment.setObserver(observer);
    }

    public boolean isInstanceRendering() {
        return this.environment.isInstanceRendering();
    }

    public VREnvironment getVREnvironment() {
        return this.environment;
    }

    public VRAPI getVRHardware() {
        return this.getVREnvironment().getVRHardware();
    }

    public VRInputAPI getVRinput() {
        if (this.getVREnvironment().getVRHardware() == null) {
            return null;
        }
        return this.getVREnvironment().getVRHardware().getVRinput();
    }

    public VRViewManager getVRViewManager() {
        return this.getVREnvironment().getVRViewManager();
    }

    public VRGuiManager getVRGUIManager() {
        return this.getVREnvironment().getVRGUIManager();
    }

    public VRMouseManager getVRMouseManager() {
        return this.getVREnvironment().getVRMouseManager();
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
        this.processSettings(settings);
    }

    public void update(float tpf) {
        if (this.environment.getVRViewManager() != null) {
            this.environment.getVRViewManager().update(tpf);
        } else if (this.environment.getObserver() != null) {
            this.environment.getCamera().setFrame(((Spatial)this.environment.getObserver()).getWorldTranslation(), ((Spatial)this.environment.getObserver()).getWorldRotation());
        }
        if (!this.environment.isInVR() || this.environment.getVRGUIManager().getPositioningMode() == VRGUIPositioningMode.MANUAL) {
            for (Spatial spatial : this.application.getGuiViewPort().getScenes()) {
                spatial.updateGeometricState();
            }
        }
        this.environment.getVRMouseManager().updateAnalogAsMouse(0, null, null, null, tpf);
    }

    public void render(RenderManager rm) {
        super.render(rm);
        if (this.environment.getVRViewManager() != null) {
            this.environment.getVRViewManager().render();
        }
    }

    public void postRender() {
        super.postRender();
        if (this.environment.getVRViewManager() != null) {
            this.environment.getVRViewManager().postRender();
        }
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.application = app;
        this.stateManager = stateManager;
        Logger.getLogger("com.jme3").setLevel(Level.SEVERE);
        app.getCamera().setFrustumFar(this.fFar);
        app.getCamera().setFrustumNear(this.fNear);
        if (this.environment.isInVR()) {
            logger.config("VR mode enabled.");
            if (this.environment.getVRHardware() != null) {
                this.environment.getVRHardware().initVRCompositor(this.environment.compositorAllowed());
            } else {
                logger.warning("No VR system found.");
            }
            this.environment.getVRViewManager().setResolutionMultiplier(this.resMult);
        } else {
            logger.config("VR mode disabled.");
        }
        if (this.environment.getVRViewManager() != null) {
            this.environment.getVRViewManager().initialize();
        }
    }

    public void stateAttached(AppStateManager stateManager) {
        super.stateAttached(stateManager);
        if (this.settings == null) {
            this.settings = new AppSettings(true);
            logger.config("Using default settings.");
        } else {
            logger.config("Using given settings.");
        }
        if (!this.environment.isInitialized()) {
            this.environment.initialize();
        }
        if (this.environment.isInitialized()) {
            this.environment.atttach((AppState)this, stateManager.getApplication());
        } else {
            logger.severe("Cannot attach VR environment to the VR app state as its not initialized.");
        }
        GraphicsDevice defDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (this.environment.isInVR() && !this.environment.compositorAllowed()) {
            GraphicsDevice[] devs;
            GraphicsDevice VRdev = null;
            for (GraphicsDevice gd : devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (gd == defDev) continue;
                VRdev = gd;
                break;
            }
            if (VRdev != null) {
                try {
                    DisplayMode useDM = null;
                    int max = 0;
                    for (DisplayMode dm : VRdev.getDisplayModes()) {
                        int check = dm.getHeight() + dm.getWidth() + dm.getRefreshRate() + dm.getBitDepth();
                        if (check <= max) continue;
                        max = check;
                        useDM = dm;
                    }
                    this.settings.setWidth(useDM.getWidth());
                    this.settings.setHeight(useDM.getHeight());
                    this.settings.setBitsPerPixel(useDM.getBitDepth());
                    this.settings.setFrequency(useDM.getRefreshRate());
                    this.settings.setSwapBuffers(true);
                    this.settings.setVSync(true);
                    stateManager.getApplication().setSettings(this.settings);
                    logger.config("Updated underlying application settings.");
                    if (!VRdev.getDisplayMode().equals(useDM)) {
                        VRdev.setDisplayMode(useDM);
                    }
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            } else {
                logger.config("Cannot access to external screen.");
            }
        } else if (!this.environment.isInVR()) {
            logger.config("Cannot switch to VR mode (VR disabled by user).");
        } else if (!this.environment.compositorAllowed()) {
            logger.warning("Cannot switch to VR mode (VR not supported).");
        }
        if (!this.environment.isInVR()) {
            boolean macOs = false;
            if (macOs) {
                this.settings.setFrequency(defDev.getDisplayMode().getRefreshRate());
                this.settings.setDepthBits(24);
                this.settings.setVSync(true);
                File resfile = new File("resolution.txt");
                if (resfile.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(resfile));
                        this.settings.setWidth(Integer.parseInt(br.readLine()));
                        this.settings.setHeight(Integer.parseInt(br.readLine()));
                        try {
                            this.settings.setFullscreen(br.readLine().toLowerCase(Locale.ENGLISH).contains("full"));
                        }
                        catch (Exception e) {
                            this.settings.setFullscreen(false);
                        }
                        br.close();
                    }
                    catch (Exception e) {
                        this.settings.setWidth(1280);
                        this.settings.setHeight(720);
                    }
                } else {
                    this.settings.setWidth(1280);
                    this.settings.setHeight(720);
                    this.settings.setFullscreen(false);
                }
                this.settings.setResizable(false);
            }
            this.settings.setSwapBuffers(true);
        } else {
            this.settings.setSamples(1);
            this.settings.setWidth(this.xWin);
            this.settings.setHeight(this.yWin);
            this.settings.setBitsPerPixel(32);
            this.settings.setFrameRate(0);
            this.settings.setFrequency(this.environment.getVRHardware().getDisplayFrequency());
            this.settings.setFullscreen(false);
            this.settings.setVSync(false);
            this.settings.setSwapBuffers(this.environment.isSwapBuffers());
        }
        stateManager.getApplication().setSettings(this.settings);
        logger.config("Updated underlying application settings.");
    }

    public void cleanup() {
        if (this.environment.getVRHardware() != null) {
            this.environment.getVRHardware().destroy();
        }
        this.application = null;
        this.stateManager = null;
    }

    public void stateDetached(AppStateManager stateManager) {
        super.stateDetached(stateManager);
    }

    protected void processSettings(AppSettings settings) {
        if (settings != null && settings.get((Object)"VRDisable") != null) {
            this.DISABLE_VR = settings.getBoolean("VRDisable");
        }
    }
}

