/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.AppTask;
import com.jme3.app.Application;
import com.jme3.app.LegacyApplication;
import com.jme3.app.LostFocusBehavior;
import com.jme3.app.ResetStatsState;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioContext;
import com.jme3.audio.AudioRenderer;
import com.jme3.audio.Listener;
import com.jme3.input.InputManager;
import com.jme3.input.JoyInput;
import com.jme3.input.KeyInput;
import com.jme3.input.MouseInput;
import com.jme3.input.TouchInput;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.VRInputAPI;
import com.jme3.input.vr.openvr.OpenVR;
import com.jme3.input.vr.openvr.OpenVRMouseManager;
import com.jme3.input.vr.openvr.OpenVRViewManager;
import com.jme3.input.vr.osvr.OSVR;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.PreNormalCaching;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.JmeSystem;
import com.jme3.system.NanoTimer;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.lwjgl.LwjglDisplayVR;
import com.jme3.system.lwjgl.LwjglOffscreenBufferVR;
import com.jme3.util.VRGUIPositioningMode;
import com.jme3.util.VRGuiManager;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.system.Platform;

public abstract class VRApplication
implements Application,
SystemListener {
    private static final Logger logger = Logger.getLogger(LegacyApplication.class.getName());
    public float DEFAULT_FOV = 108.0f;
    public float DEFAULT_ASPECT = 1.0f;
    public boolean CONSTRUCT_WITH_OSVR = false;
    public boolean DISABLE_VR = false;
    private VRAPI VRhardware = null;
    private VRGuiManager guiManager = null;
    private OpenVRMouseManager mouseManager = null;
    private OpenVRViewManager viewmanager = null;
    private String OS;
    private Camera dummyCam;
    private Spatial observer;
    private boolean VRSupportedOS;
    private boolean forceVR;
    private boolean disableSwapBuffers = true;
    private boolean tryOpenGL3 = true;
    private boolean seated;
    private boolean nogui;
    private boolean instanceVR;
    private boolean forceDisableMSAA;
    private AppStateManager stateManager;
    private Camera cam;
    private AppSettings settings;
    private JmeContext context;
    private float speed = 1.0f;
    private AudioRenderer audioRenderer;
    private LostFocusBehavior lostFocusBehavior = LostFocusBehavior.ThrottleOnLostFocus;
    private final ConcurrentLinkedQueue<AppTask<?>> taskQueue = new ConcurrentLinkedQueue();
    private Timer timer = new NanoTimer();
    private boolean paused = false;
    private boolean inputEnabled = true;
    private InputManager inputManager;
    private RenderManager renderManager;
    private ViewPort viewPort;
    private ViewPort guiViewPort;
    private AssetManager assetManager;
    private Renderer renderer;
    private Listener listener;
    private MouseInput mouseInput;
    private KeyInput keyInput;
    private JoyInput joyInput;
    private TouchInput touchInput;
    protected Node guiNode;
    protected Node rootNode = new Node("root");
    private float fFar = 1000.0f;
    private float fNear = 1.0f;
    private int xWin = 1280;
    private int yWin = 720;
    private float resMult = 1.0f;
    private boolean useCompositor = true;
    private boolean compositorOS;
    private final String RESET_HMD = "ResetHMD";
    private static Quaternion tempq = new Quaternion();

    public VRApplication(AppState ... initialStates) {
        this();
        if (initialStates != null) {
            for (AppState a : initialStates) {
                if (a == null) continue;
                this.stateManager.attach(a);
            }
        }
    }

    public VRApplication() {
        this.guiNode = new Node("guiNode");
        this.guiNode.setQueueBucket(RenderQueue.Bucket.Gui);
        this.guiNode.setCullHint(Spatial.CullHint.Never);
        this.dummyCam = new Camera();
        this.initStateManager();
        this.guiManager = new VRGuiManager(null);
        this.viewmanager = new OpenVRViewManager(null);
        this.mouseManager = new OpenVRMouseManager(null);
        this.OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        this.VRSupportedOS = !this.OS.contains("nux") && System.getProperty("sun.arch.data.model").equalsIgnoreCase("64");
        this.compositorOS = this.OS.contains("indows");
        if (!this.VRSupportedOS) {
            logger.warning("Non-supported OS: " + this.OS + ", architecture: " + System.getProperty("sun.arch.data.model"));
        } else if (this.DISABLE_VR) {
            logger.warning("VR disabled via code.");
        } else if (this.VRSupportedOS && !this.DISABLE_VR) {
            if (this.CONSTRUCT_WITH_OSVR) {
                this.VRhardware = new OSVR(null);
                logger.config("Creating OSVR wrapper [SUCCESS]");
            } else {
                this.VRhardware = new OpenVR(null);
                logger.config("Creating OpenVR wrapper [SUCCESS]");
            }
            if (this.VRhardware.initialize()) {
                this.setPauseOnLostFocus(false);
            }
        }
    }

    public VRAPI getVRHardware() {
        return this.VRhardware;
    }

    public VRInputAPI getVRinput() {
        if (this.VRhardware == null) {
            return null;
        }
        return this.VRhardware.getVRinput();
    }

    public OpenVRViewManager getVRViewManager() {
        return this.viewmanager;
    }

    public VRGuiManager getVRGUIManager() {
        return this.guiManager;
    }

    public OpenVRMouseManager getVRMouseManager() {
        return this.mouseManager;
    }

    public void setFrustrumNearFar(float near, float far) {
        this.fNear = near;
        this.fFar = far;
    }

    public void setMirrorWindowSize(int width, int height) {
        this.xWin = width;
        this.yWin = height;
    }

    public void setResolutionMultiplier(float val) {
        this.resMult = val;
        if (this.viewmanager != null) {
            this.viewmanager.setResolutionMultiplier(this.resMult);
        }
    }

    public boolean compositorAllowed() {
        return this.useCompositor && this.compositorOS;
    }

    public boolean isOSVRSupported() {
        return this.VRSupportedOS;
    }

    public void simpleUpdate(float tpf) {
    }

    public void simpleRender(RenderManager renderManager) {
        PreNormalCaching.resetCache(this.isInVR());
    }

    public Camera getCamera() {
        if (this.isInVR() && this.viewmanager != null && this.viewmanager.getLeftCamera() != null) {
            return this.dummyCam;
        }
        return this.cam;
    }

    public Camera getBaseCamera() {
        return this.cam;
    }

    public JmeContext getContext() {
        return this.context;
    }

    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    public InputManager getInputManager() {
        return this.inputManager;
    }

    public AppStateManager getStateManager() {
        return this.stateManager;
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public AudioRenderer getAudioRenderer() {
        return this.audioRenderer;
    }

    public Listener getListener() {
        return this.listener;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void handleError(String errMsg, Throwable t) {
        logger.log(Level.SEVERE, errMsg, t);
        if (this.context.getType() != JmeContext.Type.Headless) {
            if (t != null) {
                JmeSystem.showErrorDialog((String)(errMsg + "\n" + t.getClass().getSimpleName() + (t.getMessage() != null ? ": " + t.getMessage() : "")));
            } else {
                JmeSystem.showErrorDialog((String)errMsg);
            }
        }
        this.stop();
    }

    public void gainFocus() {
        if (this.lostFocusBehavior != LostFocusBehavior.Disabled) {
            if (this.lostFocusBehavior == LostFocusBehavior.PauseOnLostFocus) {
                this.paused = false;
            }
            this.context.setAutoFlushFrames(true);
            if (this.inputManager != null) {
                this.inputManager.reset();
            }
        }
    }

    public void loseFocus() {
        if (this.lostFocusBehavior != LostFocusBehavior.Disabled) {
            if (this.lostFocusBehavior == LostFocusBehavior.PauseOnLostFocus) {
                this.paused = true;
            }
            this.context.setAutoFlushFrames(false);
        }
    }

    public void reshape(int w, int h) {
        if (this.renderManager != null) {
            this.renderManager.notifyReshape(w, h);
        }
    }

    public void requestClose(boolean esc) {
        this.context.destroy(false);
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
        if (this.context != null && settings.useInput() != this.inputEnabled) {
            boolean bl = this.inputEnabled = !this.inputEnabled;
            if (this.inputEnabled) {
                this.initInput();
            } else {
                this.destroyInput();
            }
        } else {
            this.inputEnabled = settings.useInput();
        }
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
        if (timer != null) {
            timer.reset();
        }
        if (this.renderManager != null) {
            this.renderManager.setTimer(timer);
        }
    }

    public LostFocusBehavior getLostFocusBehavior() {
        return this.lostFocusBehavior;
    }

    public void setLostFocusBehavior(LostFocusBehavior lostFocusBehavior) {
        this.lostFocusBehavior = lostFocusBehavior;
    }

    public boolean isPauseOnLostFocus() {
        return this.getLostFocusBehavior() == LostFocusBehavior.PauseOnLostFocus;
    }

    public void setPauseOnLostFocus(boolean pauseOnLostFocus) {
        if (pauseOnLostFocus) {
            this.setLostFocusBehavior(LostFocusBehavior.PauseOnLostFocus);
        } else {
            this.setLostFocusBehavior(LostFocusBehavior.Disabled);
        }
    }

    public void start() {
        logger.config("Starting application...");
        boolean loadSettings = false;
        if (this.settings == null) {
            this.setSettings(new AppSettings(true));
            loadSettings = true;
        }
        GraphicsDevice defDev = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            defDev = ge.getDefaultScreenDevice();
        }
        catch (Throwable e1) {
            logger.log(Level.SEVERE, "Cannot access default screen device: " + e1.getMessage(), e1);
        }
        if (this.isInVR() && !this.compositorAllowed()) {
            GraphicsDevice[] devs;
            logger.warning("VR Composition is not allowed.");
            GraphicsDevice VRdev = null;
            for (GraphicsDevice gd : devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (gd == defDev) continue;
                VRdev = gd;
                break;
            }
            if (VRdev != null) {
                try {
                    DisplayMode useDM = null;
                    int max = 0;
                    for (DisplayMode dm : VRdev.getDisplayModes()) {
                        int check = dm.getHeight() + dm.getWidth() + dm.getRefreshRate() + dm.getBitDepth();
                        if (check <= max) continue;
                        max = check;
                        useDM = dm;
                    }
                    this.settings.setWidth(useDM.getWidth());
                    this.settings.setHeight(useDM.getHeight());
                    this.settings.setBitsPerPixel(useDM.getBitDepth());
                    this.settings.setFrequency(useDM.getRefreshRate());
                    this.settings.setSwapBuffers(true);
                    this.settings.setVSync(true);
                    this.setSettings(this.settings);
                    if (!VRdev.getDisplayMode().equals(useDM)) {
                        VRdev.setDisplayMode(useDM);
                    }
                    logger.config("Starting application [SUCCESS]");
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error during application start: " + e.getMessage(), e);
                }
            }
        }
        if (!this.isInVR()) {
            logger.config("VR mode disabled.");
            if (Platform.get() != Platform.MACOSX) {
                if (!JmeSystem.showSettingsDialog((AppSettings)this.settings, (boolean)loadSettings)) {
                    logger.config("Starting application [SUCCESS]");
                    return;
                }
            } else {
                this.settings.setFrequency(defDev.getDisplayMode().getRefreshRate());
                this.settings.setDepthBits(24);
                this.settings.setVSync(true);
                File resfile = new File("resolution.txt");
                if (resfile.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(resfile));
                        this.settings.setWidth(Integer.parseInt(br.readLine()));
                        this.settings.setHeight(Integer.parseInt(br.readLine()));
                        try {
                            this.settings.setFullscreen(br.readLine().toLowerCase(Locale.ENGLISH).contains("full"));
                        }
                        catch (Exception e) {
                            this.settings.setFullscreen(false);
                        }
                        br.close();
                    }
                    catch (Exception e) {
                        this.settings.setWidth(1280);
                        this.settings.setHeight(720);
                    }
                } else {
                    this.settings.setWidth(1280);
                    this.settings.setHeight(720);
                    this.settings.setFullscreen(false);
                }
                this.settings.setResizable(false);
            }
            this.settings.setSwapBuffers(true);
        } else {
            logger.config("VR mode enabled.");
            this.settings.setWidth(this.xWin);
            this.settings.setHeight(this.yWin);
            this.settings.setBitsPerPixel(24);
            this.settings.setFrameRate(0);
            this.settings.setFrequency(this.VRhardware.getDisplayFrequency());
            this.settings.setFullscreen(false);
            this.settings.setVSync(false);
            this.settings.setSwapBuffers(!this.disableSwapBuffers || this.VRhardware instanceof OSVR);
            this.settings.setTitle("Put Headset On Now: " + this.settings.getTitle());
            this.settings.setResizable(true);
        }
        if (this.forceDisableMSAA) {
            logger.config("Disabling multisampling.");
            this.settings.setSamples(1);
        }
        if (this.tryOpenGL3) {
            logger.config("Using LWJGL OpenGL 3 renderer.");
            this.settings.setRenderer("LWJGL-OpenGL3");
        } else {
            logger.config("Using LWJGL OpenGL 2 renderer.");
            this.settings.setRenderer("LWJGL-OpenGL2");
        }
        this.setSettings(this.settings);
        this.start(JmeContext.Type.Display, false);
        Logger.getLogger("com.jme3").setLevel(Level.SEVERE);
    }

    public void start(boolean waitFor) {
        this.start(JmeContext.Type.Display, waitFor);
    }

    public void start(JmeContext.Type contextType, boolean waitFor) {
        if (this.context != null && this.context.isCreated()) {
            logger.warning("start() called when application already created!");
            return;
        }
        if (this.settings == null) {
            this.settings = new AppSettings(true);
        }
        logger.log(Level.FINE, "Starting application: {0}", this.getClass().getName());
        if (contextType == JmeContext.Type.Display) {
            this.context = new LwjglDisplayVR();
            this.context.setSettings(this.settings);
        } else if (contextType == JmeContext.Type.OffscreenSurface) {
            this.context = new LwjglOffscreenBufferVR();
            this.context.setSettings(this.settings);
        } else {
            logger.severe("Unsupported context type \"" + contextType + "\". Supported are \"Display\" and \"OffscreenSurface\"");
            throw new IllegalArgumentException("Unsupported context type \"" + contextType + "\". Supported are \"Display\" and \"OffscreenSurface\"");
        }
        this.context.setSystemListener((SystemListener)this);
        this.context.create(waitFor);
    }

    public void moveScreenProcessingToVR() {
        if (this.isInVR()) {
            this.viewmanager.moveScreenProcessingToEyes();
        }
    }

    public void preconfigureVRApp(PreconfigParameter parm, boolean value) {
        switch (parm) {
            case SET_GUI_OVERDRAW: {
                this.guiManager.setGuiOverdraw(value);
                break;
            }
            case SET_GUI_CURVED_SURFACE: {
                this.guiManager.setCurvedSurface(value);
                break;
            }
            case FORCE_VR_MODE: {
                this.forceVR = value;
                break;
            }
            case USE_VR_COMPOSITOR: {
                this.useCompositor = value;
                if (value) break;
                this.disableSwapBuffers = false;
                break;
            }
            case FLIP_EYES: {
                if (this.VRhardware == null) {
                    return;
                }
                this.VRhardware.setFlipEyes(value);
                break;
            }
            case INSTANCE_VR_RENDERING: {
                this.instanceVR = value;
                break;
            }
            case ENABLE_MIRROR_WINDOW: {
                if (!this.useCompositor) {
                    this.disableSwapBuffers = false;
                    break;
                }
                this.disableSwapBuffers = !value;
                break;
            }
            case PREFER_OPENGL3: {
                this.tryOpenGL3 = value;
                break;
            }
            case DISABLE_VR: {
                this.DISABLE_VR = value;
                break;
            }
            case NO_GUI: {
                this.nogui = value;
                break;
            }
            case SEATED_EXPERIENCE: {
                this.seated = value;
                break;
            }
            case FORCE_DISABLE_MSAA: {
                this.forceDisableMSAA = value;
            }
        }
    }

    public void setSeatedExperience(boolean isSeated) {
        this.seated = isSeated;
        if (this.VRhardware instanceof OpenVR) {
            if (this.VRhardware.getCompositor() == null) {
                return;
            }
            if (this.seated) {
                ((OpenVR)this.VRhardware).getCompositor().SetTrackingSpace.apply(0);
            } else {
                ((OpenVR)this.VRhardware).getCompositor().SetTrackingSpace.apply(1);
            }
        }
    }

    public boolean isSeatedExperience() {
        return this.seated;
    }

    public void resetSeatedPose() {
        if (!this.VRSupportedOS || !this.isSeatedExperience()) {
            return;
        }
        this.VRhardware.reset();
    }

    public boolean isInstanceVRRendering() {
        return this.instanceVR && this.isInVR();
    }

    public boolean isInVR() {
        return !this.DISABLE_VR && (this.forceVR || this.VRSupportedOS && this.VRhardware != null && this.VRhardware.isInitialized());
    }

    public Node getGuiNode() {
        return this.guiNode;
    }

    public void setGuiNode(final Node node) {
        if (node != null) {
            if (this.guiViewPort != null) {
                this.enqueue(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        VRApplication.this.guiViewPort.clearScenes();
                        VRApplication.this.guiViewPort.attachScene((Spatial)node);
                        VRApplication.this.guiNode = node;
                        return null;
                    }
                });
            } else {
                throw new IllegalArgumentException("GUI view port is not initialized.");
            }
        }
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public boolean hasTraditionalGUIOverlay() {
        return !this.nogui;
    }

    public Object getObserver() {
        if (this.observer == null) {
            return this.getCamera();
        }
        return this.observer;
    }

    public void setObserver(Spatial observer) {
        this.observer = observer;
    }

    public Quaternion getFinalObserverRotation() {
        if (this.viewmanager == null) {
            if (this.observer == null) {
                return this.getCamera().getRotation();
            }
            return this.observer.getWorldRotation();
        }
        if (this.observer == null) {
            tempq.set(this.dummyCam.getRotation());
        } else {
            tempq.set(this.observer.getWorldRotation());
        }
        return tempq.multLocal(this.VRhardware.getOrientation());
    }

    public Vector3f getFinalObserverPosition() {
        if (this.viewmanager == null) {
            if (this.observer == null) {
                return this.getCamera().getLocation();
            }
            return this.observer.getWorldTranslation();
        }
        Vector3f pos = this.VRhardware.getPosition();
        if (this.observer == null) {
            this.dummyCam.getRotation().mult(pos, pos);
            return pos.addLocal(this.dummyCam.getLocation());
        }
        this.observer.getWorldRotation().mult(pos, pos);
        return pos.addLocal(this.observer.getWorldTranslation());
    }

    public void setVRHeightAdjustment(float amount) {
        if (this.viewmanager != null) {
            this.viewmanager.setHeightAdjustment(amount);
        }
    }

    public float getVRHeightAdjustment() {
        if (this.viewmanager != null) {
            return this.viewmanager.getHeightAdjustment();
        }
        return 0.0f;
    }

    public ViewPort getLeftViewPort() {
        if (this.viewmanager == null) {
            return this.getViewPort();
        }
        return this.viewmanager.getLeftViewPort();
    }

    public ViewPort getRightViewPort() {
        if (this.viewmanager == null) {
            return this.getViewPort();
        }
        return this.viewmanager.getRightViewPort();
    }

    public void setBackgroundColors(ColorRGBA clr) {
        if (this.viewmanager == null) {
            this.getViewPort().setBackgroundColor(clr);
        } else if (this.viewmanager.getLeftViewPort() != null) {
            this.viewmanager.getLeftViewPort().setBackgroundColor(clr);
            if (this.viewmanager.getRightViewPort() != null) {
                this.viewmanager.getRightViewPort().setBackgroundColor(clr);
            }
        }
    }

    protected void runQueuedTasks() {
        AppTask<?> task;
        while ((task = this.taskQueue.poll()) != null) {
            if (task.isCancelled()) continue;
            task.invoke();
        }
    }

    public void update() {
        AudioContext.setAudioRenderer((AudioRenderer)this.audioRenderer);
        this.runQueuedTasks();
        if (this.speed != 0.0f && !this.paused) {
            this.timer.update();
            if (this.inputEnabled) {
                this.inputManager.update(this.timer.getTimePerFrame());
            }
            if (this.audioRenderer != null) {
                this.audioRenderer.update(this.timer.getTimePerFrame());
            }
        }
        if (this.speed == 0.0f || this.paused) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(SimpleApplication.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        float tpf = this.timer.getTimePerFrame() * this.speed;
        this.stateManager.update(tpf);
        this.simpleUpdate(tpf);
        this.stateManager.render(this.renderManager);
        if (this.viewmanager != null) {
            this.viewmanager.update(tpf);
        } else if (this.observer != null) {
            this.getCamera().setFrame(this.observer.getWorldTranslation(), this.observer.getWorldRotation());
        }
        this.rootNode.updateLogicalState(tpf);
        this.guiNode.updateLogicalState(tpf);
        this.rootNode.updateGeometricState();
        if (!this.isInVR() || this.guiManager.getPositioningMode() == VRGUIPositioningMode.MANUAL) {
            this.guiNode.updateGeometricState();
        }
        this.renderManager.render(tpf, this.context.isRenderable());
        this.simpleRender(this.renderManager);
        this.stateManager.postRender();
        if (this.viewmanager != null) {
            this.viewmanager.postRender();
        }
    }

    private void initAssetManager() {
        String assetCfg;
        URL assetCfgUrl = null;
        if (this.settings != null && (assetCfg = this.settings.getString("AssetConfigURL")) != null) {
            try {
                assetCfgUrl = new URL(assetCfg);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (assetCfgUrl == null && (assetCfgUrl = LegacyApplication.class.getClassLoader().getResource(assetCfg)) == null) {
                logger.log(Level.SEVERE, "Unable to access AssetConfigURL in asset config:{0}", assetCfg);
                return;
            }
        }
        if (assetCfgUrl == null) {
            assetCfgUrl = JmeSystem.getPlatformAssetConfigURL();
        }
        if (this.assetManager == null) {
            this.assetManager = JmeSystem.newAssetManager((URL)assetCfgUrl);
            logger.config("Created asset manager from " + assetCfgUrl);
        }
    }

    private void initDisplay() {
        this.settings = this.context.getSettings();
        if (this.timer == null) {
            this.timer = this.context.getTimer();
        }
        this.renderer = this.context.getRenderer();
    }

    private void initAudio() {
        if (this.settings.getAudioRenderer() != null && this.context.getType() != JmeContext.Type.Headless) {
            this.audioRenderer = JmeSystem.newAudioRenderer((AppSettings)this.settings);
            this.audioRenderer.initialize();
            AudioContext.setAudioRenderer((AudioRenderer)this.audioRenderer);
            this.listener = new Listener();
            this.audioRenderer.setListener(this.listener);
        }
    }

    private void initCamera() {
        this.cam = new Camera(this.settings.getWidth(), this.settings.getHeight());
        this.cam.setFrustumPerspective(45.0f, (float)this.cam.getWidth() / (float)this.cam.getHeight(), 1.0f, 1000.0f);
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 10.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        this.renderManager = new RenderManager(this.renderer);
        this.renderManager.setTimer(this.timer);
        this.viewPort = this.renderManager.createMainView("Default", this.cam);
        this.viewPort.setClearFlags(true, true, true);
        Camera guiCam = new Camera(this.settings.getWidth(), this.settings.getHeight());
        this.guiViewPort = this.renderManager.createPostView("Gui Default", guiCam);
        this.guiViewPort.setClearFlags(false, false, false);
    }

    private void initInput() {
        this.mouseInput = this.context.getMouseInput();
        if (this.mouseInput != null) {
            this.mouseInput.initialize();
        }
        this.keyInput = this.context.getKeyInput();
        if (this.keyInput != null) {
            this.keyInput.initialize();
        }
        this.touchInput = this.context.getTouchInput();
        if (this.touchInput != null) {
            this.touchInput.initialize();
        }
        if (!this.settings.getBoolean("DisableJoysticks")) {
            this.joyInput = this.context.getJoyInput();
            if (this.joyInput != null) {
                this.joyInput.initialize();
            }
        }
        this.inputManager = new InputManager(this.mouseInput, this.keyInput, this.joyInput, this.touchInput);
    }

    private void initStateManager() {
        this.stateManager = new AppStateManager((Application)this);
        this.stateManager.attach((AppState)new ResetStatsState());
    }

    private void initialize_internal() {
        if (this.assetManager == null) {
            this.initAssetManager();
        }
        this.initDisplay();
        this.initCamera();
        if (this.inputEnabled) {
            this.initInput();
        }
        this.initAudio();
        this.timer.reset();
    }

    public void initialize() {
        logger.config("Initialize VR application...");
        this.initialize_internal();
        this.cam.setFrustumFar(this.fFar);
        this.cam.setFrustumNear(this.fNear);
        this.dummyCam = this.cam.clone();
        if (this.isInVR()) {
            logger.config("VR mode enabled.");
            if (this.VRhardware != null) {
                this.VRhardware.initVRCompositor(this.compositorAllowed());
            } else {
                logger.warning("No VR system found.");
            }
            this.viewmanager = new OpenVRViewManager(null);
            this.viewmanager.setResolutionMultiplier(this.resMult);
            this.inputManager.addMapping("ResetHMD", new Trigger[]{new KeyTrigger(67)});
            this.setLostFocusBehavior(LostFocusBehavior.Disabled);
        } else {
            logger.config("VR mode disabled.");
            this.viewPort.attachScene((Spatial)this.rootNode);
            this.guiViewPort.attachScene((Spatial)this.guiNode);
        }
        if (this.viewmanager != null) {
            this.viewmanager.initialize();
        }
        this.simpleInitApp();
        if (this.viewmanager != null) {
            this.viewmanager.moveScreenProcessingToEyes();
            if (this.isInVR()) {
                logger.info("VR Initialization Information");
                if (this.viewmanager.getLeftCamera() != null) {
                    logger.info("camLeft: " + this.viewmanager.getLeftCamera().toString());
                }
                if (this.viewmanager.getRightCamera() != null) {
                    logger.info("camRight: " + this.viewmanager.getRightCamera().toString());
                }
            }
        }
    }

    public abstract void simpleInitApp();

    public void destroy() {
        if (this.VRhardware != null) {
            this.VRhardware.destroy();
            this.VRhardware = null;
        }
        this.DISABLE_VR = true;
        this.stateManager.cleanup();
        this.destroyInput();
        if (this.audioRenderer != null) {
            this.audioRenderer.cleanup();
        }
        this.timer.reset();
        Runtime.getRuntime().exit(0);
    }

    protected void destroyInput() {
        if (this.mouseInput != null) {
            this.mouseInput.destroy();
        }
        if (this.keyInput != null) {
            this.keyInput.destroy();
        }
        if (this.joyInput != null) {
            this.joyInput.destroy();
        }
        if (this.touchInput != null) {
            this.touchInput.destroy();
        }
        this.inputManager = null;
    }

    public ViewPort getGuiViewPort() {
        return this.guiViewPort;
    }

    public ViewPort getViewPort() {
        return this.viewPort;
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        AppTask task = new AppTask(callable);
        this.taskQueue.add(task);
        return task;
    }

    public void enqueue(Runnable runnable) {
        this.enqueue(new RunnableWrapper(runnable));
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean waitFor) {
        logger.log(Level.FINE, "Closing application: {0}", this.getClass().getName());
        this.context.destroy(waitFor);
    }

    public void restart() {
        this.context.setSettings(this.settings);
        this.context.restart();
    }

    public void setAppProfiler(AppProfiler prof) {
    }

    public AppProfiler getAppProfiler() {
        return null;
    }

    private class RunnableWrapper
    implements Callable<Object> {
        private final Runnable runnable;

        public RunnableWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public Object call() {
            this.runnable.run();
            return null;
        }
    }

    public static enum PreconfigParameter {
        USE_VR_COMPOSITOR,
        FORCE_VR_MODE,
        FLIP_EYES,
        SET_GUI_OVERDRAW,
        SET_GUI_CURVED_SURFACE,
        ENABLE_MIRROR_WINDOW,
        PREFER_OPENGL3,
        DISABLE_VR,
        SEATED_EXPERIENCE,
        NO_GUI,
        INSTANCE_VR_RENDERING,
        FORCE_DISABLE_MSAA;

    }
}

