/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.VRBounds;
import com.jme3.input.vr.VRInputAPI;
import com.jme3.input.vr.VRMouseManager;
import com.jme3.input.vr.VRViewManager;
import com.jme3.input.vr.oculus.OculusMouseManager;
import com.jme3.input.vr.oculus.OculusVR;
import com.jme3.input.vr.oculus.OculusViewManager;
import com.jme3.input.vr.openvr.OpenVR;
import com.jme3.input.vr.openvr.OpenVRMouseManager;
import com.jme3.input.vr.openvr.OpenVRViewManager;
import com.jme3.input.vr.osvr.OSVR;
import com.jme3.input.vr.osvr.OSVRViewManager;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.util.VRGuiManager;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VREnvironment {
    private static final Logger logger = Logger.getLogger(VREnvironment.class.getName());
    private VRAPI hardware = null;
    private VRGuiManager guiManager = null;
    private VRMouseManager mouseManager = null;
    private VRViewManager viewmanager = null;
    private VRBounds bounds = null;
    public int vrBinding = 1;
    private boolean seated = false;
    private Spatial observer = null;
    private boolean forceVR = false;
    private boolean vrSupportedOS = false;
    private boolean nogui = false;
    private boolean compositorOS;
    private boolean useCompositor = true;
    private boolean instanceRendering = false;
    private boolean disableSwapBuffers = true;
    private float defaultFOV = 108.0f;
    private float defaultAspect = 1.0f;
    private AppSettings settings = null;
    private Application application = null;
    private Camera dummyCam = null;
    private AppState app = null;
    private boolean initialized = false;

    public VREnvironment(AppSettings settings) {
        this.settings = settings;
        this.bounds = null;
        this.processSettings();
    }

    public VRAPI getVRHardware() {
        return this.hardware;
    }

    public void setVRBounds(VRBounds bounds) {
        this.bounds = bounds;
    }

    public VRBounds getVRBounds() {
        return this.bounds;
    }

    public VRInputAPI getVRinput() {
        if (this.hardware == null) {
            return null;
        }
        return this.hardware.getVRinput();
    }

    public VRViewManager getVRViewManager() {
        return this.viewmanager;
    }

    public VRGuiManager getVRGUIManager() {
        return this.guiManager;
    }

    public VRMouseManager getVRMouseManager() {
        return this.mouseManager;
    }

    public void setSeatedExperience(boolean isSeated) {
        this.seated = isSeated;
        if (this.hardware instanceof OpenVR) {
            if (this.hardware.getCompositor() == null) {
                return;
            }
            if (this.seated) {
                ((OpenVR)this.hardware).getCompositor().SetTrackingSpace.apply(0);
            } else {
                ((OpenVR)this.hardware).getCompositor().SetTrackingSpace.apply(1);
            }
        }
    }

    public boolean isSeatedExperience() {
        return this.seated;
    }

    public void setVRHeightAdjustment(float amount) {
        if (this.viewmanager != null) {
            this.viewmanager.setHeightAdjustment(amount);
        }
    }

    public float getVRHeightAdjustment() {
        if (this.viewmanager != null) {
            return this.viewmanager.getHeightAdjustment();
        }
        return 0.0f;
    }

    public Object getObserver() {
        if (this.observer == null) {
            if (this.application != null) {
                return this.application.getCamera();
            }
            throw new IllegalStateException("VR environment is not attached to any application.");
        }
        return this.observer;
    }

    public void setObserver(Spatial observer) {
        this.observer = observer;
    }

    public float getDefaultFOV() {
        return this.defaultFOV;
    }

    public void setDefaultFOV(float defaultFOV) {
        this.defaultFOV = defaultFOV;
    }

    public float getDefaultAspect() {
        return this.defaultAspect;
    }

    public void setDefaultAspect(float defaultAspect) {
        this.defaultAspect = defaultAspect;
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public void setSettings(AppSettings settings) {
        this.settings = settings;
        this.processSettings();
    }

    public boolean isVRSupported() {
        return this.vrSupportedOS;
    }

    public boolean isInVR() {
        return this.forceVR || this.vrSupportedOS && this.hardware != null && this.hardware.isInitialized() && this.isInitialized();
    }

    public boolean isInstanceRendering() {
        return this.instanceRendering;
    }

    public boolean isSwapBuffers() {
        return this.disableSwapBuffers;
    }

    public boolean hasTraditionalGUIOverlay() {
        return !this.nogui;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean compositorAllowed() {
        return this.useCompositor && this.compositorOS;
    }

    public void resetSeatedPose() {
        if (!this.vrSupportedOS || !this.isSeatedExperience()) {
            return;
        }
        this.getVRHardware().reset();
    }

    public AppState getAppState() {
        return this.app;
    }

    public Application getApplication() {
        return this.application;
    }

    public Camera getCamera() {
        if (this.isInVR() && this.getVRViewManager() != null && this.getVRViewManager().getLeftCamera() != null) {
            return this.getDummyCamera();
        }
        return this.application.getCamera();
    }

    public Camera getDummyCamera() {
        if (this.dummyCam == null) {
            if (this.application != null) {
                this.dummyCam = this.application.getCamera() != null ? this.application.getCamera().clone() : (this.settings != null && this.settings.getWidth() != 0 && this.settings.getHeight() != 0 ? new Camera(this.settings.getWidth(), this.settings.getHeight()) : new Camera());
            } else {
                throw new IllegalStateException("VR environment is not attached to any application.");
            }
        }
        return this.dummyCam;
    }

    public void atttach(AppState appState, Application application) {
        this.application = application;
        this.app = appState;
        if (this.vrBinding == 1) {
            this.viewmanager = new OpenVRViewManager(this);
        } else if (this.vrBinding == 2) {
            this.viewmanager = new OSVRViewManager(this);
        } else if (this.vrBinding == 4) {
            this.viewmanager = new OculusViewManager(this);
        } else {
            logger.severe("Cannot instanciate view manager, unknown VRAPI type: " + this.vrBinding);
        }
    }

    public boolean initialize() {
        logger.config("Initializing VR environment.");
        this.initialized = false;
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        this.vrSupportedOS = !OS.contains("nux") && System.getProperty("sun.arch.data.model").equalsIgnoreCase("64");
        this.compositorOS = OS.contains("indows");
        if (this.vrSupportedOS) {
            if (this.vrBinding == 2) {
                this.guiManager = new VRGuiManager(this);
                this.mouseManager = new OpenVRMouseManager(this);
                this.hardware = new OSVR(this);
                this.initialized = true;
                logger.config("Creating OSVR wrapper [SUCCESS]");
            } else if (this.vrBinding == 1) {
                this.guiManager = new VRGuiManager(this);
                this.mouseManager = new OpenVRMouseManager(this);
                this.hardware = new OpenVR(this);
                this.initialized = true;
                logger.config("Creating OpenVR wrapper [SUCCESS]");
            } else if (this.vrBinding == 4) {
                this.guiManager = new VRGuiManager(this);
                this.mouseManager = new OculusMouseManager(this);
                this.hardware = new OculusVR(this);
                this.initialized = true;
                logger.config("Creating Occulus Rift wrapper [SUCCESS]");
            } else {
                logger.config("Cannot create VR binding: " + this.vrBinding + " [FAILED]");
                logger.log(Level.SEVERE, "Cannot initialize VR environment [FAILED]");
            }
            if (this.hardware.initialize()) {
                this.initialized &= true;
                logger.config("VR native wrapper initialized [SUCCESS]");
            } else {
                this.initialized &= false;
                logger.warning("VR native wrapper initialized [FAILED]");
                logger.log(Level.SEVERE, "Cannot initialize VR environment [FAILED]");
            }
        } else {
            logger.log(Level.SEVERE, "System does not support VR capabilities.");
            logger.log(Level.SEVERE, "Cannot initialize VR environment [FAILED]");
        }
        return this.initialized;
    }

    private void processSettings() {
        if (this.settings != null) {
            if (this.settings.get((Object)"VRUseCompositor") != null) {
                this.useCompositor = this.settings.getBoolean("VRUseCompositor");
                if (!this.useCompositor) {
                    this.disableSwapBuffers = false;
                }
            }
            if (this.settings.get((Object)"VREnableMirrorWindow") != null) {
                if (!this.useCompositor) {
                    this.disableSwapBuffers = false;
                } else {
                    boolean bl = this.disableSwapBuffers = !this.settings.getBoolean("VREnableMirrorWindow");
                }
            }
            if (this.settings.get((Object)"VRGUIOverdraw") != null) {
                this.getVRGUIManager().setGuiOverdraw(this.settings.getBoolean("VRGUIOverdraw"));
            }
            if (this.settings.get((Object)"VRGUICurvedSurface") != null) {
                this.getVRGUIManager().setCurvedSurface(this.settings.getBoolean("VRGUICurvedSurface"));
            }
            if (this.settings.get((Object)"VRNoGUI") != null) {
                this.nogui = this.settings.getBoolean("VRNoGUI");
            }
            if (this.settings.get((Object)"VRAPI") != null) {
                this.vrBinding = this.settings.getInteger("VRAPI");
            }
            if (this.settings.get((Object)"VRSeatedExperience") != null) {
                this.seated = this.settings.getBoolean("VRSeatedExperience");
            }
            if (this.settings.get((Object)"VRInstanceRendering") != null) {
                this.instanceRendering = this.settings.getBoolean("VRInstanceRendering");
            }
            if (this.settings.get((Object)"VRDefaultFOV") != null) {
                this.defaultFOV = this.settings.getFloat("VRDefaultFOV");
            }
            if (this.settings.get((Object)"VRDefaultAspectRatio") != null) {
                this.defaultAspect = this.settings.getFloat("VRDefaultAspectRatio");
            }
            if (this.settings.get((Object)"VRFlipEyes") != null && this.getVRHardware() != null) {
                this.getVRHardware().setFlipEyes(this.settings.getBoolean("VRFlipEyes"));
            }
        }
    }
}

