/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.input.KeyInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.input.lwjgl.GlfwKeyInput;
import com.jme3.input.lwjgl.GlfwKeyMap;
import com.jme3.system.lwjgl.LwjglWindowVR;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;

public class GlfwKeyInputVR
implements KeyInput {
    private static final Logger logger = Logger.getLogger(GlfwKeyInput.class.getName());
    private LwjglWindowVR context;
    private RawInputListener listener;
    private boolean initialized;
    private boolean shift_pressed;
    private GLFWKeyCallback keyCallback;
    private Queue<KeyInputEvent> keyInputEvents = new LinkedList<KeyInputEvent>();

    public GlfwKeyInputVR(LwjglWindowVR context) {
        this.context = context;
    }

    public void initialize() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.keyCallback = new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int action, int mods) {
                scancode = GlfwKeyMap.toJmeKeyCode((int)key);
                if (key == 340 || key == 344) {
                    GlfwKeyInputVR.this.shift_pressed = action == 1;
                } else if (key >= 65 && key <= 90 && !GlfwKeyInputVR.this.shift_pressed) {
                    key += 32;
                } else if (key >= 97 && key <= 122 && GlfwKeyInputVR.this.shift_pressed) {
                    key -= 32;
                }
                KeyInputEvent evt = new KeyInputEvent(scancode, (char)key, 1 == action, 2 == action);
                evt.setTime(GlfwKeyInputVR.this.getInputTimeNanos());
                GlfwKeyInputVR.this.keyInputEvents.add(evt);
            }
        };
        GLFW.glfwSetKeyCallback((long)this.context.getWindowHandle(), (GLFWKeyCallbackI)this.keyCallback);
        GLFW.glfwSetInputMode((long)this.context.getWindowHandle(), (int)208898, (int)1);
        this.initialized = true;
        logger.fine("Keyboard created.");
    }

    public int getKeyCount() {
        return 316;
    }

    public void update() {
        if (!this.context.isRenderable()) {
            return;
        }
        while (!this.keyInputEvents.isEmpty()) {
            this.listener.onKeyEvent(this.keyInputEvents.poll());
        }
    }

    public void destroy() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.keyCallback.free();
        logger.fine("Keyboard destroyed.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }
}

