/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.lwjgl;

import com.jme3.cursors.plugins.JmeCursor;
import com.jme3.input.MouseInput;
import com.jme3.input.RawInputListener;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.input.event.MouseMotionEvent;
import com.jme3.system.lwjgl.LwjglWindowVR;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;

public class GlfwMouseInputVR
implements MouseInput {
    private static final Logger logger = Logger.getLogger(GlfwMouseInputVR.class.getName());
    private static final int WHEEL_SCALE = 120;
    private LwjglWindowVR context;
    private RawInputListener listener;
    private boolean cursorVisible = true;
    private int mouseX;
    private int xDelta;
    private int mouseY;
    private int yDelta;
    private int mouseWheel;
    private boolean initialized;
    private GLFWCursorPosCallback cursorPosCallback;
    private GLFWScrollCallback scrollCallback;
    private GLFWMouseButtonCallback mouseButtonCallback;
    private Queue<MouseMotionEvent> mouseMotionEvents = new LinkedList<MouseMotionEvent>();
    private Queue<MouseButtonEvent> mouseButtonEvents = new LinkedList<MouseButtonEvent>();
    private Map<JmeCursor, Long> jmeToGlfwCursorMap = new HashMap<JmeCursor, Long>();

    public GlfwMouseInputVR(LwjglWindowVR context) {
        this.context = context;
    }

    private void onCursorPos(long window, double xpos, double ypos) {
        int x = (int)Math.round(xpos);
        int y = this.context.getSettings().getHeight() - (int)Math.round(ypos);
        if (this.mouseX == 0) {
            this.mouseX = x;
        }
        if (this.mouseY == 0) {
            this.mouseY = y;
        }
        this.xDelta = x - this.mouseX;
        this.yDelta = y - this.mouseY;
        this.mouseX = x;
        this.mouseY = y;
        if (this.xDelta != 0 || this.yDelta != 0) {
            MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(x, y, this.xDelta, this.yDelta, this.mouseWheel, 0);
            mouseMotionEvent.setTime(this.getInputTimeNanos());
            this.mouseMotionEvents.add(mouseMotionEvent);
        }
    }

    private void onWheelScroll(long window, double xOffset, double yOffset) {
        this.mouseWheel = (int)((double)this.mouseWheel + yOffset);
        MouseMotionEvent mouseMotionEvent = new MouseMotionEvent(this.mouseX, this.mouseY, 0, 0, this.mouseWheel, (int)Math.round(yOffset));
        mouseMotionEvent.setTime(this.getInputTimeNanos());
        this.mouseMotionEvents.add(mouseMotionEvent);
    }

    private void onMouseButton(long window, int button, int action, int mods) {
        MouseButtonEvent mouseButtonEvent = new MouseButtonEvent(this.convertButton(button), action == 1, this.mouseX, this.mouseY);
        mouseButtonEvent.setTime(this.getInputTimeNanos());
        this.mouseButtonEvents.add(mouseButtonEvent);
    }

    public void initialize() {
        this.cursorPosCallback = new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                GlfwMouseInputVR.this.onCursorPos(window, xpos, ypos);
            }
        };
        GLFW.glfwSetCursorPosCallback((long)this.context.getWindowHandle(), (GLFWCursorPosCallbackI)this.cursorPosCallback);
        this.scrollCallback = new GLFWScrollCallback(){

            public void invoke(long window, double xOffset, double yOffset) {
                GlfwMouseInputVR.this.onWheelScroll(window, xOffset, yOffset * 120.0);
            }
        };
        GLFW.glfwSetScrollCallback((long)this.context.getWindowHandle(), (GLFWScrollCallbackI)this.scrollCallback);
        this.mouseButtonCallback = new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                GlfwMouseInputVR.this.onMouseButton(window, button, action, mods);
            }
        };
        GLFW.glfwSetMouseButtonCallback((long)this.context.getWindowHandle(), (GLFWMouseButtonCallbackI)this.mouseButtonCallback);
        this.setCursorVisible(this.cursorVisible);
        logger.fine("Mouse created.");
        this.initialized = true;
    }

    public void setCursorPosition(int x, int y) {
        if (!this.context.isRenderable()) {
            return;
        }
        GLFW.glfwSetCursorPos((long)this.context.getWindowHandle(), (double)x, (double)y);
    }

    public void hideActiveCursor() {
        if (!this.context.isRenderable()) {
            return;
        }
        if (this.cursorVisible) {
            GLFW.glfwSetInputMode((long)this.context.getWindowHandle(), (int)208897, (int)212994);
        }
    }

    public int getLastDeltaX() {
        return this.xDelta;
    }

    public int getLastDeltaY() {
        return this.yDelta;
    }

    public void clearDeltas() {
        this.xDelta = 0;
        this.yDelta = 0;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getButtonCount() {
        return 8;
    }

    public void update() {
        while (!this.mouseMotionEvents.isEmpty()) {
            this.listener.onMouseMotionEvent(this.mouseMotionEvents.poll());
        }
        while (!this.mouseButtonEvents.isEmpty()) {
            this.listener.onMouseButtonEvent(this.mouseButtonEvents.poll());
        }
    }

    public void destroy() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.cursorPosCallback.free();
        this.scrollCallback.free();
        this.mouseButtonCallback.free();
        for (long glfwCursor : this.jmeToGlfwCursorMap.values()) {
            GLFW.glfwDestroyCursor((long)glfwCursor);
        }
        logger.fine("Mouse destroyed.");
    }

    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
        if (!this.context.isRenderable()) {
            return;
        }
        if (this.cursorVisible) {
            GLFW.glfwSetInputMode((long)this.context.getWindowHandle(), (int)208897, (int)212993);
        } else {
            GLFW.glfwSetInputMode((long)this.context.getWindowHandle(), (int)208897, (int)212995);
        }
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }

    private long createGlfwCursor(JmeCursor jmeCursor) {
        GLFWImage glfwImage = new GLFWImage(BufferUtils.createByteBuffer((int)GLFWImage.SIZEOF));
        IntBuffer imageData = jmeCursor.getImagesData();
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(imageData.capacity() * 4));
        buf.asIntBuffer().put(imageData);
        glfwImage.set(jmeCursor.getWidth(), jmeCursor.getHeight(), buf);
        return GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)jmeCursor.getXHotSpot(), (int)jmeCursor.getYHotSpot());
    }

    public void setNativeCursor(JmeCursor jmeCursor) {
        if (jmeCursor != null) {
            Long glfwCursor = this.jmeToGlfwCursorMap.get(jmeCursor);
            if (glfwCursor == null) {
                glfwCursor = this.createGlfwCursor(jmeCursor);
                this.jmeToGlfwCursorMap.put(jmeCursor, glfwCursor);
            }
            GLFW.glfwSetCursor((long)this.context.getWindowHandle(), (long)glfwCursor);
        } else {
            GLFW.glfwSetCursor((long)this.context.getWindowHandle(), (long)0L);
        }
    }

    private int convertButton(int glfwButton) {
        switch (glfwButton) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return glfwButton;
    }
}

