/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr;

import com.jme3.app.VREnvironment;
import com.jme3.input.MouseInput;
import com.jme3.input.lwjgl.GlfwMouseInputVR;
import com.jme3.input.vr.VRMouseManager;
import com.jme3.material.RenderState;
import com.jme3.math.Vector2f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import com.jme3.system.lwjgl.LwjglWindow;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractVRMouseManager
implements VRMouseManager {
    private static final Logger logger = Logger.getLogger(AbstractVRMouseManager.class.getName());
    private VREnvironment environment = null;
    private Picture mouseImage;
    private int recentCenterCount = 0;
    protected final Vector2f cursorPos = new Vector2f();
    private float ySize;
    private float sensitivity = 8.0f;
    private float acceleration = 2.0f;
    private boolean thumbstickMode;
    private float moveScale = 1.0f;

    public AbstractVRMouseManager(VREnvironment environment) {
        this.environment = environment;
    }

    @Override
    public void initialize() {
        logger.config("Initializing VR mouse manager.");
        this.mouseImage = new Picture("mouse");
        this.setImage("Common/Util/mouse.png");
        MouseInput mi = this.environment.getApplication().getContext().getMouseInput();
        if (mi instanceof GlfwMouseInputVR) {
            ((GlfwMouseInputVR)mi).hideActiveCursor();
        }
        this.centerMouse();
        logger.config("Initialized VR mouse manager [SUCCESS]");
    }

    @Override
    public VREnvironment getVREnvironment() {
        return this.environment;
    }

    @Override
    public void setThumbstickMode(boolean set) {
        this.thumbstickMode = set;
    }

    @Override
    public boolean isThumbstickMode() {
        return this.thumbstickMode;
    }

    @Override
    public void setSpeed(float sensitivity, float acceleration) {
        this.sensitivity = sensitivity;
        this.acceleration = acceleration;
    }

    @Override
    public float getSpeedSensitivity() {
        return this.sensitivity;
    }

    @Override
    public float getSpeedAcceleration() {
        return this.acceleration;
    }

    @Override
    public float getMouseMoveScale() {
        return this.moveScale;
    }

    @Override
    public void setMouseMoveScale(float set) {
        this.moveScale = set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setImage(String texture) {
        if (this.environment == null) throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        if (this.environment.getApplication() == null) throw new IllegalStateException("This VR environment is not attached to any application.");
        if (!this.environment.isInVR()) {
            Texture tex = this.environment.getApplication().getAssetManager().loadTexture(texture);
            this.mouseImage.setTexture(this.environment.getApplication().getAssetManager(), (Texture2D)tex, true);
            this.ySize = tex.getImage().getHeight();
            this.mouseImage.setHeight(this.ySize);
            this.mouseImage.setWidth((float)tex.getImage().getWidth());
            this.mouseImage.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            this.mouseImage.getMaterial().getAdditionalRenderState().setDepthWrite(false);
            return;
        } else {
            Texture tex = this.environment.getApplication().getAssetManager().loadTexture(texture);
            this.mouseImage.setTexture(this.environment.getApplication().getAssetManager(), (Texture2D)tex, true);
            this.ySize = tex.getImage().getHeight();
            this.mouseImage.setHeight(this.ySize);
            this.mouseImage.setWidth((float)tex.getImage().getWidth());
            this.mouseImage.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            this.mouseImage.getMaterial().getAdditionalRenderState().setDepthWrite(false);
        }
    }

    @Override
    public Vector2f getCursorPosition() {
        if (this.environment != null) {
            if (this.environment.getApplication() != null) {
                if (this.environment.isInVR()) {
                    return this.cursorPos;
                }
                return this.environment.getApplication().getInputManager().getCursorPosition();
            }
            throw new IllegalStateException("This VR environment is not attached to any application.");
        }
        throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void centerMouse() {
        if (this.environment == null) throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        if (this.environment.getApplication() == null) throw new IllegalStateException("This VR environment is not attached to any application.");
        Vector2f size = this.environment.getVRGUIManager().getCanvasSize();
        MouseInput mi = this.environment.getApplication().getContext().getMouseInput();
        AppSettings as = this.environment.getApplication().getContext().getSettings();
        if (mi instanceof GlfwMouseInputVR) {
            ((GlfwMouseInputVR)mi).setCursorPosition((int)((float)as.getWidth() / 2.0f), (int)((float)as.getHeight() / 2.0f));
        }
        if (!this.environment.isInVR()) return;
        this.cursorPos.x = size.x / 2.0f;
        this.cursorPos.y = size.y / 2.0f;
        this.recentCenterCount = 2;
    }

    @Override
    public void update(float tpf) {
        if (this.environment.getApplication().getInputManager().isCursorVisible()) {
            MouseInput mi;
            if (this.mouseImage.getParent() == null) {
                this.environment.getApplication().getGuiViewPort().attachScene((Spatial)this.mouseImage);
                this.centerMouse();
                if (this.environment.getApplication().getContext() instanceof LwjglWindow) {
                    GLFW.glfwSetInputMode((long)((LwjglWindow)this.environment.getApplication().getContext()).getWindowHandle(), (int)208897, (int)212995);
                }
            }
            if ((mi = this.environment.getApplication().getContext().getMouseInput()) instanceof GlfwMouseInputVR) {
                if (this.recentCenterCount <= 0) {
                    this.cursorPos.x += (float)((GlfwMouseInputVR)mi).getLastDeltaX();
                    this.cursorPos.y += (float)((GlfwMouseInputVR)mi).getLastDeltaY();
                    if (this.cursorPos.x < 0.0f) {
                        this.cursorPos.x = 0.0f;
                    }
                    if (this.cursorPos.y < 0.0f) {
                        this.cursorPos.y = 0.0f;
                    }
                    if (this.cursorPos.x > this.environment.getVRGUIManager().getCanvasSize().x) {
                        this.cursorPos.x = this.environment.getVRGUIManager().getCanvasSize().x;
                    }
                    if (this.cursorPos.y > this.environment.getVRGUIManager().getCanvasSize().y) {
                        this.cursorPos.y = this.environment.getVRGUIManager().getCanvasSize().y;
                    }
                } else {
                    --this.recentCenterCount;
                }
                ((GlfwMouseInputVR)mi).clearDeltas();
            }
            Vector2f currentPos = this.getCursorPosition();
            this.mouseImage.setLocalTranslation(currentPos.x, currentPos.y - this.ySize, this.environment.getVRGUIManager().getGuiDistance() + 1.0f);
            this.mouseImage.updateGeometricState();
        } else if (this.mouseImage.getParent() != null) {
            Node n = this.mouseImage.getParent();
            this.mouseImage.removeFromParent();
            if (n != null) {
                n.updateGeometricState();
            }
        }
    }
}

