/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.VRViewManager;
import com.jme3.post.CartoonSSAO;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.FilterUtil;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.FogFilter;
import com.jme3.post.filters.TranslucentBucketFilter;
import com.jme3.post.ssao.SSAOFilter;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.shadow.DirectionalLightShadowFilter;
import com.jme3.shadow.VRDirectionalLightShadowRenderer;
import com.jme3.texture.Texture2D;

public abstract class AbstractVRViewManager
implements VRViewManager {
    protected VREnvironment environment = null;
    protected Camera leftCamera;
    protected ViewPort leftViewPort;
    protected FilterPostProcessor leftPostProcessor;
    protected Texture2D leftEyeTexture;
    protected Texture2D leftEyeDepth;
    protected Camera rightCamera;
    protected ViewPort rightViewPort;
    protected FilterPostProcessor rightPostProcessor;
    protected Texture2D rightEyeTexture;
    protected Texture2D rightEyeDepth;
    protected ViewPort mirrorViewPort;
    private float resMult = 1.0f;
    private float heightAdjustment;

    @Override
    public Camera getLeftCamera() {
        return this.leftCamera;
    }

    @Override
    public Camera getRightCamera() {
        return this.rightCamera;
    }

    @Override
    public ViewPort getLeftViewPort() {
        return this.leftViewPort;
    }

    @Override
    public ViewPort getRightViewPort() {
        return this.rightViewPort;
    }

    @Override
    public ViewPort getMirrorViewPort() {
        return this.mirrorViewPort;
    }

    @Override
    public Texture2D getLeftTexture() {
        return this.leftEyeTexture;
    }

    @Override
    public Texture2D getRightTexture() {
        return this.rightEyeTexture;
    }

    @Override
    public Texture2D getLeftDepth() {
        return this.leftEyeDepth;
    }

    @Override
    public Texture2D getRightDepth() {
        return this.rightEyeDepth;
    }

    @Override
    public FilterPostProcessor getLeftPostProcessor() {
        return this.leftPostProcessor;
    }

    @Override
    public FilterPostProcessor getRightPostProcessor() {
        return this.rightPostProcessor;
    }

    @Override
    public float getResolutionMuliplier() {
        return this.resMult;
    }

    @Override
    public void setResolutionMultiplier(float resMult) {
        this.resMult = resMult;
    }

    @Override
    public float getHeightAdjustment() {
        return this.heightAdjustment;
    }

    @Override
    public void setHeightAdjustment(float amount) {
        this.heightAdjustment = amount;
    }

    @Override
    public VREnvironment getVREnvironment() {
        return this.environment;
    }

    @Override
    public void moveScreenProcessingToEyes() {
        if (this.environment != null) {
            if (this.getRightViewPort() == null) {
                return;
            }
            if (this.environment.getApplication() == null) {
                throw new IllegalStateException("The VR environment is not attached to any application.");
            }
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
        this.syncScreenProcessing(this.environment.getApplication().getViewPort());
        this.environment.getApplication().getViewPort().clearProcessors();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void syncScreenProcessing(ViewPort sourceViewport) {
        if (this.environment == null) throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        if (this.getRightViewPort() == null) {
            return;
        }
        if (this.environment.getApplication() == null) throw new IllegalStateException("The VR environment is not attached to any application.");
        if (this.getRightPostProcessor() == null) {
            this.rightPostProcessor = new FilterPostProcessor(this.environment.getApplication().getAssetManager());
            this.leftPostProcessor = new FilterPostProcessor(this.environment.getApplication().getAssetManager());
        }
        this.getRightPostProcessor().removeAllFilters();
        this.getLeftPostProcessor().removeAllFilters();
        this.getLeftViewPort().clearProcessors();
        this.getRightViewPort().clearProcessors();
        if (sourceViewport.getProcessors().isEmpty()) {
            return;
        }
        this.getLeftViewPort().addProcessor((SceneProcessor)this.getLeftPostProcessor());
        this.getRightViewPort().addProcessor((SceneProcessor)this.getRightPostProcessor());
        for (SceneProcessor sceneProcessor : sourceViewport.getProcessors()) {
            if (sceneProcessor instanceof FilterPostProcessor) {
                for (Filter f : ((FilterPostProcessor)sceneProcessor).getFilterList()) {
                    void var6_6;
                    if (f instanceof TranslucentBucketFilter) {
                        ((FilterPostProcessor)sceneProcessor).removeFilter(f);
                        continue;
                    }
                    this.getLeftPostProcessor().addFilter(f);
                    if (f instanceof FogFilter) {
                        FogFilter fogFilter = FilterUtil.cloneFogFilter((FogFilter)f);
                    } else if (f instanceof CartoonSSAO) {
                        CartoonSSAO cartoonSSAO = new CartoonSSAO((CartoonSSAO)f);
                    } else if (f instanceof SSAOFilter) {
                        SSAOFilter sSAOFilter = FilterUtil.cloneSSAOFilter((SSAOFilter)f);
                    } else if (f instanceof DirectionalLightShadowFilter) {
                        DirectionalLightShadowFilter directionalLightShadowFilter = FilterUtil.cloneDirectionalLightShadowFilter(this.environment.getApplication().getAssetManager(), (DirectionalLightShadowFilter)f);
                    } else {
                        Filter filter = f;
                    }
                    this.getRightPostProcessor().addFilter((Filter)var6_6);
                }
                continue;
            }
            if (!(sceneProcessor instanceof VRDirectionalLightShadowRenderer)) continue;
            VRDirectionalLightShadowRenderer dlsr = (VRDirectionalLightShadowRenderer)sceneProcessor;
            VRDirectionalLightShadowRenderer dlsrRight = dlsr.clone();
            dlsrRight.setLight(dlsr.getLight());
            this.getRightViewPort().getProcessors().add(0, (Object)dlsrRight);
            this.getLeftViewPort().getProcessors().add(0, (Object)sceneProcessor);
        }
        this.getLeftPostProcessor().addFilter((Filter)new TranslucentBucketFilter());
        this.getRightPostProcessor().addFilter((Filter)new TranslucentBucketFilter());
    }
}

