/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.oculus;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.HmdType;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.oculus.OculusVRInput;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture2D;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVR;
import org.lwjgl.ovr.OVRDetectResult;
import org.lwjgl.ovr.OVREyeRenderDesc;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRGL;
import org.lwjgl.ovr.OVRGraphicsLuid;
import org.lwjgl.ovr.OVRHmdDesc;
import org.lwjgl.ovr.OVRInitParams;
import org.lwjgl.ovr.OVRLayerEyeFov;
import org.lwjgl.ovr.OVRLogCallback;
import org.lwjgl.ovr.OVRLogCallbackI;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRSessionStatus;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.ovr.OVRTextureSwapChainDesc;
import org.lwjgl.ovr.OVRTrackingState;
import org.lwjgl.ovr.OVRUtil;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class OculusVR
implements VRAPI {
    private static final Logger LOGGER = Logger.getLogger(OculusVR.class.getName());
    private final VREnvironment environment;
    private boolean initialized;
    private long session;
    private OVRSessionStatus sessionStatus;
    private OVRHmdDesc hmdDesc;
    private int resolutionW;
    private int resolutionH;
    private final OVRFovPort[] fovPorts = new OVRFovPort[2];
    private final OVREyeRenderDesc[] eyeRenderDesc = new OVREyeRenderDesc[2];
    private final OVRMatrix4f[] projections = new OVRMatrix4f[2];
    private final Matrix4f[] hmdRelativeEyePoses = new Matrix4f[2];
    private final Vector3f[] hmdRelativeEyePositions = new Vector3f[2];
    private OVRTrackingState trackingState;
    private OVRPosef headPose;
    private OculusVRInput input;
    private int textureW;
    private int textureH;
    private PointerBuffer layers;
    private OVRLayerEyeFov layer0;
    private long[] chains;
    private FrameBuffer[][] framebuffers;

    public OculusVR(VREnvironment environment) {
        this.environment = environment;
    }

    @Override
    public OculusVRInput getVRinput() {
        return this.input;
    }

    @Override
    public String getName() {
        return "OVR";
    }

    @Override
    public int getDisplayFrequency() {
        return 60;
    }

    @Override
    public boolean initialize() {
        int eye;
        OVRDetectResult detect = OVRDetectResult.calloc();
        OVRUtil.ovr_Detect((int)0, (OVRDetectResult)detect);
        boolean connected = detect.IsOculusHMDConnected();
        LOGGER.config("OVRDetectResult.IsOculusHMDConnected = " + connected);
        LOGGER.config("OVRDetectResult.IsOculusServiceRunning = " + detect.IsOculusServiceRunning());
        detect.free();
        if (!connected) {
            LOGGER.info("Oculus Rift not connected");
            return false;
        }
        this.initialized = true;
        OVRLogCallback callback = new OVRLogCallback(){

            public void invoke(long userData, int level, long message) {
                LOGGER.fine("LibOVR [" + userData + "] [" + level + "] " + MemoryUtil.memASCII((long)message));
            }
        };
        OVRInitParams initParams = OVRInitParams.calloc();
        initParams.LogCallback((OVRLogCallbackI)callback);
        if (OVR.ovr_Initialize((OVRInitParams)initParams) != 0) {
            LOGGER.severe("LibOVR Init Failed");
            return false;
        }
        LOGGER.config("LibOVR Version " + OVR.ovr_GetVersionString());
        initParams.free();
        LOGGER.info("Initialize HMD Session");
        PointerBuffer pHmd = MemoryUtil.memAllocPointer((int)1);
        OVRGraphicsLuid luid = OVRGraphicsLuid.calloc();
        if (OVR.ovr_Create((PointerBuffer)pHmd, (OVRGraphicsLuid)luid) != 0) {
            LOGGER.severe("Failed to create HMD");
            return false;
        }
        this.session = pHmd.get(0);
        MemoryUtil.memFree((PointerBuffer)pHmd);
        luid.free();
        this.sessionStatus = OVRSessionStatus.calloc();
        LOGGER.fine("Get HMD properties");
        this.hmdDesc = OVRHmdDesc.malloc();
        OVR.ovr_GetHmdDesc((long)this.session, (OVRHmdDesc)this.hmdDesc);
        if (this.hmdDesc.Type() == 0) {
            LOGGER.warning("No HMD connected");
            return false;
        }
        this.resolutionW = this.hmdDesc.Resolution().w();
        this.resolutionH = this.hmdDesc.Resolution().h();
        LOGGER.config("HMD Properties: \t Manufacturer: " + this.hmdDesc.ManufacturerString() + "\t Product: " + this.hmdDesc.ProductNameString() + "\t Serial: <hidden>\t Type: " + this.hmdDesc.Type() + "\t Resolution (total): " + this.resolutionW + "," + this.resolutionH);
        if (this.resolutionW == 0) {
            LOGGER.severe("HMD witdth=0 : aborting");
            return false;
        }
        for (eye = 0; eye < 2; ++eye) {
            this.fovPorts[eye] = this.hmdDesc.DefaultEyeFov(eye);
        }
        for (eye = 0; eye < 2; ++eye) {
            this.projections[eye] = OVRMatrix4f.malloc();
            this.hmdRelativeEyePoses[eye] = new Matrix4f();
            this.hmdRelativeEyePositions[eye] = new Vector3f();
            this.eyeRenderDesc[eye] = OVREyeRenderDesc.malloc();
            OVR.ovr_GetRenderDesc((long)this.session, (int)eye, (OVRFovPort)this.fovPorts[eye], (OVREyeRenderDesc)this.eyeRenderDesc[eye]);
            OVRPosef pose = this.eyeRenderDesc[eye].HmdToEyePose();
            OculusVR.vecO2J(pose.Position(), this.hmdRelativeEyePositions[eye]);
            Quaternion rotation = OculusVR.quatO2J(pose.Orientation(), new Quaternion());
            this.hmdRelativeEyePoses[eye].loadIdentity();
            this.hmdRelativeEyePoses[eye].setTranslation(this.hmdRelativeEyePositions[eye]);
            this.hmdRelativeEyePoses[eye].setRotationQuaternion(rotation);
        }
        this.reset();
        this.findHMDTextureSize();
        this.trackingState = OVRTrackingState.calloc();
        this.input = new OculusVRInput(this, this.session, this.sessionStatus, this.trackingState);
        return true;
    }

    @Override
    public void updatePose() {
        double ftiming = OVR.ovr_GetPredictedDisplayTime((long)this.session, (long)0L);
        OVR.ovr_GetTrackingState((long)this.session, (double)ftiming, (boolean)true, (OVRTrackingState)this.trackingState);
        OVR.ovr_GetSessionStatus((long)this.session, (OVRSessionStatus)this.sessionStatus);
        this.input.updateControllerStates();
        this.headPose = this.trackingState.HeadPose().ThePose();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void destroy() {
        this.input.dispose();
        if (this.chains != null) {
            for (long chain : this.chains) {
                OVR.ovr_DestroyTextureSwapChain((long)this.session, (long)chain);
            }
            this.layer0.free();
        }
        for (OVREyeRenderDesc eye : this.eyeRenderDesc) {
            eye.free();
        }
        for (OVRMatrix4f projection : this.projections) {
            projection.free();
        }
        this.hmdDesc.free();
        this.trackingState.free();
        this.sessionStatus.free();
        OVR.ovr_Destroy((long)this.session);
        OVR.ovr_Shutdown();
    }

    @Override
    public void reset() {
        OVR.ovr_RecenterTrackingOrigin((long)this.session);
    }

    @Override
    public void getRenderSize(Vector2f store) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Cannot call getRenderSize() before initialized!");
        }
        store.x = this.textureW;
        store.y = this.textureH;
    }

    @Override
    public float getInterpupillaryDistance() {
        return 0.065f;
    }

    @Override
    public Quaternion getOrientation() {
        return OculusVR.quatO2J(this.headPose.Orientation(), new Quaternion());
    }

    @Override
    public Vector3f getPosition() {
        return OculusVR.vecO2J(this.headPose.Position(), new Vector3f());
    }

    @Override
    public void getPositionAndOrientation(Vector3f storePos, Quaternion storeRot) {
        storePos.set(this.getPosition());
        storeRot.set(this.getOrientation());
    }

    private Matrix4f calculateProjection(int eye, Camera cam) {
        Matrix4f mat = new Matrix4f();
        OVRUtil.ovrMatrix4f_Projection((OVRFovPort)this.fovPorts[eye], (float)cam.getFrustumNear(), (float)cam.getFrustumFar(), (int)0, (OVRMatrix4f)this.projections[eye]);
        OculusVR.matrixO2J(this.projections[eye], mat);
        return mat;
    }

    @Override
    public Matrix4f getHMDMatrixProjectionLeftEye(Camera cam) {
        return this.calculateProjection(0, cam);
    }

    @Override
    public Matrix4f getHMDMatrixProjectionRightEye(Camera cam) {
        return this.calculateProjection(1, cam);
    }

    @Override
    public Vector3f getHMDVectorPoseLeftEye() {
        return this.hmdRelativeEyePositions[0];
    }

    @Override
    public Vector3f getHMDVectorPoseRightEye() {
        return this.hmdRelativeEyePositions[1];
    }

    @Override
    public Vector3f getSeatedToAbsolutePosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix4f getHMDMatrixPoseLeftEye() {
        return this.hmdRelativeEyePoses[0];
    }

    @Override
    public Matrix4f getHMDMatrixPoseRightEye() {
        return this.hmdRelativeEyePoses[0];
    }

    @Override
    public HmdType getType() {
        return HmdType.OCULUS_RIFT;
    }

    @Override
    public boolean initVRCompositor(boolean set) {
        if (!set) {
            throw new UnsupportedOperationException("Cannot use LibOVR without compositor!");
        }
        this.setupLayers();
        this.framebuffers = new FrameBuffer[2][];
        for (int eye = 0; eye < 2; ++eye) {
            this.setupFramebuffers(eye);
        }
        return true;
    }

    @Override
    public void printLatencyInfoToConsole(boolean set) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public void setFlipEyes(boolean set) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public Void getCompositor() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public Void getVRSystem() {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void findHMDTextureSize() {
        float pixelScaling = 1.0f;
        OVRSizei leftTextureSize = OVRSizei.malloc();
        OVR.ovr_GetFovTextureSize((long)this.session, (int)0, (OVRFovPort)this.fovPorts[0], (float)pixelScaling, (OVRSizei)leftTextureSize);
        OVRSizei rightTextureSize = OVRSizei.malloc();
        OVR.ovr_GetFovTextureSize((long)this.session, (int)1, (OVRFovPort)this.fovPorts[1], (float)pixelScaling, (OVRSizei)rightTextureSize);
        if (leftTextureSize.w() != rightTextureSize.w()) {
            throw new IllegalStateException("Texture sizes do not match [horizontal]");
        }
        if (leftTextureSize.h() != rightTextureSize.h()) {
            throw new IllegalStateException("Texture sizes do not match [vertical]");
        }
        this.textureW = leftTextureSize.w();
        this.textureH = leftTextureSize.h();
        leftTextureSize.free();
        rightTextureSize.free();
    }

    private long setupTextureChain() {
        PointerBuffer textureSetPB;
        OVRTextureSwapChainDesc swapChainDesc = OVRTextureSwapChainDesc.calloc().Type(0).ArraySize(1).Format(5).Width(this.textureW).Height(this.textureH).MipLevels(1).SampleCount(1).StaticImage(false);
        if (OVRGL.ovr_CreateTextureSwapChainGL((long)this.session, (OVRTextureSwapChainDesc)swapChainDesc, (PointerBuffer)(textureSetPB = BufferUtils.createPointerBuffer((int)1))) != 0) {
            throw new RuntimeException("Failed to create Swap Texture Set");
        }
        swapChainDesc.free();
        return textureSetPB.get();
    }

    public void setupLayers() {
        this.layer0 = OVRLayerEyeFov.calloc();
        this.layer0.Header().Type(1);
        this.layer0.Header().Flags(2);
        this.chains = new long[2];
        for (int eye = 0; eye < 2; ++eye) {
            long eyeChain;
            this.chains[eye] = eyeChain = this.setupTextureChain();
            OVRRecti viewport = OVRRecti.calloc();
            viewport.Pos().x(0);
            viewport.Pos().y(0);
            viewport.Size().w(this.textureW);
            viewport.Size().h(this.textureH);
            this.layer0.ColorTexture(eye, eyeChain);
            this.layer0.Viewport(eye, viewport);
            this.layer0.Fov(eye, this.fovPorts[eye]);
            viewport.free();
        }
        this.layers = BufferUtils.createPointerBuffer((int)1);
        this.layers.put(0, (Pointer)this.layer0);
    }

    public void setupFramebuffers(int eye) {
        IntBuffer length = BufferUtils.createIntBuffer((int)1);
        OVR.ovr_GetTextureSwapChainLength((long)this.session, (long)this.chains[eye], (IntBuffer)length);
        int chainLength = length.get();
        LOGGER.fine("HMD Eye #" + eye + " texture chain length: " + chainLength);
        this.framebuffers[eye] = new FrameBuffer[chainLength];
        for (int i = 0; i < chainLength; ++i) {
            IntBuffer textureIdB = BufferUtils.createIntBuffer((int)1);
            OVRGL.ovr_GetTextureSwapChainBufferGL((long)this.session, (long)this.chains[eye], (int)i, (IntBuffer)textureIdB);
            int textureId = textureIdB.get();
            Image img = new Image();
            img.setId(textureId);
            img.setFormat(Image.Format.RGBA8);
            img.setWidth(this.textureW);
            img.setHeight(this.textureH);
            Texture2D tex = new Texture2D(img);
            FrameBuffer buffer = new FrameBuffer(this.textureW, this.textureH, 1);
            buffer.setDepthBuffer(Image.Format.Depth);
            buffer.setColorTexture(tex);
            this.framebuffers[eye][i] = buffer;
        }
    }

    public static Matrix4f matrixO2J(OVRMatrix4f from, Matrix4f to) {
        to.loadIdentity();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                float val = from.M(x + y * 4);
                to.set(x, y, val);
            }
        }
        to.transposeLocal();
        return to;
    }

    public static Quaternion quatO2J(OVRQuatf from, Quaternion to) {
        to.set(from.x(), -from.y(), from.z(), -from.w());
        to.normalizeLocal();
        return to;
    }

    public static Vector3f vecO2J(OVRVector3f from, Vector3f to) {
        to.set(-from.x(), from.y(), -from.z());
        return to;
    }

    public long getSessionPointer() {
        return this.session;
    }

    public long getChain(int eye) {
        return this.chains[eye];
    }

    public FrameBuffer[] getFramebuffers(int eye) {
        return this.framebuffers[eye];
    }

    public PointerBuffer getLayers() {
        return this.layers;
    }

    public OVRLayerEyeFov getLayer0() {
        return this.layer0;
    }

    public OVRFovPort getFovPort() {
        return this.fovPorts[0];
    }

    public OVRPosef getHeadPose() {
        return this.headPose;
    }

    public OVRPosef getEyePose(int eye) {
        return this.eyeRenderDesc[eye].HmdToEyePose();
    }

    public VREnvironment getEnvironment() {
        return this.environment;
    }
}

