/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.oculus;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.VRInputAPI;
import com.jme3.input.vr.VRInputType;
import com.jme3.input.vr.VRTrackedController;
import com.jme3.input.vr.oculus.OculusVR;
import com.jme3.input.vr.oculus.OculusViewManager;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import org.lwjgl.ovr.OVR;
import org.lwjgl.ovr.OVRInputState;
import org.lwjgl.ovr.OVRPoseStatef;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.ovr.OVRSessionStatus;
import org.lwjgl.ovr.OVRTrackingState;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.ovr.OVRVector3f;

public class OculusVRInput
implements VRInputAPI {
    private final OVRInputState inputState;
    private final OVRSessionStatus sessionStatus;
    private final OVRTrackingState trackingState;
    private final OculusVR hardware;
    private long session;
    private float axisMultiplier = 1.0f;
    private int buttons;
    private int touch;
    private int lastButtons;
    private int lastTouch;
    private final Vector2f[][] lastAxises;
    private OVRPoseStatef[] handStates;
    private OVRPosef[] handPoses;
    private final OculusController[] controllers = new OculusController[]{new OculusController(0), new OculusController(1)};

    public OculusVRInput(OculusVR hardware, long session, OVRSessionStatus sessionStatus, OVRTrackingState trackingState) {
        this.hardware = hardware;
        this.session = session;
        this.sessionStatus = sessionStatus;
        this.trackingState = trackingState;
        this.inputState = OVRInputState.calloc();
        this.handStates = new OVRPoseStatef[2];
        this.handPoses = new OVRPosef[this.handStates.length];
        this.lastAxises = new Vector2f[this.handStates.length][3];
    }

    public void dispose() {
        this.inputState.free();
        this.session = 0L;
    }

    @Override
    public void updateControllerStates() {
        OVR.ovr_GetInputState((long)this.session, (int)3, (OVRInputState)this.inputState);
        this.buttons = this.inputState.Buttons();
        this.touch = this.inputState.Touches();
        for (int hand = 0; hand < this.handPoses.length; ++hand) {
            this.handStates[hand] = this.trackingState.HandPoses(hand);
            this.handPoses[hand] = this.handStates[hand].ThePose();
        }
    }

    private Vector3f cv(OVRVector3f in) {
        return OculusVR.vecO2J(in, new Vector3f());
    }

    private Vector2f cv(OVRVector2f in) {
        return new Vector2f(in.x(), in.y());
    }

    private Quaternion cq(OVRQuatf in) {
        return OculusVR.quatO2J(in, new Quaternion());
    }

    private Vector2f axis(float input) {
        return new Vector2f(input, input);
    }

    @Override
    public Vector3f getPosition(int index) {
        return this.cv(this.handPoses[index].Position());
    }

    @Override
    public Vector3f getVelocity(int controllerIndex) {
        return this.cv(this.handStates[controllerIndex].LinearVelocity());
    }

    @Override
    public Quaternion getOrientation(int index) {
        return this.cq(this.handPoses[index].Orientation());
    }

    @Override
    public Vector3f getAngularVelocity(int controllerIndex) {
        return this.cv(this.handStates[controllerIndex].AngularVelocity());
    }

    @Override
    public Quaternion getFinalObserverRotation(int index) {
        VREnvironment env = this.hardware.getEnvironment();
        OculusViewManager vrvm = (OculusViewManager)this.hardware.getEnvironment().getVRViewManager();
        Object obs = env.getObserver();
        Quaternion tempq = new Quaternion();
        if (obs instanceof Camera) {
            tempq.set(((Camera)obs).getRotation());
        } else {
            tempq.set(((Spatial)obs).getWorldRotation());
        }
        return tempq.multLocal(this.getOrientation(index));
    }

    @Override
    public Vector3f getFinalObserverPosition(int index) {
        VREnvironment env = this.hardware.getEnvironment();
        OculusViewManager vrvm = (OculusViewManager)this.hardware.getEnvironment().getVRViewManager();
        Object obs = env.getObserver();
        Vector3f pos = this.getPosition(index);
        if (obs instanceof Camera) {
            ((Camera)obs).getRotation().mult(pos, pos);
            return pos.addLocal(((Camera)obs).getLocation());
        }
        ((Spatial)obs).getWorldRotation().mult(pos, pos);
        return pos.addLocal(((Spatial)obs).getWorldTranslation());
    }

    @Override
    public boolean isInputDeviceTracking(int index) {
        int flags = this.trackingState.HandStatusFlags(index);
        return (flags & 2) != 0;
    }

    @Override
    public Vector2f getAxis(int controllerIndex, VRInputType forAxis) {
        Vector2f result = this.getAxisRaw(controllerIndex, forAxis);
        return result == null ? null : result.multLocal(this.axisMultiplier);
    }

    @Override
    public Vector2f getAxisRaw(int controllerIndex, VRInputType forAxis) {
        switch (forAxis) {
            case OculusThumbstickAxis: {
                return this.cv(this.inputState.Thumbstick(controllerIndex));
            }
            case OculusTriggerAxis: {
                return this.axis(this.inputState.IndexTrigger(controllerIndex));
            }
            case OculusGripAxis: {
                return this.axis(this.inputState.HandTrigger(controllerIndex));
            }
        }
        return null;
    }

    @Override
    public boolean isButtonDown(int controllerIndex, VRInputType checkButton) {
        return this.isButtonDownForStatus(controllerIndex, checkButton, this.buttons, this.touch);
    }

    public boolean isButtonDownForStatus(int controllerIndex, VRInputType checkButton, int buttons, int touch) {
        int buttonMask = controllerIndex == 0 ? 0x100F00 : 15;
        int touchMask = controllerIndex == 0 ? 32512 : 127;
        switch (checkButton) {
            default: {
                return false;
            }
            case OculusTopButton: 
            case OculusBottomButton: 
            case OculusThumbstickButton: 
            case OculusMenuButton: {
                return (buttons & buttonMask & checkButton.getValue()) != 0;
            }
            case OculusTopTouch: 
            case OculusBottomTouch: 
            case OculusThumbstickTouch: 
            case OculusThumbrestTouch: 
            case OculusIndexTouch: 
            case OculusThumbUp: 
            case OculusIndexPointing: 
        }
        return (touch & touchMask & checkButton.getValue()) != 0;
    }

    @Override
    public void resetInputSinceLastCall() {
        this.lastButtons = 0;
        this.lastTouch = 0;
    }

    @Override
    public boolean wasButtonPressedSinceLastCall(int controllerIndex, VRInputType checkButton) {
        boolean wasPressed = this.isButtonDownForStatus(controllerIndex, checkButton, this.lastButtons, this.lastTouch);
        this.lastButtons = this.buttons;
        this.lastTouch = this.touch;
        return !wasPressed && this.isButtonDown(controllerIndex, checkButton);
    }

    @Override
    public Vector2f getAxisDeltaSinceLastCall(int controllerIndex, VRInputType forAxis) {
        int index;
        switch (forAxis) {
            case OculusTriggerAxis: {
                index = 0;
                break;
            }
            case OculusGripAxis: {
                index = 1;
                break;
            }
            case OculusThumbstickAxis: {
                index = 2;
                break;
            }
            default: {
                return null;
            }
        }
        Vector2f last = this.lastAxises[controllerIndex][index];
        if (last == null) {
            Vector2f vector2f = new Vector2f();
            this.lastAxises[controllerIndex][index] = vector2f;
            last = vector2f;
        }
        Vector2f current = this.getAxis(controllerIndex, forAxis);
        current.subtractLocal(last);
        last.addLocal(current);
        return current;
    }

    @Override
    public boolean init() {
        throw new UnsupportedOperationException("Input initialized at creation time");
    }

    @Override
    public void updateConnectedControllers() {
        throw new UnsupportedOperationException("Automatically done by LibOVR (I think?)");
    }

    @Override
    public float getAxisMultiplier() {
        return this.axisMultiplier;
    }

    @Override
    public void setAxisMultiplier(float axisMultiplier) {
        this.axisMultiplier = axisMultiplier;
    }

    @Override
    public void triggerHapticPulse(int controllerIndex, float seconds) {
    }

    @Override
    public boolean isInputFocused() {
        return this.sessionStatus.IsVisible();
    }

    @Override
    public Object getRawControllerState(int index) {
        throw new UnsupportedOperationException("Cannot get raw controller state!");
    }

    @Override
    public void swapHands() {
    }

    @Override
    public int getTrackedControllerCount() {
        return 2;
    }

    @Override
    public VRTrackedController getTrackedController(int index) {
        return this.controllers[index];
    }

    public class OculusController
    implements VRTrackedController {
        private int hand;

        public OculusController(int hand) {
            this.hand = hand;
        }

        @Override
        public String getControllerName() {
            return "Touch";
        }

        @Override
        public String getControllerManufacturer() {
            return "Oculus";
        }

        @Override
        public Vector3f getPosition() {
            return OculusVRInput.this.getPosition(this.hand);
        }

        @Override
        public Quaternion getOrientation() {
            return OculusVRInput.this.getOrientation(this.hand);
        }

        @Override
        public Matrix4f getPose() {
            Matrix4f mat = new Matrix4f();
            mat.setRotationQuaternion(this.getOrientation());
            mat.setTranslation(this.getPosition());
            return mat;
        }
    }
}

