/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.oculus;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.AbstractVRViewManager;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.oculus.OculusVR;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.util.BufferUtils;
import com.jme3.util.VRGUIPositioningMode;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Objects;
import java.util.logging.Logger;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVR;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRUtil;
import org.lwjgl.system.Struct;

public class OculusViewManager
extends AbstractVRViewManager {
    private static final Logger LOG = Logger.getLogger(OculusViewManager.class.getName());
    private final VREnvironment environment;
    private final OculusVR hardware;
    private final Vector3f finalPosition = new Vector3f();
    private final Quaternion finalRotation = new Quaternion();
    private final Vector3f hmdPos = new Vector3f();
    private final Quaternion hmdRot = new Quaternion();

    public OculusViewManager(VREnvironment environment) {
        this.environment = environment;
        VRAPI hardware = environment.getVRHardware();
        Objects.requireNonNull(hardware, "Attached VR Hardware cannot be null");
        if (!(hardware instanceof OculusVR)) {
            throw new IllegalStateException("Cannot use Oculus VR view manager on non-Oculus hardware state!");
        }
        this.hardware = (OculusVR)hardware;
        if (!environment.compositorAllowed()) {
            throw new UnsupportedOperationException("Cannot render without compositor on LibOVR");
        }
    }

    @Override
    public void initialize() {
        this.setupCamerasAndViews();
        if (this.environment.hasTraditionalGUIOverlay()) {
            this.environment.getVRMouseManager().initialize();
            this.update(0.0f);
            this.environment.getVRGUIManager().positionGui();
        }
    }

    private long session() {
        return this.hardware.getSessionPointer();
    }

    @Override
    public void update(float tpf) {
        Vector3f objPos;
        Quaternion objRot;
        this.hardware.updatePose();
        if (this.environment == null) {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
        Object obs = this.environment.getObserver();
        if (obs instanceof Camera) {
            objRot = ((Camera)obs).getRotation();
            objPos = ((Camera)obs).getLocation();
        } else {
            objRot = ((Spatial)obs).getWorldRotation();
            objPos = ((Spatial)obs).getWorldTranslation();
        }
        this.hardware.getPositionAndOrientation(this.hmdPos, this.hmdRot);
        if (obs != null) {
            this.finalRotation.set(objRot);
            this.finalRotation.mult(this.hmdPos, this.hmdPos);
            this.finalRotation.multLocal(this.hmdRot);
        }
        this.finalizeCamera(this.hardware.getHMDVectorPoseLeftEye(), objPos, this.leftCamera);
        this.finalizeCamera(this.hardware.getHMDVectorPoseRightEye(), objPos, this.rightCamera);
        if (!this.environment.isInstanceRendering()) {
            this.finalizeCamera(Vector3f.ZERO, objPos, this.environment.getApplication().getCamera());
        }
        if (this.environment.hasTraditionalGUIOverlay()) {
            this.environment.getVRMouseManager().update(tpf);
            if (this.environment.getVRGUIManager().isWantsReposition() || this.environment.getVRGUIManager().getPositioningMode() != VRGUIPositioningMode.MANUAL) {
                this.environment.getVRGUIManager().positionGuiNow(tpf);
                this.environment.getVRGUIManager().updateGuiQuadGeometricState();
            }
        }
    }

    private void finalizeCamera(Vector3f eyePos, Vector3f obsPosition, Camera cam) {
        this.finalRotation.mult(eyePos, this.finalPosition);
        this.finalPosition.addLocal(this.hmdPos);
        if (obsPosition != null) {
            this.finalPosition.addLocal(obsPosition);
        }
        this.finalPosition.y += this.getHeightAdjustment();
        cam.setFrame(this.finalPosition, this.finalRotation);
    }

    @Override
    public void render() {
        OVRPosef.Buffer hmdToEyeOffsets = OVRPosef.calloc((int)2);
        hmdToEyeOffsets.put(0, (Struct)this.hardware.getEyePose(0));
        hmdToEyeOffsets.put(1, (Struct)this.hardware.getEyePose(1));
        OVRUtil.ovr_CalcEyePoses((OVRPosef)this.hardware.getHeadPose(), (OVRPosef.Buffer)hmdToEyeOffsets, (OVRPosef.Buffer)this.hardware.getLayer0().RenderPose());
        hmdToEyeOffsets.free();
        for (int eye = 0; eye < 2; ++eye) {
            IntBuffer currentIndexB = BufferUtils.createIntBuffer((int)1);
            OVR.ovr_GetTextureSwapChainCurrentIndex((long)this.session(), (long)this.hardware.getChain(eye), (IntBuffer)currentIndexB);
            int index = currentIndexB.get();
            (eye == 0 ? this.leftViewPort : this.rightViewPort).setOutputFrameBuffer(this.hardware.getFramebuffers(eye)[index]);
        }
    }

    @Override
    public void postRender() {
        for (int eye = 0; eye < 2; ++eye) {
            OVR.ovr_CommitTextureSwapChain((long)this.session(), (long)this.hardware.getChain(eye));
        }
        int result = OVR.ovr_SubmitFrame((long)this.session(), (long)0L, null, (PointerBuffer)this.hardware.getLayers());
        if (result != 0) {
            throw new IllegalStateException("Failed to submit frame!");
        }
    }

    private void setupCamerasAndViews() {
        if (this.environment != null) {
            Camera origCam = this.environment.getCamera();
            float fFar = origCam.getFrustumFar();
            float fNear = origCam.getFrustumNear();
            this.leftCamera = this.environment.isInstanceRendering() ? origCam : origCam.clone();
            OVRFovPort fp = this.hardware.getFovPort();
            float hFov = fp.LeftTan() + fp.RightTan();
            float vFov = fp.UpTan() + fp.DownTan();
            this.getLeftCamera().setFrustumPerspective(hFov / ((float)Math.PI * 2) * 360.0f, vFov / hFov, fNear, fFar);
            this.prepareCameraSize(this.getLeftCamera(), 1.0f);
            if (this.environment.getVRHardware() != null) {
                this.getLeftCamera().setProjectionMatrix(this.environment.getVRHardware().getHMDMatrixProjectionLeftEye(this.getLeftCamera()));
            }
            if (!this.environment.isInstanceRendering()) {
                this.leftViewPort = this.setupViewBuffers(this.getLeftCamera(), "Left View");
                this.rightCamera = this.getLeftCamera().clone();
                if (this.environment.getVRHardware() != null) {
                    this.getRightCamera().setProjectionMatrix(this.environment.getVRHardware().getHMDMatrixProjectionRightEye(this.getRightCamera()));
                }
            } else {
                if (this.environment.getApplication() != null) {
                    throw new UnsupportedOperationException("Not yet implemented!");
                }
                throw new IllegalStateException("This VR environment is not attached to any application.");
            }
            this.rightViewPort = this.setupViewBuffers(this.getRightCamera(), "Right View");
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
        this.environment.getVRGUIManager().setupGui(this.getLeftCamera(), this.getRightCamera(), this.getLeftViewPort(), this.getRightViewPort());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareCameraSize(Camera cam, float xMult) {
        if (this.environment == null) throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        if (this.environment.getApplication() == null) throw new IllegalStateException("This VR environment is not attached to any application.");
        Vector2f size = new Vector2f();
        VRAPI vrhmd = this.environment.getVRHardware();
        if (vrhmd == null) {
            size.x = 1280.0f;
            size.y = 720.0f;
        } else {
            vrhmd.getRenderSize(size);
        }
        if (size.x < (float)this.environment.getApplication().getContext().getSettings().getWidth()) {
            size.x = this.environment.getApplication().getContext().getSettings().getWidth();
        }
        if (size.y < (float)this.environment.getApplication().getContext().getSettings().getHeight()) {
            size.y = this.environment.getApplication().getContext().getSettings().getHeight();
        }
        if (this.environment.isInstanceRendering()) {
            size.x *= 2.0f;
        }
        size.x *= xMult;
        size.x *= this.getResolutionMuliplier();
        size.y *= this.getResolutionMuliplier();
        if ((float)cam.getWidth() == size.x && (float)cam.getHeight() == size.y) return;
        cam.resize((int)size.x, (int)size.y, false);
    }

    private ViewPort setupViewBuffers(Camera cam, String viewName) {
        if (this.environment != null) {
            if (this.environment.getApplication() != null) {
                ViewPort viewPort = this.environment.getApplication().getRenderManager().createPreView(viewName, cam);
                viewPort.setClearFlags(true, true, true);
                viewPort.setBackgroundColor(ColorRGBA.Black);
                Iterator spatialIter = this.environment.getApplication().getViewPort().getScenes().iterator();
                while (spatialIter.hasNext()) {
                    viewPort.attachScene((Spatial)spatialIter.next());
                }
                return viewPort;
            }
            throw new IllegalStateException("This VR environment is not attached to any application.");
        }
        throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
    }
}

