/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.openvr;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.HmdType;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.openvr.OpenVRBounds;
import com.jme3.input.vr.openvr.OpenVRInput;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.system.jopenvr.HmdMatrix34_t;
import com.jme3.system.jopenvr.HmdMatrix44_t;
import com.jme3.system.jopenvr.JOpenVRLibrary;
import com.jme3.system.jopenvr.OpenVRUtil;
import com.jme3.system.jopenvr.TrackedDevicePose_t;
import com.jme3.system.jopenvr.VR_IVRCompositor_FnTable;
import com.jme3.system.jopenvr.VR_IVRSystem_FnTable;
import com.jme3.system.jopenvr.VR_IVRTrackedCamera_FnTable;
import com.jme3.util.VRUtil;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.FloatByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenVR
implements VRAPI {
    private static final Logger logger = Logger.getLogger(OpenVR.class.getName());
    private static VR_IVRCompositor_FnTable compositorFunctions;
    private static VR_IVRSystem_FnTable vrsystemFunctions;
    private static VR_IVRTrackedCamera_FnTable cameraFunctions;
    private static boolean initSuccess;
    private static boolean flipEyes;
    private IntBuffer hmdDisplayFrequency;
    private TrackedDevicePose_t.ByReference hmdTrackedDevicePoseReference;
    protected TrackedDevicePose_t[] hmdTrackedDevicePoses;
    protected IntByReference hmdErrorStore;
    private final Quaternion rotStore = new Quaternion();
    private final Vector3f posStore = new Vector3f();
    private static FloatByReference tlastVsync;
    public static LongByReference _tframeCount;
    private int frames = 0;
    protected Matrix4f[] poseMatrices;
    private final Matrix4f hmdPose = Matrix4f.IDENTITY.clone();
    private Matrix4f hmdProjectionLeftEye;
    private Matrix4f hmdProjectionRightEye;
    private Matrix4f hmdPoseLeftEye;
    private Matrix4f hmdPoseRightEye;
    private Vector3f hmdPoseLeftEyeVec;
    private Vector3f hmdPoseRightEyeVec;
    private Vector3f hmdSeatToStand;
    private float vsyncToPhotons;
    private double timePerFrame;
    private double frameCountRun;
    private long frameCount;
    private OpenVRInput VRinput;
    private VREnvironment environment = null;
    private static long latencyWaitTime;
    private boolean enableDebugLatency = false;

    public OpenVR(VREnvironment environment) {
        this.environment = environment;
    }

    @Override
    public OpenVRInput getVRinput() {
        return this.VRinput;
    }

    public VR_IVRSystem_FnTable getVRSystem() {
        return vrsystemFunctions;
    }

    public VR_IVRCompositor_FnTable getCompositor() {
        return compositorFunctions;
    }

    public VR_IVRTrackedCamera_FnTable getTrackedCamera() {
        return cameraFunctions;
    }

    @Override
    public String getName() {
        return "OpenVR";
    }

    @Override
    public void setFlipEyes(boolean set) {
        flipEyes = set;
    }

    @Override
    public void printLatencyInfoToConsole(boolean set) {
        this.enableDebugLatency = set;
    }

    @Override
    public int getDisplayFrequency() {
        if (this.hmdDisplayFrequency == null) {
            return 0;
        }
        return this.hmdDisplayFrequency.get(0);
    }

    @Override
    public boolean initialize() {
        int i;
        logger.config("Initializing OpenVR system...");
        this.hmdErrorStore = new IntByReference();
        vrsystemFunctions = null;
        try {
            JOpenVRLibrary.init();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Cannot link to OpenVR system library: " + t.getMessage(), t);
            return false;
        }
        JOpenVRLibrary.VR_InitInternal(this.hmdErrorStore, 1);
        if (this.hmdErrorStore.getValue() == 0) {
            vrsystemFunctions = new VR_IVRSystem_FnTable(JOpenVRLibrary.VR_GetGenericInterface("FnTable:IVRSystem_016", this.hmdErrorStore).getPointer());
        }
        if (vrsystemFunctions == null || this.hmdErrorStore.getValue() != 0) {
            logger.severe("OpenVR Initialize Result: " + JOpenVRLibrary.VR_GetVRInitErrorAsEnglishDescription(this.hmdErrorStore.getValue()).getString(0L));
            logger.severe("Initializing OpenVR system [FAILED]");
            return false;
        }
        logger.config("OpenVR initialized & VR connected.");
        vrsystemFunctions.setAutoSynch(false);
        vrsystemFunctions.read();
        tlastVsync = new FloatByReference();
        _tframeCount = new LongByReference();
        this.hmdDisplayFrequency = IntBuffer.allocate(1);
        this.hmdDisplayFrequency.put(2002);
        this.hmdTrackedDevicePoseReference = new TrackedDevicePose_t.ByReference();
        this.hmdTrackedDevicePoses = (TrackedDevicePose_t[])this.hmdTrackedDevicePoseReference.toArray(16);
        this.poseMatrices = new Matrix4f[16];
        for (i = 0; i < this.poseMatrices.length; ++i) {
            this.poseMatrices[i] = new Matrix4f();
        }
        this.timePerFrame = 1.0 / (double)this.hmdDisplayFrequency.get(0);
        this.hmdTrackedDevicePoseReference.setAutoRead(false);
        this.hmdTrackedDevicePoseReference.setAutoWrite(false);
        this.hmdTrackedDevicePoseReference.setAutoSynch(false);
        for (i = 0; i < 16; ++i) {
            this.hmdTrackedDevicePoses[i].setAutoRead(false);
            this.hmdTrackedDevicePoses[i].setAutoWrite(false);
            this.hmdTrackedDevicePoses[i].setAutoSynch(false);
        }
        this.VRinput = new OpenVRInput(this.environment);
        this.VRinput.init();
        this.VRinput.updateConnectedControllers();
        OpenVRBounds bounds = new OpenVRBounds();
        bounds.init(this);
        this.environment.setVRBounds(bounds);
        logger.config("Initializing OpenVR system [SUCCESS]");
        initSuccess = true;
        return true;
    }

    @Override
    public boolean initVRCompositor(boolean allowed) {
        this.hmdErrorStore.setValue(0);
        if (allowed && vrsystemFunctions != null) {
            IntByReference intptr = JOpenVRLibrary.VR_GetGenericInterface("FnTable:IVRCompositor_020", this.hmdErrorStore);
            if (intptr != null) {
                if (intptr.getPointer() != null) {
                    compositorFunctions = new VR_IVRCompositor_FnTable(intptr.getPointer());
                    if (compositorFunctions != null && this.hmdErrorStore.getValue() == 0) {
                        compositorFunctions.setAutoSynch(false);
                        compositorFunctions.read();
                        if (this.environment.isSeatedExperience()) {
                            OpenVR.compositorFunctions.SetTrackingSpace.apply(0);
                        } else {
                            OpenVR.compositorFunctions.SetTrackingSpace.apply(1);
                        }
                        logger.config("OpenVR Compositor initialized");
                    } else {
                        logger.severe("OpenVR Compositor error: " + this.hmdErrorStore.getValue());
                        compositorFunctions = null;
                    }
                } else {
                    logger.log(Level.SEVERE, "Cannot get valid pointer for generic interface \"FnTable:IVRCompositor_020\", " + OpenVRUtil.getEVRInitErrorString(this.hmdErrorStore.getValue()) + " (" + this.hmdErrorStore.getValue() + ")");
                    compositorFunctions = null;
                }
            } else {
                logger.log(Level.SEVERE, "Cannot get generic interface for \"FnTable:IVRCompositor_020\", " + OpenVRUtil.getEVRInitErrorString(this.hmdErrorStore.getValue()) + " (" + this.hmdErrorStore.getValue() + ")");
                compositorFunctions = null;
            }
        }
        if (compositorFunctions == null) {
            logger.severe("Skipping VR Compositor...");
            this.vsyncToPhotons = vrsystemFunctions != null ? OpenVR.vrsystemFunctions.GetFloatTrackedDeviceProperty.apply(0, 2001, this.hmdErrorStore) : 0.0f;
        }
        return compositorFunctions != null;
    }

    public void initCamera(boolean allowed) {
        IntByReference intptr;
        this.hmdErrorStore.setValue(0);
        if (allowed && vrsystemFunctions != null && (intptr = JOpenVRLibrary.VR_GetGenericInterface("FnTable:IVRTrackedCamera_003", this.hmdErrorStore)) != null && (cameraFunctions = new VR_IVRTrackedCamera_FnTable(intptr.getPointer())) != null && this.hmdErrorStore.getValue() == 0) {
            cameraFunctions.setAutoSynch(false);
            cameraFunctions.read();
            logger.config("OpenVR Camera initialized");
        }
    }

    @Override
    public void destroy() {
        JOpenVRLibrary.VR_ShutdownInternal();
    }

    @Override
    public boolean isInitialized() {
        return initSuccess;
    }

    @Override
    public void reset() {
        if (vrsystemFunctions == null) {
            return;
        }
        OpenVR.vrsystemFunctions.ResetSeatedZeroPose.apply();
        this.hmdSeatToStand = null;
    }

    @Override
    public void getRenderSize(Vector2f store) {
        if (vrsystemFunctions == null) {
            store.x = 1344.0f;
            store.y = 1512.0f;
        } else {
            IntByReference x = new IntByReference();
            IntByReference y = new IntByReference();
            OpenVR.vrsystemFunctions.GetRecommendedRenderTargetSize.apply(x, y);
            store.x = x.getValue();
            store.y = y.getValue();
        }
    }

    @Override
    public float getInterpupillaryDistance() {
        if (vrsystemFunctions == null) {
            return 0.065f;
        }
        return OpenVR.vrsystemFunctions.GetFloatTrackedDeviceProperty.apply(0, 2003, this.hmdErrorStore);
    }

    @Override
    public Quaternion getOrientation() {
        VRUtil.convertMatrix4toQuat(this.hmdPose, this.rotStore);
        return this.rotStore;
    }

    @Override
    public Vector3f getPosition() {
        this.hmdPose.toTranslationVector(this.posStore);
        this.posStore.x = -this.posStore.x;
        this.posStore.z = -this.posStore.z;
        return this.posStore;
    }

    @Override
    public void getPositionAndOrientation(Vector3f storePos, Quaternion storeRot) {
        this.hmdPose.toTranslationVector(storePos);
        storePos.x = -storePos.x;
        storePos.z = -storePos.z;
        storeRot.set(this.getOrientation());
    }

    @Override
    public void updatePose() {
        if (vrsystemFunctions == null) {
            return;
        }
        if (compositorFunctions != null) {
            OpenVR.compositorFunctions.WaitGetPoses.apply(this.hmdTrackedDevicePoseReference, 16, null, 0);
        } else {
            long nowCount;
            if (latencyWaitTime > 0L) {
                VRUtil.sleepNanos(latencyWaitTime);
            }
            OpenVR.vrsystemFunctions.GetTimeSinceLastVsync.apply(tlastVsync, _tframeCount);
            float fSecondsUntilPhotons = (float)this.timePerFrame - tlastVsync.getValue() + this.vsyncToPhotons;
            if (this.enableDebugLatency) {
                if (this.frames == 10) {
                    System.out.println("Waited (nanos): " + Long.toString(latencyWaitTime));
                    System.out.println("Predict ahead time: " + Float.toString(fSecondsUntilPhotons));
                }
                this.frames = (this.frames + 1) % 60;
            }
            if ((nowCount = _tframeCount.getValue()) - this.frameCount > 1L) {
                if (this.enableDebugLatency) {
                    System.out.println("Frame skipped!");
                }
                this.frameCountRun = 0.0;
                if (latencyWaitTime > 0L && (latencyWaitTime -= TimeUnit.MILLISECONDS.toNanos(1L)) < 0L) {
                    latencyWaitTime = 0L;
                }
            } else if ((double)latencyWaitTime < this.timePerFrame * 1.0E9) {
                this.frameCountRun += 1.0;
                latencyWaitTime += Math.round(Math.pow(this.frameCountRun / 10.0, 2.0));
            }
            this.frameCount = nowCount;
            OpenVR.vrsystemFunctions.GetDeviceToAbsoluteTrackingPose.apply(this.environment.isSeatedExperience() ? 0 : 1, fSecondsUntilPhotons, this.hmdTrackedDevicePoseReference, 16);
        }
        this.environment.getVRinput().updateControllerStates();
        for (int nDevice = 0; nDevice < 16; ++nDevice) {
            this.hmdTrackedDevicePoses[nDevice].readField("bPoseIsValid");
            if (this.hmdTrackedDevicePoses[nDevice].bPoseIsValid == 0) continue;
            this.hmdTrackedDevicePoses[nDevice].readField("mDeviceToAbsoluteTracking");
            VRUtil.convertSteamVRMatrix3ToMatrix4f(this.hmdTrackedDevicePoses[nDevice].mDeviceToAbsoluteTracking, this.poseMatrices[nDevice]);
        }
        if (this.hmdTrackedDevicePoses[0].bPoseIsValid != 0) {
            this.hmdPose.set(this.poseMatrices[0]);
        } else {
            this.hmdPose.set(Matrix4f.IDENTITY);
        }
    }

    @Override
    public Matrix4f getHMDMatrixProjectionLeftEye(Camera cam) {
        if (this.hmdProjectionLeftEye != null) {
            return this.hmdProjectionLeftEye;
        }
        if (vrsystemFunctions == null) {
            return cam.getProjectionMatrix();
        }
        HmdMatrix44_t.ByValue mat = OpenVR.vrsystemFunctions.GetProjectionMatrix.apply(0, cam.getFrustumNear(), cam.getFrustumFar());
        this.hmdProjectionLeftEye = new Matrix4f();
        VRUtil.convertSteamVRMatrix4ToMatrix4f(mat, this.hmdProjectionLeftEye);
        return this.hmdProjectionLeftEye;
    }

    @Override
    public Matrix4f getHMDMatrixProjectionRightEye(Camera cam) {
        if (this.hmdProjectionRightEye != null) {
            return this.hmdProjectionRightEye;
        }
        if (vrsystemFunctions == null) {
            return cam.getProjectionMatrix();
        }
        HmdMatrix44_t.ByValue mat = OpenVR.vrsystemFunctions.GetProjectionMatrix.apply(1, cam.getFrustumNear(), cam.getFrustumFar());
        this.hmdProjectionRightEye = new Matrix4f();
        VRUtil.convertSteamVRMatrix4ToMatrix4f(mat, this.hmdProjectionRightEye);
        return this.hmdProjectionRightEye;
    }

    @Override
    public Vector3f getHMDVectorPoseLeftEye() {
        if (this.hmdPoseLeftEyeVec == null) {
            this.hmdPoseLeftEyeVec = this.getHMDMatrixPoseLeftEye().toTranslationVector();
            if (this.hmdPoseLeftEyeVec.x <= -0.04f || this.hmdPoseLeftEyeVec.x >= -0.02f) {
                this.hmdPoseLeftEyeVec.x = -0.0325f;
            }
            if (!flipEyes) {
                this.hmdPoseLeftEyeVec.x *= -1.0f;
            }
        }
        return this.hmdPoseLeftEyeVec;
    }

    @Override
    public Vector3f getHMDVectorPoseRightEye() {
        if (this.hmdPoseRightEyeVec == null) {
            this.hmdPoseRightEyeVec = this.getHMDMatrixPoseRightEye().toTranslationVector();
            if (this.hmdPoseRightEyeVec.x >= 0.04f || this.hmdPoseRightEyeVec.x <= 0.02f) {
                this.hmdPoseRightEyeVec.x = 0.0325f;
            }
            if (!flipEyes) {
                this.hmdPoseRightEyeVec.x *= -1.0f;
            }
        }
        return this.hmdPoseRightEyeVec;
    }

    @Override
    public Vector3f getSeatedToAbsolutePosition() {
        if (!this.environment.isSeatedExperience()) {
            return Vector3f.ZERO;
        }
        if (this.hmdSeatToStand == null) {
            this.hmdSeatToStand = new Vector3f();
            HmdMatrix34_t.ByValue mat = OpenVR.vrsystemFunctions.GetSeatedZeroPoseToStandingAbsoluteTrackingPose.apply();
            Matrix4f tempmat = new Matrix4f();
            VRUtil.convertSteamVRMatrix3ToMatrix4f(mat, tempmat);
            tempmat.toTranslationVector(this.hmdSeatToStand);
        }
        return this.hmdSeatToStand;
    }

    @Override
    public Matrix4f getHMDMatrixPoseLeftEye() {
        if (this.hmdPoseLeftEye != null) {
            return this.hmdPoseLeftEye;
        }
        if (vrsystemFunctions == null) {
            return Matrix4f.IDENTITY;
        }
        HmdMatrix34_t.ByValue mat = OpenVR.vrsystemFunctions.GetEyeToHeadTransform.apply(0);
        this.hmdPoseLeftEye = new Matrix4f();
        return VRUtil.convertSteamVRMatrix3ToMatrix4f(mat, this.hmdPoseLeftEye);
    }

    @Override
    public HmdType getType() {
        if (vrsystemFunctions != null) {
            Memory str1 = new Memory(128L);
            Memory str2 = new Memory(128L);
            String completeName = "";
            OpenVR.vrsystemFunctions.GetStringTrackedDeviceProperty.apply(0, 1005, (Pointer)str1, 128, this.hmdErrorStore);
            if (this.hmdErrorStore.getValue() == 0) {
                completeName = completeName + str1.getString(0L);
            }
            OpenVR.vrsystemFunctions.GetStringTrackedDeviceProperty.apply(0, 1001, (Pointer)str2, 128, this.hmdErrorStore);
            if (this.hmdErrorStore.getValue() == 0) {
                completeName = completeName + " " + str2.getString(0L);
            }
            if (completeName.length() > 0) {
                if ((completeName = completeName.toLowerCase(Locale.ENGLISH).trim()).contains("htc") || completeName.contains("vive")) {
                    return HmdType.HTC_VIVE;
                }
                if (completeName.contains("osvr")) {
                    return HmdType.OSVR;
                }
                if (completeName.contains("oculus") || completeName.contains("rift") || completeName.contains("dk1") || completeName.contains("dk2") || completeName.contains("cv1")) {
                    return HmdType.OCULUS_RIFT;
                }
                if (completeName.contains("fove")) {
                    return HmdType.FOVE;
                }
                if (completeName.contains("game") && completeName.contains("face")) {
                    return HmdType.GAMEFACE;
                }
                if (completeName.contains("morpheus")) {
                    return HmdType.MORPHEUS;
                }
                if (completeName.contains("gear")) {
                    return HmdType.GEARVR;
                }
                if (completeName.contains("star")) {
                    return HmdType.STARVR;
                }
                if (completeName.contains("null")) {
                    return HmdType.NULL;
                }
            }
        } else {
            return HmdType.NONE;
        }
        return HmdType.OTHER;
    }

    @Override
    public Matrix4f getHMDMatrixPoseRightEye() {
        if (this.hmdPoseRightEye != null) {
            return this.hmdPoseRightEye;
        }
        if (vrsystemFunctions == null) {
            return Matrix4f.IDENTITY;
        }
        HmdMatrix34_t.ByValue mat = OpenVR.vrsystemFunctions.GetEyeToHeadTransform.apply(1);
        this.hmdPoseRightEye = new Matrix4f();
        return VRUtil.convertSteamVRMatrix3ToMatrix4f(mat, this.hmdPoseRightEye);
    }

    static {
        initSuccess = false;
        flipEyes = false;
        latencyWaitTime = 0L;
    }
}

