/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.openvr;

import com.jme3.input.vr.VRBounds;
import com.jme3.input.vr.openvr.OpenVR;
import com.jme3.math.Vector2f;
import com.jme3.system.jopenvr.JOpenVRLibrary;
import com.jme3.system.jopenvr.VR_IVRChaperone_FnTable;
import com.sun.jna.ptr.FloatByReference;
import java.util.logging.Logger;

public class OpenVRBounds
implements VRBounds {
    private static Logger logger = Logger.getLogger(OpenVRBounds.class.getName());
    private VR_IVRChaperone_FnTable vrChaperone;
    private Vector2f playSize;

    public boolean init(OpenVR api) {
        logger.config("Initialize VR bounds...");
        if (this.vrChaperone == null) {
            this.vrChaperone = new VR_IVRChaperone_FnTable(JOpenVRLibrary.VR_GetGenericInterface("FnTable:IVRChaperone_003", api.hmdErrorStore).getPointer());
            if (this.vrChaperone != null) {
                this.vrChaperone.setAutoSynch(false);
                this.vrChaperone.read();
                FloatByReference fbX = new FloatByReference();
                FloatByReference fbZ = new FloatByReference();
                this.vrChaperone.GetPlayAreaSize.apply(fbX, fbZ);
                this.playSize = new Vector2f(fbX.getValue(), fbZ.getValue());
                logger.config("Initialize VR bounds [SUCCESS]");
                return true;
            }
            logger.warning("Initialize VR bounds [FAILED].");
            return false;
        }
        logger.config("Initialize VR bounds already done.");
        return true;
    }

    @Override
    public Vector2f getPlaySize() {
        return this.playSize;
    }
}

