/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.openvr;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.VRInputAPI;
import com.jme3.input.vr.VRInputType;
import com.jme3.input.vr.VRTrackedController;
import com.jme3.input.vr.openvr.OpenVR;
import com.jme3.input.vr.openvr.OpenVRTrackedController;
import com.jme3.input.vr.openvr.OpenVRViewManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Spatial;
import com.jme3.system.jopenvr.OpenVRUtil;
import com.jme3.system.jopenvr.VRControllerState_t;
import com.jme3.system.jopenvr.VR_IVRSystem_FnTable;
import com.jme3.util.VRUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenVRInput
implements VRInputAPI {
    private static final Logger logger = Logger.getLogger(OpenVRInput.class.getName());
    private final VRControllerState_t[] cStates = new VRControllerState_t[16];
    private final Quaternion[] rotStore = new Quaternion[16];
    private final Vector3f[] posStore = new Vector3f[16];
    private static final int[] controllerIndex = new int[16];
    private int controllerCount = 0;
    private final Vector2f tempAxis = new Vector2f();
    private final Vector2f temp2Axis = new Vector2f();
    private final Vector2f[] lastCallAxis = new Vector2f[16];
    private final boolean[] needsNewVelocity = new boolean[16];
    private final boolean[] needsNewAngVelocity = new boolean[16];
    private final boolean[][] buttonDown = new boolean[16][16];
    private float axisMultiplier = 1.0f;
    private final Vector3f tempVel = new Vector3f();
    private final Quaternion tempq = new Quaternion();
    private VREnvironment environment;
    private List<VRTrackedController> trackedControllers = null;

    public OpenVRInput(VREnvironment environment) {
        this.environment = environment;
    }

    @Override
    public float getAxisMultiplier() {
        return this.axisMultiplier;
    }

    @Override
    public void setAxisMultiplier(float set) {
        this.axisMultiplier = set;
    }

    @Override
    public void swapHands() {
        if (this.controllerCount != 2) {
            return;
        }
        int temp = controllerIndex[0];
        OpenVRInput.controllerIndex[0] = controllerIndex[1];
        OpenVRInput.controllerIndex[1] = temp;
    }

    @Override
    public boolean isButtonDown(int controllerIndex, VRInputType checkButton) {
        VRControllerState_t cs = this.cStates[OpenVRInput.controllerIndex[controllerIndex]];
        switch (checkButton) {
            default: {
                return false;
            }
            case ViveGripButton: {
                return (cs.ulButtonPressed & 4L) != 0L;
            }
            case ViveMenuButton: {
                return (cs.ulButtonPressed & 2L) != 0L;
            }
            case ViveTrackpadAxis: {
                return (cs.ulButtonPressed & 0x100000000L) != 0L;
            }
            case ViveTriggerAxis: 
        }
        return (cs.ulButtonPressed & 0x200000000L) != 0L;
    }

    @Override
    public boolean wasButtonPressedSinceLastCall(int controllerIndex, VRInputType checkButton) {
        boolean buttonDownNow = this.isButtonDown(controllerIndex, checkButton);
        int checkButtonValue = checkButton.getValue();
        int cIndex = OpenVRInput.controllerIndex[controllerIndex];
        boolean retval = buttonDownNow && !this.buttonDown[cIndex][checkButtonValue];
        this.buttonDown[cIndex][checkButtonValue] = buttonDownNow;
        return retval;
    }

    @Override
    public void resetInputSinceLastCall() {
        int i;
        for (i = 0; i < this.lastCallAxis.length; ++i) {
            this.lastCallAxis[i].x = 0.0f;
            this.lastCallAxis[i].y = 0.0f;
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.buttonDown[i][j] = false;
            }
        }
    }

    @Override
    public Vector2f getAxisDeltaSinceLastCall(int controllerIndex, VRInputType forAxis) {
        int axisIndex = forAxis.getValue();
        this.temp2Axis.set(this.lastCallAxis[axisIndex]);
        this.lastCallAxis[axisIndex].set(this.getAxis(controllerIndex, forAxis));
        if (!(this.temp2Axis.x == 0.0f && this.temp2Axis.y == 0.0f || this.lastCallAxis[axisIndex].x == 0.0f && this.lastCallAxis[axisIndex].y == 0.0f)) {
            this.temp2Axis.subtractLocal(this.lastCallAxis[axisIndex]);
        } else {
            this.temp2Axis.x = 0.0f;
            this.temp2Axis.y = 0.0f;
        }
        return this.temp2Axis;
    }

    @Override
    public Vector3f getVelocity(int controllerIndex) {
        if (this.environment != null) {
            if (this.environment.getVRHardware() instanceof OpenVR) {
                int index = OpenVRInput.controllerIndex[controllerIndex];
                if (this.needsNewVelocity[index]) {
                    ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].readField("vVelocity");
                    this.needsNewVelocity[index] = false;
                }
                this.tempVel.x = ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].vVelocity.v[0];
                this.tempVel.y = ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].vVelocity.v[1];
                this.tempVel.z = ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].vVelocity.v[2];
                return this.tempVel;
            }
            throw new IllegalStateException("VR hardware " + this.environment.getVRHardware().getClass().getSimpleName() + " is not a subclass of " + OpenVR.class.getSimpleName());
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public Vector3f getAngularVelocity(int controllerIndex) {
        if (this.environment != null) {
            if (this.environment.getVRHardware() instanceof OpenVR) {
                int index = OpenVRInput.controllerIndex[controllerIndex];
                if (this.needsNewAngVelocity[index]) {
                    ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].readField("vAngularVelocity");
                    this.needsNewAngVelocity[index] = false;
                }
                this.tempVel.x = ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].vAngularVelocity.v[0];
                this.tempVel.y = ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].vAngularVelocity.v[1];
                this.tempVel.z = ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[index].vAngularVelocity.v[2];
                return this.tempVel;
            }
            throw new IllegalStateException("VR hardware " + this.environment.getVRHardware().getClass().getSimpleName() + " is not a subclass of " + OpenVR.class.getSimpleName());
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public Vector2f getAxisRaw(int controllerIndex, VRInputType forAxis) {
        VRControllerState_t cs = this.cStates[OpenVRInput.controllerIndex[controllerIndex]];
        switch (forAxis) {
            default: {
                return null;
            }
            case ViveTriggerAxis: {
                this.tempAxis.y = this.tempAxis.x = cs.rAxis[1].x;
                break;
            }
            case ViveTrackpadAxis: {
                this.tempAxis.x = cs.rAxis[0].x;
                this.tempAxis.y = cs.rAxis[0].y;
            }
        }
        return this.tempAxis;
    }

    @Override
    public Vector2f getAxis(int controllerIndex, VRInputType forAxis) {
        VRControllerState_t cs = this.cStates[OpenVRInput.controllerIndex[controllerIndex]];
        switch (forAxis) {
            default: {
                return null;
            }
            case ViveTriggerAxis: {
                this.tempAxis.y = this.tempAxis.x = cs.rAxis[1].x;
                break;
            }
            case ViveTrackpadAxis: {
                this.tempAxis.x = cs.rAxis[0].x;
                this.tempAxis.y = cs.rAxis[0].y;
            }
        }
        this.tempAxis.x *= this.axisMultiplier;
        this.tempAxis.y *= this.axisMultiplier;
        return this.tempAxis;
    }

    @Override
    public boolean init() {
        logger.config("Initialize OpenVR input.");
        for (int i = 0; i < 16; ++i) {
            this.rotStore[i] = new Quaternion();
            this.posStore[i] = new Vector3f();
            this.cStates[i] = new VRControllerState_t();
            this.cStates[i].setAutoSynch(false);
            this.cStates[i].setAutoRead(false);
            this.cStates[i].setAutoWrite(false);
            this.lastCallAxis[i] = new Vector2f();
            this.needsNewVelocity[i] = true;
            this.needsNewAngVelocity[i] = true;
            logger.config("  Input " + (i + 1) + "/" + 16 + " binded.");
        }
        return true;
    }

    @Override
    public VRTrackedController getTrackedController(int index) {
        if (this.trackedControllers != null && this.trackedControllers.size() > 0 && index < this.trackedControllers.size()) {
            return this.trackedControllers.get(index);
        }
        return null;
    }

    @Override
    public int getTrackedControllerCount() {
        return this.controllerCount;
    }

    public VRControllerState_t getRawControllerState(int index) {
        if (!this.isInputDeviceTracking(index)) {
            return null;
        }
        return this.cStates[controllerIndex[index]];
    }

    @Override
    public boolean isInputFocused() {
        if (this.environment != null) {
            return ((VR_IVRSystem_FnTable)((Object)this.environment.getVRHardware().getVRSystem())).IsInputFocusCapturedByAnotherProcess.apply() == 0;
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public boolean isInputDeviceTracking(int index) {
        if (index < 0 || index >= this.controllerCount) {
            return false;
        }
        if (this.environment != null) {
            if (this.environment.getVRHardware() instanceof OpenVR) {
                return ((OpenVR)this.environment.getVRHardware()).hmdTrackedDevicePoses[OpenVRInput.controllerIndex[index]].bPoseIsValid != 0;
            }
            throw new IllegalStateException("VR hardware " + this.environment.getVRHardware().getClass().getSimpleName() + " is not a subclass of " + OpenVR.class.getSimpleName());
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public Quaternion getOrientation(int index) {
        if (!this.isInputDeviceTracking(index)) {
            return null;
        }
        if (this.environment != null) {
            if (this.environment.getVRHardware() instanceof OpenVR) {
                index = controllerIndex[index];
                VRUtil.convertMatrix4toQuat(((OpenVR)this.environment.getVRHardware()).poseMatrices[index], this.rotStore[index]);
                return this.rotStore[index];
            }
            throw new IllegalStateException("VR hardware " + this.environment.getVRHardware().getClass().getSimpleName() + " is not a subclass of " + OpenVR.class.getSimpleName());
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public Vector3f getPosition(int index) {
        if (!this.isInputDeviceTracking(index)) {
            return null;
        }
        if (this.environment != null) {
            if (this.environment.getVRHardware() instanceof OpenVR) {
                index = controllerIndex[index];
                ((OpenVR)this.environment.getVRHardware()).poseMatrices[index].toTranslationVector(this.posStore[index]);
                this.posStore[index].x = -this.posStore[index].x;
                this.posStore[index].z = -this.posStore[index].z;
                return this.posStore[index];
            }
            throw new IllegalStateException("VR hardware " + this.environment.getVRHardware().getClass().getSimpleName() + " is not a subclass of " + OpenVR.class.getSimpleName());
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public Quaternion getFinalObserverRotation(int index) {
        if (this.environment != null) {
            OpenVRViewManager vrvm = (OpenVRViewManager)this.environment.getVRViewManager();
            if (vrvm != null) {
                if (!this.isInputDeviceTracking(index)) {
                    return null;
                }
                Object obs = this.environment.getObserver();
                if (obs instanceof Camera) {
                    this.tempq.set(((Camera)obs).getRotation());
                } else {
                    this.tempq.set(((Spatial)obs).getWorldRotation());
                }
                return this.tempq.multLocal(this.getOrientation(index));
            }
            throw new IllegalStateException("VR environment has no valid view manager.");
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public Vector3f getFinalObserverPosition(int index) {
        if (this.environment != null) {
            OpenVRViewManager vrvm = (OpenVRViewManager)this.environment.getVRViewManager();
            if (vrvm != null) {
                if (!this.isInputDeviceTracking(index)) {
                    return null;
                }
                Object obs = this.environment.getObserver();
                Vector3f pos = this.getPosition(index);
                if (obs instanceof Camera) {
                    ((Camera)obs).getRotation().mult(pos, pos);
                    return pos.addLocal(((Camera)obs).getLocation());
                }
                ((Spatial)obs).getWorldRotation().mult(pos, pos);
                return pos.addLocal(((Spatial)obs).getWorldTranslation());
            }
            throw new IllegalStateException("VR environment has no valid view manager.");
        }
        throw new IllegalStateException("VR input is not attached to a VR environment.");
    }

    @Override
    public void triggerHapticPulse(int controllerIndex, float seconds) {
        if (!this.environment.isInVR() || !this.isInputDeviceTracking(controllerIndex)) {
            return;
        }
        ((VR_IVRSystem_FnTable)((Object)this.environment.getVRHardware().getVRSystem())).TriggerHapticPulse.apply(OpenVRInput.controllerIndex[controllerIndex], 0, (short)Math.round(3.0f * seconds / 0.001f));
    }

    @Override
    public void updateConnectedControllers() {
        logger.config("Updating connected controllers.");
        if (this.environment != null) {
            this.controllerCount = 0;
            for (int i = 0; i < 16; ++i) {
                int classCallback = ((OpenVR)this.environment.getVRHardware()).getVRSystem().GetTrackedDeviceClass.apply(i);
                if (classCallback == 2 || classCallback == 3) {
                    String controllerName = "Unknown";
                    String manufacturerName = "Unknown";
                    try {
                        controllerName = OpenVRUtil.getTrackedDeviceStringProperty(((OpenVR)this.environment.getVRHardware()).getVRSystem(), i, 1000);
                        manufacturerName = OpenVRUtil.getTrackedDeviceStringProperty(((OpenVR)this.environment.getVRHardware()).getVRSystem(), i, 1005);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                    OpenVRInput.controllerIndex[this.controllerCount] = i;
                    if (this.trackedControllers == null) {
                        this.trackedControllers = new ArrayList<VRTrackedController>(16);
                    }
                    this.trackedControllers.add(new OpenVRTrackedController(i, this, controllerName, manufacturerName, this.environment));
                    this.triggerHapticPulse(this.controllerCount, 1.0f);
                    ++this.controllerCount;
                    logger.config("  Tracked controller " + (i + 1) + "/" + 16 + " " + controllerName + " (" + manufacturerName + ") attached.");
                    continue;
                }
                logger.config("  Controller " + (i + 1) + "/" + 16 + " ignored.");
            }
        } else {
            throw new IllegalStateException("VR input is not attached to a VR environment.");
        }
    }

    @Override
    public void updateControllerStates() {
        if (this.environment != null) {
            for (int i = 0; i < this.controllerCount; ++i) {
                int index = controllerIndex[i];
                ((OpenVR)this.environment.getVRHardware()).getVRSystem().GetControllerState.apply(index, this.cStates[index], 64);
                this.cStates[index].readField("ulButtonPressed");
                this.cStates[index].readField("rAxis");
                this.needsNewVelocity[index] = true;
                this.needsNewAngVelocity[index] = true;
            }
        } else {
            throw new IllegalStateException("VR input is not attached to a VR environment.");
        }
    }
}

