/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.openvr;

import com.jme3.app.VREnvironment;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.vr.AbstractVRMouseManager;
import com.jme3.input.vr.VRInputType;
import com.jme3.math.Vector2f;

public class OpenVRMouseManager
extends AbstractVRMouseManager {
    private final int AVERAGE_AMNT = 4;
    private int avgCounter;
    private final float[] lastXmv = new float[4];
    private final float[] lastYmv = new float[4];

    public OpenVRMouseManager(VREnvironment environment) {
        super(environment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateAnalogAsMouse(int inputIndex, AnalogListener mouseListener, String mouseXName, String mouseYName, float tpf) {
        if (this.getVREnvironment() == null) throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        if (this.getVREnvironment().getApplication() == null) throw new IllegalStateException("This VR environment is not attached to any application.");
        if (!this.getVREnvironment().isInVR() || this.getVREnvironment().getVRinput() == null || !this.getVREnvironment().getVRinput().isInputDeviceTracking(inputIndex)) {
            return;
        }
        Vector2f tpDelta = this.isThumbstickMode() ? this.getVREnvironment().getVRinput().getAxis(inputIndex, VRInputType.ViveTrackpadAxis) : this.getVREnvironment().getVRinput().getAxisDeltaSinceLastCall(inputIndex, VRInputType.ViveTrackpadAxis);
        float Xamount = (float)Math.pow(Math.abs(tpDelta.x) * this.getSpeedSensitivity(), this.getSpeedAcceleration());
        float Yamount = (float)Math.pow(Math.abs(tpDelta.y) * this.getSpeedSensitivity(), this.getSpeedAcceleration());
        if (tpDelta.x < 0.0f) {
            Xamount = -Xamount;
        }
        if (tpDelta.y < 0.0f) {
            Yamount = -Yamount;
        }
        Xamount *= this.getMouseMoveScale();
        Yamount *= this.getMouseMoveScale();
        if (mouseListener != null) {
            if (tpDelta.x != 0.0f && mouseXName != null) {
                mouseListener.onAnalog(mouseXName, Xamount * 0.2f, tpf);
            }
            if (tpDelta.y != 0.0f && mouseYName != null) {
                mouseListener.onAnalog(mouseYName, Yamount * 0.2f, tpf);
            }
        }
        if (!this.getVREnvironment().getApplication().getInputManager().isCursorVisible()) return;
        int index = (this.avgCounter + 1) % 4;
        this.lastXmv[index] = Xamount * 133.0f;
        this.lastYmv[index] = Yamount * 133.0f;
        this.cursorPos.x -= this.avg(this.lastXmv);
        this.cursorPos.y -= this.avg(this.lastYmv);
        Vector2f maxsize = this.getVREnvironment().getVRGUIManager().getCanvasSize();
        if (this.cursorPos.x > maxsize.x) {
            this.cursorPos.x = maxsize.x;
        }
        if (this.cursorPos.x < 0.0f) {
            this.cursorPos.x = 0.0f;
        }
        if (this.cursorPos.y > maxsize.y) {
            this.cursorPos.y = maxsize.y;
        }
        if (!(this.cursorPos.y < 0.0f)) return;
        this.cursorPos.y = 0.0f;
    }

    private float avg(float[] arr) {
        float amt = 0.0f;
        for (float f : arr) {
            amt += f;
        }
        return amt / (float)arr.length;
    }
}

