/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.openvr;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.VRTrackedController;
import com.jme3.input.vr.openvr.OpenVR;
import com.jme3.input.vr.openvr.OpenVRInput;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;

public class OpenVRTrackedController
implements VRTrackedController {
    private int controllerIndex = -1;
    private OpenVRInput hardware = null;
    private String name;
    private VREnvironment environment;
    private String manufacturer;

    public OpenVRTrackedController(int controllerIndex, OpenVRInput hardware, String name, String manufacturer, VREnvironment environment) {
        this.controllerIndex = controllerIndex;
        this.hardware = hardware;
        this.name = name;
        this.manufacturer = manufacturer;
        this.environment = environment;
    }

    @Override
    public Vector3f getPosition() {
        if (this.hardware != null) {
            return this.hardware.getPosition(this.controllerIndex);
        }
        throw new IllegalStateException("No underlying VR API.");
    }

    @Override
    public Quaternion getOrientation() {
        if (this.hardware != null) {
            return this.hardware.getOrientation(this.controllerIndex);
        }
        throw new IllegalStateException("No underlying VR API.");
    }

    @Override
    public Matrix4f getPose() {
        if (this.environment != null) {
            if (this.hardware != null) {
                return ((OpenVR)this.environment.getVRHardware()).poseMatrices[this.controllerIndex];
            }
            throw new IllegalStateException("No underlying VR API.");
        }
        throw new IllegalStateException("VR tracked device is not attached to any environment.");
    }

    @Override
    public String getControllerName() {
        return this.name;
    }

    @Override
    public String getControllerManufacturer() {
        return this.manufacturer;
    }
}

