/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.openvr;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.AbstractVRViewManager;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.openvr.OpenVR;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.system.jopenvr.DistortionCoordinates_t;
import com.jme3.system.jopenvr.OpenVRUtil;
import com.jme3.system.jopenvr.Texture_t;
import com.jme3.system.jopenvr.VRTextureBounds_t;
import com.jme3.system.jopenvr.VR_IVRSystem_FnTable;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import com.jme3.util.VRGUIPositioningMode;
import java.util.Iterator;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL11;

public class OpenVRViewManager
extends AbstractVRViewManager {
    private static final Logger logger = Logger.getLogger(OpenVRViewManager.class.getName());
    private VRTextureBounds_t leftTextureBounds;
    private Texture_t leftTextureType;
    private VRTextureBounds_t rightTextureBounds;
    private Texture_t rightTextureType;
    private Texture2D dualEyeTex;
    private final Vector3f finalPosition = new Vector3f();
    private final Quaternion finalRotation = new Quaternion();
    private final Vector3f hmdPos = new Vector3f();
    private final Quaternion hmdRot = new Quaternion();

    public OpenVRViewManager(VREnvironment environment) {
        this.environment = environment;
    }

    protected int getLeftTexId() {
        return this.getLeftTexture().getImage().getId();
    }

    protected int getRightTexId() {
        return this.getRightTexture().getImage().getId();
    }

    private int getFullTexId() {
        return this.dualEyeTex.getImage().getId();
    }

    private void initTextureSubmitStructs() {
        this.leftTextureType = new Texture_t();
        this.rightTextureType = new Texture_t();
        if (this.environment != null) {
            if (this.environment.getVRHardware() instanceof OpenVR) {
                this.leftTextureBounds = new VRTextureBounds_t();
                this.rightTextureBounds = new VRTextureBounds_t();
                this.leftTextureBounds.uMax = 0.5f;
                this.leftTextureBounds.uMin = 0.0f;
                this.leftTextureBounds.vMax = 1.0f;
                this.leftTextureBounds.vMin = 0.0f;
                this.leftTextureBounds.setAutoSynch(false);
                this.leftTextureBounds.setAutoRead(false);
                this.leftTextureBounds.setAutoWrite(false);
                this.leftTextureBounds.write();
                this.rightTextureBounds.uMax = 1.0f;
                this.rightTextureBounds.uMin = 0.5f;
                this.rightTextureBounds.vMax = 1.0f;
                this.rightTextureBounds.vMin = 0.0f;
                this.rightTextureBounds.setAutoSynch(false);
                this.rightTextureBounds.setAutoRead(false);
                this.rightTextureBounds.setAutoWrite(false);
                this.rightTextureBounds.write();
                this.leftTextureType.eColorSpace = 1;
                this.leftTextureType.eType = 1;
                this.leftTextureType.setAutoSynch(false);
                this.leftTextureType.setAutoRead(false);
                this.leftTextureType.setAutoWrite(false);
                this.leftTextureType.handle = -1;
                this.rightTextureType.eColorSpace = 1;
                this.rightTextureType.eType = 1;
                this.rightTextureType.setAutoSynch(false);
                this.rightTextureType.setAutoRead(false);
                this.rightTextureType.setAutoWrite(false);
                this.rightTextureType.handle = -1;
                logger.config("Init eyes native texture binds");
                logger.config("  Left eye texture");
                logger.config("           address: " + this.leftTextureType.getPointer());
                logger.config("              size: " + this.leftTextureType.size() + " bytes");
                logger.config("       color space: " + OpenVRUtil.getEColorSpaceString(this.leftTextureType.eColorSpace));
                logger.config("              type: " + OpenVRUtil.getETextureTypeString(this.leftTextureType.eType));
                logger.config("         auto read: " + this.leftTextureType.getAutoRead());
                logger.config("        auto write: " + this.leftTextureType.getAutoWrite());
                logger.config("    handle address: " + this.leftTextureType.handle);
                logger.config("      handle value: " + this.leftTextureType.handle);
                logger.config("");
                logger.config("  Right eye texture");
                logger.config("           address: " + this.rightTextureType.getPointer());
                logger.config("              size: " + this.rightTextureType.size() + " bytes");
                logger.config("       color space: " + OpenVRUtil.getEColorSpaceString(this.rightTextureType.eColorSpace));
                logger.config("              type: " + OpenVRUtil.getETextureTypeString(this.rightTextureType.eType));
                logger.config("         auto read: " + this.rightTextureType.getAutoRead());
                logger.config("        auto write: " + this.rightTextureType.getAutoWrite());
                logger.config("    handle address: " + this.rightTextureType.handle);
                logger.config("      handle value: " + this.rightTextureType.handle);
            }
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
    }

    @Override
    public void render() {
    }

    @Override
    public void postRender() {
        if (this.environment != null) {
            VRAPI api;
            if (this.environment.isInVR() && (api = this.environment.getVRHardware()).getCompositor() != null) {
                int errl = 0;
                int errr = 0;
                if (this.environment.isInstanceRendering()) {
                    if (this.leftTextureType.handle == -1 || this.leftTextureType.handle != this.getFullTexId()) {
                        this.leftTextureType.handle = this.getFullTexId();
                        if (this.leftTextureType.handle != -1) {
                            this.leftTextureType.write();
                        }
                    } else if (api instanceof OpenVR) {
                        int submitFlag = 0;
                        errr = ((OpenVR)api).getCompositor().Submit.apply(1, this.leftTextureType, this.rightTextureBounds, submitFlag);
                        errl = ((OpenVR)api).getCompositor().Submit.apply(0, this.leftTextureType, this.leftTextureBounds, submitFlag);
                    }
                } else if (this.leftTextureType.handle == -1 || this.rightTextureType.handle == -1 || this.leftTextureType.handle != this.getLeftTexId() || this.rightTextureType.handle != this.getRightTexId()) {
                    this.leftTextureType.handle = this.getLeftTexId();
                    if (this.leftTextureType.handle != -1) {
                        logger.fine("Writing Left texture to native memory at " + this.leftTextureType.getPointer());
                        this.leftTextureType.write();
                    }
                    this.rightTextureType.handle = this.getRightTexId();
                    if (this.rightTextureType.handle != -1) {
                        logger.fine("Writing Right texture to native memory at " + this.leftTextureType.getPointer());
                        this.rightTextureType.write();
                    }
                } else if (api instanceof OpenVR) {
                    errl = ((OpenVR)api).getCompositor().Submit.apply(0, this.leftTextureType, null, 0);
                    errr = ((OpenVR)api).getCompositor().Submit.apply(1, this.rightTextureType, null, 0);
                }
                if (errl != 0) {
                    logger.severe("Submit to left compositor error: " + OpenVRUtil.getEVRCompositorErrorString(errl) + " (" + Integer.toString(errl) + ")");
                    logger.severe("  Texture color space: " + OpenVRUtil.getEColorSpaceString(this.leftTextureType.eColorSpace));
                    logger.severe("  Texture type: " + OpenVRUtil.getETextureTypeString(this.leftTextureType.eType));
                    logger.severe("  Texture handle: " + this.leftTextureType.handle);
                    logger.severe("  Left eye texture " + this.leftEyeTexture.getName() + " (" + this.leftEyeTexture.getImage().getId() + ")");
                    logger.severe("                 Type: " + this.leftEyeTexture.getType());
                    logger.severe("                 Size: " + this.leftEyeTexture.getImage().getWidth() + "x" + this.leftEyeTexture.getImage().getHeight());
                    logger.severe("          Image depth: " + this.leftEyeTexture.getImage().getDepth());
                    logger.severe("         Image format: " + this.leftEyeTexture.getImage().getFormat());
                    logger.severe("    Image color space: " + this.leftEyeTexture.getImage().getColorSpace());
                }
                if (errr != 0) {
                    logger.severe("Submit to right compositor error: " + OpenVRUtil.getEVRCompositorErrorString(errl) + " (" + Integer.toString(errl) + ")");
                    logger.severe("  Texture color space: " + OpenVRUtil.getEColorSpaceString(this.rightTextureType.eColorSpace));
                    logger.severe("  Texture type: " + OpenVRUtil.getETextureTypeString(this.rightTextureType.eType));
                    logger.severe("  Texture handle: " + this.rightTextureType.handle);
                    logger.severe("  Right eye texture " + this.rightEyeTexture.getName() + " (" + this.rightEyeTexture.getImage().getId() + ")");
                    logger.severe("                 Type: " + this.rightEyeTexture.getType());
                    logger.severe("                 Size: " + this.rightEyeTexture.getImage().getWidth() + "x" + this.rightEyeTexture.getImage().getHeight());
                    logger.severe("          Image depth: " + this.rightEyeTexture.getImage().getDepth());
                    logger.severe("         Image format: " + this.rightEyeTexture.getImage().getFormat());
                    logger.severe("    Image color space: " + this.rightEyeTexture.getImage().getColorSpace());
                }
            }
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
    }

    @Override
    public void initialize() {
        logger.config("Initializing VR view manager.");
        if (this.environment != null) {
            this.initTextureSubmitStructs();
            this.setupCamerasAndViews();
            this.setupVRScene();
            this.moveScreenProcessingToEyes();
            if (this.environment.hasTraditionalGUIOverlay()) {
                this.environment.getVRMouseManager().initialize();
                this.update(0.0f);
                this.environment.getVRGUIManager().positionGui();
            }
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
        logger.config("Initialized VR view manager [SUCCESS]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareCameraSize(Camera cam, float xMult) {
        if (this.environment == null) throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        if (this.environment.getApplication() == null) throw new IllegalStateException("This VR environment is not attached to any application.");
        Vector2f size = new Vector2f();
        VRAPI vrhmd = this.environment.getVRHardware();
        if (vrhmd == null) {
            size.x = 1280.0f;
            size.y = 720.0f;
        } else {
            vrhmd.getRenderSize(size);
        }
        if (size.x < (float)this.environment.getApplication().getContext().getSettings().getWidth()) {
            size.x = this.environment.getApplication().getContext().getSettings().getWidth();
        }
        if (size.y < (float)this.environment.getApplication().getContext().getSettings().getHeight()) {
            size.y = this.environment.getApplication().getContext().getSettings().getHeight();
        }
        if (this.environment.isInstanceRendering()) {
            size.x *= 2.0f;
        }
        size.x *= xMult;
        size.x *= this.getResolutionMuliplier();
        size.y *= this.getResolutionMuliplier();
        if ((float)cam.getWidth() == size.x && (float)cam.getHeight() == size.y) return;
        cam.resize((int)size.x, (int)size.y, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupVRScene() {
        if (this.environment == null) throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        if (this.environment.getApplication() == null) throw new IllegalStateException("This VR environment is not attached to any application.");
        if (this.environment.isInstanceRendering()) {
            if (!this.environment.getApplication().getContext().getSettings().isSwapBuffers()) return;
            this.setupMirrorBuffers(this.environment.getCamera(), (Texture)this.dualEyeTex, true);
            return;
        }
        this.leftEyeTexture = (Texture2D)this.getLeftViewPort().getOutputFrameBuffer().getColorBuffer().getTexture();
        this.rightEyeTexture = (Texture2D)this.getRightViewPort().getOutputFrameBuffer().getColorBuffer().getTexture();
        this.leftEyeDepth = (Texture2D)this.getLeftViewPort().getOutputFrameBuffer().getDepthBuffer().getTexture();
        this.rightEyeDepth = (Texture2D)this.getRightViewPort().getOutputFrameBuffer().getDepthBuffer().getTexture();
        Iterator spatialIter = this.environment.getApplication().getViewPort().getScenes().iterator();
        while (spatialIter.hasNext()) {
            this.environment.getApplication().getViewPort().detachScene((Spatial)spatialIter.next());
        }
        spatialIter = this.environment.getApplication().getGuiViewPort().getScenes().iterator();
        while (spatialIter.hasNext()) {
            this.environment.getApplication().getGuiViewPort().detachScene((Spatial)spatialIter.next());
        }
        if (this.environment.getVRHardware().getCompositor() == null) {
            Node distortionScene = new Node();
            Material leftMat = new Material(this.environment.getApplication().getAssetManager(), "Common/MatDefs/VR/OpenVR.j3md");
            leftMat.setTexture("Texture", (Texture)this.leftEyeTexture);
            Geometry leftEye = new Geometry("box", OpenVRViewManager.setupDistortionMesh(0, this.environment.getVRHardware()));
            leftEye.setMaterial(leftMat);
            distortionScene.attachChild((Spatial)leftEye);
            Material rightMat = new Material(this.environment.getApplication().getAssetManager(), "Common/MatDefs/VR/OpenVR.j3md");
            rightMat.setTexture("Texture", (Texture)this.rightEyeTexture);
            Geometry rightEye = new Geometry("box", OpenVRViewManager.setupDistortionMesh(1, this.environment.getVRHardware()));
            rightEye.setMaterial(rightMat);
            distortionScene.attachChild((Spatial)rightEye);
            distortionScene.updateGeometricState();
            this.environment.getApplication().getViewPort().attachScene((Spatial)distortionScene);
        }
        if (!this.environment.getApplication().getContext().getSettings().isSwapBuffers()) return;
        this.setupMirrorBuffers(this.environment.getCamera(), (Texture)this.leftEyeTexture, false);
    }

    @Override
    public void update(float tpf) {
        if (this.environment != null) {
            Vector3f objPos;
            Quaternion objRot;
            Object obs = this.environment.getObserver();
            if (obs instanceof Camera) {
                objRot = ((Camera)obs).getRotation();
                objPos = ((Camera)obs).getLocation();
            } else {
                objRot = ((Spatial)obs).getWorldRotation();
                objPos = ((Spatial)obs).getWorldTranslation();
            }
            VRAPI dev = this.environment.getVRHardware();
            if (dev != null) {
                dev.updatePose();
                dev.getPositionAndOrientation(this.hmdPos, this.hmdRot);
                if (obs != null) {
                    this.finalRotation.set(objRot);
                    this.finalRotation.mult(this.hmdPos, this.hmdPos);
                    this.finalRotation.multLocal(this.hmdRot);
                }
                this.finalizeCamera(dev.getHMDVectorPoseLeftEye(), objPos, this.getLeftCamera());
                this.finalizeCamera(dev.getHMDVectorPoseRightEye(), objPos, this.getRightCamera());
            } else {
                this.getLeftCamera().setFrame(objPos, objRot);
                this.getRightCamera().setFrame(objPos, objRot);
            }
            if (this.environment.hasTraditionalGUIOverlay()) {
                this.environment.getVRMouseManager().update(tpf);
                if (this.environment.getVRGUIManager().isWantsReposition() || this.environment.getVRGUIManager().getPositioningMode() != VRGUIPositioningMode.MANUAL) {
                    this.environment.getVRGUIManager().positionGuiNow(tpf);
                    this.environment.getVRGUIManager().updateGuiQuadGeometricState();
                }
            }
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
    }

    private void finalizeCamera(Vector3f eyePos, Vector3f obsPosition, Camera cam) {
        this.finalRotation.mult(eyePos, this.finalPosition);
        this.finalPosition.addLocal(this.hmdPos);
        if (obsPosition != null) {
            this.finalPosition.addLocal(obsPosition);
        }
        this.finalPosition.y += this.getHeightAdjustment();
        cam.setFrame(this.finalPosition, this.finalRotation);
    }

    private void setupCamerasAndViews() {
        if (this.environment != null) {
            Camera origCam = this.environment.getCamera();
            float fFar = origCam.getFrustumFar();
            float fNear = origCam.getFrustumNear();
            if (this.environment.isInstanceRendering()) {
                this.leftCamera = origCam;
            } else if (!this.environment.compositorAllowed()) {
                origCam.setFrustumFar(100.0f);
                origCam.setFrustumNear(1.0f);
                this.leftCamera = origCam.clone();
                this.prepareCameraSize(origCam, 2.0f);
            } else {
                this.leftCamera = origCam.clone();
            }
            this.getLeftCamera().setFrustumPerspective(this.environment.getDefaultFOV(), this.environment.getDefaultAspect(), fNear, fFar);
            this.prepareCameraSize(this.getLeftCamera(), 1.0f);
            if (this.environment.getVRHardware() != null) {
                this.getLeftCamera().setProjectionMatrix(this.environment.getVRHardware().getHMDMatrixProjectionLeftEye(this.getLeftCamera()));
            }
            if (!this.environment.isInstanceRendering()) {
                this.leftViewPort = this.setupViewBuffers(this.getLeftCamera(), "Left View");
                this.rightCamera = this.getLeftCamera().clone();
                if (this.environment.getVRHardware() != null) {
                    this.getRightCamera().setProjectionMatrix(this.environment.getVRHardware().getHMDMatrixProjectionRightEye(this.getRightCamera()));
                }
                this.rightViewPort = this.setupViewBuffers(this.getRightCamera(), "Right View");
            } else if (this.environment.getApplication() != null) {
                logger.severe("THIS CODE NEED CHANGES !!!");
                this.leftViewPort = this.environment.getApplication().getViewPort();
                this.rightCamera = this.getLeftCamera().clone();
                if (this.environment.getVRHardware() != null) {
                    this.getRightCamera().setProjectionMatrix(this.environment.getVRHardware().getHMDMatrixProjectionRightEye(this.getRightCamera()));
                }
                GL11.glEnable((int)12288);
                this.setupFinalFullTexture(this.environment.getApplication().getViewPort().getCamera());
            } else {
                throw new IllegalStateException("This VR environment is not attached to any application.");
            }
            this.environment.getVRGUIManager().setupGui(this.getLeftCamera(), this.getRightCamera(), this.getLeftViewPort(), this.getRightViewPort());
            if (this.environment.getVRHardware() != null) {
                this.environment.getVRHardware().getHMDMatrixPoseLeftEye();
                this.environment.getVRHardware().getHMDMatrixPoseRightEye();
            }
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
    }

    private ViewPort setupMirrorBuffers(Camera cam, Texture tex, boolean expand) {
        if (this.environment != null) {
            if (this.environment.getApplication() != null) {
                Camera clonecam = cam.clone();
                ViewPort viewPort = this.environment.getApplication().getRenderManager().createPostView("MirrorView", clonecam);
                clonecam.setParallelProjection(true);
                viewPort.setClearFlags(true, true, true);
                viewPort.setBackgroundColor(ColorRGBA.Black);
                Picture pic = new Picture("fullscene");
                pic.setLocalTranslation(-0.75f, -0.5f, 0.0f);
                if (expand) {
                    pic.setLocalScale(3.0f, 1.0f, 1.0f);
                } else {
                    pic.setLocalScale(1.5f, 1.0f, 1.0f);
                }
                pic.setQueueBucket(RenderQueue.Bucket.Opaque);
                pic.setTexture(this.environment.getApplication().getAssetManager(), (Texture2D)tex, false);
                viewPort.attachScene((Spatial)pic);
                viewPort.setOutputFrameBuffer(null);
                pic.updateGeometricState();
                return viewPort;
            }
            throw new IllegalStateException("This VR environment is not attached to any application.");
        }
        throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
    }

    private void setupFinalFullTexture(Camera cam) {
        if (this.environment != null) {
            if (this.environment.getApplication() == null) {
                throw new IllegalStateException("This VR environment is not attached to any application.");
            }
        } else {
            throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
        }
        FrameBuffer out = new FrameBuffer(cam.getWidth(), cam.getHeight(), 1);
        this.dualEyeTex = new Texture2D(cam.getWidth(), cam.getHeight(), Image.Format.RGBA8);
        this.dualEyeTex.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
        this.dualEyeTex.setMagFilter(Texture.MagFilter.Bilinear);
        logger.config("Dual eye texture " + this.dualEyeTex.getName() + " (" + this.dualEyeTex.getImage().getId() + ")");
        logger.config("               Type: " + this.dualEyeTex.getType());
        logger.config("               Size: " + this.dualEyeTex.getImage().getWidth() + "x" + this.dualEyeTex.getImage().getHeight());
        logger.config("        Image depth: " + this.dualEyeTex.getImage().getDepth());
        logger.config("       Image format: " + this.dualEyeTex.getImage().getFormat());
        logger.config("  Image color space: " + this.dualEyeTex.getImage().getColorSpace());
        out.setDepthBuffer(Image.Format.Depth);
        out.setColorTexture(this.dualEyeTex);
        ViewPort viewPort = this.environment.getApplication().getViewPort();
        viewPort.setClearFlags(true, true, true);
        viewPort.setBackgroundColor(ColorRGBA.Black);
        viewPort.setOutputFrameBuffer(out);
    }

    private ViewPort setupViewBuffers(Camera cam, String viewName) {
        if (this.environment != null) {
            if (this.environment.getApplication() != null) {
                FrameBuffer offBufferLeft = new FrameBuffer(cam.getWidth(), cam.getHeight(), 1);
                Texture2D offTex = new Texture2D(cam.getWidth(), cam.getHeight(), Image.Format.RGBA8);
                offTex.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                offTex.setMagFilter(Texture.MagFilter.Bilinear);
                offBufferLeft.setDepthBuffer(Image.Format.Depth);
                offBufferLeft.setColorTexture(offTex);
                ViewPort viewPort = this.environment.getApplication().getRenderManager().createPreView(viewName, cam);
                viewPort.setClearFlags(true, true, true);
                viewPort.setBackgroundColor(ColorRGBA.Black);
                Iterator spatialIter = this.environment.getApplication().getViewPort().getScenes().iterator();
                while (spatialIter.hasNext()) {
                    viewPort.attachScene((Spatial)spatialIter.next());
                }
                viewPort.setOutputFrameBuffer(offBufferLeft);
                return viewPort;
            }
            throw new IllegalStateException("This VR environment is not attached to any application.");
        }
        throw new IllegalStateException("This VR view manager is not attached to any VR environment.");
    }

    public static Mesh setupDistortionMesh(int eye, VRAPI api) {
        Mesh distortionMesh = new Mesh();
        float m_iLensGridSegmentCountH = 43.0f;
        float m_iLensGridSegmentCountV = 43.0f;
        float w = 1.0f / (m_iLensGridSegmentCountH - 1.0f);
        float h = 1.0f / (m_iLensGridSegmentCountV - 1.0f);
        float[] verts = new float[(int)(m_iLensGridSegmentCountV * m_iLensGridSegmentCountH) * 3];
        float[] texcoordR = new float[(int)(m_iLensGridSegmentCountV * m_iLensGridSegmentCountH) * 2];
        float[] texcoordG = new float[(int)(m_iLensGridSegmentCountV * m_iLensGridSegmentCountH) * 2];
        float[] texcoordB = new float[(int)(m_iLensGridSegmentCountV * m_iLensGridSegmentCountH) * 2];
        int vertPos = 0;
        int coordPos = 0;
        float Xoffset = eye == 0 ? -1.0f : 0.0f;
        int y = 0;
        while ((float)y < m_iLensGridSegmentCountV) {
            int x = 0;
            while ((float)x < m_iLensGridSegmentCountH) {
                float u = (float)x * w;
                float v = 1.0f - (float)y * h;
                verts[vertPos] = Xoffset + u;
                verts[vertPos + 1] = -1.0f + (float)(2 * y) * h;
                verts[vertPos + 2] = 0.0f;
                vertPos += 3;
                DistortionCoordinates_t dc0 = new DistortionCoordinates_t();
                if (api.getVRSystem() == null) {
                    texcoordR[coordPos] = u;
                    texcoordR[coordPos + 1] = 1.0f - v;
                    texcoordG[coordPos] = u;
                    texcoordG[coordPos + 1] = 1.0f - v;
                    texcoordB[coordPos] = u;
                    texcoordB[coordPos + 1] = 1.0f - v;
                } else {
                    ((VR_IVRSystem_FnTable)((Object)api.getVRSystem())).ComputeDistortion.apply(eye, u, v, dc0);
                    texcoordR[coordPos] = dc0.rfRed[0];
                    texcoordR[coordPos + 1] = 1.0f - dc0.rfRed[1];
                    texcoordG[coordPos] = dc0.rfGreen[0];
                    texcoordG[coordPos + 1] = 1.0f - dc0.rfGreen[1];
                    texcoordB[coordPos] = dc0.rfBlue[0];
                    texcoordB[coordPos + 1] = 1.0f - dc0.rfBlue[1];
                }
                coordPos += 2;
                ++x;
            }
            ++y;
        }
        int[] indices = new int[(int)((m_iLensGridSegmentCountV - 1.0f) * (m_iLensGridSegmentCountH - 1.0f)) * 6];
        int indexPos = 0;
        boolean offset = false;
        int y2 = 0;
        while ((float)y2 < m_iLensGridSegmentCountV - 1.0f) {
            int x = 0;
            while ((float)x < m_iLensGridSegmentCountH - 1.0f) {
                int a = (int)(m_iLensGridSegmentCountH * (float)y2 + (float)x + (float)offset);
                int b = (int)(m_iLensGridSegmentCountH * (float)y2 + (float)x + 1.0f + (float)offset);
                int c = (int)((float)(y2 + 1) * m_iLensGridSegmentCountH + (float)x + 1.0f + (float)offset);
                int d = (int)((float)(y2 + 1) * m_iLensGridSegmentCountH + (float)x + (float)offset);
                indices[indexPos] = a;
                indices[indexPos + 1] = b;
                indices[indexPos + 2] = c;
                indices[indexPos + 3] = a;
                indices[indexPos + 4] = c;
                indices[indexPos + 5] = d;
                indexPos += 6;
                ++x;
            }
            ++y2;
        }
        distortionMesh.setBuffer(VertexBuffer.Type.Position, 3, verts);
        distortionMesh.setBuffer(VertexBuffer.Type.Index, 1, indices);
        distortionMesh.setBuffer(VertexBuffer.Type.TexCoord, 2, texcoordR);
        distortionMesh.setBuffer(VertexBuffer.Type.TexCoord2, 2, texcoordG);
        distortionMesh.setBuffer(VertexBuffer.Type.TexCoord3, 2, texcoordB);
        distortionMesh.setStatic();
        return distortionMesh;
    }
}

