/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.vr.osvr;

import com.jme3.app.VREnvironment;
import com.jme3.input.vr.HmdType;
import com.jme3.input.vr.VRAPI;
import com.jme3.input.vr.VRInputAPI;
import com.jme3.input.vr.osvr.OSVRInput;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.system.osvr.osvrclientkit.OsvrClientKitLibrary;
import com.jme3.system.osvr.osvrdisplay.OsvrDisplayLibrary;
import com.jme3.system.osvr.osvrmatrixconventions.OSVR_Pose3;
import com.jme3.system.osvr.osvrrendermanageropengl.OSVR_GraphicsLibraryOpenGL;
import com.jme3.system.osvr.osvrrendermanageropengl.OSVR_OpenResultsOpenGL;
import com.jme3.system.osvr.osvrrendermanageropengl.OSVR_RenderBufferOpenGL;
import com.jme3.system.osvr.osvrrendermanageropengl.OSVR_RenderInfoOpenGL;
import com.jme3.system.osvr.osvrrendermanageropengl.OSVR_RenderParams;
import com.jme3.system.osvr.osvrrendermanageropengl.OSVR_ViewportDescription;
import com.jme3.system.osvr.osvrrendermanageropengl.OsvrRenderManagerOpenGLLibrary;
import com.ochafik.lang.jnaerator.runtime.NativeSize;
import com.ochafik.lang.jnaerator.runtime.NativeSizeByReference;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.WGL;

public class OSVR
implements VRAPI {
    private static final Logger logger = Logger.getLogger(OSVR.class.getName());
    public static final int FIRST_VIEWER = 0;
    public static final int EYE_LEFT = 0;
    public static final int EYE_RIGHT = 1;
    public static final NativeSize EYE_LEFT_SIZE = new NativeSize(0L);
    public static final NativeSize EYE_RIGHT_SIZE = new NativeSize(1L);
    public static byte[] defaultJString = new byte[]{106, 0};
    public static byte[] OpenGLString = new byte[]{79, 112, 101, 110, 71, 76, 0};
    private final Matrix4f[] eyeMatrix = new Matrix4f[2];
    private PointerByReference grabRM;
    private PointerByReference grabRMOGL;
    private PointerByReference grabRIC;
    OSVR_RenderParams.ByValue renderParams;
    OsvrClientKitLibrary.OSVR_ClientContext context;
    OSVR_GraphicsLibraryOpenGL.ByValue graphicsLibrary;
    Pointer renderManager;
    Pointer renderManagerOpenGL;
    Pointer renderInfoCollection;
    Pointer registerBufferState;
    OSVRInput VRinput;
    NativeSize numRenderInfo;
    NativeSizeByReference grabNumInfo = new NativeSizeByReference();
    OSVR_RenderInfoOpenGL.ByValue eyeLeftInfo;
    OSVR_RenderInfoOpenGL.ByValue eyeRightInfo;
    Matrix4f hmdPoseLeftEye;
    Matrix4f hmdPoseRightEye;
    Vector3f hmdPoseLeftEyeVec;
    Vector3f hmdPoseRightEyeVec;
    Vector3f hmdSeatToStand;
    OsvrDisplayLibrary.OSVR_DisplayConfig displayConfig;
    OSVR_Pose3 hmdPose = new OSVR_Pose3();
    Vector3f storePos = new Vector3f();
    Quaternion storeRot = new Quaternion();
    PointerByReference presentState = new PointerByReference();
    OSVR_OpenResultsOpenGL openResults = new OSVR_OpenResultsOpenGL();
    long glfwContext;
    long renderManagerContext;
    long wglGLFW;
    long wglRM;
    boolean initSuccess = false;
    boolean flipEyes = false;
    private VREnvironment environment = null;

    public OSVR(VREnvironment environment) {
        this.environment = environment;
    }

    public boolean handleRenderBufferPresent(OSVR_ViewportDescription.ByValue leftView, OSVR_ViewportDescription.ByValue rightView, OSVR_RenderBufferOpenGL.ByValue leftBuffer, OSVR_RenderBufferOpenGL.ByValue rightBuffer) {
        if (this.eyeLeftInfo == null || this.eyeRightInfo == null) {
            return false;
        }
        OsvrRenderManagerOpenGLLibrary.osvrRenderManagerStartPresentRenderBuffers(this.presentState);
        this.getEyeInfo();
        OsvrRenderManagerOpenGLLibrary.osvrRenderManagerPresentRenderBufferOpenGL(this.presentState.getValue(), leftBuffer, this.eyeLeftInfo, leftView);
        OsvrRenderManagerOpenGLLibrary.osvrRenderManagerPresentRenderBufferOpenGL(this.presentState.getValue(), rightBuffer, this.eyeRightInfo, rightView);
        byte retval = OsvrRenderManagerOpenGLLibrary.osvrRenderManagerFinishPresentRenderBuffers(this.renderManager, this.presentState.getValue(), this.renderParams, (byte)0);
        return retval == 0;
    }

    @Override
    public boolean initialize() {
        logger.config("Initialize OSVR system.");
        this.hmdPose.setAutoSynch(false);
        this.context = OsvrClientKitLibrary.osvrClientInit(defaultJString, 0);
        this.VRinput = new OSVRInput(this.environment);
        boolean bl = this.initSuccess = this.context != null && this.VRinput.init();
        if (this.initSuccess) {
            PointerByReference grabDisplay = new PointerByReference();
            byte retval = OsvrDisplayLibrary.osvrClientGetDisplay(this.context, grabDisplay);
            if (retval != 0) {
                System.out.println("OSVR Get Display Error: " + retval);
                this.initSuccess = false;
                return false;
            }
            this.displayConfig = new OsvrDisplayLibrary.OSVR_DisplayConfig(grabDisplay.getValue());
            System.out.println("Waiting for the display to fully start up, including receiving initial pose update...");
            int i = 400;
            while (OsvrDisplayLibrary.osvrClientCheckDisplayStartup(this.displayConfig) != 0) {
                if (i-- < 0) {
                    System.out.println("Couldn't get display startup update in time, continuing anyway...");
                    break;
                }
                OsvrClientKitLibrary.osvrClientUpdate(this.context);
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {}
            }
            System.out.println("OK, display startup status is good!");
        }
        return this.initSuccess;
    }

    public void grabGLFWContext() {
        this.wglGLFW = WGL.wglGetCurrentContext();
        this.glfwContext = GLFW.glfwGetCurrentContext();
    }

    public boolean shareContext() {
        if (WGL.wglShareLists((long)this.wglRM, (long)this.wglGLFW)) {
            System.out.println("Context sharing success!");
            return true;
        }
        System.out.println("Context sharing problem...");
        return false;
    }

    @Override
    public boolean initVRCompositor(boolean allowed) {
        if (!allowed || this.renderManager != null) {
            return false;
        }
        this.grabGLFWContext();
        this.graphicsLibrary = new OSVR_GraphicsLibraryOpenGL.ByValue();
        this.graphicsLibrary.toolkit = null;
        this.graphicsLibrary.setAutoSynch(false);
        this.grabRM = new PointerByReference();
        this.grabRMOGL = new PointerByReference();
        byte retval = OsvrRenderManagerOpenGLLibrary.osvrCreateRenderManagerOpenGL(this.context, OpenGLString, this.graphicsLibrary, this.grabRM, this.grabRMOGL);
        if (retval == 0) {
            this.renderManager = this.grabRM.getValue();
            this.renderManagerOpenGL = this.grabRMOGL.getValue();
            if (this.renderManager == null || this.renderManagerOpenGL == null) {
                System.out.println("Render Manager Created NULL, error!");
                return false;
            }
            this.openResults.setAutoSynch(false);
            retval = OsvrRenderManagerOpenGLLibrary.osvrRenderManagerOpenDisplayOpenGL(this.renderManager, this.openResults);
            if (retval == 0) {
                this.wglRM = WGL.wglGetCurrentContext();
                this.renderManagerContext = GLFW.glfwGetCurrentContext();
                this.shareContext();
                OsvrClientKitLibrary.osvrClientUpdate(this.context);
                this.renderParams = new OSVR_RenderParams.ByValue();
                this.renderParams.setAutoSynch(false);
                OsvrRenderManagerOpenGLLibrary.osvrRenderManagerGetDefaultRenderParams(this.renderParams);
                this.grabRIC = new PointerByReference();
                retval = OsvrRenderManagerOpenGLLibrary.osvrRenderManagerGetRenderInfoCollection(this.renderManager, this.renderParams, this.grabRIC);
                if (retval == 0) {
                    this.renderInfoCollection = this.grabRIC.getValue();
                    OsvrRenderManagerOpenGLLibrary.osvrRenderManagerGetNumRenderInfoInCollection(this.renderInfoCollection, this.grabNumInfo);
                    this.numRenderInfo = this.grabNumInfo.getValue();
                    this.eyeLeftInfo = new OSVR_RenderInfoOpenGL.ByValue();
                    this.eyeRightInfo = new OSVR_RenderInfoOpenGL.ByValue();
                    this.eyeLeftInfo.setAutoSynch(false);
                    this.eyeRightInfo.setAutoSynch(false);
                    return true;
                }
                OsvrRenderManagerOpenGLLibrary.osvrDestroyRenderManager(this.renderManager);
                System.out.println("OSVR Render Manager Info Collection Error: " + retval);
                return false;
            }
            OsvrRenderManagerOpenGLLibrary.osvrDestroyRenderManager(this.renderManager);
            System.out.println("OSVR Open Render Manager Display Error: " + retval);
            return false;
        }
        System.out.println("OSVR Create Render Manager Error: " + retval);
        return false;
    }

    public OsvrClientKitLibrary.OSVR_ClientContext getVRSystem() {
        return this.context;
    }

    public Pointer getCompositor() {
        return this.renderManager;
    }

    @Override
    public String getName() {
        return "OSVR";
    }

    @Override
    public VRInputAPI getVRinput() {
        return this.VRinput;
    }

    @Override
    public void setFlipEyes(boolean set) {
        this.flipEyes = set;
    }

    @Override
    public void printLatencyInfoToConsole(boolean set) {
    }

    @Override
    public int getDisplayFrequency() {
        return 60;
    }

    @Override
    public void destroy() {
        if (this.renderManager != null) {
            OsvrRenderManagerOpenGLLibrary.osvrDestroyRenderManager(this.renderManager);
        }
        if (this.displayConfig != null) {
            OsvrDisplayLibrary.osvrClientFreeDisplay(this.displayConfig);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initSuccess;
    }

    @Override
    public void reset() {
    }

    @Override
    public void getRenderSize(Vector2f store) {
        if (this.eyeLeftInfo == null || this.eyeLeftInfo.viewport.width == 0.0) {
            store.x = 1280.0f;
            store.y = 720.0f;
        } else {
            store.x = (float)this.eyeLeftInfo.viewport.width;
            store.y = (float)this.eyeLeftInfo.viewport.height;
        }
    }

    public void getEyeInfo() {
        OsvrRenderManagerOpenGLLibrary.osvrRenderManagerGetRenderInfoFromCollectionOpenGL(this.renderInfoCollection, EYE_LEFT_SIZE, this.eyeLeftInfo);
        OsvrRenderManagerOpenGLLibrary.osvrRenderManagerGetRenderInfoFromCollectionOpenGL(this.renderInfoCollection, EYE_RIGHT_SIZE, this.eyeRightInfo);
        this.eyeLeftInfo.read();
        this.eyeRightInfo.read();
    }

    @Override
    public float getInterpupillaryDistance() {
        return 0.065f;
    }

    @Override
    public Quaternion getOrientation() {
        this.storeRot.set((float)(-this.hmdPose.rotation.data[1]), (float)this.hmdPose.rotation.data[2], (float)(-this.hmdPose.rotation.data[3]), (float)this.hmdPose.rotation.data[0]);
        if (this.storeRot.equals((Object)Quaternion.ZERO)) {
            this.storeRot.set(Quaternion.DIRECTION_Z);
        }
        return this.storeRot;
    }

    @Override
    public Vector3f getPosition() {
        this.storePos.x = (float)(-this.hmdPose.translation.data[0]);
        this.storePos.y = (float)this.hmdPose.translation.data[1];
        this.storePos.z = (float)(-this.hmdPose.translation.data[2]);
        return this.storePos;
    }

    @Override
    public void getPositionAndOrientation(Vector3f storePos, Quaternion storeRot) {
        storePos.x = (float)(-this.hmdPose.translation.data[0]);
        storePos.y = (float)this.hmdPose.translation.data[1];
        storePos.z = (float)(-this.hmdPose.translation.data[2]);
        storeRot.set((float)(-this.hmdPose.rotation.data[1]), (float)this.hmdPose.rotation.data[2], (float)(-this.hmdPose.rotation.data[3]), (float)this.hmdPose.rotation.data[0]);
        if (storeRot.equals((Object)Quaternion.ZERO)) {
            storeRot.set(Quaternion.DIRECTION_Z);
        }
    }

    @Override
    public void updatePose() {
        if (this.context == null || this.displayConfig == null) {
            return;
        }
        OsvrClientKitLibrary.osvrClientUpdate(this.context);
        OsvrDisplayLibrary.osvrClientGetViewerPose(this.displayConfig, 0, this.hmdPose.getPointer());
        this.VRinput.updateControllerStates();
        this.hmdPose.read();
    }

    @Override
    public Matrix4f getHMDMatrixProjectionLeftEye(Camera cam) {
        if (this.eyeLeftInfo == null) {
            return cam.getProjectionMatrix();
        }
        if (this.eyeMatrix[0] == null) {
            FloatBuffer tfb = FloatBuffer.allocate(16);
            OsvrDisplayLibrary.osvrClientGetViewerEyeSurfaceProjectionMatrixf(this.displayConfig, 0, (byte)0, 0, cam.getFrustumNear(), cam.getFrustumFar(), (short)0, tfb);
            this.eyeMatrix[0] = new Matrix4f();
            this.eyeMatrix[0].set(tfb.get(0), tfb.get(4), tfb.get(8), tfb.get(12), tfb.get(1), tfb.get(5), tfb.get(9), tfb.get(13), tfb.get(2), tfb.get(6), tfb.get(10), tfb.get(14), tfb.get(3), tfb.get(7), tfb.get(11), tfb.get(15));
        }
        return this.eyeMatrix[0];
    }

    @Override
    public Matrix4f getHMDMatrixProjectionRightEye(Camera cam) {
        if (this.eyeRightInfo == null) {
            return cam.getProjectionMatrix();
        }
        if (this.eyeMatrix[1] == null) {
            FloatBuffer tfb = FloatBuffer.allocate(16);
            OsvrDisplayLibrary.osvrClientGetViewerEyeSurfaceProjectionMatrixf(this.displayConfig, 0, (byte)1, 0, cam.getFrustumNear(), cam.getFrustumFar(), (short)0, tfb);
            this.eyeMatrix[1] = new Matrix4f();
            this.eyeMatrix[1].set(tfb.get(0), tfb.get(4), tfb.get(8), tfb.get(12), tfb.get(1), tfb.get(5), tfb.get(9), tfb.get(13), tfb.get(2), tfb.get(6), tfb.get(10), tfb.get(14), tfb.get(3), tfb.get(7), tfb.get(11), tfb.get(15));
        }
        return this.eyeMatrix[1];
    }

    @Override
    public Vector3f getHMDVectorPoseLeftEye() {
        if (this.hmdPoseLeftEyeVec == null) {
            this.hmdPoseLeftEyeVec = new Vector3f();
            this.hmdPoseLeftEyeVec.x = -0.0325f;
            if (!this.flipEyes) {
                this.hmdPoseLeftEyeVec.x *= -1.0f;
            }
        }
        return this.hmdPoseLeftEyeVec;
    }

    @Override
    public Vector3f getHMDVectorPoseRightEye() {
        if (this.hmdPoseRightEyeVec == null) {
            this.hmdPoseRightEyeVec = new Vector3f();
            this.hmdPoseRightEyeVec.x = 0.0325f;
            if (!this.flipEyes) {
                this.hmdPoseRightEyeVec.x *= -1.0f;
            }
        }
        return this.hmdPoseRightEyeVec;
    }

    @Override
    public Vector3f getSeatedToAbsolutePosition() {
        return Vector3f.ZERO;
    }

    @Override
    public Matrix4f getHMDMatrixPoseLeftEye() {
        return null;
    }

    @Override
    public Matrix4f getHMDMatrixPoseRightEye() {
        return null;
    }

    @Override
    public HmdType getType() {
        return HmdType.OSVR;
    }
}

